/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.text.WordUtils;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class WordUtilsTest {
    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)new WordUtils());
        Constructor<?>[] cons = WordUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertTrue((boolean)Modifier.isPublic(WordUtils.class.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isFinal(WordUtils.class.getModifiers()));
    }

    @Test
    public void testWrap_StringInt() {
        Assert.assertEquals(null, (Object)WordUtils.wrap(null, (int)20));
        Assert.assertEquals(null, (Object)WordUtils.wrap(null, (int)-1));
        Assert.assertEquals((Object)"", (Object)WordUtils.wrap((String)"", (int)20));
        Assert.assertEquals((Object)"", (Object)WordUtils.wrap((String)"", (int)-1));
        String systemNewLine = System.lineSeparator();
        String input = "Here is one line of text that is going to be wrapped after 20 columns.";
        String expected = "Here is one line of" + systemNewLine + "text that is going" + systemNewLine + "to be wrapped after" + systemNewLine + "20 columns.";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20));
        input = "Click here to jump to the commons website - http://commons.apache.org";
        expected = "Click here to jump" + systemNewLine + "to the commons" + systemNewLine + "website -" + systemNewLine + "http://commons.apache.org";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20));
        input = "Click here, http://commons.apache.org, to jump to the commons website";
        expected = "Click here," + systemNewLine + "http://commons.apache.org," + systemNewLine + "to jump to the" + systemNewLine + "commons website";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20));
        input = "word1             word2                        word3";
        expected = "word1  " + systemNewLine + "word2  " + systemNewLine + "word3";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)7));
    }

    @Test
    public void testWrap_StringIntStringBoolean() {
        Assert.assertEquals(null, (Object)WordUtils.wrap(null, (int)20, (String)"\n", (boolean)false));
        Assert.assertEquals(null, (Object)WordUtils.wrap(null, (int)20, (String)"\n", (boolean)true));
        Assert.assertEquals(null, (Object)WordUtils.wrap(null, (int)20, null, (boolean)true));
        Assert.assertEquals(null, (Object)WordUtils.wrap(null, (int)20, null, (boolean)false));
        Assert.assertEquals(null, (Object)WordUtils.wrap(null, (int)-1, null, (boolean)true));
        Assert.assertEquals(null, (Object)WordUtils.wrap(null, (int)-1, null, (boolean)false));
        Assert.assertEquals((Object)"", (Object)WordUtils.wrap((String)"", (int)20, (String)"\n", (boolean)false));
        Assert.assertEquals((Object)"", (Object)WordUtils.wrap((String)"", (int)20, (String)"\n", (boolean)true));
        Assert.assertEquals((Object)"", (Object)WordUtils.wrap((String)"", (int)20, null, (boolean)false));
        Assert.assertEquals((Object)"", (Object)WordUtils.wrap((String)"", (int)20, null, (boolean)true));
        Assert.assertEquals((Object)"", (Object)WordUtils.wrap((String)"", (int)-1, null, (boolean)false));
        Assert.assertEquals((Object)"", (Object)WordUtils.wrap((String)"", (int)-1, null, (boolean)true));
        String input = "Here is one line of text that is going to be wrapped after 20 columns.";
        String expected = "Here is one line of\ntext that is going\nto be wrapped after\n20 columns.";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false));
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true));
        input = "Here is one line of text that is going to be wrapped after 20 columns.";
        expected = "Here is one line of<br />text that is going<br />to be wrapped after<br />20 columns.";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"<br />", (boolean)false));
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"<br />", (boolean)true));
        input = "Here is one line";
        expected = "Here\nis one\nline";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)6, (String)"\n", (boolean)false));
        expected = "Here\nis\none\nline";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)2, (String)"\n", (boolean)false));
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)-1, (String)"\n", (boolean)false));
        String systemNewLine = System.lineSeparator();
        input = "Here is one line of text that is going to be wrapped after 20 columns.";
        expected = "Here is one line of" + systemNewLine + "text that is going" + systemNewLine + "to be wrapped after" + systemNewLine + "20 columns.";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, null, (boolean)false));
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, null, (boolean)true));
        input = " Here:  is  one  line  of  text  that  is  going  to  be  wrapped  after  20  columns.";
        expected = "Here:  is  one  line\nof  text  that  is \ngoing  to  be \nwrapped  after  20 \ncolumns.";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false));
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true));
        input = "Here is\tone line of text that is going to be wrapped after 20 columns.";
        expected = "Here is\tone line of\ntext that is going\nto be wrapped after\n20 columns.";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false));
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true));
        input = "Here is one line of\ttext that is going to be wrapped after 20 columns.";
        expected = "Here is one line\nof\ttext that is\ngoing to be wrapped\nafter 20 columns.";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false));
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true));
        input = "Click here to jump to the commons website - http://commons.apache.org";
        expected = "Click here to jump\nto the commons\nwebsite -\nhttp://commons.apache.org";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false));
        expected = "Click here to jump\nto the commons\nwebsite -\nhttp://commons.apach\ne.org";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true));
        input = "Click here, http://commons.apache.org, to jump to the commons website";
        expected = "Click here,\nhttp://commons.apache.org,\nto jump to the\ncommons website";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false));
        expected = "Click here,\nhttp://commons.apach\ne.org, to jump to\nthe commons website";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true));
    }

    @Test
    public void testWrap_StringIntStringBooleanString() {
        String input = "flammable/inflammable";
        String expected = "flammable/inflammable";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)30, (String)"\n", (boolean)false, (String)"/"));
        expected = "flammable\ninflammable";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)2, (String)"\n", (boolean)false, (String)"/"));
        expected = "flammable\ninflammab\nle";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)9, (String)"\n", (boolean)true, (String)"/"));
        expected = "flammable\ninflammable";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)15, (String)"\n", (boolean)true, (String)"/"));
        input = "flammableinflammable";
        expected = "flammableinflam\nmable";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)15, (String)"\n", (boolean)true, (String)"/"));
    }

    @Test
    public void testCapitalize_String() {
        Assert.assertEquals(null, (Object)WordUtils.capitalize(null));
        Assert.assertEquals((Object)"", (Object)WordUtils.capitalize((String)""));
        Assert.assertEquals((Object)"  ", (Object)WordUtils.capitalize((String)"  "));
        Assert.assertEquals((Object)"I", (Object)WordUtils.capitalize((String)"I"));
        Assert.assertEquals((Object)"I", (Object)WordUtils.capitalize((String)"i"));
        Assert.assertEquals((Object)"I Am Here 123", (Object)WordUtils.capitalize((String)"i am here 123"));
        Assert.assertEquals((Object)"I Am Here 123", (Object)WordUtils.capitalize((String)"I Am Here 123"));
        Assert.assertEquals((Object)"I Am HERE 123", (Object)WordUtils.capitalize((String)"i am HERE 123"));
        Assert.assertEquals((Object)"I AM HERE 123", (Object)WordUtils.capitalize((String)"I AM HERE 123"));
    }

    @Test
    public void testCapitalizeWithDelimiters_String() {
        Assert.assertEquals(null, (Object)WordUtils.capitalize(null, null));
        Assert.assertEquals((Object)"", (Object)WordUtils.capitalize((String)"", (char[])new char[0]));
        Assert.assertEquals((Object)"  ", (Object)WordUtils.capitalize((String)"  ", (char[])new char[0]));
        char[] chars = new char[]{'-', '+', ' ', '@'};
        Assert.assertEquals((Object)"I", (Object)WordUtils.capitalize((String)"I", (char[])chars));
        Assert.assertEquals((Object)"I", (Object)WordUtils.capitalize((String)"i", (char[])chars));
        Assert.assertEquals((Object)"I-Am Here+123", (Object)WordUtils.capitalize((String)"i-am here+123", (char[])chars));
        Assert.assertEquals((Object)"I Am+Here-123", (Object)WordUtils.capitalize((String)"I Am+Here-123", (char[])chars));
        Assert.assertEquals((Object)"I+Am-HERE 123", (Object)WordUtils.capitalize((String)"i+am-HERE 123", (char[])chars));
        Assert.assertEquals((Object)"I-AM HERE+123", (Object)WordUtils.capitalize((String)"I-AM HERE+123", (char[])chars));
        chars = new char[]{'.'};
        Assert.assertEquals((Object)"I aM.Fine", (Object)WordUtils.capitalize((String)"i aM.fine", (char[])chars));
        Assert.assertEquals((Object)"I Am.fine", (Object)WordUtils.capitalize((String)"i am.fine", null));
    }

    @Test
    public void testCapitalizeFully_String() {
        Assert.assertEquals(null, (Object)WordUtils.capitalizeFully(null));
        Assert.assertEquals((Object)"", (Object)WordUtils.capitalizeFully((String)""));
        Assert.assertEquals((Object)"  ", (Object)WordUtils.capitalizeFully((String)"  "));
        Assert.assertEquals((Object)"I", (Object)WordUtils.capitalizeFully((String)"I"));
        Assert.assertEquals((Object)"I", (Object)WordUtils.capitalizeFully((String)"i"));
        Assert.assertEquals((Object)"I Am Here 123", (Object)WordUtils.capitalizeFully((String)"i am here 123"));
        Assert.assertEquals((Object)"I Am Here 123", (Object)WordUtils.capitalizeFully((String)"I Am Here 123"));
        Assert.assertEquals((Object)"I Am Here 123", (Object)WordUtils.capitalizeFully((String)"i am HERE 123"));
        Assert.assertEquals((Object)"I Am Here 123", (Object)WordUtils.capitalizeFully((String)"I AM HERE 123"));
    }

    @Test
    public void testCapitalizeFullyWithDelimiters_String() {
        Assert.assertEquals(null, (Object)WordUtils.capitalizeFully(null, null));
        Assert.assertEquals((Object)"", (Object)WordUtils.capitalizeFully((String)"", (char[])new char[0]));
        Assert.assertEquals((Object)"  ", (Object)WordUtils.capitalizeFully((String)"  ", (char[])new char[0]));
        char[] chars = new char[]{'-', '+', ' ', '@'};
        Assert.assertEquals((Object)"I", (Object)WordUtils.capitalizeFully((String)"I", (char[])chars));
        Assert.assertEquals((Object)"I", (Object)WordUtils.capitalizeFully((String)"i", (char[])chars));
        Assert.assertEquals((Object)"I-Am Here+123", (Object)WordUtils.capitalizeFully((String)"i-am here+123", (char[])chars));
        Assert.assertEquals((Object)"I Am+Here-123", (Object)WordUtils.capitalizeFully((String)"I Am+Here-123", (char[])chars));
        Assert.assertEquals((Object)"I+Am-Here 123", (Object)WordUtils.capitalizeFully((String)"i+am-HERE 123", (char[])chars));
        Assert.assertEquals((Object)"I-Am Here+123", (Object)WordUtils.capitalizeFully((String)"I-AM HERE+123", (char[])chars));
        chars = new char[]{'.'};
        Assert.assertEquals((Object)"I am.Fine", (Object)WordUtils.capitalizeFully((String)"i aM.fine", (char[])chars));
        Assert.assertEquals((Object)"I Am.fine", (Object)WordUtils.capitalizeFully((String)"i am.fine", null));
    }

    @Test
    public void testContainsAllWords_StringString() {
        Assert.assertFalse((boolean)WordUtils.containsAllWords(null, (CharSequence[])new CharSequence[]{null}));
        Assert.assertFalse((boolean)WordUtils.containsAllWords(null, (CharSequence[])new CharSequence[]{""}));
        Assert.assertFalse((boolean)WordUtils.containsAllWords(null, (CharSequence[])new CharSequence[]{"ab"}));
        Assert.assertFalse((boolean)WordUtils.containsAllWords((CharSequence)"", (CharSequence[])new CharSequence[]{null}));
        Assert.assertFalse((boolean)WordUtils.containsAllWords((CharSequence)"", (CharSequence[])new CharSequence[]{""}));
        Assert.assertFalse((boolean)WordUtils.containsAllWords((CharSequence)"", (CharSequence[])new CharSequence[]{"ab"}));
        Assert.assertFalse((boolean)WordUtils.containsAllWords((CharSequence)"foo", (CharSequence[])new CharSequence[]{null}));
        Assert.assertFalse((boolean)WordUtils.containsAllWords((CharSequence)"bar", (CharSequence[])new CharSequence[]{""}));
        Assert.assertFalse((boolean)WordUtils.containsAllWords((CharSequence)"zzabyycdxx", (CharSequence[])new CharSequence[]{"by"}));
        Assert.assertTrue((boolean)WordUtils.containsAllWords((CharSequence)"lorem ipsum dolor sit amet", (CharSequence[])new CharSequence[]{"ipsum", "lorem", "dolor"}));
        Assert.assertFalse((boolean)WordUtils.containsAllWords((CharSequence)"lorem ipsum dolor sit amet", (CharSequence[])new CharSequence[]{"ipsum", null, "lorem", "dolor"}));
        Assert.assertFalse((boolean)WordUtils.containsAllWords((CharSequence)"lorem ipsum null dolor sit amet", (CharSequence[])new CharSequence[]{"ipsum", null, "lorem", "dolor"}));
        Assert.assertFalse((boolean)WordUtils.containsAllWords((CharSequence)"ab", (CharSequence[])new CharSequence[]{"b"}));
        Assert.assertFalse((boolean)WordUtils.containsAllWords((CharSequence)"ab", (CharSequence[])new CharSequence[]{"z"}));
    }

    @Test
    public void testUncapitalize_String() {
        Assert.assertEquals(null, (Object)WordUtils.uncapitalize(null));
        Assert.assertEquals((Object)"", (Object)WordUtils.uncapitalize((String)""));
        Assert.assertEquals((Object)"  ", (Object)WordUtils.uncapitalize((String)"  "));
        Assert.assertEquals((Object)"i", (Object)WordUtils.uncapitalize((String)"I"));
        Assert.assertEquals((Object)"i", (Object)WordUtils.uncapitalize((String)"i"));
        Assert.assertEquals((Object)"i am here 123", (Object)WordUtils.uncapitalize((String)"i am here 123"));
        Assert.assertEquals((Object)"i am here 123", (Object)WordUtils.uncapitalize((String)"I Am Here 123"));
        Assert.assertEquals((Object)"i am hERE 123", (Object)WordUtils.uncapitalize((String)"i am HERE 123"));
        Assert.assertEquals((Object)"i aM hERE 123", (Object)WordUtils.uncapitalize((String)"I AM HERE 123"));
    }

    @Test
    public void testUncapitalizeWithDelimiters_String() {
        Assert.assertEquals(null, (Object)WordUtils.uncapitalize(null, null));
        Assert.assertEquals((Object)"", (Object)WordUtils.uncapitalize((String)"", (char[])new char[0]));
        Assert.assertEquals((Object)"  ", (Object)WordUtils.uncapitalize((String)"  ", (char[])new char[0]));
        char[] chars = new char[]{'-', '+', ' ', '@'};
        Assert.assertEquals((Object)"i", (Object)WordUtils.uncapitalize((String)"I", (char[])chars));
        Assert.assertEquals((Object)"i", (Object)WordUtils.uncapitalize((String)"i", (char[])chars));
        Assert.assertEquals((Object)"i am-here+123", (Object)WordUtils.uncapitalize((String)"i am-here+123", (char[])chars));
        Assert.assertEquals((Object)"i+am here-123", (Object)WordUtils.uncapitalize((String)"I+Am Here-123", (char[])chars));
        Assert.assertEquals((Object)"i-am+hERE 123", (Object)WordUtils.uncapitalize((String)"i-am+HERE 123", (char[])chars));
        Assert.assertEquals((Object)"i aM-hERE+123", (Object)WordUtils.uncapitalize((String)"I AM-HERE+123", (char[])chars));
        chars = new char[]{'.'};
        Assert.assertEquals((Object)"i AM.fINE", (Object)WordUtils.uncapitalize((String)"I AM.FINE", (char[])chars));
        Assert.assertEquals((Object)"i aM.FINE", (Object)WordUtils.uncapitalize((String)"I AM.FINE", null));
    }

    @Test
    public void testInitials_String() {
        Assert.assertEquals(null, (Object)WordUtils.initials(null));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)""));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"  "));
        Assert.assertEquals((Object)"I", (Object)WordUtils.initials((String)"I"));
        Assert.assertEquals((Object)"i", (Object)WordUtils.initials((String)"i"));
        Assert.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)"Ben John Lee"));
        Assert.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)"   Ben \n   John\tLee\t"));
        Assert.assertEquals((Object)"BJ", (Object)WordUtils.initials((String)"Ben J.Lee"));
        Assert.assertEquals((Object)"BJ.L", (Object)WordUtils.initials((String)" Ben   John  . Lee"));
        Assert.assertEquals((Object)"iah1", (Object)WordUtils.initials((String)"i am here 123"));
    }

    @Test
    public void testInitials_String_charArray() {
        char[] array = null;
        Assert.assertEquals(null, (Object)WordUtils.initials(null, array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"", array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"  ", array));
        Assert.assertEquals((Object)"I", (Object)WordUtils.initials((String)"I", array));
        Assert.assertEquals((Object)"i", (Object)WordUtils.initials((String)"i", array));
        Assert.assertEquals((Object)"S", (Object)WordUtils.initials((String)"SJC", array));
        Assert.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)"Ben John Lee", array));
        Assert.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)"   Ben \n   John\tLee\t", array));
        Assert.assertEquals((Object)"BJ", (Object)WordUtils.initials((String)"Ben J.Lee", array));
        Assert.assertEquals((Object)"BJ.L", (Object)WordUtils.initials((String)" Ben   John  . Lee", array));
        Assert.assertEquals((Object)"KO", (Object)WordUtils.initials((String)"Kay O'Murphy", array));
        Assert.assertEquals((Object)"iah1", (Object)WordUtils.initials((String)"i am here 123", array));
        array = new char[]{};
        Assert.assertEquals(null, (Object)WordUtils.initials(null, (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"  ", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"I", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"i", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"SJC", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"Ben John Lee", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"   Ben \n   John\tLee\t", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"Ben J.Lee", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)" Ben   John  . Lee", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"Kay O'Murphy", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"i am here 123", (char[])array));
        array = " ".toCharArray();
        Assert.assertEquals(null, (Object)WordUtils.initials(null, (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"  ", (char[])array));
        Assert.assertEquals((Object)"I", (Object)WordUtils.initials((String)"I", (char[])array));
        Assert.assertEquals((Object)"i", (Object)WordUtils.initials((String)"i", (char[])array));
        Assert.assertEquals((Object)"S", (Object)WordUtils.initials((String)"SJC", (char[])array));
        Assert.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)"Ben John Lee", (char[])array));
        Assert.assertEquals((Object)"BJ", (Object)WordUtils.initials((String)"Ben J.Lee", (char[])array));
        Assert.assertEquals((Object)"B\nJ", (Object)WordUtils.initials((String)"   Ben \n   John\tLee\t", (char[])array));
        Assert.assertEquals((Object)"BJ.L", (Object)WordUtils.initials((String)" Ben   John  . Lee", (char[])array));
        Assert.assertEquals((Object)"KO", (Object)WordUtils.initials((String)"Kay O'Murphy", (char[])array));
        Assert.assertEquals((Object)"iah1", (Object)WordUtils.initials((String)"i am here 123", (char[])array));
        array = " .".toCharArray();
        Assert.assertEquals(null, (Object)WordUtils.initials(null, (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"  ", (char[])array));
        Assert.assertEquals((Object)"I", (Object)WordUtils.initials((String)"I", (char[])array));
        Assert.assertEquals((Object)"i", (Object)WordUtils.initials((String)"i", (char[])array));
        Assert.assertEquals((Object)"S", (Object)WordUtils.initials((String)"SJC", (char[])array));
        Assert.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)"Ben John Lee", (char[])array));
        Assert.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)"Ben J.Lee", (char[])array));
        Assert.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)" Ben   John  . Lee", (char[])array));
        Assert.assertEquals((Object)"KO", (Object)WordUtils.initials((String)"Kay O'Murphy", (char[])array));
        Assert.assertEquals((Object)"iah1", (Object)WordUtils.initials((String)"i am here 123", (char[])array));
        array = " .'".toCharArray();
        Assert.assertEquals(null, (Object)WordUtils.initials(null, (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"  ", (char[])array));
        Assert.assertEquals((Object)"I", (Object)WordUtils.initials((String)"I", (char[])array));
        Assert.assertEquals((Object)"i", (Object)WordUtils.initials((String)"i", (char[])array));
        Assert.assertEquals((Object)"S", (Object)WordUtils.initials((String)"SJC", (char[])array));
        Assert.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)"Ben John Lee", (char[])array));
        Assert.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)"Ben J.Lee", (char[])array));
        Assert.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)" Ben   John  . Lee", (char[])array));
        Assert.assertEquals((Object)"KOM", (Object)WordUtils.initials((String)"Kay O'Murphy", (char[])array));
        Assert.assertEquals((Object)"iah1", (Object)WordUtils.initials((String)"i am here 123", (char[])array));
        array = "SIJo1".toCharArray();
        Assert.assertEquals(null, (Object)WordUtils.initials(null, (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"", (char[])array));
        Assert.assertEquals((Object)" ", (Object)WordUtils.initials((String)"  ", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"I", (char[])array));
        Assert.assertEquals((Object)"i", (Object)WordUtils.initials((String)"i", (char[])array));
        Assert.assertEquals((Object)"C", (Object)WordUtils.initials((String)"SJC", (char[])array));
        Assert.assertEquals((Object)"Bh", (Object)WordUtils.initials((String)"Ben John Lee", (char[])array));
        Assert.assertEquals((Object)"B.", (Object)WordUtils.initials((String)"Ben J.Lee", (char[])array));
        Assert.assertEquals((Object)" h", (Object)WordUtils.initials((String)" Ben   John  . Lee", (char[])array));
        Assert.assertEquals((Object)"K", (Object)WordUtils.initials((String)"Kay O'Murphy", (char[])array));
        Assert.assertEquals((Object)"i2", (Object)WordUtils.initials((String)"i am here 123", (char[])array));
    }

    @Test
    public void testSwapCase_String() {
        Assert.assertEquals(null, (Object)WordUtils.swapCase(null));
        Assert.assertEquals((Object)"", (Object)WordUtils.swapCase((String)""));
        Assert.assertEquals((Object)"  ", (Object)WordUtils.swapCase((String)"  "));
        Assert.assertEquals((Object)"i", (Object)WordUtils.swapCase((String)"I"));
        Assert.assertEquals((Object)"I", (Object)WordUtils.swapCase((String)"i"));
        Assert.assertEquals((Object)"I AM HERE 123", (Object)WordUtils.swapCase((String)"i am here 123"));
        Assert.assertEquals((Object)"i aM hERE 123", (Object)WordUtils.swapCase((String)"I Am Here 123"));
        Assert.assertEquals((Object)"I AM here 123", (Object)WordUtils.swapCase((String)"i am HERE 123"));
        Assert.assertEquals((Object)"i am here 123", (Object)WordUtils.swapCase((String)"I AM HERE 123"));
        String test = "This String contains a TitleCase character: \u01c8";
        String expect = "tHIS sTRING CONTAINS A tITLEcASE CHARACTER: \u01c9";
        Assert.assertEquals((Object)"tHIS sTRING CONTAINS A tITLEcASE CHARACTER: \u01c9", (Object)WordUtils.swapCase((String)"This String contains a TitleCase character: \u01c8"));
    }

    @Test
    public void testLANG1292() throws Exception {
        WordUtils.wrap((String)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", (int)70);
    }
}

