/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;

public class ArrayUtilsInsertTest {
    @Test
    public void testInsertBooleans() throws Exception {
        boolean[] array = new boolean[]{true, false, true};
        boolean[] values = new boolean[]{false, true, false};
        boolean[] result = ArrayUtils.insert((int)42, (boolean[])array, null);
        Assert.assertArrayEquals((boolean[])array, (boolean[])result);
        Assert.assertFalse((array == result ? 1 : 0) != 0);
        Assert.assertNull((Object)ArrayUtils.insert((int)42, null, (boolean[])array));
        Assert.assertArrayEquals((boolean[])new boolean[0], (boolean[])ArrayUtils.insert((int)0, (boolean[])new boolean[0], null));
        Assert.assertNull((Object)ArrayUtils.insert((int)42, (boolean[])null, null));
        try {
            ArrayUtils.insert((int)-1, (boolean[])array, (boolean[])array);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.insert((int)(array.length + 1), (boolean[])array, (boolean[])array);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertArrayEquals((boolean[])new boolean[]{false, true, false, true}, (boolean[])ArrayUtils.insert((int)0, (boolean[])array, (boolean[])new boolean[]{false}));
        Assert.assertArrayEquals((boolean[])new boolean[]{true, false, false, true}, (boolean[])ArrayUtils.insert((int)1, (boolean[])array, (boolean[])new boolean[]{false}));
        Assert.assertArrayEquals((boolean[])new boolean[]{true, false, true, false}, (boolean[])ArrayUtils.insert((int)array.length, (boolean[])array, (boolean[])new boolean[]{false}));
        Assert.assertArrayEquals((boolean[])new boolean[]{false, true, false, true, false, true}, (boolean[])ArrayUtils.insert((int)0, (boolean[])array, (boolean[])values));
        Assert.assertArrayEquals((boolean[])new boolean[]{true, false, true, false, false, true}, (boolean[])ArrayUtils.insert((int)1, (boolean[])array, (boolean[])values));
        Assert.assertArrayEquals((boolean[])new boolean[]{true, false, true, false, true, false}, (boolean[])ArrayUtils.insert((int)array.length, (boolean[])array, (boolean[])values));
    }

    @Test
    public void testInsertBytes() throws Exception {
        byte[] array = new byte[]{1, 2, 3};
        byte[] values = new byte[]{4, 5, 6};
        byte[] result = ArrayUtils.insert((int)42, (byte[])array, null);
        Assert.assertArrayEquals((byte[])array, (byte[])result);
        Assert.assertFalse((array == result ? 1 : 0) != 0);
        Assert.assertNull((Object)ArrayUtils.insert((int)42, null, (byte[])array));
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])ArrayUtils.insert((int)0, (byte[])new byte[0], null));
        Assert.assertNull((Object)ArrayUtils.insert((int)42, (byte[])null, null));
        try {
            ArrayUtils.insert((int)-1, (byte[])array, (byte[])array);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.insert((int)(array.length + 1), (byte[])array, (byte[])array);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertArrayEquals((byte[])new byte[]{0, 1, 2, 3}, (byte[])ArrayUtils.insert((int)0, (byte[])array, (byte[])new byte[]{0}));
        Assert.assertArrayEquals((byte[])new byte[]{1, 0, 2, 3}, (byte[])ArrayUtils.insert((int)1, (byte[])array, (byte[])new byte[]{0}));
        Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3, 0}, (byte[])ArrayUtils.insert((int)array.length, (byte[])array, (byte[])new byte[]{0}));
        Assert.assertArrayEquals((byte[])new byte[]{4, 5, 6, 1, 2, 3}, (byte[])ArrayUtils.insert((int)0, (byte[])array, (byte[])values));
        Assert.assertArrayEquals((byte[])new byte[]{1, 4, 5, 6, 2, 3}, (byte[])ArrayUtils.insert((int)1, (byte[])array, (byte[])values));
        Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 5, 6}, (byte[])ArrayUtils.insert((int)array.length, (byte[])array, (byte[])values));
    }

    @Test
    public void testInsertChars() throws Exception {
        char[] array = new char[]{'a', 'b', 'c'};
        char[] values = new char[]{'d', 'e', 'f'};
        char[] result = ArrayUtils.insert((int)42, (char[])array, null);
        Assert.assertArrayEquals((char[])array, (char[])result);
        Assert.assertFalse((array == result ? 1 : 0) != 0);
        Assert.assertNull((Object)ArrayUtils.insert((int)42, null, (char[])array));
        Assert.assertArrayEquals((char[])new char[0], (char[])ArrayUtils.insert((int)0, (char[])new char[0], null));
        Assert.assertNull((Object)ArrayUtils.insert((int)42, (char[])null, null));
        try {
            ArrayUtils.insert((int)-1, (char[])array, (char[])array);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.insert((int)(array.length + 1), (char[])array, (char[])array);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertArrayEquals((char[])new char[]{'z', 'a', 'b', 'c'}, (char[])ArrayUtils.insert((int)0, (char[])array, (char[])new char[]{'z'}));
        Assert.assertArrayEquals((char[])new char[]{'a', 'z', 'b', 'c'}, (char[])ArrayUtils.insert((int)1, (char[])array, (char[])new char[]{'z'}));
        Assert.assertArrayEquals((char[])new char[]{'a', 'b', 'c', 'z'}, (char[])ArrayUtils.insert((int)array.length, (char[])array, (char[])new char[]{'z'}));
        Assert.assertArrayEquals((char[])new char[]{'d', 'e', 'f', 'a', 'b', 'c'}, (char[])ArrayUtils.insert((int)0, (char[])array, (char[])values));
        Assert.assertArrayEquals((char[])new char[]{'a', 'd', 'e', 'f', 'b', 'c'}, (char[])ArrayUtils.insert((int)1, (char[])array, (char[])values));
        Assert.assertArrayEquals((char[])new char[]{'a', 'b', 'c', 'd', 'e', 'f'}, (char[])ArrayUtils.insert((int)array.length, (char[])array, (char[])values));
    }

    @Test
    public void testInsertDoubles() throws Exception {
        double[] array = new double[]{1.0, 2.0, 3.0};
        double[] values = new double[]{4.0, 5.0, 6.0};
        double delta = 1.0E-6;
        double[] result = ArrayUtils.insert((int)42, (double[])array, null);
        Assert.assertArrayEquals((double[])array, (double[])result, (double)1.0E-6);
        Assert.assertFalse((array == result ? 1 : 0) != 0);
        Assert.assertNull((Object)ArrayUtils.insert((int)42, null, (double[])array));
        Assert.assertArrayEquals((double[])new double[0], (double[])ArrayUtils.insert((int)0, (double[])new double[0], null), (double)1.0E-6);
        Assert.assertNull((Object)ArrayUtils.insert((int)42, (double[])null, null));
        try {
            ArrayUtils.insert((int)-1, (double[])array, (double[])array);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.insert((int)(array.length + 1), (double[])array, (double[])array);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertArrayEquals((double[])new double[]{0.0, 1.0, 2.0, 3.0}, (double[])ArrayUtils.insert((int)0, (double[])array, (double[])new double[]{0.0}), (double)1.0E-6);
        Assert.assertArrayEquals((double[])new double[]{1.0, 0.0, 2.0, 3.0}, (double[])ArrayUtils.insert((int)1, (double[])array, (double[])new double[]{0.0}), (double)1.0E-6);
        Assert.assertArrayEquals((double[])new double[]{1.0, 2.0, 3.0, 0.0}, (double[])ArrayUtils.insert((int)array.length, (double[])array, (double[])new double[]{0.0}), (double)1.0E-6);
        Assert.assertArrayEquals((double[])new double[]{4.0, 5.0, 6.0, 1.0, 2.0, 3.0}, (double[])ArrayUtils.insert((int)0, (double[])array, (double[])values), (double)1.0E-6);
        Assert.assertArrayEquals((double[])new double[]{1.0, 4.0, 5.0, 6.0, 2.0, 3.0}, (double[])ArrayUtils.insert((int)1, (double[])array, (double[])values), (double)1.0E-6);
        Assert.assertArrayEquals((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0}, (double[])ArrayUtils.insert((int)array.length, (double[])array, (double[])values), (double)1.0E-6);
    }

    @Test
    public void testInsertFloats() throws Exception {
        float[] array = new float[]{1.0f, 2.0f, 3.0f};
        float[] values = new float[]{4.0f, 5.0f, 6.0f};
        float delta = 1.0E-6f;
        float[] result = ArrayUtils.insert((int)42, (float[])array, null);
        Assert.assertArrayEquals((float[])array, (float[])result, (float)1.0E-6f);
        Assert.assertFalse((array == result ? 1 : 0) != 0);
        Assert.assertNull((Object)ArrayUtils.insert((int)42, null, (float[])array));
        Assert.assertArrayEquals((float[])new float[0], (float[])ArrayUtils.insert((int)0, (float[])new float[0], null), (float)1.0E-6f);
        Assert.assertNull((Object)ArrayUtils.insert((int)42, (float[])null, null));
        try {
            ArrayUtils.insert((int)-1, (float[])array, (float[])array);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.insert((int)(array.length + 1), (float[])array, (float[])array);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertArrayEquals((float[])new float[]{0.0f, 1.0f, 2.0f, 3.0f}, (float[])ArrayUtils.insert((int)0, (float[])array, (float[])new float[]{0.0f}), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])new float[]{1.0f, 0.0f, 2.0f, 3.0f}, (float[])ArrayUtils.insert((int)1, (float[])array, (float[])new float[]{0.0f}), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])new float[]{1.0f, 2.0f, 3.0f, 0.0f}, (float[])ArrayUtils.insert((int)array.length, (float[])array, (float[])new float[]{0.0f}), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])new float[]{4.0f, 5.0f, 6.0f, 1.0f, 2.0f, 3.0f}, (float[])ArrayUtils.insert((int)0, (float[])array, (float[])values), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])new float[]{1.0f, 4.0f, 5.0f, 6.0f, 2.0f, 3.0f}, (float[])ArrayUtils.insert((int)1, (float[])array, (float[])values), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f}, (float[])ArrayUtils.insert((int)array.length, (float[])array, (float[])values), (float)1.0E-6f);
    }

    @Test
    public void testInsertInts() throws Exception {
        int[] array = new int[]{1, 2, 3};
        int[] values = new int[]{4, 5, 6};
        int[] result = ArrayUtils.insert((int)42, (int[])array, null);
        Assert.assertArrayEquals((int[])array, (int[])result);
        Assert.assertFalse((array == result ? 1 : 0) != 0);
        Assert.assertNull((Object)ArrayUtils.insert((int)42, null, (int[])array));
        Assert.assertArrayEquals((int[])new int[0], (int[])ArrayUtils.insert((int)0, (int[])new int[0], null));
        Assert.assertNull((Object)ArrayUtils.insert((int)42, (int[])null, null));
        try {
            ArrayUtils.insert((int)-1, (int[])array, (int[])array);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.insert((int)(array.length + 1), (int[])array, (int[])array);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3}, (int[])ArrayUtils.insert((int)0, (int[])array, (int[])new int[]{0}));
        Assert.assertArrayEquals((int[])new int[]{1, 0, 2, 3}, (int[])ArrayUtils.insert((int)1, (int[])array, (int[])new int[]{0}));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3, 0}, (int[])ArrayUtils.insert((int)array.length, (int[])array, (int[])new int[]{0}));
        Assert.assertArrayEquals((int[])new int[]{4, 5, 6, 1, 2, 3}, (int[])ArrayUtils.insert((int)0, (int[])array, (int[])values));
        Assert.assertArrayEquals((int[])new int[]{1, 4, 5, 6, 2, 3}, (int[])ArrayUtils.insert((int)1, (int[])array, (int[])values));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3, 4, 5, 6}, (int[])ArrayUtils.insert((int)array.length, (int[])array, (int[])values));
    }

    @Test
    public void testInsertLongs() throws Exception {
        long[] array = new long[]{1L, 2L, 3L};
        long[] values = new long[]{4L, 5L, 6L};
        long[] result = ArrayUtils.insert((int)42, (long[])array, null);
        Assert.assertArrayEquals((long[])array, (long[])result);
        Assert.assertFalse((array == result ? 1 : 0) != 0);
        Assert.assertNull((Object)ArrayUtils.insert((int)42, null, (long[])array));
        Assert.assertArrayEquals((long[])new long[0], (long[])ArrayUtils.insert((int)0, (long[])new long[0], null));
        Assert.assertNull((Object)ArrayUtils.insert((int)42, (long[])null, null));
        try {
            ArrayUtils.insert((int)-1, (long[])array, (long[])array);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.insert((int)(array.length + 1), (long[])array, (long[])array);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertArrayEquals((long[])new long[]{0L, 1L, 2L, 3L}, (long[])ArrayUtils.insert((int)0, (long[])array, (long[])new long[]{0L}));
        Assert.assertArrayEquals((long[])new long[]{1L, 0L, 2L, 3L}, (long[])ArrayUtils.insert((int)1, (long[])array, (long[])new long[]{0L}));
        Assert.assertArrayEquals((long[])new long[]{1L, 2L, 3L, 0L}, (long[])ArrayUtils.insert((int)array.length, (long[])array, (long[])new long[]{0L}));
        Assert.assertArrayEquals((long[])new long[]{4L, 5L, 6L, 1L, 2L, 3L}, (long[])ArrayUtils.insert((int)0, (long[])array, (long[])values));
        Assert.assertArrayEquals((long[])new long[]{1L, 4L, 5L, 6L, 2L, 3L}, (long[])ArrayUtils.insert((int)1, (long[])array, (long[])values));
        Assert.assertArrayEquals((long[])new long[]{1L, 2L, 3L, 4L, 5L, 6L}, (long[])ArrayUtils.insert((int)array.length, (long[])array, (long[])values));
    }

    @Test
    public void testInsertShorts() throws Exception {
        short[] array = new short[]{1, 2, 3};
        short[] values = new short[]{4, 5, 6};
        short[] result = ArrayUtils.insert((int)42, (short[])array, null);
        Assert.assertArrayEquals((short[])array, (short[])result);
        Assert.assertFalse((array == result ? 1 : 0) != 0);
        Assert.assertNull((Object)ArrayUtils.insert((int)42, null, (short[])array));
        Assert.assertArrayEquals((short[])new short[0], (short[])ArrayUtils.insert((int)0, (short[])new short[0], null));
        Assert.assertNull((Object)ArrayUtils.insert((int)42, (short[])null, null));
        try {
            ArrayUtils.insert((int)-1, (short[])array, (short[])array);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.insert((int)(array.length + 1), (short[])array, (short[])array);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertArrayEquals((short[])new short[]{0, 1, 2, 3}, (short[])ArrayUtils.insert((int)0, (short[])array, (short[])new short[]{0}));
        Assert.assertArrayEquals((short[])new short[]{1, 0, 2, 3}, (short[])ArrayUtils.insert((int)1, (short[])array, (short[])new short[]{0}));
        Assert.assertArrayEquals((short[])new short[]{1, 2, 3, 0}, (short[])ArrayUtils.insert((int)array.length, (short[])array, (short[])new short[]{0}));
        Assert.assertArrayEquals((short[])new short[]{4, 5, 6, 1, 2, 3}, (short[])ArrayUtils.insert((int)0, (short[])array, (short[])values));
        Assert.assertArrayEquals((short[])new short[]{1, 4, 5, 6, 2, 3}, (short[])ArrayUtils.insert((int)1, (short[])array, (short[])values));
        Assert.assertArrayEquals((short[])new short[]{1, 2, 3, 4, 5, 6}, (short[])ArrayUtils.insert((int)array.length, (short[])array, (short[])values));
    }

    @Test
    public void testInsertGenericArray() throws Exception {
        Object[] array = new String[]{"a", "b", "c"};
        Object[] values = new String[]{"d", "e", "f"};
        Object[] result = (String[])ArrayUtils.insert((int)42, (Object[])array, (Object[])null);
        Assert.assertArrayEquals((Object[])array, (Object[])result);
        Assert.assertFalse((array == result ? 1 : 0) != 0);
        Assert.assertNull((Object)ArrayUtils.insert((int)42, null, (Object[])array));
        Assert.assertArrayEquals((Object[])new String[0], (Object[])ArrayUtils.insert((int)0, (Object[])new String[0], (Object[])null));
        Assert.assertNull((Object)ArrayUtils.insert((int)42, null, (Object[])null));
        try {
            ArrayUtils.insert((int)-1, (Object[])array, (Object[])array);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.insert((int)(array.length + 1), (Object[])array, (Object[])array);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertArrayEquals((Object[])new String[]{"z", "a", "b", "c"}, (Object[])ArrayUtils.insert((int)0, (Object[])array, (Object[])new String[]{"z"}));
        Assert.assertArrayEquals((Object[])new String[]{"a", "z", "b", "c"}, (Object[])ArrayUtils.insert((int)1, (Object[])array, (Object[])new String[]{"z"}));
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "z"}, (Object[])ArrayUtils.insert((int)array.length, (Object[])array, (Object[])new String[]{"z"}));
        Assert.assertArrayEquals((Object[])new String[]{"d", "e", "f", "a", "b", "c"}, (Object[])ArrayUtils.insert((int)0, (Object[])array, (Object[])values));
        Assert.assertArrayEquals((Object[])new String[]{"a", "d", "e", "f", "b", "c"}, (Object[])ArrayUtils.insert((int)1, (Object[])array, (Object[])values));
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "d", "e", "f"}, (Object[])ArrayUtils.insert((int)array.length, (Object[])array, (Object[])values));
    }
}

