/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.EventCountCircuitBreaker;
import org.junit.Assert;
import org.junit.Test;

public class EventCountCircuitBreakerTest {
    private static final int OPENING_THRESHOLD = 10;
    private static final int CLOSING_THRESHOLD = 5;
    private static final long NANO_FACTOR = 1000000000L;

    @Test
    public void testIntervalCalculation() {
        EventCountCircuitBreaker breaker = new EventCountCircuitBreaker(10, 1L, TimeUnit.SECONDS, 5, 2L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((String)"Wrong opening interval", (long)1000000000L, (long)breaker.getOpeningInterval());
        Assert.assertEquals((String)"Wrong closing interval", (long)2000000L, (long)breaker.getClosingInterval());
    }

    @Test
    public void testDefaultClosingInterval() {
        EventCountCircuitBreaker breaker = new EventCountCircuitBreaker(10, 1L, TimeUnit.SECONDS, 5);
        Assert.assertEquals((String)"Wrong closing interval", (long)1000000000L, (long)breaker.getClosingInterval());
    }

    @Test
    public void testDefaultClosingThreshold() {
        EventCountCircuitBreaker breaker = new EventCountCircuitBreaker(10, 1L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"Wrong closing interval", (long)1000000000L, (long)breaker.getClosingInterval());
        Assert.assertEquals((String)"Wrong closing threshold", (long)10L, (long)breaker.getClosingThreshold());
    }

    @Test
    public void testInitiallyClosed() {
        EventCountCircuitBreaker breaker = new EventCountCircuitBreaker(10, 1L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"Open", (boolean)breaker.isOpen());
        Assert.assertTrue((String)"Not closed", (boolean)breaker.isClosed());
    }

    @Test
    public void testNow() {
        EventCountCircuitBreaker breaker = new EventCountCircuitBreaker(10, 1L, TimeUnit.SECONDS);
        long now = breaker.now();
        long delta = Math.abs(System.nanoTime() - now);
        Assert.assertTrue((String)String.format("Delta %d ns to current time too large", delta), (delta < 100000L ? 1 : 0) != 0);
    }

    @Test
    public void testNotOpeningUnderThreshold() {
        long startTime = 1000L;
        EventCountCircuitBreakerTestImpl breaker = new EventCountCircuitBreakerTestImpl(10, 1L, TimeUnit.SECONDS, 5, 1L, TimeUnit.SECONDS);
        for (int i = 0; i < 9; ++i) {
            Assert.assertTrue((String)"In open state", (boolean)breaker.at(startTime).incrementAndCheckState());
            ++startTime;
        }
        Assert.assertTrue((String)"Not closed", (boolean)breaker.isClosed());
    }

    @Test
    public void testNotOpeningCheckIntervalExceeded() {
        long startTime = 0L;
        long timeIncrement = 150000000L;
        EventCountCircuitBreakerTestImpl breaker = new EventCountCircuitBreakerTestImpl(10, 1L, TimeUnit.SECONDS, 5, 1L, TimeUnit.SECONDS);
        for (int i = 0; i < 50; ++i) {
            Assert.assertTrue((String)"In open state", (boolean)breaker.at(startTime).incrementAndCheckState());
            startTime += 150000000L;
        }
        Assert.assertTrue((String)"Not closed", (boolean)breaker.isClosed());
    }

    @Test
    public void testOpeningWhenThresholdReached() {
        long startTime = 0L;
        long timeIncrement = 99999999L;
        EventCountCircuitBreakerTestImpl breaker = new EventCountCircuitBreakerTestImpl(10, 1L, TimeUnit.SECONDS, 5, 1L, TimeUnit.SECONDS);
        boolean open = false;
        for (int i = 0; i < 11; ++i) {
            open = !breaker.at(startTime).incrementAndCheckState();
            startTime += 99999999L;
        }
        Assert.assertTrue((String)"Not open", (boolean)open);
        Assert.assertFalse((String)"Closed", (boolean)breaker.isClosed());
    }

    @Test
    public void testNotClosingOverThreshold() {
        EventCountCircuitBreakerTestImpl breaker = new EventCountCircuitBreakerTestImpl(10, 10L, TimeUnit.SECONDS, 5, 1L, TimeUnit.SECONDS);
        long startTime = 0L;
        breaker.open();
        for (int i = 0; i <= 5; ++i) {
            Assert.assertFalse((String)"Not open", (boolean)breaker.at(startTime).incrementAndCheckState());
            startTime += 1000L;
        }
        Assert.assertFalse((String)"Closed in new interval", (boolean)breaker.at(startTime + 1000000000L).incrementAndCheckState());
        Assert.assertTrue((String)"Not open at end", (boolean)breaker.isOpen());
    }

    @Test
    public void testClosingWhenThresholdReached() {
        EventCountCircuitBreakerTestImpl breaker = new EventCountCircuitBreakerTestImpl(10, 10L, TimeUnit.SECONDS, 5, 1L, TimeUnit.SECONDS);
        breaker.open();
        breaker.at(1000L).incrementAndCheckState();
        Assert.assertFalse((String)"Already closed", (boolean)breaker.at(2000L).checkState());
        Assert.assertFalse((String)"Closed at interval end", (boolean)breaker.at(1000000000L).checkState());
        Assert.assertTrue((String)"Not closed after interval end", (boolean)breaker.at(1000000001L).checkState());
        Assert.assertTrue((String)"Not closed at end", (boolean)breaker.isClosed());
    }

    @Test
    public void testOpenStartsNewCheckInterval() {
        EventCountCircuitBreakerTestImpl breaker = new EventCountCircuitBreakerTestImpl(10, 2L, TimeUnit.SECONDS, 5, 1L, TimeUnit.SECONDS);
        breaker.at(999999000L).open();
        Assert.assertTrue((String)"Not open", (boolean)breaker.isOpen());
        Assert.assertFalse((String)"Already closed", (boolean)breaker.at(1000000100L).checkState());
    }

    @Test
    public void testAutomaticOpenStartsNewCheckInterval() {
        EventCountCircuitBreakerTestImpl breaker = new EventCountCircuitBreakerTestImpl(10, 2L, TimeUnit.SECONDS, 5, 1L, TimeUnit.SECONDS);
        long time = 10000000000L;
        for (int i = 0; i <= 10; ++i) {
            breaker.at(time++).incrementAndCheckState();
        }
        Assert.assertTrue((String)"Not open", (boolean)breaker.isOpen());
        Assert.assertFalse((String)"Already closed", (boolean)breaker.at(time += 999999000L).incrementAndCheckState());
        Assert.assertTrue((String)"Not closed in time interval", (boolean)breaker.at(time += 1001L).checkState());
    }

    @Test
    public void testClose() {
        EventCountCircuitBreakerTestImpl breaker = new EventCountCircuitBreakerTestImpl(10, 2L, TimeUnit.SECONDS, 5, 1L, TimeUnit.SECONDS);
        long time = 0L;
        int i = 0;
        while (i <= 10) {
            breaker.at(time).incrementAndCheckState();
            ++i;
            time += 1000L;
        }
        Assert.assertTrue((String)"Not open", (boolean)breaker.isOpen());
        breaker.close();
        Assert.assertTrue((String)"Not closed", (boolean)breaker.isClosed());
        Assert.assertTrue((String)"Open again", (boolean)breaker.at(time + 1000L).incrementAndCheckState());
    }

    @Test
    public void testChangeEvents() {
        EventCountCircuitBreaker breaker = new EventCountCircuitBreaker(10, 1L, TimeUnit.SECONDS);
        ChangeListener listener = new ChangeListener(breaker);
        breaker.addChangeListener((PropertyChangeListener)listener);
        breaker.open();
        breaker.close();
        listener.verify(Boolean.TRUE, Boolean.FALSE);
    }

    @Test
    public void testRemoveChangeListener() {
        EventCountCircuitBreaker breaker = new EventCountCircuitBreaker(10, 1L, TimeUnit.SECONDS);
        ChangeListener listener = new ChangeListener(breaker);
        breaker.addChangeListener((PropertyChangeListener)listener);
        breaker.open();
        breaker.removeChangeListener((PropertyChangeListener)listener);
        breaker.close();
        listener.verify(Boolean.TRUE);
    }

    @Test
    public void testStateTransitionGuarded() throws InterruptedException {
        final EventCountCircuitBreaker breaker = new EventCountCircuitBreaker(10, 1L, TimeUnit.SECONDS);
        ChangeListener listener = new ChangeListener(breaker);
        breaker.addChangeListener((PropertyChangeListener)listener);
        int threadCount = 128;
        final CountDownLatch latch = new CountDownLatch(1);
        Thread[] threads = new Thread[128];
        for (int i = 0; i < 128; ++i) {
            threads[i] = new Thread(){

                @Override
                public void run() {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    breaker.open();
                }
            };
            threads[i].start();
        }
        latch.countDown();
        for (Thread thread : threads) {
            thread.join();
        }
        listener.verify(Boolean.TRUE);
    }

    @Test
    public void testChangeEventsGeneratedByAutomaticTransitions() {
        EventCountCircuitBreakerTestImpl breaker = new EventCountCircuitBreakerTestImpl(10, 2L, TimeUnit.SECONDS, 5, 1L, TimeUnit.SECONDS);
        ChangeListener listener = new ChangeListener((Object)breaker);
        breaker.addChangeListener(listener);
        long time = 0L;
        int i = 0;
        while (i <= 10) {
            breaker.at(time).incrementAndCheckState();
            ++i;
            time += 1000L;
        }
        breaker.at(1000000001L).checkState();
        breaker.at(3000000000L).checkState();
        listener.verify(Boolean.TRUE, Boolean.FALSE);
    }

    private static class ChangeListener
    implements PropertyChangeListener {
        private final Object expectedSource;
        private final List<Boolean> changedValues;

        ChangeListener(Object source) {
            this.expectedSource = source;
            this.changedValues = new ArrayList<Boolean>();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Assert.assertEquals((String)"Wrong event source", (Object)this.expectedSource, (Object)evt.getSource());
            Assert.assertEquals((String)"Wrong property name", (Object)"open", (Object)evt.getPropertyName());
            Boolean newValue = (Boolean)evt.getNewValue();
            Boolean oldValue = (Boolean)evt.getOldValue();
            Assert.assertNotEquals((String)"Old and new value are equal", (Object)newValue, (Object)oldValue);
            this.changedValues.add(newValue);
        }

        public void verify(Boolean ... values) {
            Assert.assertArrayEquals((Object[])values, (Object[])this.changedValues.toArray(new Boolean[this.changedValues.size()]));
        }
    }

    private static class EventCountCircuitBreakerTestImpl
    extends EventCountCircuitBreaker {
        private long currentTime;

        EventCountCircuitBreakerTestImpl(int openingThreshold, long openingInterval, TimeUnit openingUnit, int closingThreshold, long closingInterval, TimeUnit closingUnit) {
            super(openingThreshold, openingInterval, openingUnit, closingThreshold, closingInterval, closingUnit);
        }

        public EventCountCircuitBreakerTestImpl at(long time) {
            this.currentTime = time;
            return this;
        }

        long now() {
            return this.currentTime;
        }
    }
}

