/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.test;

import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.test.SystemDefaults;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SystemDefaultsSwitch
implements TestRule {
    public Statement apply(Statement stmt, Description description) {
        SystemDefaults defaults = (SystemDefaults)description.getAnnotation(SystemDefaults.class);
        if (defaults == null) {
            return stmt;
        }
        return this.applyTimeZone(defaults, this.applyLocale(defaults, stmt));
    }

    private Statement applyTimeZone(SystemDefaults defaults, final Statement stmt) {
        if (defaults.timezone().isEmpty()) {
            return stmt;
        }
        final TimeZone newTimeZone = TimeZone.getTimeZone(defaults.timezone());
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                TimeZone save = TimeZone.getDefault();
                try {
                    TimeZone.setDefault(newTimeZone);
                    stmt.evaluate();
                }
                finally {
                    TimeZone.setDefault(save);
                }
            }
        };
    }

    private Statement applyLocale(SystemDefaults defaults, final Statement stmt) {
        if (defaults.locale().isEmpty()) {
            return stmt;
        }
        final Locale newLocale = LocaleUtils.toLocale((String)defaults.locale());
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                Locale save = Locale.getDefault();
                try {
                    Locale.setDefault(newLocale);
                    stmt.evaluate();
                }
                finally {
                    Locale.setDefault(save);
                }
            }
        };
    }
}

