/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.ArchUtils;
import org.apache.commons.lang3.arch.Processor;
import org.junit.Assert;
import org.junit.Test;

public class ArchUtilsTest {
    private static final String X86 = "x86";
    private static final String X86_64 = "x86_64";
    private static final String IA64 = "ia64";
    private static final String IA64_32 = "ia64_32";
    private static final String PPC = "ppc";
    private static final String PPC64 = "ppc64";

    @Test
    public void testIs32BitJVM() {
        Processor processor = ArchUtils.getProcessor((String)X86);
        this.assertEqualsArchNotNull(Processor.Arch.BIT_32, processor);
        Assert.assertTrue((boolean)processor.is32Bit());
        processor = ArchUtils.getProcessor((String)IA64_32);
        this.assertEqualsArchNotNull(Processor.Arch.BIT_32, processor);
        Assert.assertTrue((boolean)processor.is32Bit());
        processor = ArchUtils.getProcessor((String)PPC);
        this.assertEqualsArchNotNull(Processor.Arch.BIT_32, processor);
        processor.is32Bit();
        processor = ArchUtils.getProcessor((String)X86_64);
        this.assertNotEqualsArchNotNull(Processor.Arch.BIT_32, processor);
        Assert.assertFalse((boolean)processor.is32Bit());
        processor = ArchUtils.getProcessor((String)PPC64);
        this.assertNotEqualsArchNotNull(Processor.Arch.BIT_32, processor);
        Assert.assertFalse((boolean)processor.is32Bit());
        processor = ArchUtils.getProcessor((String)IA64);
        this.assertNotEqualsArchNotNull(Processor.Arch.BIT_32, processor);
        Assert.assertFalse((boolean)processor.is32Bit());
    }

    @Test
    public void testIs64BitJVM() {
        Processor processor = ArchUtils.getProcessor((String)X86_64);
        this.assertEqualsArchNotNull(Processor.Arch.BIT_64, processor);
        Assert.assertTrue((boolean)processor.is64Bit());
        processor = ArchUtils.getProcessor((String)PPC64);
        this.assertEqualsArchNotNull(Processor.Arch.BIT_64, processor);
        Assert.assertTrue((boolean)processor.is64Bit());
        processor = ArchUtils.getProcessor((String)IA64);
        this.assertEqualsArchNotNull(Processor.Arch.BIT_64, processor);
        Assert.assertTrue((boolean)processor.is64Bit());
        processor = ArchUtils.getProcessor((String)X86);
        this.assertNotEqualsArchNotNull(Processor.Arch.BIT_64, processor);
        Assert.assertFalse((boolean)processor.is64Bit());
        processor = ArchUtils.getProcessor((String)PPC);
        this.assertNotEqualsArchNotNull(Processor.Arch.BIT_64, processor);
        Assert.assertFalse((boolean)processor.is64Bit());
        processor = ArchUtils.getProcessor((String)IA64_32);
        this.assertNotEqualsArchNotNull(Processor.Arch.BIT_64, processor);
        Assert.assertFalse((boolean)processor.is64Bit());
    }

    @Test
    public void testArch() {
        Processor processor = ArchUtils.getProcessor((String)X86);
        this.assertEqualsTypeNotNull(Processor.Type.X86, processor);
        Assert.assertTrue((boolean)processor.isX86());
        this.assertNotEqualsTypeNotNull(Processor.Type.PPC, processor);
        Assert.assertFalse((boolean)processor.isPPC());
        processor = ArchUtils.getProcessor((String)X86_64);
        this.assertEqualsTypeNotNull(Processor.Type.X86, processor);
        Assert.assertTrue((boolean)processor.isX86());
        processor = ArchUtils.getProcessor((String)IA64_32);
        this.assertEqualsTypeNotNull(Processor.Type.IA_64, processor);
        Assert.assertTrue((boolean)processor.isIA64());
        processor = ArchUtils.getProcessor((String)IA64);
        this.assertEqualsTypeNotNull(Processor.Type.IA_64, processor);
        Assert.assertTrue((boolean)processor.isIA64());
        this.assertNotEqualsTypeNotNull(Processor.Type.X86, processor);
        Assert.assertFalse((boolean)processor.isX86());
        processor = ArchUtils.getProcessor((String)PPC);
        this.assertEqualsTypeNotNull(Processor.Type.PPC, processor);
        Assert.assertTrue((boolean)processor.isPPC());
        this.assertNotEqualsTypeNotNull(Processor.Type.IA_64, processor);
        Assert.assertFalse((boolean)processor.isIA64());
        processor = ArchUtils.getProcessor((String)PPC64);
        this.assertEqualsTypeNotNull(Processor.Type.PPC, processor);
        Assert.assertTrue((boolean)processor.isPPC());
    }

    @Test
    public void testGetProcessor() {
        Assert.assertNotNull((Object)ArchUtils.getProcessor((String)X86));
        Assert.assertNull((Object)ArchUtils.getProcessor((String)"NA"));
    }

    private void assertEqualsArchNotNull(Processor.Arch arch, Processor processor) {
        Assert.assertNotNull((Object)arch);
        Assert.assertNotNull((Object)processor);
        Assert.assertEquals((Object)arch, (Object)processor.getArch());
    }

    private void assertNotEqualsArchNotNull(Processor.Arch arch, Processor processor) {
        Assert.assertNotNull((Object)arch);
        Assert.assertNotNull((Object)processor);
        Assert.assertNotEquals((Object)arch, (Object)processor.getArch());
    }

    private void assertEqualsTypeNotNull(Processor.Type type, Processor processor) {
        Assert.assertNotNull((Object)type);
        Assert.assertNotNull((Object)processor);
        Assert.assertEquals((Object)type, (Object)processor.getType());
    }

    private void assertNotEqualsTypeNotNull(Processor.Type type, Processor processor) {
        Assert.assertNotNull((Object)type);
        Assert.assertNotNull((Object)processor);
        Assert.assertNotEquals((Object)type, (Object)processor.getType());
    }
}

