/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.CharEncoding;
import org.junit.Assert;
import org.junit.Test;

public class CharEncodingTest {
    private void assertSupportedEncoding(String name) {
        Assert.assertTrue((String)("Encoding should be supported: " + name), (boolean)CharEncoding.isSupported((String)name));
    }

    @Test
    public void testConstructor() {
        new CharEncoding();
    }

    @Test
    public void testMustBeSupportedJava1_3_1_and_above() {
        this.assertSupportedEncoding("ISO-8859-1");
        this.assertSupportedEncoding("US-ASCII");
        this.assertSupportedEncoding("UTF-16");
        this.assertSupportedEncoding("UTF-16BE");
        this.assertSupportedEncoding("UTF-16LE");
        this.assertSupportedEncoding("UTF-8");
    }

    @Test
    public void testSupported() {
        Assert.assertTrue((boolean)CharEncoding.isSupported((String)"UTF8"));
        Assert.assertTrue((boolean)CharEncoding.isSupported((String)"UTF-8"));
        Assert.assertTrue((boolean)CharEncoding.isSupported((String)"ASCII"));
    }

    @Test
    public void testNotSupported() {
        Assert.assertFalse((boolean)CharEncoding.isSupported(null));
        Assert.assertFalse((boolean)CharEncoding.isSupported((String)""));
        Assert.assertFalse((boolean)CharEncoding.isSupported((String)" "));
        Assert.assertFalse((boolean)CharEncoding.isSupported((String)"\t\r\n"));
        Assert.assertFalse((boolean)CharEncoding.isSupported((String)"DOESNOTEXIST"));
        Assert.assertFalse((boolean)CharEncoding.isSupported((String)"this is not a valid encoding name"));
    }

    @Test
    public void testStandardCharsetsEquality() throws Exception {
        Assert.assertEquals((Object)StandardCharsets.ISO_8859_1.name(), (Object)"ISO-8859-1");
        Assert.assertEquals((Object)StandardCharsets.US_ASCII.name(), (Object)"US-ASCII");
        Assert.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)"UTF-8");
        Assert.assertEquals((Object)StandardCharsets.UTF_16.name(), (Object)"UTF-16");
        Assert.assertEquals((Object)StandardCharsets.UTF_16BE.name(), (Object)"UTF-16BE");
        Assert.assertEquals((Object)StandardCharsets.UTF_16LE.name(), (Object)"UTF-16LE");
    }
}

