/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.lang3.time.FastTimeZone;
import org.junit.Assert;
import org.junit.Test;

public class DurationFormatUtilsTest {
    private static final int FOUR_YEARS = 1461;

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)new DurationFormatUtils());
        Constructor<?>[] cons = DurationFormatUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertTrue((boolean)Modifier.isPublic(DurationFormatUtils.class.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isFinal(DurationFormatUtils.class.getModifiers()));
    }

    @Test
    public void testFormatDurationWords() {
        String text = null;
        text = DurationFormatUtils.formatDurationWords((long)50000L, (boolean)true, (boolean)false);
        Assert.assertEquals((Object)"50 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)65000L, (boolean)true, (boolean)false);
        Assert.assertEquals((Object)"1 minute 5 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)120000L, (boolean)true, (boolean)false);
        Assert.assertEquals((Object)"2 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)121000L, (boolean)true, (boolean)false);
        Assert.assertEquals((Object)"2 minutes 1 second", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)4320000L, (boolean)true, (boolean)false);
        Assert.assertEquals((Object)"1 hour 12 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)86400000L, (boolean)true, (boolean)false);
        Assert.assertEquals((Object)"1 day 0 hours 0 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)50000L, (boolean)true, (boolean)true);
        Assert.assertEquals((Object)"50 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)65000L, (boolean)true, (boolean)true);
        Assert.assertEquals((Object)"1 minute 5 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)120000L, (boolean)true, (boolean)true);
        Assert.assertEquals((Object)"2 minutes", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)121000L, (boolean)true, (boolean)true);
        Assert.assertEquals((Object)"2 minutes 1 second", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)4320000L, (boolean)true, (boolean)true);
        Assert.assertEquals((Object)"1 hour 12 minutes", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)86400000L, (boolean)true, (boolean)true);
        Assert.assertEquals((Object)"1 day", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)50000L, (boolean)false, (boolean)true);
        Assert.assertEquals((Object)"0 days 0 hours 0 minutes 50 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)65000L, (boolean)false, (boolean)true);
        Assert.assertEquals((Object)"0 days 0 hours 1 minute 5 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)120000L, (boolean)false, (boolean)true);
        Assert.assertEquals((Object)"0 days 0 hours 2 minutes", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)121000L, (boolean)false, (boolean)true);
        Assert.assertEquals((Object)"0 days 0 hours 2 minutes 1 second", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)4320000L, (boolean)false, (boolean)true);
        Assert.assertEquals((Object)"0 days 1 hour 12 minutes", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)86400000L, (boolean)false, (boolean)true);
        Assert.assertEquals((Object)"1 day", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)50000L, (boolean)false, (boolean)false);
        Assert.assertEquals((Object)"0 days 0 hours 0 minutes 50 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)65000L, (boolean)false, (boolean)false);
        Assert.assertEquals((Object)"0 days 0 hours 1 minute 5 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)120000L, (boolean)false, (boolean)false);
        Assert.assertEquals((Object)"0 days 0 hours 2 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)121000L, (boolean)false, (boolean)false);
        Assert.assertEquals((Object)"0 days 0 hours 2 minutes 1 second", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)4320000L, (boolean)false, (boolean)false);
        Assert.assertEquals((Object)"0 days 1 hour 12 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)90720000L, (boolean)false, (boolean)false);
        Assert.assertEquals((Object)"1 day 1 hour 12 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)177120000L, (boolean)false, (boolean)false);
        Assert.assertEquals((Object)"2 days 1 hour 12 minutes 0 seconds", (Object)text);
        for (int i = 2; i < 31; ++i) {
            text = DurationFormatUtils.formatDurationWords((long)((long)(i * 24 * 60 * 60) * 1000L), (boolean)false, (boolean)false);
            Assert.assertEquals((Object)(i + " days 0 hours 0 minutes 0 seconds"), (Object)text);
        }
    }

    @Test
    public void testFormatDurationPluralWords() {
        long oneSecond = 1000L;
        long oneMinute = 60000L;
        long oneHour = 3600000L;
        long oneDay = 86400000L;
        String text = null;
        text = DurationFormatUtils.formatDurationWords((long)1000L, (boolean)false, (boolean)false);
        Assert.assertEquals((Object)"0 days 0 hours 0 minutes 1 second", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)2000L, (boolean)false, (boolean)false);
        Assert.assertEquals((Object)"0 days 0 hours 0 minutes 2 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)11000L, (boolean)false, (boolean)false);
        Assert.assertEquals((Object)"0 days 0 hours 0 minutes 11 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)60000L, (boolean)false, (boolean)false);
        Assert.assertEquals((Object)"0 days 0 hours 1 minute 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)120000L, (boolean)false, (boolean)false);
        Assert.assertEquals((Object)"0 days 0 hours 2 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)660000L, (boolean)false, (boolean)false);
        Assert.assertEquals((Object)"0 days 0 hours 11 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)61000L, (boolean)false, (boolean)false);
        Assert.assertEquals((Object)"0 days 0 hours 1 minute 1 second", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)3600000L, (boolean)false, (boolean)false);
        Assert.assertEquals((Object)"0 days 1 hour 0 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)0x6DDD00L, (boolean)false, (boolean)false);
        Assert.assertEquals((Object)"0 days 2 hours 0 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)39600000L, (boolean)false, (boolean)false);
        Assert.assertEquals((Object)"0 days 11 hours 0 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)3661000L, (boolean)false, (boolean)false);
        Assert.assertEquals((Object)"0 days 1 hour 1 minute 1 second", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)86400000L, (boolean)false, (boolean)false);
        Assert.assertEquals((Object)"1 day 0 hours 0 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)172800000L, (boolean)false, (boolean)false);
        Assert.assertEquals((Object)"2 days 0 hours 0 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)950400000L, (boolean)false, (boolean)false);
        Assert.assertEquals((Object)"11 days 0 hours 0 minutes 0 seconds", (Object)text);
        text = DurationFormatUtils.formatDurationWords((long)90061000L, (boolean)false, (boolean)false);
        Assert.assertEquals((Object)"1 day 1 hour 1 minute 1 second", (Object)text);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFormatNegativeDurationWords() throws Exception {
        DurationFormatUtils.formatDurationWords((long)-5000L, (boolean)true, (boolean)true);
    }

    @Test
    public void testFormatDurationHMS() {
        long time = 0L;
        Assert.assertEquals((Object)"00:00:00.000", (Object)DurationFormatUtils.formatDurationHMS((long)time));
        time = 1L;
        Assert.assertEquals((Object)"00:00:00.001", (Object)DurationFormatUtils.formatDurationHMS((long)time));
        time = 15L;
        Assert.assertEquals((Object)"00:00:00.015", (Object)DurationFormatUtils.formatDurationHMS((long)time));
        time = 165L;
        Assert.assertEquals((Object)"00:00:00.165", (Object)DurationFormatUtils.formatDurationHMS((long)time));
        time = 1675L;
        Assert.assertEquals((Object)"00:00:01.675", (Object)DurationFormatUtils.formatDurationHMS((long)time));
        time = 13465L;
        Assert.assertEquals((Object)"00:00:13.465", (Object)DurationFormatUtils.formatDurationHMS((long)time));
        time = 72789L;
        Assert.assertEquals((Object)"00:01:12.789", (Object)DurationFormatUtils.formatDurationHMS((long)time));
        time = 1932789L;
        Assert.assertEquals((Object)"00:32:12.789", (Object)DurationFormatUtils.formatDurationHMS((long)time));
        time = 3732789L;
        Assert.assertEquals((Object)"01:02:12.789", (Object)DurationFormatUtils.formatDurationHMS((long)time));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFormatNegativeDurationHMS() throws Exception {
        DurationFormatUtils.formatDurationHMS((long)-5000L);
    }

    @Test
    public void testFormatDurationISO() {
        Assert.assertEquals((Object)"P0Y0M0DT0H0M0.000S", (Object)DurationFormatUtils.formatDurationISO((long)0L));
        Assert.assertEquals((Object)"P0Y0M0DT0H0M0.001S", (Object)DurationFormatUtils.formatDurationISO((long)1L));
        Assert.assertEquals((Object)"P0Y0M0DT0H0M0.010S", (Object)DurationFormatUtils.formatDurationISO((long)10L));
        Assert.assertEquals((Object)"P0Y0M0DT0H0M0.100S", (Object)DurationFormatUtils.formatDurationISO((long)100L));
        Assert.assertEquals((Object)"P0Y0M0DT0H1M15.321S", (Object)DurationFormatUtils.formatDurationISO((long)75321L));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFormatNegativeDurationISO() throws Exception {
        DurationFormatUtils.formatDurationISO((long)-5000L);
    }

    @Test
    public void testFormatDuration() {
        long duration = 0L;
        Assert.assertEquals((Object)"0", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"y"));
        Assert.assertEquals((Object)"0", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"M"));
        Assert.assertEquals((Object)"0", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"d"));
        Assert.assertEquals((Object)"0", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"H"));
        Assert.assertEquals((Object)"0", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"m"));
        Assert.assertEquals((Object)"0", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"s"));
        Assert.assertEquals((Object)"0", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"S"));
        Assert.assertEquals((Object)"0000", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"SSSS"));
        Assert.assertEquals((Object)"0000", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"yyyy"));
        Assert.assertEquals((Object)"0000", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"yyMM"));
        duration = 60000L;
        Assert.assertEquals((Object)"0", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"y"));
        Assert.assertEquals((Object)"0", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"M"));
        Assert.assertEquals((Object)"0", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"d"));
        Assert.assertEquals((Object)"0", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"H"));
        Assert.assertEquals((Object)"1", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"m"));
        Assert.assertEquals((Object)"60", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"s"));
        Assert.assertEquals((Object)"60000", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"S"));
        Assert.assertEquals((Object)"01:00", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"mm:ss"));
        Calendar base = Calendar.getInstance();
        base.set(2000, 0, 1, 0, 0, 0);
        base.set(14, 0);
        Calendar cal = Calendar.getInstance();
        cal.set(2003, 1, 1, 0, 0, 0);
        cal.set(14, 0);
        duration = cal.getTime().getTime() - base.getTime().getTime();
        int days = 1127;
        Assert.assertEquals((Object)"0 0 1127", (Object)DurationFormatUtils.formatDuration((long)duration, (String)"y M d"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFormatNegativeDuration() throws Exception {
        DurationFormatUtils.formatDuration((long)-5000L, (String)"S", (boolean)true);
    }

    @Test
    public void testFormatPeriodISO() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT-3");
        Calendar base = Calendar.getInstance(timeZone);
        base.set(1970, 0, 1, 0, 0, 0);
        base.set(14, 0);
        Calendar cal = Calendar.getInstance(timeZone);
        cal.set(2002, 1, 23, 9, 11, 12);
        cal.set(14, 1);
        String text = DateFormatUtils.format((Calendar)cal, (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern(), (TimeZone)timeZone);
        Assert.assertEquals((Object)"2002-02-23T09:11:12-03:00", (Object)text);
        text = DurationFormatUtils.formatPeriod((long)base.getTime().getTime(), (long)cal.getTime().getTime(), (String)"'P'yyyy'Y'M'M'd'DT'H'H'm'M's.SSS'S'", (boolean)false, (TimeZone)timeZone);
        Assert.assertEquals((Object)"P32Y1M22DT9H11M12.001S", (Object)text);
        cal.set(1971, 1, 3, 10, 30, 0);
        cal.set(14, 0);
        text = DurationFormatUtils.formatPeriod((long)base.getTime().getTime(), (long)cal.getTime().getTime(), (String)"'P'yyyy'Y'M'M'd'DT'H'H'm'M's.SSS'S'", (boolean)false, (TimeZone)timeZone);
        Assert.assertEquals((Object)"P1Y1M2DT10H30M0.000S", (Object)text);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFormatPeriodISOStartGreaterEnd() throws Exception {
        DurationFormatUtils.formatPeriodISO((long)5000L, (long)2000L);
    }

    @Test
    public void testFormatPeriodISOMethod() {
        Assert.assertEquals((Object)"P0Y0M0DT0H0M0.000S", (Object)DurationFormatUtils.formatPeriodISO((long)0L, (long)0L));
        Assert.assertEquals((Object)"P0Y0M0DT0H0M1.000S", (Object)DurationFormatUtils.formatPeriodISO((long)0L, (long)1000L));
        Assert.assertEquals((Object)"P0Y0M0DT0H1M1.000S", (Object)DurationFormatUtils.formatPeriodISO((long)0L, (long)61000L));
    }

    @Test
    public void testFormatPeriod() {
        Calendar cal1970 = Calendar.getInstance();
        cal1970.set(1970, 0, 1, 0, 0, 0);
        cal1970.set(14, 0);
        long time1970 = cal1970.getTime().getTime();
        Assert.assertEquals((Object)"0", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"y"));
        Assert.assertEquals((Object)"0", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"M"));
        Assert.assertEquals((Object)"0", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"d"));
        Assert.assertEquals((Object)"0", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"H"));
        Assert.assertEquals((Object)"0", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"m"));
        Assert.assertEquals((Object)"0", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"s"));
        Assert.assertEquals((Object)"0", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"S"));
        Assert.assertEquals((Object)"0000", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"SSSS"));
        Assert.assertEquals((Object)"0000", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"yyyy"));
        Assert.assertEquals((Object)"0000", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"yyMM"));
        long time = time1970 + 60000L;
        Assert.assertEquals((Object)"0", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"y"));
        Assert.assertEquals((Object)"0", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"M"));
        Assert.assertEquals((Object)"0", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"d"));
        Assert.assertEquals((Object)"0", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"H"));
        Assert.assertEquals((Object)"1", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"m"));
        Assert.assertEquals((Object)"60", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"s"));
        Assert.assertEquals((Object)"60000", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"S"));
        Assert.assertEquals((Object)"01:00", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"mm:ss"));
        Calendar cal = Calendar.getInstance();
        cal.set(1973, 6, 1, 0, 0, 0);
        cal.set(14, 0);
        time = cal.getTime().getTime();
        Assert.assertEquals((Object)"36", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"yM"));
        Assert.assertEquals((Object)"3 years 6 months", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"y' years 'M' months'"));
        Assert.assertEquals((Object)"03/06", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"yy/MM"));
        cal.set(1973, 10, 1, 0, 0, 0);
        cal.set(14, 0);
        time = cal.getTime().getTime();
        Assert.assertEquals((Object)"310", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"yM"));
        Assert.assertEquals((Object)"3 years 10 months", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"y' years 'M' months'"));
        Assert.assertEquals((Object)"03/10", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"yy/MM"));
        cal.set(1974, 0, 1, 0, 0, 0);
        cal.set(14, 0);
        time = cal.getTime().getTime();
        Assert.assertEquals((Object)"40", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"yM"));
        Assert.assertEquals((Object)"4 years 0 months", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"y' years 'M' months'"));
        Assert.assertEquals((Object)"04/00", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"yy/MM"));
        Assert.assertEquals((Object)"48", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"M"));
        Assert.assertEquals((Object)"48", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"MM"));
        Assert.assertEquals((Object)"048", (Object)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"MMM"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFormatPeriodeStartGreaterEnd() throws Exception {
        DurationFormatUtils.formatPeriod((long)5000L, (long)2500L, (String)"yy/MM");
    }

    @Test
    public void testLexx() {
        Assert.assertArrayEquals((Object[])new DurationFormatUtils.Token[]{new DurationFormatUtils.Token(DurationFormatUtils.y, 1), new DurationFormatUtils.Token(DurationFormatUtils.M, 1), new DurationFormatUtils.Token(DurationFormatUtils.d, 1), new DurationFormatUtils.Token(DurationFormatUtils.H, 1), new DurationFormatUtils.Token(DurationFormatUtils.m, 1), new DurationFormatUtils.Token(DurationFormatUtils.s, 1), new DurationFormatUtils.Token(DurationFormatUtils.S, 1)}, (Object[])DurationFormatUtils.lexx((String)"yMdHmsS"));
        Assert.assertArrayEquals((Object[])new DurationFormatUtils.Token[]{new DurationFormatUtils.Token(DurationFormatUtils.H, 2), new DurationFormatUtils.Token((Object)new StringBuilder(":"), 1), new DurationFormatUtils.Token(DurationFormatUtils.m, 2), new DurationFormatUtils.Token((Object)new StringBuilder(":"), 1), new DurationFormatUtils.Token(DurationFormatUtils.s, 2), new DurationFormatUtils.Token((Object)new StringBuilder("."), 1), new DurationFormatUtils.Token(DurationFormatUtils.S, 3)}, (Object[])DurationFormatUtils.lexx((String)"HH:mm:ss.SSS"));
        Assert.assertArrayEquals((Object[])new DurationFormatUtils.Token[]{new DurationFormatUtils.Token((Object)new StringBuilder("P"), 1), new DurationFormatUtils.Token(DurationFormatUtils.y, 4), new DurationFormatUtils.Token((Object)new StringBuilder("Y"), 1), new DurationFormatUtils.Token(DurationFormatUtils.M, 1), new DurationFormatUtils.Token((Object)new StringBuilder("M"), 1), new DurationFormatUtils.Token(DurationFormatUtils.d, 1), new DurationFormatUtils.Token((Object)new StringBuilder("DT"), 1), new DurationFormatUtils.Token(DurationFormatUtils.H, 1), new DurationFormatUtils.Token((Object)new StringBuilder("H"), 1), new DurationFormatUtils.Token(DurationFormatUtils.m, 1), new DurationFormatUtils.Token((Object)new StringBuilder("M"), 1), new DurationFormatUtils.Token(DurationFormatUtils.s, 1), new DurationFormatUtils.Token((Object)new StringBuilder("."), 1), new DurationFormatUtils.Token(DurationFormatUtils.S, 3), new DurationFormatUtils.Token((Object)new StringBuilder("S"), 1)}, (Object[])DurationFormatUtils.lexx((String)"'P'yyyy'Y'M'M'd'DT'H'H'm'M's.SSS'S'"));
        DurationFormatUtils.Token token = new DurationFormatUtils.Token(DurationFormatUtils.y, 4);
        Assert.assertFalse((String)"Token equal to non-Token class. ", (boolean)token.equals(new Object()));
        Assert.assertFalse((String)"Token equal to Token with wrong value class. ", (boolean)token.equals((Object)new DurationFormatUtils.Token(new Object())));
        Assert.assertFalse((String)"Token equal to Token with different count. ", (boolean)token.equals((Object)new DurationFormatUtils.Token(DurationFormatUtils.y, 1)));
        DurationFormatUtils.Token numToken = new DurationFormatUtils.Token((Object)1, 4);
        Assert.assertTrue((String)"Token with Number value not equal to itself. ", (boolean)numToken.equals((Object)numToken));
    }

    @Test
    public void testBugzilla38401() {
        this.assertEqualDuration("0000/00/30 16:00:00 000", new int[]{2006, 0, 26, 18, 47, 34}, new int[]{2006, 1, 26, 10, 47, 34}, "yyyy/MM/dd HH:mm:ss SSS");
    }

    @Test
    public void testJiraLang281() {
        this.assertEqualDuration("09", new int[]{2005, 11, 31, 0, 0, 0}, new int[]{2006, 9, 6, 0, 0, 0}, "MM");
    }

    @Test
    public void testLANG815() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2012, 6, 30, 0, 0, 0);
        long startMillis = calendar.getTimeInMillis();
        calendar.set(2012, 8, 8);
        long endMillis = calendar.getTimeInMillis();
        Assert.assertEquals((Object)"1 9", (Object)DurationFormatUtils.formatPeriod((long)startMillis, (long)endMillis, (String)"M d"));
    }

    @Test
    public void testLowDurations() {
        for (int hr = 0; hr < 24; ++hr) {
            for (int min = 0; min < 60; ++min) {
                for (int sec = 0; sec < 60; ++sec) {
                    this.assertEqualDuration(hr + ":" + min + ":" + sec, new int[]{2000, 0, 1, 0, 0, 0, 0}, new int[]{2000, 0, 1, hr, min, sec}, "H:m:s");
                }
            }
        }
    }

    @Test
    public void testEdgeDurations() {
        TimeZone.setDefault(FastTimeZone.getGmtTimeZone());
        this.assertEqualDuration("01", new int[]{2006, 0, 15, 0, 0, 0}, new int[]{2006, 2, 10, 0, 0, 0}, "MM");
        this.assertEqualDuration("12", new int[]{2005, 0, 15, 0, 0, 0}, new int[]{2006, 0, 15, 0, 0, 0}, "MM");
        this.assertEqualDuration("12", new int[]{2005, 0, 15, 0, 0, 0}, new int[]{2006, 0, 16, 0, 0, 0}, "MM");
        this.assertEqualDuration("11", new int[]{2005, 0, 15, 0, 0, 0}, new int[]{2006, 0, 14, 0, 0, 0}, "MM");
        this.assertEqualDuration("01 26", new int[]{2006, 0, 15, 0, 0, 0}, new int[]{2006, 2, 10, 0, 0, 0}, "MM dd");
        this.assertEqualDuration("54", new int[]{2006, 0, 15, 0, 0, 0}, new int[]{2006, 2, 10, 0, 0, 0}, "dd");
        this.assertEqualDuration("09 12", new int[]{2006, 1, 20, 0, 0, 0}, new int[]{2006, 11, 4, 0, 0, 0}, "MM dd");
        this.assertEqualDuration("287", new int[]{2006, 1, 20, 0, 0, 0}, new int[]{2006, 11, 4, 0, 0, 0}, "dd");
        this.assertEqualDuration("11 30", new int[]{2006, 0, 2, 0, 0, 0}, new int[]{2007, 0, 1, 0, 0, 0}, "MM dd");
        this.assertEqualDuration("364", new int[]{2006, 0, 2, 0, 0, 0}, new int[]{2007, 0, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("12 00", new int[]{2006, 0, 1, 0, 0, 0}, new int[]{2007, 0, 1, 0, 0, 0}, "MM dd");
        this.assertEqualDuration("365", new int[]{2006, 0, 1, 0, 0, 0}, new int[]{2007, 0, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("31", new int[]{2006, 0, 1, 0, 0, 0}, new int[]{2006, 1, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("92", new int[]{2005, 9, 1, 0, 0, 0}, new int[]{2006, 0, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("77", new int[]{2005, 9, 16, 0, 0, 0}, new int[]{2006, 0, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("136", new int[]{2005, 9, 16, 0, 0, 0}, new int[]{2006, 2, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("136", new int[]{2004, 9, 16, 0, 0, 0}, new int[]{2005, 2, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("137", new int[]{2003, 9, 16, 0, 0, 0}, new int[]{2004, 2, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("135", new int[]{2003, 9, 16, 0, 0, 0}, new int[]{2004, 1, 28, 0, 0, 0}, "dd");
        this.assertEqualDuration("364", new int[]{2007, 0, 2, 0, 0, 0}, new int[]{2008, 0, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("729", new int[]{2006, 0, 2, 0, 0, 0}, new int[]{2008, 0, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("365", new int[]{2007, 2, 2, 0, 0, 0}, new int[]{2008, 2, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("333", new int[]{2007, 1, 2, 0, 0, 0}, new int[]{2008, 0, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("28", new int[]{2008, 1, 2, 0, 0, 0}, new int[]{2008, 2, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("393", new int[]{2007, 1, 2, 0, 0, 0}, new int[]{2008, 2, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("369", new int[]{2004, 0, 29, 0, 0, 0}, new int[]{2005, 1, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("338", new int[]{2004, 1, 29, 0, 0, 0}, new int[]{2005, 1, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("28", new int[]{2004, 2, 8, 0, 0, 0}, new int[]{2004, 3, 5, 0, 0, 0}, "dd");
        this.assertEqualDuration("48", new int[]{1992, 1, 29, 0, 0, 0}, new int[]{1996, 1, 29, 0, 0, 0}, "M");
        this.assertEqualDuration("11", new int[]{1996, 1, 29, 0, 0, 0}, new int[]{1997, 1, 28, 0, 0, 0}, "M");
        this.assertEqualDuration("11 28", new int[]{1996, 1, 29, 0, 0, 0}, new int[]{1997, 1, 28, 0, 0, 0}, "M d");
    }

    @Test
    public void testLANG984() {
        Assert.assertEquals((Object)"0", (Object)DurationFormatUtils.formatDuration((long)0L, (String)"S"));
        Assert.assertEquals((Object)Integer.toString(Integer.MAX_VALUE), (Object)DurationFormatUtils.formatDuration((long)Integer.MAX_VALUE, (String)"S"));
        long maxIntPlus = Integer.MAX_VALUE;
        Assert.assertEquals((Object)Long.toString(++maxIntPlus), (Object)DurationFormatUtils.formatDuration((long)maxIntPlus, (String)"S"));
        Assert.assertEquals((Object)Long.toString(Long.MAX_VALUE), (Object)DurationFormatUtils.formatDuration((long)Long.MAX_VALUE, (String)"S"));
    }

    @Test
    public void testLANG982() {
        Assert.assertEquals((Object)"61.999", (Object)DurationFormatUtils.formatDuration((long)61999L, (String)"s.S"));
        Assert.assertEquals((Object)"1 1999", (Object)DurationFormatUtils.formatDuration((long)61999L, (String)"m S"));
        Assert.assertEquals((Object)"61.999", (Object)DurationFormatUtils.formatDuration((long)61999L, (String)"s.SSS"));
        Assert.assertEquals((Object)"1 1999", (Object)DurationFormatUtils.formatDuration((long)61999L, (String)"m SSS"));
        Assert.assertEquals((Object)"61.0999", (Object)DurationFormatUtils.formatDuration((long)61999L, (String)"s.SSSS"));
        Assert.assertEquals((Object)"1 1999", (Object)DurationFormatUtils.formatDuration((long)61999L, (String)"m SSSS"));
        Assert.assertEquals((Object)"61.00999", (Object)DurationFormatUtils.formatDuration((long)61999L, (String)"s.SSSSS"));
        Assert.assertEquals((Object)"1 01999", (Object)DurationFormatUtils.formatDuration((long)61999L, (String)"m SSSSS"));
    }

    @Test
    public void testDurationsByBruteForce() {
        this.bruteForce(2006, 0, 1, "d", 5);
        this.bruteForce(2006, 0, 2, "d", 5);
        this.bruteForce(2007, 1, 2, "d", 5);
        this.bruteForce(2004, 1, 29, "d", 5);
        this.bruteForce(1996, 1, 29, "d", 5);
        this.bruteForce(1969, 1, 28, "M", 2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLANG981() {
        DurationFormatUtils.lexx((String)"'yMdHms''S");
    }

    private void bruteForce(int year, int month, int day, String format, int calendarType) {
        String msg = year + "-" + month + "-" + day + " to ";
        Calendar c = Calendar.getInstance();
        c.set(year, month, day, 0, 0, 0);
        int[] array1 = new int[]{year, month, day, 0, 0, 0};
        int[] array2 = new int[]{year, month, day, 0, 0, 0};
        for (int i = 0; i < 1461; ++i) {
            array2[0] = c.get(1);
            array2[1] = c.get(2);
            array2[2] = c.get(5);
            String tmpMsg = msg + array2[0] + "-" + array2[1] + "-" + array2[2] + " at ";
            this.assertEqualDuration(tmpMsg + i, Integer.toString(i), array1, array2, format);
            c.add(calendarType, 1);
        }
    }

    private void assertEqualDuration(String expected, int[] start, int[] end, String format) {
        this.assertEqualDuration(null, expected, start, end, format);
    }

    private void assertEqualDuration(String message, String expected, int[] start, int[] end, String format) {
        Calendar cal1 = Calendar.getInstance();
        cal1.set(start[0], start[1], start[2], start[3], start[4], start[5]);
        cal1.set(14, 0);
        Calendar cal2 = Calendar.getInstance();
        cal2.set(end[0], end[1], end[2], end[3], end[4], end[5]);
        cal2.set(14, 0);
        long milli1 = cal1.getTime().getTime();
        long milli2 = cal2.getTime().getTime();
        String result = DurationFormatUtils.formatPeriod((long)milli1, (long)milli2, (String)format);
        if (message == null) {
            Assert.assertEquals((Object)expected, (Object)result);
        } else {
            Assert.assertEquals((String)message, (Object)expected, (Object)result);
        }
    }
}

