/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.commons.lang3.test.SystemDefaults;
import org.apache.commons.lang3.test.SystemDefaultsSwitch;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.commons.lang3.time.FastTimeZone;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class FastDateFormatTest {
    @Rule
    public SystemDefaultsSwitch defaults = new SystemDefaultsSwitch();
    private static final int NTHREADS = 10;
    private static final int NROUNDS = 10000;

    @Test
    public void test_getInstance() {
        FastDateFormat format1 = FastDateFormat.getInstance();
        FastDateFormat format2 = FastDateFormat.getInstance();
        Assert.assertSame((Object)format1, (Object)format2);
    }

    @Test
    public void test_getInstance_String() {
        FastDateFormat format1 = FastDateFormat.getInstance((String)"MM/DD/yyyy");
        FastDateFormat format2 = FastDateFormat.getInstance((String)"MM-DD-yyyy");
        FastDateFormat format3 = FastDateFormat.getInstance((String)"MM-DD-yyyy");
        Assert.assertTrue((format1 != format2 ? 1 : 0) != 0);
        Assert.assertSame((Object)format2, (Object)format3);
        Assert.assertEquals((Object)"MM/DD/yyyy", (Object)format1.getPattern());
        Assert.assertEquals((Object)TimeZone.getDefault(), (Object)format1.getTimeZone());
        Assert.assertEquals((Object)TimeZone.getDefault(), (Object)format2.getTimeZone());
    }

    @SystemDefaults(timezone="America/New_York", locale="en_US")
    @Test
    public void test_getInstance_String_TimeZone() {
        FastDateFormat format1 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (TimeZone)TimeZone.getTimeZone("Atlantic/Reykjavik"));
        FastDateFormat format2 = FastDateFormat.getInstance((String)"MM/DD/yyyy");
        FastDateFormat format3 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (TimeZone)TimeZone.getDefault());
        FastDateFormat format4 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (TimeZone)TimeZone.getDefault());
        FastDateFormat format5 = FastDateFormat.getInstance((String)"MM-DD-yyyy", (TimeZone)TimeZone.getDefault());
        FastDateFormat format6 = FastDateFormat.getInstance((String)"MM-DD-yyyy");
        Assert.assertNotSame((Object)format1, (Object)format2);
        Assert.assertEquals((Object)TimeZone.getTimeZone("Atlantic/Reykjavik"), (Object)format1.getTimeZone());
        Assert.assertEquals((Object)TimeZone.getDefault(), (Object)format2.getTimeZone());
        Assert.assertSame((Object)format3, (Object)format4);
        Assert.assertNotSame((Object)format3, (Object)format5);
        Assert.assertNotSame((Object)format4, (Object)format6);
    }

    @SystemDefaults(locale="en_US")
    @Test
    public void test_getInstance_String_Locale() {
        FastDateFormat format1 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (Locale)Locale.GERMANY);
        FastDateFormat format2 = FastDateFormat.getInstance((String)"MM/DD/yyyy");
        FastDateFormat format3 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (Locale)Locale.GERMANY);
        Assert.assertNotSame((Object)format1, (Object)format2);
        Assert.assertSame((Object)format1, (Object)format3);
        Assert.assertEquals((Object)Locale.GERMANY, (Object)format1.getLocale());
    }

    @SystemDefaults(locale="en_US")
    @Test
    public void test_changeDefault_Locale_DateInstance() {
        FastDateFormat format1 = FastDateFormat.getDateInstance((int)0, (Locale)Locale.GERMANY);
        FastDateFormat format2 = FastDateFormat.getDateInstance((int)0);
        Locale.setDefault(Locale.GERMANY);
        FastDateFormat format3 = FastDateFormat.getDateInstance((int)0);
        Assert.assertSame((Object)Locale.GERMANY, (Object)format1.getLocale());
        Assert.assertEquals((Object)Locale.US, (Object)format2.getLocale());
        Assert.assertSame((Object)Locale.GERMANY, (Object)format3.getLocale());
        Assert.assertNotSame((Object)format1, (Object)format2);
        Assert.assertNotSame((Object)format2, (Object)format3);
    }

    @SystemDefaults(locale="en_US")
    @Test
    public void test_changeDefault_Locale_DateTimeInstance() {
        FastDateFormat format1 = FastDateFormat.getDateTimeInstance((int)0, (int)0, (Locale)Locale.GERMANY);
        FastDateFormat format2 = FastDateFormat.getDateTimeInstance((int)0, (int)0);
        Locale.setDefault(Locale.GERMANY);
        FastDateFormat format3 = FastDateFormat.getDateTimeInstance((int)0, (int)0);
        Assert.assertSame((Object)Locale.GERMANY, (Object)format1.getLocale());
        Assert.assertEquals((Object)Locale.US, (Object)format2.getLocale());
        Assert.assertSame((Object)Locale.GERMANY, (Object)format3.getLocale());
        Assert.assertNotSame((Object)format1, (Object)format2);
        Assert.assertNotSame((Object)format2, (Object)format3);
    }

    @SystemDefaults(locale="en_US", timezone="America/New_York")
    @Test
    public void test_getInstance_String_TimeZone_Locale() {
        FastDateFormat format1 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (TimeZone)TimeZone.getTimeZone("Atlantic/Reykjavik"), (Locale)Locale.GERMANY);
        FastDateFormat format2 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (Locale)Locale.GERMANY);
        FastDateFormat format3 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (TimeZone)TimeZone.getDefault(), (Locale)Locale.GERMANY);
        Assert.assertNotSame((Object)format1, (Object)format2);
        Assert.assertEquals((Object)TimeZone.getTimeZone("Atlantic/Reykjavik"), (Object)format1.getTimeZone());
        Assert.assertEquals((Object)TimeZone.getDefault(), (Object)format2.getTimeZone());
        Assert.assertEquals((Object)TimeZone.getDefault(), (Object)format3.getTimeZone());
        Assert.assertEquals((Object)Locale.GERMANY, (Object)format1.getLocale());
        Assert.assertEquals((Object)Locale.GERMANY, (Object)format2.getLocale());
        Assert.assertEquals((Object)Locale.GERMANY, (Object)format3.getLocale());
    }

    @Test
    public void testCheckDefaults() {
        FastDateFormat format = FastDateFormat.getInstance();
        FastDateFormat medium = FastDateFormat.getDateTimeInstance((int)3, (int)3);
        Assert.assertEquals((Object)medium, (Object)format);
        SimpleDateFormat sdf = new SimpleDateFormat();
        Assert.assertEquals((Object)sdf.toPattern(), (Object)format.getPattern());
        Assert.assertEquals((Object)Locale.getDefault(), (Object)format.getLocale());
        Assert.assertEquals((Object)TimeZone.getDefault(), (Object)format.getTimeZone());
    }

    @Test
    public void testCheckDifferingStyles() {
        FastDateFormat shortShort = FastDateFormat.getDateTimeInstance((int)3, (int)3, (Locale)Locale.US);
        FastDateFormat shortLong = FastDateFormat.getDateTimeInstance((int)3, (int)1, (Locale)Locale.US);
        FastDateFormat longShort = FastDateFormat.getDateTimeInstance((int)1, (int)3, (Locale)Locale.US);
        FastDateFormat longLong = FastDateFormat.getDateTimeInstance((int)1, (int)1, (Locale)Locale.US);
        Assert.assertFalse((boolean)shortShort.equals((Object)shortLong));
        Assert.assertFalse((boolean)shortShort.equals((Object)longShort));
        Assert.assertFalse((boolean)shortShort.equals((Object)longLong));
        Assert.assertFalse((boolean)shortLong.equals((Object)longShort));
        Assert.assertFalse((boolean)shortLong.equals((Object)longLong));
        Assert.assertFalse((boolean)longShort.equals((Object)longLong));
    }

    @Test
    public void testDateDefaults() {
        Assert.assertEquals((Object)FastDateFormat.getDateInstance((int)1, (Locale)Locale.CANADA), (Object)FastDateFormat.getDateInstance((int)1, (TimeZone)TimeZone.getDefault(), (Locale)Locale.CANADA));
        Assert.assertEquals((Object)FastDateFormat.getDateInstance((int)1, (TimeZone)TimeZone.getTimeZone("America/New_York")), (Object)FastDateFormat.getDateInstance((int)1, (TimeZone)TimeZone.getTimeZone("America/New_York"), (Locale)Locale.getDefault()));
        Assert.assertEquals((Object)FastDateFormat.getDateInstance((int)1), (Object)FastDateFormat.getDateInstance((int)1, (TimeZone)TimeZone.getDefault(), (Locale)Locale.getDefault()));
    }

    @Test
    public void testTimeDefaults() {
        Assert.assertEquals((Object)FastDateFormat.getTimeInstance((int)1, (Locale)Locale.CANADA), (Object)FastDateFormat.getTimeInstance((int)1, (TimeZone)TimeZone.getDefault(), (Locale)Locale.CANADA));
        Assert.assertEquals((Object)FastDateFormat.getTimeInstance((int)1, (TimeZone)TimeZone.getTimeZone("America/New_York")), (Object)FastDateFormat.getTimeInstance((int)1, (TimeZone)TimeZone.getTimeZone("America/New_York"), (Locale)Locale.getDefault()));
        Assert.assertEquals((Object)FastDateFormat.getTimeInstance((int)1), (Object)FastDateFormat.getTimeInstance((int)1, (TimeZone)TimeZone.getDefault(), (Locale)Locale.getDefault()));
    }

    @Test
    public void testTimeDateDefaults() {
        Assert.assertEquals((Object)FastDateFormat.getDateTimeInstance((int)1, (int)2, (Locale)Locale.CANADA), (Object)FastDateFormat.getDateTimeInstance((int)1, (int)2, (TimeZone)TimeZone.getDefault(), (Locale)Locale.CANADA));
        Assert.assertEquals((Object)FastDateFormat.getDateTimeInstance((int)1, (int)2, (TimeZone)TimeZone.getTimeZone("America/New_York")), (Object)FastDateFormat.getDateTimeInstance((int)1, (int)2, (TimeZone)TimeZone.getTimeZone("America/New_York"), (Locale)Locale.getDefault()));
        Assert.assertEquals((Object)FastDateFormat.getDateTimeInstance((int)1, (int)2), (Object)FastDateFormat.getDateTimeInstance((int)1, (int)2, (TimeZone)TimeZone.getDefault(), (Locale)Locale.getDefault()));
    }

    @Test
    public void testParseSync() throws InterruptedException {
        String pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS";
        final SimpleDateFormat inner = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        Format sdf = new Format(){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition fieldPosition) {
                1 var4_4 = this;
                synchronized (var4_4) {
                    return inner.format(obj, toAppendTo, fieldPosition);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object parseObject(String source, ParsePosition pos) {
                1 var3_3 = this;
                synchronized (var3_3) {
                    return inner.parseObject(source, pos);
                }
            }
        };
        AtomicLongArray sdfTime = this.measureTime(sdf, sdf);
        FastDateFormat fdf = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS");
        AtomicLongArray fdfTime = this.measureTime((Format)fdf, (Format)fdf);
        System.out.println(">>FastDateFormatTest: FastDatePrinter:" + fdfTime.get(0) + "  SimpleDateFormat:" + sdfTime.get(0));
        System.out.println(">>FastDateFormatTest: FastDateParser:" + fdfTime.get(1) + "  SimpleDateFormat:" + sdfTime.get(1));
    }

    private AtomicLongArray measureTime(final Format printer, final Format parser) throws InterruptedException {
        ExecutorService pool = Executors.newFixedThreadPool(10);
        final AtomicInteger failures = new AtomicInteger(0);
        final AtomicLongArray totalElapsed = new AtomicLongArray(2);
        for (int i = 0; i < 10; ++i) {
            pool.submit(new Runnable(){

                @Override
                public void run() {
                    for (int j = 0; j < 10000; ++j) {
                        try {
                            Date date = new Date();
                            long t0 = System.currentTimeMillis();
                            String formattedDate = printer.format(date);
                            totalElapsed.addAndGet(0, System.currentTimeMillis() - t0);
                            long t1 = System.currentTimeMillis();
                            Object pd = parser.parseObject(formattedDate);
                            totalElapsed.addAndGet(1, System.currentTimeMillis() - t1);
                            if (date.equals(pd)) continue;
                            failures.incrementAndGet();
                            continue;
                        }
                        catch (Exception e) {
                            failures.incrementAndGet();
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        pool.shutdown();
        if (!pool.awaitTermination(30L, TimeUnit.SECONDS)) {
            pool.shutdownNow();
            Assert.fail((String)"did not complete tasks");
        }
        Assert.assertEquals((long)0L, (long)failures.get());
        return totalElapsed;
    }

    @Test
    public void testLANG_954() {
        String pattern = "yyyy-MM-dd'T'";
        FastDateFormat.getInstance((String)"yyyy-MM-dd'T'");
    }

    @Test
    public void testLANG_1152() {
        TimeZone utc = FastTimeZone.getGmtTimeZone();
        Date date = new Date(Long.MAX_VALUE);
        String dateAsString = FastDateFormat.getInstance((String)"yyyy-MM-dd", (TimeZone)utc, (Locale)Locale.US).format(date);
        Assert.assertEquals((Object)"292278994-08-17", (Object)dateAsString);
        dateAsString = FastDateFormat.getInstance((String)"dd/MM/yyyy", (TimeZone)utc, (Locale)Locale.US).format(date);
        Assert.assertEquals((Object)"17/08/292278994", (Object)dateAsString);
    }

    @Test
    public void testLANG_1267() throws Exception {
        FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    }
}

