/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.tuple;

import java.util.Calendar;
import java.util.HashSet;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.junit.Assert;
import org.junit.Test;

public class TripleTest {
    @Test
    public void testTripleOf() throws Exception {
        Triple triple = Triple.of((Object)0, (Object)"foo", (Object)Boolean.TRUE);
        Assert.assertTrue((boolean)(triple instanceof ImmutableTriple));
        Assert.assertEquals((long)0L, (long)((Integer)((ImmutableTriple)triple).left).intValue());
        Assert.assertEquals((Object)"foo", (Object)((ImmutableTriple)triple).middle);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)((ImmutableTriple)triple).right);
        Triple triple2 = Triple.of(null, (Object)"bar", (Object)200L);
        Assert.assertTrue((boolean)(triple2 instanceof ImmutableTriple));
        Assert.assertNull((Object)((ImmutableTriple)triple2).left);
        Assert.assertEquals((Object)"bar", (Object)((ImmutableTriple)triple2).middle);
        Assert.assertEquals((Object)new Long(200L), (Object)((ImmutableTriple)triple2).right);
    }

    @Test
    public void testCompatibilityBetweenTriples() throws Exception {
        ImmutableTriple triple = ImmutableTriple.of((Object)0, (Object)"foo", (Object)Boolean.TRUE);
        MutableTriple triple2 = MutableTriple.of((Object)0, (Object)"foo", (Object)Boolean.TRUE);
        Assert.assertEquals((Object)triple, (Object)triple2);
        Assert.assertEquals((long)triple.hashCode(), (long)triple2.hashCode());
        HashSet<ImmutableTriple> set = new HashSet<ImmutableTriple>();
        set.add(triple);
        Assert.assertTrue((boolean)set.contains(triple2));
    }

    @Test
    public void testComparable1() throws Exception {
        Triple triple1 = Triple.of((Object)"A", (Object)"D", (Object)"A");
        Triple triple2 = Triple.of((Object)"B", (Object)"C", (Object)"A");
        Assert.assertTrue((triple1.compareTo(triple1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((triple1.compareTo(triple2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((triple2.compareTo(triple2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((triple2.compareTo(triple1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testComparable2() throws Exception {
        Triple triple1 = Triple.of((Object)"A", (Object)"C", (Object)"B");
        Triple triple2 = Triple.of((Object)"A", (Object)"D", (Object)"B");
        Assert.assertTrue((triple1.compareTo(triple1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((triple1.compareTo(triple2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((triple2.compareTo(triple2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((triple2.compareTo(triple1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testComparable3() throws Exception {
        Triple triple1 = Triple.of((Object)"A", (Object)"A", (Object)"D");
        Triple triple2 = Triple.of((Object)"A", (Object)"B", (Object)"C");
        Assert.assertTrue((triple1.compareTo(triple1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((triple1.compareTo(triple2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((triple2.compareTo(triple2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((triple2.compareTo(triple1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testComparable4() throws Exception {
        Triple triple1 = Triple.of((Object)"B", (Object)"A", (Object)"C");
        Triple triple2 = Triple.of((Object)"B", (Object)"A", (Object)"D");
        Assert.assertTrue((triple1.compareTo(triple1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((triple1.compareTo(triple2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((triple2.compareTo(triple2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((triple2.compareTo(triple1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testToString() throws Exception {
        Triple triple = Triple.of((Object)"Key", (Object)"Something", (Object)"Value");
        Assert.assertEquals((Object)"(Key,Something,Value)", (Object)triple.toString());
    }

    @Test
    public void testToStringCustom() throws Exception {
        Calendar date = Calendar.getInstance();
        date.set(2011, 3, 25);
        Triple triple = Triple.of((Object)"DOB", (Object)"string", (Object)date);
        Assert.assertEquals((Object)"Test created on 04-25-2011", (Object)triple.toString("Test created on %3$tm-%3$td-%3$tY"));
    }

    @Test
    public void testFormattable_simple() throws Exception {
        Triple triple = Triple.of((Object)"Key", (Object)"Something", (Object)"Value");
        Assert.assertEquals((Object)"(Key,Something,Value)", (Object)String.format("%1$s", triple));
    }

    @Test
    public void testFormattable_padded() throws Exception {
        Triple triple = Triple.of((Object)"Key", (Object)"Something", (Object)"Value");
        Assert.assertEquals((Object)"         (Key,Something,Value)", (Object)String.format("%1$30s", triple));
    }
}

