/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;

public class ArrayUtilsAddTest {
    @Test
    public void testJira567() {
        Number[] n = (Number[])ArrayUtils.addAll((Object[])new Number[]{1}, (Object[])new Long[]{2L});
        Assert.assertEquals((long)2L, (long)n.length);
        Assert.assertEquals(Number.class, n.getClass().getComponentType());
        try {
            n = (Number[])ArrayUtils.addAll((Object[])new Integer[]{1}, (Object[])new Long[]{2L});
            Assert.fail((String)"Should have generated IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddObjectArrayBoolean() {
        boolean[] newArray = ArrayUtils.add(null, (boolean)false);
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{false}, newArray));
        Assert.assertEquals(Boolean.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add(null, (boolean)true);
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true}, newArray));
        Assert.assertEquals(Boolean.TYPE, newArray.getClass().getComponentType());
        boolean[] array1 = new boolean[]{true, false, true};
        newArray = ArrayUtils.add((boolean[])array1, (boolean)false);
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true, false, true, false}, newArray));
        Assert.assertEquals(Boolean.TYPE, newArray.getClass().getComponentType());
    }

    @Test
    public void testAddObjectArrayByte() {
        byte[] newArray = ArrayUtils.add((byte[])null, (byte)0);
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{0}, newArray));
        Assert.assertEquals(Byte.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((byte[])null, (byte)1);
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{1}, newArray));
        Assert.assertEquals(Byte.TYPE, newArray.getClass().getComponentType());
        byte[] array1 = new byte[]{1, 2, 3};
        newArray = ArrayUtils.add((byte[])array1, (byte)0);
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3, 0}, newArray));
        Assert.assertEquals(Byte.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((byte[])array1, (byte)4);
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3, 4}, newArray));
        Assert.assertEquals(Byte.TYPE, newArray.getClass().getComponentType());
    }

    @Test
    public void testAddObjectArrayChar() {
        char[] newArray = ArrayUtils.add((char[])null, (char)'\u0000');
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'\u0000'}, newArray));
        Assert.assertEquals(Character.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((char[])null, (char)'\u0001');
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'\u0001'}, newArray));
        Assert.assertEquals(Character.TYPE, newArray.getClass().getComponentType());
        char[] array1 = new char[]{'\u0001', '\u0002', '\u0003'};
        newArray = ArrayUtils.add((char[])array1, (char)'\u0000');
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'\u0001', '\u0002', '\u0003', '\u0000'}, newArray));
        Assert.assertEquals(Character.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((char[])array1, (char)'\u0004');
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'\u0001', '\u0002', '\u0003', '\u0004'}, newArray));
        Assert.assertEquals(Character.TYPE, newArray.getClass().getComponentType());
    }

    @Test
    public void testAddObjectArrayDouble() {
        double[] newArray = ArrayUtils.add((double[])null, (double)0.0);
        Assert.assertTrue((boolean)Arrays.equals(new double[]{0.0}, newArray));
        Assert.assertEquals(Double.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((double[])null, (double)1.0);
        Assert.assertTrue((boolean)Arrays.equals(new double[]{1.0}, newArray));
        Assert.assertEquals(Double.TYPE, newArray.getClass().getComponentType());
        double[] array1 = new double[]{1.0, 2.0, 3.0};
        newArray = ArrayUtils.add((double[])array1, (double)0.0);
        Assert.assertTrue((boolean)Arrays.equals(new double[]{1.0, 2.0, 3.0, 0.0}, newArray));
        Assert.assertEquals(Double.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((double[])array1, (double)4.0);
        Assert.assertTrue((boolean)Arrays.equals(new double[]{1.0, 2.0, 3.0, 4.0}, newArray));
        Assert.assertEquals(Double.TYPE, newArray.getClass().getComponentType());
    }

    @Test
    public void testAddObjectArrayFloat() {
        float[] newArray = ArrayUtils.add((float[])null, (float)0.0f);
        Assert.assertTrue((boolean)Arrays.equals(new float[]{0.0f}, newArray));
        Assert.assertEquals(Float.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((float[])null, (float)1.0f);
        Assert.assertTrue((boolean)Arrays.equals(new float[]{1.0f}, newArray));
        Assert.assertEquals(Float.TYPE, newArray.getClass().getComponentType());
        float[] array1 = new float[]{1.0f, 2.0f, 3.0f};
        newArray = ArrayUtils.add((float[])array1, (float)0.0f);
        Assert.assertTrue((boolean)Arrays.equals(new float[]{1.0f, 2.0f, 3.0f, 0.0f}, newArray));
        Assert.assertEquals(Float.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((float[])array1, (float)4.0f);
        Assert.assertTrue((boolean)Arrays.equals(new float[]{1.0f, 2.0f, 3.0f, 4.0f}, newArray));
        Assert.assertEquals(Float.TYPE, newArray.getClass().getComponentType());
    }

    @Test
    public void testAddObjectArrayInt() {
        int[] newArray = ArrayUtils.add((int[])null, (int)0);
        Assert.assertTrue((boolean)Arrays.equals(new int[]{0}, newArray));
        Assert.assertEquals(Integer.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((int[])null, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(new int[]{1}, newArray));
        Assert.assertEquals(Integer.TYPE, newArray.getClass().getComponentType());
        int[] array1 = new int[]{1, 2, 3};
        newArray = ArrayUtils.add((int[])array1, (int)0);
        Assert.assertTrue((boolean)Arrays.equals(new int[]{1, 2, 3, 0}, newArray));
        Assert.assertEquals(Integer.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((int[])array1, (int)4);
        Assert.assertTrue((boolean)Arrays.equals(new int[]{1, 2, 3, 4}, newArray));
        Assert.assertEquals(Integer.TYPE, newArray.getClass().getComponentType());
    }

    @Test
    public void testAddObjectArrayLong() {
        long[] newArray = ArrayUtils.add((long[])null, (long)0L);
        Assert.assertTrue((boolean)Arrays.equals(new long[]{0L}, newArray));
        Assert.assertEquals(Long.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((long[])null, (long)1L);
        Assert.assertTrue((boolean)Arrays.equals(new long[]{1L}, newArray));
        Assert.assertEquals(Long.TYPE, newArray.getClass().getComponentType());
        long[] array1 = new long[]{1L, 2L, 3L};
        newArray = ArrayUtils.add((long[])array1, (long)0L);
        Assert.assertTrue((boolean)Arrays.equals(new long[]{1L, 2L, 3L, 0L}, newArray));
        Assert.assertEquals(Long.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((long[])array1, (long)4L);
        Assert.assertTrue((boolean)Arrays.equals(new long[]{1L, 2L, 3L, 4L}, newArray));
        Assert.assertEquals(Long.TYPE, newArray.getClass().getComponentType());
    }

    @Test
    public void testAddObjectArrayShort() {
        short[] newArray = ArrayUtils.add((short[])null, (short)0);
        Assert.assertTrue((boolean)Arrays.equals(new short[]{0}, newArray));
        Assert.assertEquals(Short.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((short[])null, (short)1);
        Assert.assertTrue((boolean)Arrays.equals(new short[]{1}, newArray));
        Assert.assertEquals(Short.TYPE, newArray.getClass().getComponentType());
        short[] array1 = new short[]{1, 2, 3};
        newArray = ArrayUtils.add((short[])array1, (short)0);
        Assert.assertTrue((boolean)Arrays.equals(new short[]{1, 2, 3, 0}, newArray));
        Assert.assertEquals(Short.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((short[])array1, (short)4);
        Assert.assertTrue((boolean)Arrays.equals(new short[]{1, 2, 3, 4}, newArray));
        Assert.assertEquals(Short.TYPE, newArray.getClass().getComponentType());
    }

    @Test
    public void testAddObjectArrayObject() {
        Object[] newArray = ArrayUtils.add((Object[])null, (Object)"a");
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"a"}, newArray));
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{"a"}, newArray));
        Assert.assertEquals(String.class, newArray.getClass().getComponentType());
        Object[] newStringArray = (String[])ArrayUtils.add(null, (Object)"a");
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"a"}, newStringArray));
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{"a"}, newStringArray));
        Assert.assertEquals(String.class, newStringArray.getClass().getComponentType());
        Object[] stringArray1 = new String[]{"a", "b", "c"};
        newArray = ArrayUtils.add((Object[])stringArray1, null);
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"a", "b", "c", null}, newArray));
        Assert.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((Object[])stringArray1, (Object)"d");
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"a", "b", "c", "d"}, newArray));
        Assert.assertEquals(String.class, newArray.getClass().getComponentType());
        Object[] numberArray1 = new Number[]{1, 2.0};
        newArray = ArrayUtils.add((Object[])numberArray1, (Object)Float.valueOf(3.0f));
        Assert.assertTrue((boolean)Arrays.equals(new Number[]{1, 2.0, Float.valueOf(3.0f)}, newArray));
        Assert.assertEquals(Number.class, newArray.getClass().getComponentType());
        numberArray1 = null;
        newArray = ArrayUtils.add((Object[])numberArray1, (Object)Float.valueOf(3.0f));
        Assert.assertTrue((boolean)Arrays.equals((Object[])new Float[]{Float.valueOf(3.0f)}, newArray));
        Assert.assertEquals(Float.class, newArray.getClass().getComponentType());
    }

    @Test
    public void testLANG571() {
        String[] sa2;
        Object[] stringArray = null;
        Object aString = null;
        try {
            sa2 = (String[])ArrayUtils.add(stringArray, aString);
            Assert.fail((String)"Should have caused IllegalArgumentException");
        }
        catch (IllegalArgumentException sa2) {
            // empty catch block
        }
        try {
            sa2 = (String[])ArrayUtils.add(stringArray, (int)0, aString);
            Assert.fail((String)"Should have caused IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddObjectArrayToObjectArray() {
        Assert.assertNull((Object)ArrayUtils.addAll(null, (Object[])null));
        Object[] stringArray1 = new String[]{"a", "b", "c"};
        Object[] stringArray2 = new String[]{"1", "2", "3"};
        Object[] newArray = ArrayUtils.addAll((Object[])stringArray1, (Object[])null);
        Assert.assertNotSame((Object)stringArray1, (Object)newArray);
        Assert.assertTrue((boolean)Arrays.equals(stringArray1, newArray));
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"a", "b", "c"}, newArray));
        Assert.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addAll(null, (Object[])stringArray2);
        Assert.assertNotSame((Object)stringArray2, (Object)newArray);
        Assert.assertTrue((boolean)Arrays.equals(stringArray2, newArray));
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"1", "2", "3"}, newArray));
        Assert.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addAll((Object[])stringArray1, (Object[])stringArray2);
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"a", "b", "c", "1", "2", "3"}, newArray));
        Assert.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addAll((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])null);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_STRING_ARRAY, newArray));
        Assert.assertTrue((boolean)Arrays.equals(new String[0], newArray));
        Assert.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addAll(null, (Object[])ArrayUtils.EMPTY_STRING_ARRAY);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_STRING_ARRAY, newArray));
        Assert.assertTrue((boolean)Arrays.equals(new String[0], newArray));
        Assert.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addAll((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])ArrayUtils.EMPTY_STRING_ARRAY);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_STRING_ARRAY, newArray));
        Assert.assertTrue((boolean)Arrays.equals(new String[0], newArray));
        Assert.assertEquals(String.class, newArray.getClass().getComponentType());
        Object[] stringArrayNull = new String[]{null};
        newArray = ArrayUtils.addAll((Object[])stringArrayNull, (Object[])stringArrayNull);
        Assert.assertTrue((boolean)Arrays.equals(new String[]{null, null}, newArray));
        Assert.assertEquals(String.class, newArray.getClass().getComponentType());
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true, false, false, true}, ArrayUtils.addAll((boolean[])new boolean[]{true, false}, (boolean[])new boolean[]{false, true})));
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{false, true}, ArrayUtils.addAll(null, (boolean[])new boolean[]{false, true})));
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true, false}, ArrayUtils.addAll((boolean[])new boolean[]{true, false}, null)));
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'a', 'b', 'c', 'd'}, ArrayUtils.addAll((char[])new char[]{'a', 'b'}, (char[])new char[]{'c', 'd'})));
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'c', 'd'}, ArrayUtils.addAll(null, (char[])new char[]{'c', 'd'})));
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'a', 'b'}, ArrayUtils.addAll((char[])new char[]{'a', 'b'}, null)));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{0, 1, 2, 3}, ArrayUtils.addAll((byte[])new byte[]{0, 1}, (byte[])new byte[]{2, 3})));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{2, 3}, ArrayUtils.addAll(null, (byte[])new byte[]{2, 3})));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{0, 1}, ArrayUtils.addAll((byte[])new byte[]{0, 1}, null)));
        Assert.assertTrue((boolean)Arrays.equals(new short[]{10, 20, 30, 40}, ArrayUtils.addAll((short[])new short[]{10, 20}, (short[])new short[]{30, 40})));
        Assert.assertTrue((boolean)Arrays.equals(new short[]{30, 40}, ArrayUtils.addAll(null, (short[])new short[]{30, 40})));
        Assert.assertTrue((boolean)Arrays.equals(new short[]{10, 20}, ArrayUtils.addAll((short[])new short[]{10, 20}, null)));
        Assert.assertTrue((boolean)Arrays.equals(new int[]{1, 1000, -1000, -1}, ArrayUtils.addAll((int[])new int[]{1, 1000}, (int[])new int[]{-1000, -1})));
        Assert.assertTrue((boolean)Arrays.equals(new int[]{-1000, -1}, ArrayUtils.addAll(null, (int[])new int[]{-1000, -1})));
        Assert.assertTrue((boolean)Arrays.equals(new int[]{1, 1000}, ArrayUtils.addAll((int[])new int[]{1, 1000}, null)));
        Assert.assertTrue((boolean)Arrays.equals(new long[]{1L, -1L, 1000L, -1000L}, ArrayUtils.addAll((long[])new long[]{1L, -1L}, (long[])new long[]{1000L, -1000L})));
        Assert.assertTrue((boolean)Arrays.equals(new long[]{1000L, -1000L}, ArrayUtils.addAll(null, (long[])new long[]{1000L, -1000L})));
        Assert.assertTrue((boolean)Arrays.equals(new long[]{1L, -1L}, ArrayUtils.addAll((long[])new long[]{1L, -1L}, null)));
        Assert.assertTrue((boolean)Arrays.equals(new float[]{10.5f, 10.1f, 1.6f, 0.01f}, ArrayUtils.addAll((float[])new float[]{10.5f, 10.1f}, (float[])new float[]{1.6f, 0.01f})));
        Assert.assertTrue((boolean)Arrays.equals(new float[]{1.6f, 0.01f}, ArrayUtils.addAll(null, (float[])new float[]{1.6f, 0.01f})));
        Assert.assertTrue((boolean)Arrays.equals(new float[]{10.5f, 10.1f}, ArrayUtils.addAll((float[])new float[]{10.5f, 10.1f}, null)));
        Assert.assertTrue((boolean)Arrays.equals(new double[]{Math.PI, -Math.PI, 0.0, 9.99}, ArrayUtils.addAll((double[])new double[]{Math.PI, -Math.PI}, (double[])new double[]{0.0, 9.99})));
        Assert.assertTrue((boolean)Arrays.equals(new double[]{0.0, 9.99}, ArrayUtils.addAll(null, (double[])new double[]{0.0, 9.99})));
        Assert.assertTrue((boolean)Arrays.equals(new double[]{Math.PI, -Math.PI}, ArrayUtils.addAll((double[])new double[]{Math.PI, -Math.PI}, null)));
    }

    @Test
    public void testAddObjectAtIndex() {
        Object[] newArray = ArrayUtils.add((Object[])null, (int)0, (Object)"a");
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"a"}, newArray));
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{"a"}, newArray));
        Assert.assertEquals(String.class, newArray.getClass().getComponentType());
        Object[] stringArray1 = new String[]{"a", "b", "c"};
        newArray = ArrayUtils.add((Object[])stringArray1, (int)0, null);
        Assert.assertTrue((boolean)Arrays.equals(new String[]{null, "a", "b", "c"}, newArray));
        Assert.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((Object[])stringArray1, (int)1, null);
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"a", null, "b", "c"}, newArray));
        Assert.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((Object[])stringArray1, (int)3, null);
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"a", "b", "c", null}, newArray));
        Assert.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((Object[])stringArray1, (int)3, (Object)"d");
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"a", "b", "c", "d"}, newArray));
        Assert.assertEquals(String.class, newArray.getClass().getComponentType());
        Assert.assertEquals(String.class, newArray.getClass().getComponentType());
        Object[] o = new Object[]{"1", "2", "4"};
        Object[] result = ArrayUtils.add((Object[])o, (int)2, (Object)"3");
        Object[] result2 = ArrayUtils.add((Object[])o, (int)3, (Object)"5");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)4L, (long)result.length);
        Assert.assertEquals((Object)"1", (Object)result[0]);
        Assert.assertEquals((Object)"2", (Object)result[1]);
        Assert.assertEquals((Object)"3", (Object)result[2]);
        Assert.assertEquals((Object)"4", (Object)result[3]);
        Assert.assertNotNull((Object)result2);
        Assert.assertEquals((long)4L, (long)result2.length);
        Assert.assertEquals((Object)"1", (Object)result2[0]);
        Assert.assertEquals((Object)"2", (Object)result2[1]);
        Assert.assertEquals((Object)"4", (Object)result2[2]);
        Assert.assertEquals((Object)"5", (Object)result2[3]);
        boolean[] booleanArray = ArrayUtils.add(null, (int)0, (boolean)true);
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true}, booleanArray));
        try {
            booleanArray = ArrayUtils.add(null, (int)-1, (boolean)true);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Index: -1, Length: 0", (Object)e.getMessage());
        }
        booleanArray = ArrayUtils.add((boolean[])new boolean[]{true}, (int)0, (boolean)false);
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{false, true}, booleanArray));
        booleanArray = ArrayUtils.add((boolean[])new boolean[]{false}, (int)1, (boolean)true);
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{false, true}, booleanArray));
        booleanArray = ArrayUtils.add((boolean[])new boolean[]{true, false}, (int)1, (boolean)true);
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true, true, false}, booleanArray));
        try {
            booleanArray = ArrayUtils.add((boolean[])new boolean[]{true, false}, (int)4, (boolean)true);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Index: 4, Length: 2", (Object)e.getMessage());
        }
        try {
            booleanArray = ArrayUtils.add((boolean[])new boolean[]{true, false}, (int)-1, (boolean)true);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Index: -1, Length: 2", (Object)e.getMessage());
        }
        char[] charArray = ArrayUtils.add((char[])null, (int)0, (char)'a');
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'a'}, charArray));
        try {
            charArray = ArrayUtils.add((char[])null, (int)-1, (char)'a');
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Index: -1, Length: 0", (Object)e.getMessage());
        }
        charArray = ArrayUtils.add((char[])new char[]{'a'}, (int)0, (char)'b');
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'b', 'a'}, charArray));
        charArray = ArrayUtils.add((char[])new char[]{'a', 'b'}, (int)0, (char)'c');
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'c', 'a', 'b'}, charArray));
        charArray = ArrayUtils.add((char[])new char[]{'a', 'b'}, (int)1, (char)'k');
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'a', 'k', 'b'}, charArray));
        charArray = ArrayUtils.add((char[])new char[]{'a', 'b', 'c'}, (int)1, (char)'t');
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'a', 't', 'b', 'c'}, charArray));
        try {
            charArray = ArrayUtils.add((char[])new char[]{'a', 'b'}, (int)4, (char)'c');
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Index: 4, Length: 2", (Object)e.getMessage());
        }
        try {
            charArray = ArrayUtils.add((char[])new char[]{'a', 'b'}, (int)-1, (char)'c');
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Index: -1, Length: 2", (Object)e.getMessage());
        }
        short[] shortArray = ArrayUtils.add((short[])new short[]{1}, (int)0, (short)2);
        Assert.assertTrue((boolean)Arrays.equals(new short[]{2, 1}, shortArray));
        try {
            shortArray = ArrayUtils.add((short[])null, (int)-1, (short)2);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Index: -1, Length: 0", (Object)e.getMessage());
        }
        shortArray = ArrayUtils.add((short[])new short[]{2, 6}, (int)2, (short)10);
        Assert.assertTrue((boolean)Arrays.equals(new short[]{2, 6, 10}, shortArray));
        shortArray = ArrayUtils.add((short[])new short[]{2, 6}, (int)0, (short)-4);
        Assert.assertTrue((boolean)Arrays.equals(new short[]{-4, 2, 6}, shortArray));
        shortArray = ArrayUtils.add((short[])new short[]{2, 6, 3}, (int)2, (short)1);
        Assert.assertTrue((boolean)Arrays.equals(new short[]{2, 6, 1, 3}, shortArray));
        try {
            shortArray = ArrayUtils.add((short[])new short[]{2, 6}, (int)4, (short)10);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Index: 4, Length: 2", (Object)e.getMessage());
        }
        try {
            shortArray = ArrayUtils.add((short[])new short[]{2, 6}, (int)-1, (short)10);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Index: -1, Length: 2", (Object)e.getMessage());
        }
        byte[] byteArray = ArrayUtils.add((byte[])new byte[]{1}, (int)0, (byte)2);
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{2, 1}, byteArray));
        try {
            byteArray = ArrayUtils.add((byte[])null, (int)-1, (byte)2);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Index: -1, Length: 0", (Object)e.getMessage());
        }
        byteArray = ArrayUtils.add((byte[])new byte[]{2, 6}, (int)2, (byte)3);
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{2, 6, 3}, byteArray));
        byteArray = ArrayUtils.add((byte[])new byte[]{2, 6}, (int)0, (byte)1);
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 6}, byteArray));
        byteArray = ArrayUtils.add((byte[])new byte[]{2, 6, 3}, (int)2, (byte)1);
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{2, 6, 1, 3}, byteArray));
        try {
            byteArray = ArrayUtils.add((byte[])new byte[]{2, 6}, (int)4, (byte)3);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Index: 4, Length: 2", (Object)e.getMessage());
        }
        try {
            byteArray = ArrayUtils.add((byte[])new byte[]{2, 6}, (int)-1, (byte)3);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Index: -1, Length: 2", (Object)e.getMessage());
        }
        int[] intArray = ArrayUtils.add((int[])new int[]{1}, (int)0, (int)2);
        Assert.assertTrue((boolean)Arrays.equals(new int[]{2, 1}, intArray));
        try {
            intArray = ArrayUtils.add((int[])null, (int)-1, (int)2);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Index: -1, Length: 0", (Object)e.getMessage());
        }
        intArray = ArrayUtils.add((int[])new int[]{2, 6}, (int)2, (int)10);
        Assert.assertTrue((boolean)Arrays.equals(new int[]{2, 6, 10}, intArray));
        intArray = ArrayUtils.add((int[])new int[]{2, 6}, (int)0, (int)-4);
        Assert.assertTrue((boolean)Arrays.equals(new int[]{-4, 2, 6}, intArray));
        intArray = ArrayUtils.add((int[])new int[]{2, 6, 3}, (int)2, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(new int[]{2, 6, 1, 3}, intArray));
        try {
            intArray = ArrayUtils.add((int[])new int[]{2, 6}, (int)4, (int)10);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Index: 4, Length: 2", (Object)e.getMessage());
        }
        try {
            intArray = ArrayUtils.add((int[])new int[]{2, 6}, (int)-1, (int)10);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Index: -1, Length: 2", (Object)e.getMessage());
        }
        long[] longArray = ArrayUtils.add((long[])new long[]{1L}, (int)0, (long)2L);
        Assert.assertTrue((boolean)Arrays.equals(new long[]{2L, 1L}, longArray));
        try {
            longArray = ArrayUtils.add((long[])null, (int)-1, (long)2L);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Index: -1, Length: 0", (Object)e.getMessage());
        }
        longArray = ArrayUtils.add((long[])new long[]{2L, 6L}, (int)2, (long)10L);
        Assert.assertTrue((boolean)Arrays.equals(new long[]{2L, 6L, 10L}, longArray));
        longArray = ArrayUtils.add((long[])new long[]{2L, 6L}, (int)0, (long)-4L);
        Assert.assertTrue((boolean)Arrays.equals(new long[]{-4L, 2L, 6L}, longArray));
        longArray = ArrayUtils.add((long[])new long[]{2L, 6L, 3L}, (int)2, (long)1L);
        Assert.assertTrue((boolean)Arrays.equals(new long[]{2L, 6L, 1L, 3L}, longArray));
        try {
            longArray = ArrayUtils.add((long[])new long[]{2L, 6L}, (int)4, (long)10L);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Index: 4, Length: 2", (Object)e.getMessage());
        }
        try {
            longArray = ArrayUtils.add((long[])new long[]{2L, 6L}, (int)-1, (long)10L);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Index: -1, Length: 2", (Object)e.getMessage());
        }
        float[] floatArray = ArrayUtils.add((float[])new float[]{1.1f}, (int)0, (float)2.2f);
        Assert.assertTrue((boolean)Arrays.equals(new float[]{2.2f, 1.1f}, floatArray));
        try {
            floatArray = ArrayUtils.add((float[])null, (int)-1, (float)2.2f);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Index: -1, Length: 0", (Object)e.getMessage());
        }
        floatArray = ArrayUtils.add((float[])new float[]{2.3f, 6.4f}, (int)2, (float)10.5f);
        Assert.assertTrue((boolean)Arrays.equals(new float[]{2.3f, 6.4f, 10.5f}, floatArray));
        floatArray = ArrayUtils.add((float[])new float[]{2.6f, 6.7f}, (int)0, (float)-4.8f);
        Assert.assertTrue((boolean)Arrays.equals(new float[]{-4.8f, 2.6f, 6.7f}, floatArray));
        floatArray = ArrayUtils.add((float[])new float[]{2.9f, 6.0f, 0.3f}, (int)2, (float)1.0f);
        Assert.assertTrue((boolean)Arrays.equals(new float[]{2.9f, 6.0f, 1.0f, 0.3f}, floatArray));
        try {
            floatArray = ArrayUtils.add((float[])new float[]{2.3f, 6.4f}, (int)4, (float)10.5f);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Index: 4, Length: 2", (Object)e.getMessage());
        }
        try {
            floatArray = ArrayUtils.add((float[])new float[]{2.3f, 6.4f}, (int)-1, (float)10.5f);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Index: -1, Length: 2", (Object)e.getMessage());
        }
        double[] doubleArray = ArrayUtils.add((double[])new double[]{1.1}, (int)0, (double)2.2);
        Assert.assertTrue((boolean)Arrays.equals(new double[]{2.2, 1.1}, doubleArray));
        try {
            doubleArray = ArrayUtils.add(null, (int)-1, (double)2.2);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Index: -1, Length: 0", (Object)e.getMessage());
        }
        doubleArray = ArrayUtils.add((double[])new double[]{2.3, 6.4}, (int)2, (double)10.5);
        Assert.assertTrue((boolean)Arrays.equals(new double[]{2.3, 6.4, 10.5}, doubleArray));
        doubleArray = ArrayUtils.add((double[])new double[]{2.6, 6.7}, (int)0, (double)-4.8);
        Assert.assertTrue((boolean)Arrays.equals(new double[]{-4.8, 2.6, 6.7}, doubleArray));
        doubleArray = ArrayUtils.add((double[])new double[]{2.9, 6.0, 0.3}, (int)2, (double)1.0);
        Assert.assertTrue((boolean)Arrays.equals(new double[]{2.9, 6.0, 1.0, 0.3}, doubleArray));
        try {
            doubleArray = ArrayUtils.add((double[])new double[]{2.3, 6.4}, (int)4, (double)10.5);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Index: 4, Length: 2", (Object)e.getMessage());
        }
        try {
            doubleArray = ArrayUtils.add((double[])new double[]{2.3, 6.4}, (int)-1, (double)10.5);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Index: -1, Length: 2", (Object)e.getMessage());
        }
    }
}

