/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.builder.ToStringStyleTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JsonToStringStyleTest {
    private final Integer base = 5;

    @Before
    public void setUp() throws Exception {
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.JSON_STYLE);
    }

    @After
    public void tearDown() throws Exception {
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }

    @Test
    public void testNull() {
        Assert.assertEquals((Object)"null", (Object)new ToStringBuilder(null).toString());
    }

    @Test
    public void testBlank() {
        Assert.assertEquals((Object)"{}", (Object)new ToStringBuilder((Object)this.base).toString());
    }

    @Test
    public void testAppendSuper() {
        Assert.assertEquals((Object)"{}", (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[" + System.lineSeparator() + "]").toString());
        Assert.assertEquals((Object)"{}", (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[" + System.lineSeparator() + "  null" + System.lineSeparator() + "]").toString());
        Assert.assertEquals((Object)"{\"a\":\"hello\"}", (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[" + System.lineSeparator() + "]").append("a", (Object)"hello").toString());
        Assert.assertEquals((Object)"{\"a\":\"hello\"}", (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[" + System.lineSeparator() + "  null" + System.lineSeparator() + "]").append("a", (Object)"hello").toString());
        Assert.assertEquals((Object)"{\"a\":\"hello\"}", (Object)new ToStringBuilder((Object)this.base).appendSuper(null).append("a", (Object)"hello").toString());
        Assert.assertEquals((Object)"{\"a\":\"hello\",\"b\":\"world\"}", (Object)new ToStringBuilder((Object)this.base).appendSuper("{\"a\":\"hello\"}").append("b", (Object)"world").toString());
    }

    @Test
    public void testChar() {
        try {
            new ToStringBuilder((Object)this.base).append('A').toString();
            Assert.fail((String)"Should have generated UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"{\"a\":\"A\"}", (Object)new ToStringBuilder((Object)this.base).append("a", 'A').toString());
        Assert.assertEquals((Object)"{\"a\":\"A\",\"b\":\"B\"}", (Object)new ToStringBuilder((Object)this.base).append("a", 'A').append("b", 'B').toString());
    }

    @Test
    public void testDate() {
        Date now = new Date();
        Date afterNow = new Date(System.currentTimeMillis() + 1L);
        try {
            new ToStringBuilder((Object)this.base).append((Object)now).toString();
            Assert.fail((String)"Should have generated UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertEquals((Object)("{\"now\":\"" + now.toString() + "\"}"), (Object)new ToStringBuilder((Object)this.base).append("now", (Object)now).toString());
        Assert.assertEquals((Object)("{\"now\":\"" + now.toString() + "\",\"after\":\"" + afterNow.toString() + "\"}"), (Object)new ToStringBuilder((Object)this.base).append("now", (Object)now).append("after", (Object)afterNow).toString());
    }

    @Test
    public void testObject() {
        Integer i3 = 3;
        Integer i4 = 4;
        try {
            new ToStringBuilder((Object)this.base).append(null).toString();
            Assert.fail((String)"Should have generated UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            new ToStringBuilder((Object)this.base).append((Object)i3).toString();
            Assert.fail((String)"Should have generated UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"{\"a\":null}", (Object)new ToStringBuilder((Object)this.base).append("a", null).toString());
        Assert.assertEquals((Object)"{\"a\":3}", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3).toString());
        Assert.assertEquals((Object)"{\"a\":3,\"b\":4}", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3).append("b", (Object)i4).toString());
        try {
            new ToStringBuilder((Object)this.base).append("a", (Object)i3, false).toString();
            Assert.fail((String)"Should have generated UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            new ToStringBuilder((Object)this.base).append("a", new ArrayList(), false).toString();
            Assert.fail((String)"Should have generated UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"{\"a\":[]}", (Object)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), true).toString());
        try {
            new ToStringBuilder((Object)this.base).append("a", new HashMap(), false).toString();
            Assert.fail((String)"Should have generated UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"{\"a\":{}}", (Object)new ToStringBuilder((Object)this.base).append("a", new HashMap(), true).toString());
        try {
            new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], false).toString();
            Assert.fail((String)"Should have generated UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"{\"a\":[]}", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], true).toString());
        try {
            new ToStringBuilder((Object)this.base).append("a", (Object)new int[]{1, 2, 3}, false).toString();
            Assert.fail((String)"Should have generated UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"{\"a\":[1,2,3]}", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new int[]{1, 2, 3}, true).toString());
        try {
            new ToStringBuilder((Object)this.base).append("a", (Object)new String[]{"v", "x", "y", "z"}, false).toString();
            Assert.fail((String)"Should have generated UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"{\"a\":[\"v\",\"x\",\"y\",\"z\"]}", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new String[]{"v", "x", "y", "z"}, true).toString());
    }

    @Test
    public void testPerson() {
        ToStringStyleTest.Person p = new ToStringStyleTest.Person();
        p.name = "Jane Doe";
        p.age = 25;
        p.smoker = true;
        Assert.assertEquals((Object)"{\"name\":\"Jane Doe\",\"age\":25,\"smoker\":true}", (Object)new ToStringBuilder((Object)p).append("name", (Object)p.name).append("age", p.age).append("smoker", p.smoker).toString());
    }

    @Test
    public void testNestingPerson() {
        ToStringStyleTest.Person p = new ToStringStyleTest.Person(){

            public String toString() {
                return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("age", this.age).append("smoker", this.smoker).toString();
            }
        };
        p.name = "Jane Doe";
        p.age = 25;
        p.smoker = true;
        NestingPerson nestP = new NestingPerson();
        nestP.pid = "#1@Jane";
        nestP.person = p;
        Assert.assertEquals((Object)"{\"pid\":\"#1@Jane\",\"person\":{\"name\":\"Jane Doe\",\"age\":25,\"smoker\":true}}", (Object)new ToStringBuilder((Object)nestP).append("pid", (Object)nestP.pid).append("person", (Object)nestP.person).toString());
    }

    @Test
    public void testLong() {
        try {
            new ToStringBuilder((Object)this.base).append(3L).toString();
            Assert.fail((String)"Should have generated UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"{\"a\":3}", (Object)new ToStringBuilder((Object)this.base).append("a", 3L).toString());
        Assert.assertEquals((Object)"{\"a\":3,\"b\":4}", (Object)new ToStringBuilder((Object)this.base).append("a", 3L).append("b", 4L).toString());
    }

    @Test
    public void testObjectArray() {
        Object[] array = new Object[]{null, this.base, new int[]{3, 6}};
        try {
            new ToStringBuilder((Object)this.base).append(array).toString();
            Assert.fail((String)"Should have generated UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            new ToStringBuilder((Object)this.base).append((Object)array).toString();
            Assert.fail((String)"Should have generated UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        array = null;
        try {
            new ToStringBuilder((Object)this.base).append(array).toString();
            Assert.fail((String)"Should have generated UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            new ToStringBuilder((Object)this.base).append((Object)array).toString();
            Assert.fail((String)"Should have generated UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testLongArray() {
        long[] array = new long[]{1L, 2L, -3L, 4L};
        try {
            new ToStringBuilder((Object)this.base).append(array).toString();
            Assert.fail((String)"Should have generated UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            new ToStringBuilder((Object)this.base).append((Object)array).toString();
            Assert.fail((String)"Should have generated UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        array = null;
        try {
            new ToStringBuilder((Object)this.base).append(array).toString();
            Assert.fail((String)"Should have generated UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            new ToStringBuilder((Object)this.base).append((Object)array).toString();
            Assert.fail((String)"Should have generated UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testLongArrayArray() {
        Object array = new long[][]{{1L, 2L}, null, {5L}};
        try {
            new ToStringBuilder((Object)this.base).append((Object[])array).toString();
            Assert.fail((String)"Should have generated UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            new ToStringBuilder((Object)this.base).append(array).toString();
            Assert.fail((String)"Should have generated UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        array = null;
        try {
            new ToStringBuilder((Object)this.base).append((Object[])array).toString();
            Assert.fail((String)"Should have generated UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            new ToStringBuilder((Object)this.base).append(array).toString();
            Assert.fail((String)"Should have generated UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testArray() {
        ToStringStyleTest.Person p = new ToStringStyleTest.Person();
        p.name = "Jane Doe";
        p.age = 25;
        p.smoker = true;
        Assert.assertEquals((Object)"{\"name\":\"Jane Doe\",\"age\":25,\"smoker\":true,\"groups\":['admin', 'manager', 'user']}", (Object)new ToStringBuilder((Object)p).append("name", (Object)p.name).append("age", p.age).append("smoker", p.smoker).append("groups", new Object(){

            public String toString() {
                return "['admin', 'manager', 'user']";
            }
        }).toString());
    }

    @Test
    public void testLANG1395() {
        Assert.assertEquals((Object)"{\"name\":\"value\"}", (Object)new ToStringBuilder((Object)this.base).append("name", (Object)"value").toString());
        Assert.assertEquals((Object)"{\"name\":\"\"}", (Object)new ToStringBuilder((Object)this.base).append("name", (Object)"").toString());
        Assert.assertEquals((Object)"{\"name\":\"\\\"\"}", (Object)new ToStringBuilder((Object)this.base).append("name", '\"').toString());
        Assert.assertEquals((Object)"{\"name\":\"\\\\\"}", (Object)new ToStringBuilder((Object)this.base).append("name", '\\').toString());
        Assert.assertEquals((Object)"{\"name\":\"Let's \\\"quote\\\" this\"}", (Object)new ToStringBuilder((Object)this.base).append("name", (Object)"Let's \"quote\" this").toString());
    }

    @Test
    public void testLANG1396() {
        Assert.assertEquals((Object)"{\"Let's \\\"quote\\\" this\":\"value\"}", (Object)new ToStringBuilder((Object)this.base).append("Let's \"quote\" this", (Object)"value").toString());
    }

    static class NestingPerson {
        String pid;
        ToStringStyleTest.Person person;

        NestingPerson() {
        }
    }
}

