/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.Diffable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ReflectionDiffBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.junit.Assert;
import org.junit.Test;

public class ReflectionDiffBuilderTest {
    private static final ToStringStyle SHORT_STYLE = ToStringStyle.SHORT_PREFIX_STYLE;

    @Test
    public void test_no_differences() {
        TypeTestClass firstObject = new TypeTestClass();
        TypeTestClass secondObject = new TypeTestClass();
        DiffResult list = firstObject.diff(secondObject);
        Assert.assertEquals((long)0L, (long)list.getNumberOfDiffs());
    }

    @Test
    public void test_primitive_difference() {
        TypeTestClass firstObject = new TypeTestClass();
        firstObject.charField = 'c';
        TypeTestClass secondObject = new TypeTestClass();
        DiffResult list = firstObject.diff(secondObject);
        Assert.assertEquals((long)1L, (long)list.getNumberOfDiffs());
    }

    @Test
    public void test_array_difference() {
        TypeTestClass firstObject = new TypeTestClass();
        TypeTestClass.access$302(firstObject, new char[]{'c'});
        TypeTestClass secondObject = new TypeTestClass();
        DiffResult list = firstObject.diff(secondObject);
        Assert.assertEquals((long)1L, (long)list.getNumberOfDiffs());
    }

    @Test
    public void test_transient_field_difference() {
        TypeTestClass firstObject = new TypeTestClass();
        firstObject.transientField = "a";
        TypeTestClass secondObject = new TypeTestClass();
        firstObject.transientField = "b";
        DiffResult list = firstObject.diff(secondObject);
        Assert.assertEquals((long)0L, (long)list.getNumberOfDiffs());
    }

    @Test
    public void test_no_differences_inheritance() {
        TypeTestChildClass firstObject = new TypeTestChildClass();
        TypeTestChildClass secondObject = new TypeTestChildClass();
        DiffResult list = firstObject.diff(secondObject);
        Assert.assertEquals((long)0L, (long)list.getNumberOfDiffs());
    }

    @Test
    public void test_difference_in_inherited_field() {
        TypeTestChildClass firstObject = new TypeTestChildClass();
        firstObject.intField = 99;
        TypeTestChildClass secondObject = new TypeTestChildClass();
        DiffResult list = firstObject.diff(secondObject);
        Assert.assertEquals((long)1L, (long)list.getNumberOfDiffs());
    }

    static /* synthetic */ ToStringStyle access$000() {
        return SHORT_STYLE;
    }

    private static class TypeTestChildClass
    extends TypeTestClass {
        String field = "a";

        private TypeTestChildClass() {
        }
    }

    private static class TypeTestClass
    implements Diffable<TypeTestClass> {
        private final ToStringStyle style = ReflectionDiffBuilderTest.access$000();
        private final boolean booleanField = true;
        private final boolean[] booleanArrayField = new boolean[]{true};
        private final byte byteField = (byte)-1;
        private final byte[] byteArrayField = new byte[]{-1};
        private char charField = (char)97;
        private char[] charArrayField = new char[]{'a'};
        private final double doubleField = 1.0;
        private final double[] doubleArrayField = new double[]{1.0};
        private final float floatField = 1.0f;
        private final float[] floatArrayField = new float[]{1.0f};
        int intField = 1;
        private final int[] intArrayField = new int[]{1};
        private final long longField = 1L;
        private final long[] longArrayField = new long[]{1L};
        private final short shortField = 1;
        private final short[] shortArrayField = new short[]{1};
        private final Object objectField = null;
        private final Object[] objectArrayField = new Object[]{null};
        private static int staticField;
        private transient String transientField;

        private TypeTestClass() {
        }

        public DiffResult diff(TypeTestClass obj) {
            return new ReflectionDiffBuilder((Object)this, (Object)obj, this.style).build();
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (boolean)false);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (boolean)false);
        }

        static /* synthetic */ char[] access$302(TypeTestClass x0, char[] x1) {
            x0.charArrayField = x1;
            return x1;
        }
    }
}

