/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import org.apache.commons.lang3.concurrent.Computable;
import org.apache.commons.lang3.concurrent.Memoizer;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class MemoizerTest {
    @Mock
    private Computable<Integer, Integer> computable;

    @Test
    public void testOnlyCallComputableOnceIfDoesNotThrowException() throws Exception {
        Integer input = 1;
        Memoizer memoizer = new Memoizer(this.computable);
        EasyMock.expect((Object)this.computable.compute((Object)input)).andReturn((Object)input);
        EasyMock.replay((Object[])new Object[]{this.computable});
        Assert.assertEquals((String)"Should call computable first time", (Object)input, (Object)memoizer.compute((Object)input));
        Assert.assertEquals((String)"Should not call the computable the second time", (Object)input, (Object)memoizer.compute((Object)input));
    }

    @Test(expected=IllegalStateException.class)
    public void testDefaultBehaviourNotToRecalculateExecutionExceptions() throws Exception {
        Integer input = 1;
        Memoizer memoizer = new Memoizer(this.computable);
        InterruptedException interruptedException = new InterruptedException();
        EasyMock.expect((Object)this.computable.compute((Object)input)).andThrow((Throwable)interruptedException);
        EasyMock.replay((Object[])new Object[]{this.computable});
        try {
            memoizer.compute((Object)input);
            Assert.fail((String)"Expected Throwable to be thrown!");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        memoizer.compute((Object)input);
    }

    @Test(expected=IllegalStateException.class)
    public void testDoesNotRecalculateWhenSetToFalse() throws Exception {
        Integer input = 1;
        Memoizer memoizer = new Memoizer(this.computable, false);
        InterruptedException interruptedException = new InterruptedException();
        EasyMock.expect((Object)this.computable.compute((Object)input)).andThrow((Throwable)interruptedException);
        EasyMock.replay((Object[])new Object[]{this.computable});
        try {
            memoizer.compute((Object)input);
            Assert.fail((String)"Expected Throwable to be thrown!");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        memoizer.compute((Object)input);
    }

    @Test
    public void testDoesRecalculateWhenSetToTrue() throws Exception {
        Integer input = 1;
        Integer answer = 3;
        Memoizer memoizer = new Memoizer(this.computable, true);
        InterruptedException interruptedException = new InterruptedException();
        EasyMock.expect((Object)this.computable.compute((Object)input)).andThrow((Throwable)interruptedException).andReturn((Object)answer);
        EasyMock.replay((Object[])new Object[]{this.computable});
        try {
            memoizer.compute((Object)input);
            Assert.fail((String)"Expected Throwable to be thrown!");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertEquals((Object)answer, (Object)memoizer.compute((Object)input));
    }

    @Test(expected=RuntimeException.class)
    public void testWhenComputableThrowsRuntimeException() throws Exception {
        Integer input = 1;
        Memoizer memoizer = new Memoizer(this.computable);
        RuntimeException runtimeException = new RuntimeException("Some runtime exception");
        EasyMock.expect((Object)this.computable.compute((Object)input)).andThrow((Throwable)runtimeException);
        EasyMock.replay((Object[])new Object[]{this.computable});
        memoizer.compute((Object)input);
    }

    @Test(expected=Error.class)
    public void testWhenComputableThrowsError() throws Exception {
        Integer input = 1;
        Memoizer memoizer = new Memoizer(this.computable);
        Error error = new Error();
        EasyMock.expect((Object)this.computable.compute((Object)input)).andThrow((Throwable)error);
        EasyMock.replay((Object[])new Object[]{this.computable});
        memoizer.compute((Object)input);
    }
}

