/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.io.Serializable;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.time.DateParser;
import org.apache.commons.lang3.time.FastDateParser;
import org.apache.commons.lang3.time.FormatCache;
import org.junit.Assert;
import org.junit.Test;

public class FastDateParserTest {
    private static final String SHORT_FORMAT_NOERA = "y/M/d/h/a/m/s/E";
    private static final String LONG_FORMAT_NOERA = "yyyy/MMMM/dddd/hhhh/mmmm/ss/aaaa/EEEE";
    private static final String SHORT_FORMAT = "G/y/M/d/h/a/m/s/E";
    private static final String LONG_FORMAT = "GGGG/yyyy/MMMM/dddd/hhhh/mmmm/ss/aaaa/EEEE";
    private static final String yMdHmsSZ = "yyyy-MM-dd'T'HH:mm:ss.SSS Z";
    private static final String DMY_DOT = "dd.MM.yyyy";
    private static final String YMD_SLASH = "yyyy/MM/dd";
    private static final String MDY_DASH = "MM-DD-yyyy";
    private static final String MDY_SLASH = "MM/DD/yyyy";
    private static final TimeZone REYKJAVIK = TimeZone.getTimeZone("Atlantic/Reykjavik");
    private static final TimeZone NEW_YORK = TimeZone.getTimeZone("America/New_York");
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final TimeZone INDIA = TimeZone.getTimeZone("Asia/Calcutta");
    private static final Locale SWEDEN = new Locale("sv", "SE");

    DateParser getInstance(String format) {
        return this.getInstance(format, TimeZone.getDefault(), Locale.getDefault());
    }

    private DateParser getDateInstance(int dateStyle, Locale locale) {
        return this.getInstance(FormatCache.getPatternForStyle((Integer)dateStyle, null, (Locale)locale), TimeZone.getDefault(), Locale.getDefault());
    }

    private DateParser getInstance(String format, Locale locale) {
        return this.getInstance(format, TimeZone.getDefault(), locale);
    }

    private DateParser getInstance(String format, TimeZone timeZone) {
        return this.getInstance(format, timeZone, Locale.getDefault());
    }

    protected DateParser getInstance(String format, TimeZone timeZone, Locale locale) {
        return new FastDateParser(format, timeZone, locale, null);
    }

    @Test
    public void test_Equality_Hash() {
        DateParser[] parsers = new DateParser[]{this.getInstance(yMdHmsSZ, NEW_YORK, Locale.US), this.getInstance(DMY_DOT, NEW_YORK, Locale.US), this.getInstance(YMD_SLASH, NEW_YORK, Locale.US), this.getInstance(MDY_DASH, NEW_YORK, Locale.US), this.getInstance(MDY_SLASH, NEW_YORK, Locale.US), this.getInstance(MDY_SLASH, REYKJAVIK, Locale.US), this.getInstance(MDY_SLASH, REYKJAVIK, SWEDEN)};
        HashMap<DateParser, Integer> map = new HashMap<DateParser, Integer>();
        int i = 0;
        for (DateParser parser : parsers) {
            map.put(parser, i++);
        }
        i = 0;
        for (DateParser parser : parsers) {
            Assert.assertEquals((long)i++, (long)((Integer)map.get(parser)).intValue());
        }
    }

    @Test
    public void testParseZone() throws ParseException {
        Calendar cal = Calendar.getInstance(NEW_YORK, Locale.US);
        cal.clear();
        cal.set(2003, 6, 10, 16, 33, 20);
        DateParser fdf = this.getInstance(yMdHmsSZ, NEW_YORK, Locale.US);
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2003-07-10T15:33:20.000 -0500"));
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2003-07-10T15:33:20.000 GMT-05:00"));
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2003-07-10T16:33:20.000 Eastern Daylight Time"));
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2003-07-10T16:33:20.000 EDT"));
        cal.setTimeZone(TimeZone.getTimeZone("GMT-3"));
        cal.set(2003, 1, 10, 9, 0, 0);
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2003-02-10T09:00:00.000 -0300"));
        cal.setTimeZone(TimeZone.getTimeZone("GMT+5"));
        cal.set(2003, 1, 10, 15, 5, 6);
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2003-02-10T15:05:06.000 +0500"));
    }

    @Test
    public void testParseLongShort() throws ParseException {
        Calendar cal = Calendar.getInstance(NEW_YORK, Locale.US);
        cal.clear();
        cal.set(2003, 1, 10, 15, 33, 20);
        cal.set(14, 989);
        cal.setTimeZone(NEW_YORK);
        DateParser fdf = this.getInstance("yyyy GGGG MMMM dddd aaaa EEEE HHHH mmmm ssss SSSS ZZZZ", NEW_YORK, Locale.US);
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2003 AD February 0010 PM Monday 0015 0033 0020 0989 GMT-05:00"));
        cal.set(0, 0);
        Date parse = fdf.parse("2003 BC February 0010 PM Saturday 0015 0033 0020 0989 GMT-05:00");
        Assert.assertEquals((Object)cal.getTime(), (Object)parse);
        fdf = this.getInstance("y G M d a E H m s S Z", NEW_YORK, Locale.US);
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("03 BC 2 10 PM Sat 15 33 20 989 -0500"));
        cal.set(0, 1);
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("03 AD 2 10 PM Saturday 15 33 20 989 -0500"));
    }

    @Test
    public void testAmPm() throws ParseException {
        Calendar cal = Calendar.getInstance(NEW_YORK, Locale.US);
        cal.clear();
        DateParser h = this.getInstance("yyyy-MM-dd hh a mm:ss", NEW_YORK, Locale.US);
        DateParser K = this.getInstance("yyyy-MM-dd KK a mm:ss", NEW_YORK, Locale.US);
        DateParser k = this.getInstance("yyyy-MM-dd kk:mm:ss", NEW_YORK, Locale.US);
        DateParser H = this.getInstance("yyyy-MM-dd HH:mm:ss", NEW_YORK, Locale.US);
        cal.set(2010, 7, 1, 0, 33, 20);
        Assert.assertEquals((Object)cal.getTime(), (Object)h.parse("2010-08-01 12 AM 33:20"));
        Assert.assertEquals((Object)cal.getTime(), (Object)K.parse("2010-08-01 0 AM 33:20"));
        Assert.assertEquals((Object)cal.getTime(), (Object)k.parse("2010-08-01 00:33:20"));
        Assert.assertEquals((Object)cal.getTime(), (Object)H.parse("2010-08-01 00:33:20"));
        cal.set(2010, 7, 1, 3, 33, 20);
        Assert.assertEquals((Object)cal.getTime(), (Object)h.parse("2010-08-01 3 AM 33:20"));
        Assert.assertEquals((Object)cal.getTime(), (Object)K.parse("2010-08-01 3 AM 33:20"));
        Assert.assertEquals((Object)cal.getTime(), (Object)k.parse("2010-08-01 03:33:20"));
        Assert.assertEquals((Object)cal.getTime(), (Object)H.parse("2010-08-01 03:33:20"));
        cal.set(2010, 7, 1, 15, 33, 20);
        Assert.assertEquals((Object)cal.getTime(), (Object)h.parse("2010-08-01 3 PM 33:20"));
        Assert.assertEquals((Object)cal.getTime(), (Object)K.parse("2010-08-01 3 PM 33:20"));
        Assert.assertEquals((Object)cal.getTime(), (Object)k.parse("2010-08-01 15:33:20"));
        Assert.assertEquals((Object)cal.getTime(), (Object)H.parse("2010-08-01 15:33:20"));
        cal.set(2010, 7, 1, 12, 33, 20);
        Assert.assertEquals((Object)cal.getTime(), (Object)h.parse("2010-08-01 12 PM 33:20"));
        Assert.assertEquals((Object)cal.getTime(), (Object)K.parse("2010-08-01 0 PM 33:20"));
        Assert.assertEquals((Object)cal.getTime(), (Object)k.parse("2010-08-01 12:33:20"));
        Assert.assertEquals((Object)cal.getTime(), (Object)H.parse("2010-08-01 12:33:20"));
    }

    private Calendar getEraStart(int year, TimeZone zone, Locale locale) {
        Calendar cal = Calendar.getInstance(zone, locale);
        cal.clear();
        if (locale.equals(FastDateParser.JAPANESE_IMPERIAL)) {
            if (year < 1868) {
                cal.set(0, 0);
                cal.set(1, 1868 - year);
            }
        } else {
            if (year < 0) {
                cal.set(0, 0);
                year = -year;
            }
            cal.set(1, year / 100 * 100);
        }
        return cal;
    }

    private void validateSdfFormatFdpParseEquality(String format, Locale locale, TimeZone tz, DateParser fdp, Date in, int year, Date cs) throws ParseException {
        block3: {
            SimpleDateFormat sdf = new SimpleDateFormat(format, locale);
            sdf.setTimeZone(tz);
            if (format.equals(SHORT_FORMAT)) {
                sdf.set2DigitYearStart(cs);
            }
            String fmt = sdf.format(in);
            try {
                Date out = fdp.parse(fmt);
                Assert.assertEquals((String)(locale.toString() + " " + in + " " + format + " " + tz.getID()), (Object)in, (Object)out);
            }
            catch (ParseException pe) {
                if (year < 1868 && locale.getCountry().equals("JP")) break block3;
                throw pe;
            }
        }
    }

    @Test
    public void testParses() throws Exception {
        for (String format : new String[]{LONG_FORMAT, SHORT_FORMAT}) {
            for (Locale locale : Locale.getAvailableLocales()) {
                for (TimeZone tz : new TimeZone[]{NEW_YORK, REYKJAVIK, GMT}) {
                    for (int year : new int[]{2003, 1940, 1868, 1867, 1, -1, -1940}) {
                        Calendar cal = this.getEraStart(year, tz, locale);
                        Date centuryStart = cal.getTime();
                        cal.set(2, 1);
                        cal.set(5, 10);
                        Date in = cal.getTime();
                        FastDateParser fdp = new FastDateParser(format, tz, locale, centuryStart);
                        this.validateSdfFormatFdpParseEquality(format, locale, tz, (DateParser)fdp, in, year, centuryStart);
                    }
                }
            }
        }
    }

    @Test
    public void testTzParses() throws Exception {
        for (Locale locale : Locale.getAvailableLocales()) {
            FastDateParser fdp = new FastDateParser("yyyy/MM/dd z", TimeZone.getDefault(), locale);
            for (TimeZone tz : new TimeZone[]{NEW_YORK, REYKJAVIK, GMT}) {
                Calendar cal = Calendar.getInstance(tz, locale);
                cal.clear();
                cal.set(1, 2000);
                cal.set(2, 1);
                cal.set(5, 10);
                Date expected = cal.getTime();
                Date actual = fdp.parse("2000/02/10 " + tz.getDisplayName(locale));
                Assert.assertEquals((String)("tz:" + tz.getID() + " locale:" + locale.getDisplayName()), (Object)expected, (Object)actual);
            }
        }
    }

    @Test
    public void testLocales_Long_AD() throws Exception {
        this.testLocales(LONG_FORMAT, false);
    }

    @Test
    public void testLocales_Long_BC() throws Exception {
        this.testLocales(LONG_FORMAT, true);
    }

    @Test
    public void testLocales_Short_AD() throws Exception {
        this.testLocales(SHORT_FORMAT, false);
    }

    @Test
    public void testLocales_Short_BC() throws Exception {
        this.testLocales(SHORT_FORMAT, true);
    }

    @Test
    public void testLocales_LongNoEra_AD() throws Exception {
        this.testLocales(LONG_FORMAT_NOERA, false);
    }

    @Test
    public void testLocales_LongNoEra_BC() throws Exception {
        this.testLocales(LONG_FORMAT_NOERA, true);
    }

    @Test
    public void testLocales_ShortNoEra_AD() throws Exception {
        this.testLocales(SHORT_FORMAT_NOERA, false);
    }

    @Test
    public void testLocales_ShortNoEra_BC() throws Exception {
        this.testLocales(SHORT_FORMAT_NOERA, true);
    }

    private void testLocales(String format, boolean eraBC) throws Exception {
        Calendar cal = Calendar.getInstance(GMT);
        cal.clear();
        cal.set(2003, 1, 10);
        if (eraBC) {
            cal.set(0, 0);
        }
        for (Locale locale : Locale.getAvailableLocales()) {
            if (eraBC && locale.equals(FastDateParser.JAPANESE_IMPERIAL)) continue;
            SimpleDateFormat sdf = new SimpleDateFormat(format, locale);
            DateParser fdf = this.getInstance(format, locale);
            try {
                this.checkParse(locale, cal, sdf, fdf);
            }
            catch (ParseException ex) {
                Assert.fail((String)("Locale " + locale + " failed with " + format + " era " + (eraBC ? "BC" : "AD") + "\n" + this.trimMessage(ex.toString())));
            }
        }
    }

    @Test
    public void testJpLocales() {
        Calendar cal = Calendar.getInstance(GMT);
        cal.clear();
        cal.set(2003, 1, 10);
        cal.set(0, 0);
        Locale locale = LocaleUtils.toLocale((String)"zh");
        SimpleDateFormat sdf = new SimpleDateFormat(LONG_FORMAT, locale);
        DateParser fdf = this.getInstance(LONG_FORMAT, locale);
        try {
            this.checkParse(locale, cal, sdf, fdf);
        }
        catch (ParseException ex) {
            Assert.fail((String)("Locale " + locale + " failed with " + LONG_FORMAT + "\n" + this.trimMessage(ex.toString())));
        }
    }

    private String trimMessage(String msg) {
        if (msg.length() < 100) {
            return msg;
        }
        int gmt = msg.indexOf("(GMT");
        if (gmt > 0) {
            return msg.substring(0, gmt + 4) + "...)";
        }
        return msg.substring(0, 100) + "...";
    }

    private void checkParse(Locale locale, Calendar cal, SimpleDateFormat sdf, DateParser fdf) throws ParseException {
        String formattedDate = sdf.format(cal.getTime());
        this.checkParse(locale, sdf, fdf, formattedDate);
        this.checkParse(locale, sdf, fdf, formattedDate.toLowerCase(locale));
        this.checkParse(locale, sdf, fdf, formattedDate.toUpperCase(locale));
    }

    private void checkParse(Locale locale, SimpleDateFormat sdf, DateParser fdf, String formattedDate) throws ParseException {
        Date expectedTime = sdf.parse(formattedDate);
        Date actualTime = fdf.parse(formattedDate);
        Assert.assertEquals((String)(locale.toString() + " " + formattedDate + "\n"), (Object)expectedTime, (Object)actualTime);
    }

    @Test
    public void testParseNumerics() throws ParseException {
        Calendar cal = Calendar.getInstance(NEW_YORK, Locale.US);
        cal.clear();
        cal.set(2003, 1, 10, 15, 33, 20);
        cal.set(14, 989);
        DateParser fdf = this.getInstance("yyyyMMddHHmmssSSS", NEW_YORK, Locale.US);
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("20030210153320989"));
    }

    @Test
    public void testQuotes() throws ParseException {
        Calendar cal = Calendar.getInstance(NEW_YORK, Locale.US);
        cal.clear();
        cal.set(2003, 1, 10, 15, 33, 20);
        cal.set(14, 989);
        DateParser fdf = this.getInstance("''yyyyMMdd'A''B'HHmmssSSS''", NEW_YORK, Locale.US);
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("'20030210A'B153320989'"));
    }

    @Test
    public void testSpecialCharacters() throws Exception {
        this.testSdfAndFdp("q", "", true);
        this.testSdfAndFdp("Q", "", true);
        this.testSdfAndFdp("$", "$", false);
        this.testSdfAndFdp("?.d", "?.12", false);
        this.testSdfAndFdp("''yyyyMMdd'A''B'HHmmssSSS''", "'20030210A'B153320989'", false);
        this.testSdfAndFdp("''''yyyyMMdd'A''B'HHmmssSSS''", "''20030210A'B153320989'", false);
        this.testSdfAndFdp("'$\\Ed'", "$\\Ed", false);
        this.testSdfAndFdp("'QED'", "QED", false);
        this.testSdfAndFdp("'QED'", "qed", true);
        this.testSdfAndFdp("yyyy-MM-dd 'QED'", "2003-02-10 QED", false);
        this.testSdfAndFdp("yyyy-MM-dd 'QED'", "2003-02-10 qed", true);
    }

    @Test
    public void testLANG_832() throws Exception {
        this.testSdfAndFdp("'d'd", "d3", false);
        this.testSdfAndFdp("'d'd'", "d3", true);
    }

    @Test
    public void testLANG_831() throws Exception {
        this.testSdfAndFdp("M E", "3  Tue", true);
    }

    private void testSdfAndFdp(String format, String date, boolean shouldFail) throws Exception {
        Exception s;
        Exception f;
        Date dsdf;
        Date dfdp;
        block7: {
            block6: {
                dfdp = null;
                dsdf = null;
                f = null;
                s = null;
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.US);
                    sdf.setTimeZone(NEW_YORK);
                    dsdf = sdf.parse(date);
                    if (shouldFail) {
                        Assert.fail((String)("Expected SDF failure, but got " + dsdf + " for [" + format + "," + date + "]"));
                    }
                }
                catch (Exception e) {
                    s = e;
                    if (shouldFail) break block6;
                    throw e;
                }
            }
            try {
                DateParser fdp = this.getInstance(format, NEW_YORK, Locale.US);
                dfdp = fdp.parse(date);
                if (shouldFail) {
                    Assert.fail((String)("Expected FDF failure, but got " + dfdp + " for [" + format + "," + date + "]"));
                }
            }
            catch (Exception e) {
                f = e;
                if (shouldFail) break block7;
                throw e;
            }
        }
        Assert.assertTrue((String)"Should both or neither throw Exceptions", (f == null == (s == null) ? 1 : 0) != 0);
        Assert.assertEquals((String)"Parsed dates should be equal", (Object)dsdf, (Object)dfdp);
    }

    @Test
    public void testDayOf() throws ParseException {
        Calendar cal = Calendar.getInstance(NEW_YORK, Locale.US);
        cal.clear();
        cal.set(2003, 1, 10);
        DateParser fdf = this.getInstance("W w F D y", NEW_YORK, Locale.US);
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("3 7 2 41 03"));
    }

    @Test
    public void testShortDateStyleWithLocales() throws ParseException {
        DateParser fdf = this.getDateInstance(3, Locale.US);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2004, 1, 3);
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2/3/04"));
        fdf = this.getDateInstance(3, SWEDEN);
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2004-02-03"));
    }

    @Test
    public void testLowYearPadding() throws ParseException {
        DateParser parser = this.getInstance(YMD_SLASH);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, 0, 1);
        Assert.assertEquals((Object)cal.getTime(), (Object)parser.parse("0001/01/01"));
        cal.set(10, 0, 1);
        Assert.assertEquals((Object)cal.getTime(), (Object)parser.parse("0010/01/01"));
        cal.set(100, 0, 1);
        Assert.assertEquals((Object)cal.getTime(), (Object)parser.parse("0100/01/01"));
        cal.set(999, 0, 1);
        Assert.assertEquals((Object)cal.getTime(), (Object)parser.parse("0999/01/01"));
    }

    @Test
    public void testMilleniumBug() throws ParseException {
        DateParser parser = this.getInstance(DMY_DOT);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1000, 0, 1);
        Assert.assertEquals((Object)cal.getTime(), (Object)parser.parse("01.01.1000"));
    }

    @Test
    public void testLang303() throws ParseException {
        DateParser parser = this.getInstance(YMD_SLASH);
        Calendar cal = Calendar.getInstance();
        cal.set(2004, 11, 31);
        Date date = parser.parse("2004/11/31");
        parser = (DateParser)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)((Serializable)parser)));
        Assert.assertEquals((Object)date, (Object)parser.parse("2004/11/31"));
    }

    @Test
    public void testLang538() throws ParseException {
        DateParser parser = this.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", GMT);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT-8"));
        cal.clear();
        cal.set(2009, 9, 16, 8, 42, 16);
        Assert.assertEquals((Object)cal.getTime(), (Object)parser.parse("2009-10-16T16:42:16.000Z"));
    }

    @Test
    public void testEquals() {
        DateParser parser1 = this.getInstance(YMD_SLASH);
        DateParser parser2 = this.getInstance(YMD_SLASH);
        Assert.assertEquals((Object)parser1, (Object)parser2);
        Assert.assertEquals((long)parser1.hashCode(), (long)parser2.hashCode());
        Assert.assertFalse((boolean)parser1.equals(new Object()));
    }

    @Test
    public void testToStringContainsName() {
        DateParser parser = this.getInstance(YMD_SLASH);
        Assert.assertTrue((boolean)parser.toString().startsWith("FastDate"));
    }

    @Test
    public void testPatternMatches() {
        DateParser parser = this.getInstance(yMdHmsSZ);
        Assert.assertEquals((Object)yMdHmsSZ, (Object)parser.getPattern());
    }

    @Test
    public void testLocaleMatches() {
        DateParser parser = this.getInstance(yMdHmsSZ, SWEDEN);
        Assert.assertEquals((Object)SWEDEN, (Object)parser.getLocale());
    }

    @Test
    public void testTimeZoneMatches() {
        DateParser parser = this.getInstance(yMdHmsSZ, REYKJAVIK);
        Assert.assertEquals((Object)REYKJAVIK, (Object)parser.getTimeZone());
    }

    @Test
    public void testLang996() throws ParseException {
        Calendar expected = Calendar.getInstance(NEW_YORK, Locale.US);
        expected.clear();
        expected.set(2014, 4, 14);
        DateParser fdp = this.getInstance("ddMMMyyyy", NEW_YORK, Locale.US);
        Assert.assertEquals((Object)expected.getTime(), (Object)fdp.parse("14may2014"));
        Assert.assertEquals((Object)expected.getTime(), (Object)fdp.parse("14MAY2014"));
        Assert.assertEquals((Object)expected.getTime(), (Object)fdp.parse("14May2014"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test1806Argument() {
        this.getInstance("XXXX");
    }

    private static Calendar initializeCalendar(TimeZone tz) {
        Calendar cal = Calendar.getInstance(tz);
        cal.set(1, 2001);
        cal.set(2, 1);
        cal.set(5, 4);
        cal.set(11, 12);
        cal.set(12, 8);
        cal.set(13, 56);
        cal.set(14, 235);
        return cal;
    }

    @Test
    public void test1806() throws ParseException {
        String formatStub = "yyyy-MM-dd'T'HH:mm:ss.SSS";
        String dateStub = "2001-02-04T12:08:56.235";
        for (Expected1806 trial : Expected1806.values()) {
            Calendar cal = FastDateParserTest.initializeCalendar(trial.zone);
            String message = trial.zone.getDisplayName() + ";";
            DateParser parser = this.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSSX", trial.zone);
            Assert.assertEquals((String)(message + trial.one), (long)cal.getTime().getTime(), (long)(parser.parse("2001-02-04T12:08:56.235" + trial.one).getTime() - trial.offset));
            parser = this.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSSXX", trial.zone);
            Assert.assertEquals((String)(message + trial.two), (Object)cal.getTime(), (Object)parser.parse("2001-02-04T12:08:56.235" + trial.two));
            parser = this.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", trial.zone);
            Assert.assertEquals((String)(message + trial.three), (Object)cal.getTime(), (Object)parser.parse("2001-02-04T12:08:56.235" + trial.three));
        }
    }

    @Test
    public void testLang1121() throws ParseException {
        TimeZone kst = TimeZone.getTimeZone("KST");
        DateParser fdp = this.getInstance("yyyyMMdd", kst, Locale.KOREA);
        try {
            fdp.parse("2015");
            Assert.fail((String)"expected parse exception");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Date actual = fdp.parse("20150429");
        Calendar cal = Calendar.getInstance(kst, Locale.KOREA);
        cal.clear();
        cal.set(2015, 3, 29);
        Date expected = cal.getTime();
        Assert.assertEquals((Object)expected, (Object)actual);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd", Locale.KOREA);
        df.setTimeZone(kst);
        expected = df.parse("20150429113100");
        actual = fdp.parse("20150429113100");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseOffset() {
        DateParser parser = this.getInstance(YMD_SLASH);
        Date date = parser.parse("Today is 2015/07/04", new ParsePosition(9));
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2015, 6, 4);
        Assert.assertEquals((Object)cal.getTime(), (Object)date);
    }

    @Test
    public void testDayNumberOfWeek() throws ParseException {
        DateParser parser = this.getInstance("u");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(parser.parse("1"));
        Assert.assertEquals((long)2L, (long)calendar.get(7));
        calendar.setTime(parser.parse("6"));
        Assert.assertEquals((long)7L, (long)calendar.get(7));
        calendar.setTime(parser.parse("7"));
        Assert.assertEquals((long)1L, (long)calendar.get(7));
    }

    @Test
    public void testLang1380() throws ParseException {
        Calendar expected = Calendar.getInstance(GMT, Locale.FRANCE);
        expected.clear();
        expected.set(2014, 3, 14);
        DateParser fdp = this.getInstance("dd MMM yyyy", GMT, Locale.FRANCE);
        Assert.assertEquals((Object)expected.getTime(), (Object)fdp.parse("14 avril 2014"));
        Assert.assertEquals((Object)expected.getTime(), (Object)fdp.parse("14 avr. 2014"));
        Assert.assertEquals((Object)expected.getTime(), (Object)fdp.parse("14 avr 2014"));
    }

    static /* synthetic */ TimeZone access$000() {
        return INDIA;
    }

    static /* synthetic */ TimeZone access$100() {
        return GMT;
    }

    static /* synthetic */ TimeZone access$200() {
        return NEW_YORK;
    }

    private static enum Expected1806 {
        India(FastDateParserTest.access$000(), "+05", "+0530", "+05:30", true),
        Greenwich(FastDateParserTest.access$100(), "Z", "Z", "Z", false),
        NewYork(FastDateParserTest.access$200(), "-05", "-0500", "-05:00", false);

        final TimeZone zone;
        final String one;
        final String two;
        final String three;
        final long offset;

        private Expected1806(TimeZone zone, String one, String two, String three, boolean hasHalfHourOffset) {
            this.zone = zone;
            this.one = one;
            this.two = two;
            this.three = three;
            this.offset = hasHalfHourOffset ? 1800000L : 0L;
        }
    }
}

