/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import org.apache.commons.lang3.time.GmtTimeZone;
import org.junit.Assert;
import org.junit.Test;

public class GmtTimeZoneTest {
    @Test(expected=IllegalArgumentException.class)
    public void hoursOutOfRange() {
        new GmtTimeZone(false, 24, 0);
    }

    @Test
    public void hoursInRange() {
        Assert.assertEquals((long)82800000L, (long)new GmtTimeZone(false, 23, 0).getRawOffset());
    }

    @Test(expected=IllegalArgumentException.class)
    public void minutesOutOfRange() {
        new GmtTimeZone(false, 0, 60);
    }

    @Test
    public void minutesInRange() {
        Assert.assertEquals((long)3540000L, (long)new GmtTimeZone(false, 0, 59).getRawOffset());
    }

    @Test
    public void getOffset() {
        Assert.assertEquals((long)0L, (long)new GmtTimeZone(false, 0, 0).getOffset(234304L));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void setRawOffset() {
        new GmtTimeZone(false, 0, 0).setRawOffset(0);
    }

    @Test
    public void getRawOffset() {
        Assert.assertEquals((long)0L, (long)new GmtTimeZone(false, 0, 0).getRawOffset());
    }

    @Test
    public void getID() {
        Assert.assertEquals((Object)"GMT+00:00", (Object)new GmtTimeZone(false, 0, 0).getID());
        Assert.assertEquals((Object)"GMT+01:02", (Object)new GmtTimeZone(false, 1, 2).getID());
        Assert.assertEquals((Object)"GMT+11:22", (Object)new GmtTimeZone(false, 11, 22).getID());
        Assert.assertEquals((Object)"GMT-01:02", (Object)new GmtTimeZone(true, 1, 2).getID());
        Assert.assertEquals((Object)"GMT-11:22", (Object)new GmtTimeZone(true, 11, 22).getID());
    }

    @Test
    public void useDaylightTime() {
        Assert.assertFalse((boolean)new GmtTimeZone(false, 0, 0).useDaylightTime());
    }

    @Test
    public void inDaylightTime() {
        Assert.assertFalse((boolean)new GmtTimeZone(false, 0, 0).useDaylightTime());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"[GmtTimeZone id=\"GMT-12:00\",offset=-43200000]", (Object)new GmtTimeZone(true, 12, 0).toString());
    }

    @Test
    public void testGetOffset() {
        Assert.assertEquals((long)-23400000L, (long)new GmtTimeZone(true, 6, 30).getOffset(1, 1, 1, 1, 1, 1));
    }
}

