/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.BooleanUtils;
import org.junit.Assert;
import org.junit.Test;

public class BooleanUtilsTest {
    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)new BooleanUtils());
        Constructor<?>[] cons = BooleanUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertTrue((boolean)Modifier.isPublic(BooleanUtils.class.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isFinal(BooleanUtils.class.getModifiers()));
    }

    @Test
    public void test_negate_Boolean() {
        Assert.assertSame(null, (Object)BooleanUtils.negate(null));
        Assert.assertSame((Object)Boolean.TRUE, (Object)BooleanUtils.negate((Boolean)Boolean.FALSE));
        Assert.assertSame((Object)Boolean.FALSE, (Object)BooleanUtils.negate((Boolean)Boolean.TRUE));
    }

    @Test
    public void test_isTrue_Boolean() {
        Assert.assertTrue((boolean)BooleanUtils.isTrue((Boolean)Boolean.TRUE));
        Assert.assertFalse((boolean)BooleanUtils.isTrue((Boolean)Boolean.FALSE));
        Assert.assertFalse((boolean)BooleanUtils.isTrue(null));
    }

    @Test
    public void test_isNotTrue_Boolean() {
        Assert.assertFalse((boolean)BooleanUtils.isNotTrue((Boolean)Boolean.TRUE));
        Assert.assertTrue((boolean)BooleanUtils.isNotTrue((Boolean)Boolean.FALSE));
        Assert.assertTrue((boolean)BooleanUtils.isNotTrue(null));
    }

    @Test
    public void test_isFalse_Boolean() {
        Assert.assertFalse((boolean)BooleanUtils.isFalse((Boolean)Boolean.TRUE));
        Assert.assertTrue((boolean)BooleanUtils.isFalse((Boolean)Boolean.FALSE));
        Assert.assertFalse((boolean)BooleanUtils.isFalse(null));
    }

    @Test
    public void test_isNotFalse_Boolean() {
        Assert.assertTrue((boolean)BooleanUtils.isNotFalse((Boolean)Boolean.TRUE));
        Assert.assertFalse((boolean)BooleanUtils.isNotFalse((Boolean)Boolean.FALSE));
        Assert.assertTrue((boolean)BooleanUtils.isNotFalse(null));
    }

    @Test
    public void test_toBoolean_Boolean() {
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((Boolean)Boolean.TRUE));
        Assert.assertFalse((boolean)BooleanUtils.toBoolean((Boolean)Boolean.FALSE));
        Assert.assertFalse((boolean)BooleanUtils.toBoolean((Boolean)null));
    }

    @Test
    public void test_toBooleanDefaultIfNull_Boolean_boolean() {
        Assert.assertTrue((boolean)BooleanUtils.toBooleanDefaultIfNull((Boolean)Boolean.TRUE, (boolean)true));
        Assert.assertTrue((boolean)BooleanUtils.toBooleanDefaultIfNull((Boolean)Boolean.TRUE, (boolean)false));
        Assert.assertFalse((boolean)BooleanUtils.toBooleanDefaultIfNull((Boolean)Boolean.FALSE, (boolean)true));
        Assert.assertFalse((boolean)BooleanUtils.toBooleanDefaultIfNull((Boolean)Boolean.FALSE, (boolean)false));
        Assert.assertTrue((boolean)BooleanUtils.toBooleanDefaultIfNull(null, (boolean)true));
        Assert.assertFalse((boolean)BooleanUtils.toBooleanDefaultIfNull(null, (boolean)false));
    }

    @Test
    public void test_toBoolean_int() {
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((int)1));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((int)-1));
        Assert.assertFalse((boolean)BooleanUtils.toBoolean((int)0));
    }

    @Test
    public void test_toBooleanObject_int() {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((int)1));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((int)-1));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((int)0));
    }

    @Test
    public void test_toBooleanObject_Integer() {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((Integer)1));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((Integer)-1));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((Integer)0));
        Assert.assertNull((Object)BooleanUtils.toBooleanObject((Integer)null));
    }

    @Test
    public void test_toBoolean_int_int_int() {
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((int)6, (int)6, (int)7));
        Assert.assertFalse((boolean)BooleanUtils.toBoolean((int)7, (int)6, (int)7));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_toBoolean_int_int_int_noMatch() {
        BooleanUtils.toBoolean((int)8, (int)6, (int)7);
    }

    @Test
    public void test_toBoolean_Integer_Integer_Integer() {
        Integer six = 6;
        Integer seven = 7;
        Assert.assertTrue((boolean)BooleanUtils.toBoolean(null, null, (Integer)seven));
        Assert.assertFalse((boolean)BooleanUtils.toBoolean(null, (Integer)six, null));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((Integer)6, (Integer)six, (Integer)seven));
        Assert.assertFalse((boolean)BooleanUtils.toBoolean((Integer)7, (Integer)six, (Integer)seven));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_toBoolean_Integer_Integer_Integer_nullValue() {
        BooleanUtils.toBoolean(null, (Integer)6, (Integer)7);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_toBoolean_Integer_Integer_Integer_noMatch() {
        BooleanUtils.toBoolean((Integer)8, (Integer)6, (Integer)7);
    }

    @Test
    public void test_toBooleanObject_int_int_int() {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((int)6, (int)6, (int)7, (int)8));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((int)7, (int)6, (int)7, (int)8));
        Assert.assertNull((Object)BooleanUtils.toBooleanObject((int)8, (int)6, (int)7, (int)8));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_toBooleanObject_int_int_int_noMatch() {
        BooleanUtils.toBooleanObject((int)9, (int)6, (int)7, (int)8);
    }

    @Test
    public void test_toBooleanObject_Integer_Integer_Integer_Integer() {
        Integer six = 6;
        Integer seven = 7;
        Integer eight = 8;
        Assert.assertSame((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject(null, null, (Integer)seven, (Integer)eight));
        Assert.assertSame((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject(null, (Integer)six, null, (Integer)eight));
        Assert.assertSame(null, (Object)BooleanUtils.toBooleanObject(null, (Integer)six, (Integer)seven, null));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((Integer)6, (Integer)six, (Integer)seven, (Integer)eight));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((Integer)7, (Integer)six, (Integer)seven, (Integer)eight));
        Assert.assertNull((Object)BooleanUtils.toBooleanObject((Integer)8, (Integer)six, (Integer)seven, (Integer)eight));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_toBooleanObject_Integer_Integer_Integer_Integer_nullValue() {
        BooleanUtils.toBooleanObject(null, (Integer)6, (Integer)7, (Integer)8);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_toBooleanObject_Integer_Integer_Integer_Integer_noMatch() {
        BooleanUtils.toBooleanObject((Integer)9, (Integer)6, (Integer)7, (Integer)8);
    }

    @Test
    public void test_toInteger_boolean() {
        Assert.assertEquals((long)1L, (long)BooleanUtils.toInteger((boolean)true));
        Assert.assertEquals((long)0L, (long)BooleanUtils.toInteger((boolean)false));
    }

    @Test
    public void test_toIntegerObject_boolean() {
        Assert.assertEquals((Object)1, (Object)BooleanUtils.toIntegerObject((boolean)true));
        Assert.assertEquals((Object)0, (Object)BooleanUtils.toIntegerObject((boolean)false));
    }

    @Test
    public void test_toIntegerObject_Boolean() {
        Assert.assertEquals((Object)1, (Object)BooleanUtils.toIntegerObject((Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)0, (Object)BooleanUtils.toIntegerObject((Boolean)Boolean.FALSE));
        Assert.assertNull((Object)BooleanUtils.toIntegerObject(null));
    }

    @Test
    public void test_toInteger_boolean_int_int() {
        Assert.assertEquals((long)6L, (long)BooleanUtils.toInteger((boolean)true, (int)6, (int)7));
        Assert.assertEquals((long)7L, (long)BooleanUtils.toInteger((boolean)false, (int)6, (int)7));
    }

    @Test
    public void test_toInteger_Boolean_int_int_int() {
        Assert.assertEquals((long)6L, (long)BooleanUtils.toInteger((Boolean)Boolean.TRUE, (int)6, (int)7, (int)8));
        Assert.assertEquals((long)7L, (long)BooleanUtils.toInteger((Boolean)Boolean.FALSE, (int)6, (int)7, (int)8));
        Assert.assertEquals((long)8L, (long)BooleanUtils.toInteger(null, (int)6, (int)7, (int)8));
    }

    @Test
    public void test_toIntegerObject_boolean_Integer_Integer() {
        Integer six = 6;
        Integer seven = 7;
        Assert.assertEquals((Object)six, (Object)BooleanUtils.toIntegerObject((boolean)true, (Integer)six, (Integer)seven));
        Assert.assertEquals((Object)seven, (Object)BooleanUtils.toIntegerObject((boolean)false, (Integer)six, (Integer)seven));
    }

    @Test
    public void test_toIntegerObject_Boolean_Integer_Integer_Integer() {
        Integer six = 6;
        Integer seven = 7;
        Integer eight = 8;
        Assert.assertEquals((Object)six, (Object)BooleanUtils.toIntegerObject((Boolean)Boolean.TRUE, (Integer)six, (Integer)seven, (Integer)eight));
        Assert.assertEquals((Object)seven, (Object)BooleanUtils.toIntegerObject((Boolean)Boolean.FALSE, (Integer)six, (Integer)seven, (Integer)eight));
        Assert.assertEquals((Object)eight, (Object)BooleanUtils.toIntegerObject(null, (Integer)six, (Integer)seven, (Integer)eight));
        Assert.assertNull((Object)BooleanUtils.toIntegerObject(null, (Integer)six, (Integer)seven, null));
    }

    @Test
    public void test_toBooleanObject_String() {
        Assert.assertNull((Object)BooleanUtils.toBooleanObject((String)null));
        Assert.assertNull((Object)BooleanUtils.toBooleanObject((String)""));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"false"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"no"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"off"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"FALSE"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"NO"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"OFF"));
        Assert.assertNull((Object)BooleanUtils.toBooleanObject((String)"oof"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"true"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"yes"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"on"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"TRUE"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"ON"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"YES"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"TruE"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"TruE"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"y"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"Y"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"t"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"T"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"f"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"F"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"n"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"N"));
        Assert.assertNull((Object)BooleanUtils.toBooleanObject((String)"z"));
        Assert.assertNull((Object)BooleanUtils.toBooleanObject((String)"ab"));
        Assert.assertNull((Object)BooleanUtils.toBooleanObject((String)"yoo"));
        Assert.assertNull((Object)BooleanUtils.toBooleanObject((String)"true "));
        Assert.assertNull((Object)BooleanUtils.toBooleanObject((String)"ono"));
    }

    @Test
    public void test_toBooleanObject_String_String_String_String() {
        Assert.assertSame((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject(null, null, (String)"N", (String)"U"));
        Assert.assertSame((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject(null, (String)"Y", null, (String)"U"));
        Assert.assertSame(null, (Object)BooleanUtils.toBooleanObject(null, (String)"Y", (String)"N", null));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"Y", (String)"Y", (String)"N", (String)"U"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"N", (String)"Y", (String)"N", (String)"U"));
        Assert.assertNull((Object)BooleanUtils.toBooleanObject((String)"U", (String)"Y", (String)"N", (String)"U"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_toBooleanObject_String_String_String_String_nullValue() {
        BooleanUtils.toBooleanObject(null, (String)"Y", (String)"N", (String)"U");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_toBooleanObject_String_String_String_String_noMatch() {
        BooleanUtils.toBooleanObject((String)"X", (String)"Y", (String)"N", (String)"U");
    }

    @Test
    public void test_toBoolean_String() {
        Assert.assertFalse((boolean)BooleanUtils.toBoolean((String)null));
        Assert.assertFalse((boolean)BooleanUtils.toBoolean((String)""));
        Assert.assertFalse((boolean)BooleanUtils.toBoolean((String)"off"));
        Assert.assertFalse((boolean)BooleanUtils.toBoolean((String)"oof"));
        Assert.assertFalse((boolean)BooleanUtils.toBoolean((String)"yep"));
        Assert.assertFalse((boolean)BooleanUtils.toBoolean((String)"trux"));
        Assert.assertFalse((boolean)BooleanUtils.toBoolean((String)"false"));
        Assert.assertFalse((boolean)BooleanUtils.toBoolean((String)"a"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"true"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)("tr" + "ue")));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"truE"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"trUe"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"trUE"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"tRue"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"tRuE"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"tRUe"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"tRUE"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"TRUE"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"TRUe"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"TRuE"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"TRue"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"TrUE"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"TrUe"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"TruE"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"True"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"on"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"oN"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"On"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"ON"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"yes"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"yeS"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"yEs"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"yES"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"Yes"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"YeS"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"YEs"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"YES"));
        Assert.assertFalse((boolean)BooleanUtils.toBoolean((String)"yes?"));
        Assert.assertFalse((boolean)BooleanUtils.toBoolean((String)"tru"));
        Assert.assertFalse((boolean)BooleanUtils.toBoolean((String)"no"));
        Assert.assertFalse((boolean)BooleanUtils.toBoolean((String)"off"));
        Assert.assertFalse((boolean)BooleanUtils.toBoolean((String)"yoo"));
    }

    @Test
    public void test_toBoolean_String_String_String() {
        Assert.assertTrue((boolean)BooleanUtils.toBoolean(null, null, (String)"N"));
        Assert.assertFalse((boolean)BooleanUtils.toBoolean(null, (String)"Y", null));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"Y", (String)"Y", (String)"N"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"Y", (String)new String("Y"), (String)new String("N")));
        Assert.assertFalse((boolean)BooleanUtils.toBoolean((String)"N", (String)"Y", (String)"N"));
        Assert.assertFalse((boolean)BooleanUtils.toBoolean((String)"N", (String)new String("Y"), (String)new String("N")));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)null, null, null));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"Y", (String)"Y", (String)"Y"));
        Assert.assertTrue((boolean)BooleanUtils.toBoolean((String)"Y", (String)new String("Y"), (String)new String("Y")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_toBoolean_String_String_String_nullValue() {
        BooleanUtils.toBoolean(null, (String)"Y", (String)"N");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_toBoolean_String_String_String_noMatch() {
        BooleanUtils.toBoolean((String)"X", (String)"Y", (String)"N");
    }

    @Test
    public void test_toStringTrueFalse_Boolean() {
        Assert.assertNull((Object)BooleanUtils.toStringTrueFalse(null));
        Assert.assertEquals((Object)"true", (Object)BooleanUtils.toStringTrueFalse((Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)"false", (Object)BooleanUtils.toStringTrueFalse((Boolean)Boolean.FALSE));
    }

    @Test
    public void test_toStringOnOff_Boolean() {
        Assert.assertNull((Object)BooleanUtils.toStringOnOff(null));
        Assert.assertEquals((Object)"on", (Object)BooleanUtils.toStringOnOff((Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)"off", (Object)BooleanUtils.toStringOnOff((Boolean)Boolean.FALSE));
    }

    @Test
    public void test_toStringYesNo_Boolean() {
        Assert.assertNull((Object)BooleanUtils.toStringYesNo(null));
        Assert.assertEquals((Object)"yes", (Object)BooleanUtils.toStringYesNo((Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)"no", (Object)BooleanUtils.toStringYesNo((Boolean)Boolean.FALSE));
    }

    @Test
    public void test_toString_Boolean_String_String_String() {
        Assert.assertEquals((Object)"U", (Object)BooleanUtils.toString(null, (String)"Y", (String)"N", (String)"U"));
        Assert.assertEquals((Object)"Y", (Object)BooleanUtils.toString((Boolean)Boolean.TRUE, (String)"Y", (String)"N", (String)"U"));
        Assert.assertEquals((Object)"N", (Object)BooleanUtils.toString((Boolean)Boolean.FALSE, (String)"Y", (String)"N", (String)"U"));
    }

    @Test
    public void test_toStringTrueFalse_boolean() {
        Assert.assertEquals((Object)"true", (Object)BooleanUtils.toStringTrueFalse((boolean)true));
        Assert.assertEquals((Object)"false", (Object)BooleanUtils.toStringTrueFalse((boolean)false));
    }

    @Test
    public void test_toStringOnOff_boolean() {
        Assert.assertEquals((Object)"on", (Object)BooleanUtils.toStringOnOff((boolean)true));
        Assert.assertEquals((Object)"off", (Object)BooleanUtils.toStringOnOff((boolean)false));
    }

    @Test
    public void test_toStringYesNo_boolean() {
        Assert.assertEquals((Object)"yes", (Object)BooleanUtils.toStringYesNo((boolean)true));
        Assert.assertEquals((Object)"no", (Object)BooleanUtils.toStringYesNo((boolean)false));
    }

    @Test
    public void test_toString_boolean_String_String_String() {
        Assert.assertEquals((Object)"Y", (Object)BooleanUtils.toString((boolean)true, (String)"Y", (String)"N"));
        Assert.assertEquals((Object)"N", (Object)BooleanUtils.toString((boolean)false, (String)"Y", (String)"N"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testXor_primitive_nullInput() {
        BooleanUtils.xor((boolean[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testXor_primitive_emptyInput() {
        BooleanUtils.xor((boolean[])new boolean[0]);
    }

    @Test
    public void testXor_primitive_validInput_2items() {
        Assert.assertEquals((String)"true ^ true", (Object)false, (Object)BooleanUtils.xor((boolean[])new boolean[]{true, true}));
        Assert.assertEquals((String)"false ^ false", (Object)false, (Object)BooleanUtils.xor((boolean[])new boolean[]{false, false}));
        Assert.assertEquals((String)"true ^ false", (Object)true, (Object)BooleanUtils.xor((boolean[])new boolean[]{true, false}));
        Assert.assertEquals((String)"false ^ true", (Object)true, (Object)BooleanUtils.xor((boolean[])new boolean[]{false, true}));
    }

    @Test
    public void testXor_primitive_validInput_3items() {
        Assert.assertEquals((String)"false ^ false ^ false", (Object)false, (Object)BooleanUtils.xor((boolean[])new boolean[]{false, false, false}));
        Assert.assertEquals((String)"false ^ false ^ true", (Object)true, (Object)BooleanUtils.xor((boolean[])new boolean[]{false, false, true}));
        Assert.assertEquals((String)"false ^ true ^ false", (Object)true, (Object)BooleanUtils.xor((boolean[])new boolean[]{false, true, false}));
        Assert.assertEquals((String)"false ^ true ^ true", (Object)false, (Object)BooleanUtils.xor((boolean[])new boolean[]{false, true, true}));
        Assert.assertEquals((String)"true ^ false ^ false", (Object)true, (Object)BooleanUtils.xor((boolean[])new boolean[]{true, false, false}));
        Assert.assertEquals((String)"true ^ false ^ true", (Object)false, (Object)BooleanUtils.xor((boolean[])new boolean[]{true, false, true}));
        Assert.assertEquals((String)"true ^ true ^ false", (Object)false, (Object)BooleanUtils.xor((boolean[])new boolean[]{true, true, false}));
        Assert.assertEquals((String)"true ^ true ^ true", (Object)true, (Object)BooleanUtils.xor((boolean[])new boolean[]{true, true, true}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testXor_object_nullInput() {
        BooleanUtils.xor((Boolean[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testXor_object_emptyInput() {
        BooleanUtils.xor((Boolean[])new Boolean[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testXor_object_nullElementInput() {
        BooleanUtils.xor((Boolean[])new Boolean[]{null});
    }

    @Test
    public void testXor_object_validInput_2items() {
        Assert.assertEquals((String)"false ^ false", (Object)false, (Object)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.FALSE}));
        Assert.assertEquals((String)"false ^ true", (Object)true, (Object)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.TRUE}));
        Assert.assertEquals((String)"true ^ false", (Object)true, (Object)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}));
        Assert.assertEquals((String)"true ^ true", (Object)false, (Object)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.TRUE}));
    }

    @Test
    public void testXor_object_validInput_3items() {
        Assert.assertEquals((String)"false ^ false ^ false", (Object)false, (Object)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.FALSE, Boolean.FALSE}));
        Assert.assertEquals((String)"false ^ false ^ true", (Object)true, (Object)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.FALSE, Boolean.TRUE}));
        Assert.assertEquals((String)"false ^ true ^ false", (Object)true, (Object)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.TRUE, Boolean.FALSE}));
        Assert.assertEquals((String)"true ^ false ^ false", (Object)true, (Object)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.FALSE}));
        Assert.assertEquals((String)"true ^ false ^ true", (Object)false, (Object)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.TRUE}));
        Assert.assertEquals((String)"true ^ true ^ false", (Object)false, (Object)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.TRUE, Boolean.FALSE}));
        Assert.assertEquals((String)"false ^ true ^ true", (Object)false, (Object)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.TRUE, Boolean.TRUE}));
        Assert.assertEquals((String)"true ^ true ^ true", (Object)true, (Object)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.TRUE, Boolean.TRUE}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAnd_primitive_nullInput() {
        BooleanUtils.and((boolean[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAnd_primitive_emptyInput() {
        BooleanUtils.and((boolean[])new boolean[0]);
    }

    @Test
    public void testAnd_primitive_validInput_2items() {
        Assert.assertTrue((String)"False result for (true, true)", (boolean)BooleanUtils.and((boolean[])new boolean[]{true, true}));
        Assert.assertTrue((String)"True result for (false, false)", (!BooleanUtils.and((boolean[])new boolean[]{false, false}) ? 1 : 0) != 0);
        Assert.assertTrue((String)"True result for (true, false)", (!BooleanUtils.and((boolean[])new boolean[]{true, false}) ? 1 : 0) != 0);
        Assert.assertTrue((String)"True result for (false, true)", (!BooleanUtils.and((boolean[])new boolean[]{false, true}) ? 1 : 0) != 0);
    }

    @Test
    public void testAnd_primitive_validInput_3items() {
        Assert.assertTrue((String)"True result for (false, false, true)", (!BooleanUtils.and((boolean[])new boolean[]{false, false, true}) ? 1 : 0) != 0);
        Assert.assertTrue((String)"True result for (false, true, false)", (!BooleanUtils.and((boolean[])new boolean[]{false, true, false}) ? 1 : 0) != 0);
        Assert.assertTrue((String)"True result for (true, false, false)", (!BooleanUtils.and((boolean[])new boolean[]{true, false, false}) ? 1 : 0) != 0);
        Assert.assertTrue((String)"False result for (true, true, true)", (boolean)BooleanUtils.and((boolean[])new boolean[]{true, true, true}));
        Assert.assertTrue((String)"True result for (false, false)", (!BooleanUtils.and((boolean[])new boolean[]{false, false, false}) ? 1 : 0) != 0);
        Assert.assertTrue((String)"True result for (true, true, false)", (!BooleanUtils.and((boolean[])new boolean[]{true, true, false}) ? 1 : 0) != 0);
        Assert.assertTrue((String)"True result for (true, false, true)", (!BooleanUtils.and((boolean[])new boolean[]{true, false, true}) ? 1 : 0) != 0);
        Assert.assertTrue((String)"True result for (false, true, true)", (!BooleanUtils.and((boolean[])new boolean[]{false, true, true}) ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAnd_object_nullInput() {
        BooleanUtils.and((Boolean[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAnd_object_emptyInput() {
        BooleanUtils.and((Boolean[])new Boolean[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAnd_object_nullElementInput() {
        BooleanUtils.and((Boolean[])new Boolean[]{null});
    }

    @Test
    public void testAnd_object_validInput_2items() {
        Assert.assertTrue((String)"False result for (true, true)", (boolean)BooleanUtils.and((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.TRUE}));
        Assert.assertTrue((String)"True result for (false, false)", (BooleanUtils.and((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.FALSE}) == false ? 1 : 0) != 0);
        Assert.assertTrue((String)"True result for (true, false)", (BooleanUtils.and((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}) == false ? 1 : 0) != 0);
        Assert.assertTrue((String)"True result for (false, true)", (BooleanUtils.and((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.TRUE}) == false ? 1 : 0) != 0);
    }

    @Test
    public void testAnd_object_validInput_3items() {
        Assert.assertTrue((String)"True result for (false, false, true)", (BooleanUtils.and((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.FALSE, Boolean.TRUE}) == false ? 1 : 0) != 0);
        Assert.assertTrue((String)"True result for (false, true, false)", (BooleanUtils.and((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.TRUE, Boolean.FALSE}) == false ? 1 : 0) != 0);
        Assert.assertTrue((String)"True result for (true, false, false)", (BooleanUtils.and((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.FALSE}) == false ? 1 : 0) != 0);
        Assert.assertTrue((String)"False result for (true, true, true)", (boolean)BooleanUtils.and((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.TRUE, Boolean.TRUE}));
        Assert.assertTrue((String)"True result for (false, false)", (BooleanUtils.and((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.FALSE, Boolean.FALSE}) == false ? 1 : 0) != 0);
        Assert.assertTrue((String)"True result for (true, true, false)", (BooleanUtils.and((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.TRUE, Boolean.FALSE}) == false ? 1 : 0) != 0);
        Assert.assertTrue((String)"True result for (true, false, true)", (BooleanUtils.and((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.TRUE}) == false ? 1 : 0) != 0);
        Assert.assertTrue((String)"True result for (false, true, true)", (BooleanUtils.and((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.TRUE, Boolean.TRUE}) == false ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOr_primitive_nullInput() {
        BooleanUtils.or((boolean[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOr_primitive_emptyInput() {
        BooleanUtils.or((boolean[])new boolean[0]);
    }

    @Test
    public void testOr_primitive_validInput_2items() {
        Assert.assertTrue((String)"False result for (true, true)", (boolean)BooleanUtils.or((boolean[])new boolean[]{true, true}));
        Assert.assertTrue((String)"True result for (false, false)", (!BooleanUtils.or((boolean[])new boolean[]{false, false}) ? 1 : 0) != 0);
        Assert.assertTrue((String)"False result for (true, false)", (boolean)BooleanUtils.or((boolean[])new boolean[]{true, false}));
        Assert.assertTrue((String)"False result for (false, true)", (boolean)BooleanUtils.or((boolean[])new boolean[]{false, true}));
    }

    @Test
    public void testOr_primitive_validInput_3items() {
        Assert.assertTrue((String)"False result for (false, false, true)", (boolean)BooleanUtils.or((boolean[])new boolean[]{false, false, true}));
        Assert.assertTrue((String)"False result for (false, true, false)", (boolean)BooleanUtils.or((boolean[])new boolean[]{false, true, false}));
        Assert.assertTrue((String)"False result for (true, false, false)", (boolean)BooleanUtils.or((boolean[])new boolean[]{true, false, false}));
        Assert.assertTrue((String)"False result for (true, true, true)", (boolean)BooleanUtils.or((boolean[])new boolean[]{true, true, true}));
        Assert.assertTrue((String)"True result for (false, false)", (!BooleanUtils.or((boolean[])new boolean[]{false, false, false}) ? 1 : 0) != 0);
        Assert.assertTrue((String)"False result for (true, true, false)", (boolean)BooleanUtils.or((boolean[])new boolean[]{true, true, false}));
        Assert.assertTrue((String)"False result for (true, false, true)", (boolean)BooleanUtils.or((boolean[])new boolean[]{true, false, true}));
        Assert.assertTrue((String)"False result for (false, true, true)", (boolean)BooleanUtils.or((boolean[])new boolean[]{false, true, true}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOr_object_nullInput() {
        BooleanUtils.or((Boolean[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOr_object_emptyInput() {
        BooleanUtils.or((Boolean[])new Boolean[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOr_object_nullElementInput() {
        BooleanUtils.or((Boolean[])new Boolean[]{null});
    }

    @Test
    public void testOr_object_validInput_2items() {
        Assert.assertTrue((String)"False result for (true, true)", (boolean)BooleanUtils.or((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.TRUE}));
        Assert.assertTrue((String)"True result for (false, false)", (BooleanUtils.or((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.FALSE}) == false ? 1 : 0) != 0);
        Assert.assertTrue((String)"False result for (true, false)", (boolean)BooleanUtils.or((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}));
        Assert.assertTrue((String)"False result for (false, true)", (boolean)BooleanUtils.or((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.TRUE}));
    }

    @Test
    public void testOr_object_validInput_3items() {
        Assert.assertTrue((String)"False result for (false, false, true)", (boolean)BooleanUtils.or((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.FALSE, Boolean.TRUE}));
        Assert.assertTrue((String)"False result for (false, true, false)", (boolean)BooleanUtils.or((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.TRUE, Boolean.FALSE}));
        Assert.assertTrue((String)"False result for (true, false, false)", (boolean)BooleanUtils.or((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.FALSE}));
        Assert.assertTrue((String)"False result for (true, true, true)", (boolean)BooleanUtils.or((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.TRUE, Boolean.TRUE}));
        Assert.assertTrue((String)"True result for (false, false)", (BooleanUtils.or((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.FALSE, Boolean.FALSE}) == false ? 1 : 0) != 0);
        Assert.assertTrue((String)"False result for (true, true, false)", (boolean)BooleanUtils.or((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.TRUE, Boolean.FALSE}));
        Assert.assertTrue((String)"False result for (true, false, true)", (boolean)BooleanUtils.or((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.TRUE}));
        Assert.assertTrue((String)"False result for (false, true, true)", (boolean)BooleanUtils.or((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.TRUE, Boolean.TRUE}));
    }

    @Test
    public void testCompare() {
        Assert.assertTrue((BooleanUtils.compare((boolean)true, (boolean)false) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((BooleanUtils.compare((boolean)true, (boolean)true) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BooleanUtils.compare((boolean)false, (boolean)false) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BooleanUtils.compare((boolean)false, (boolean)true) < 0 ? 1 : 0) != 0);
    }
}

