/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Enum64;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.TooMany;
import org.apache.commons.lang3.Traffic;
import org.junit.Assert;
import org.junit.Test;

public class EnumUtilsTest {
    @Test
    public void testConstructable() {
        new EnumUtils();
    }

    @Test
    public void test_getEnumMap() {
        Map test = EnumUtils.getEnumMap(Traffic.class);
        Assert.assertEquals((String)"getEnumMap not created correctly", (Object)"{RED=RED, AMBER=AMBER, GREEN=GREEN}", (Object)test.toString());
        Assert.assertEquals((long)3L, (long)test.size());
        Assert.assertTrue((boolean)test.containsKey("RED"));
        Assert.assertEquals((Object)((Object)Traffic.RED), test.get("RED"));
        Assert.assertTrue((boolean)test.containsKey("AMBER"));
        Assert.assertEquals((Object)((Object)Traffic.AMBER), test.get("AMBER"));
        Assert.assertTrue((boolean)test.containsKey("GREEN"));
        Assert.assertEquals((Object)((Object)Traffic.GREEN), test.get("GREEN"));
        Assert.assertFalse((boolean)test.containsKey("PURPLE"));
    }

    @Test
    public void test_getEnumList() {
        List test = EnumUtils.getEnumList(Traffic.class);
        Assert.assertEquals((long)3L, (long)test.size());
        Assert.assertEquals((Object)((Object)Traffic.RED), test.get(0));
        Assert.assertEquals((Object)((Object)Traffic.AMBER), test.get(1));
        Assert.assertEquals((Object)((Object)Traffic.GREEN), test.get(2));
    }

    @Test
    public void test_isValidEnum() {
        Assert.assertTrue((boolean)EnumUtils.isValidEnum(Traffic.class, (String)"RED"));
        Assert.assertTrue((boolean)EnumUtils.isValidEnum(Traffic.class, (String)"AMBER"));
        Assert.assertTrue((boolean)EnumUtils.isValidEnum(Traffic.class, (String)"GREEN"));
        Assert.assertFalse((boolean)EnumUtils.isValidEnum(Traffic.class, (String)"PURPLE"));
        Assert.assertFalse((boolean)EnumUtils.isValidEnum(Traffic.class, null));
    }

    @Test(expected=NullPointerException.class)
    public void test_isValidEnum_nullClass() {
        EnumUtils.isValidEnum(null, (String)"PURPLE");
    }

    @Test
    public void test_isValidEnumIgnoreCase() {
        Assert.assertTrue((boolean)EnumUtils.isValidEnumIgnoreCase(Traffic.class, (String)"red"));
        Assert.assertTrue((boolean)EnumUtils.isValidEnumIgnoreCase(Traffic.class, (String)"Amber"));
        Assert.assertTrue((boolean)EnumUtils.isValidEnumIgnoreCase(Traffic.class, (String)"grEEn"));
        Assert.assertFalse((boolean)EnumUtils.isValidEnumIgnoreCase(Traffic.class, (String)"purple"));
        Assert.assertFalse((boolean)EnumUtils.isValidEnumIgnoreCase(Traffic.class, null));
    }

    @Test(expected=NullPointerException.class)
    public void test_isValidEnumIgnoreCase_nullClass() {
        EnumUtils.isValidEnumIgnoreCase(null, (String)"PURPLE");
    }

    @Test
    public void test_getEnum() {
        Assert.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnum(Traffic.class, (String)"RED"));
        Assert.assertEquals((Object)((Object)Traffic.AMBER), (Object)EnumUtils.getEnum(Traffic.class, (String)"AMBER"));
        Assert.assertEquals((Object)((Object)Traffic.GREEN), (Object)EnumUtils.getEnum(Traffic.class, (String)"GREEN"));
        Assert.assertNull((Object)EnumUtils.getEnum(Traffic.class, (String)"PURPLE"));
        Assert.assertNull((Object)EnumUtils.getEnum(Traffic.class, null));
    }

    @Test
    public void test_getEnum_nonEnumClass() {
        Class<Object> rawType = Object.class;
        Assert.assertNull((Object)EnumUtils.getEnum(rawType, (String)"rawType"));
    }

    @Test(expected=NullPointerException.class)
    public void test_getEnum_nullClass() {
        EnumUtils.getEnum((Class)null, (String)"PURPLE");
    }

    @Test
    public void test_getEnumIgnoreCase() {
        Assert.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, (String)"red"));
        Assert.assertEquals((Object)((Object)Traffic.AMBER), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, (String)"Amber"));
        Assert.assertEquals((Object)((Object)Traffic.GREEN), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, (String)"grEEn"));
        Assert.assertNull((Object)EnumUtils.getEnumIgnoreCase(Traffic.class, (String)"purple"));
        Assert.assertNull((Object)EnumUtils.getEnumIgnoreCase(Traffic.class, null));
    }

    @Test
    public void test_getEnumIgnoreCase_nonEnumClass() {
        Class<Object> rawType = Object.class;
        Assert.assertNull((Object)EnumUtils.getEnumIgnoreCase(rawType, (String)"rawType"));
    }

    @Test(expected=NullPointerException.class)
    public void test_getEnumIgnoreCase_nullClass() {
        EnumUtils.getEnumIgnoreCase((Class)null, (String)"PURPLE");
    }

    @Test(expected=NullPointerException.class)
    public void test_generateBitVector_nullClass() {
        EnumUtils.generateBitVector(null, EnumSet.of(Traffic.RED));
    }

    @Test(expected=NullPointerException.class)
    public void test_generateBitVectors_nullClass() {
        EnumUtils.generateBitVectors(null, EnumSet.of(Traffic.RED));
    }

    @Test(expected=NullPointerException.class)
    public void test_generateBitVector_nullIterable() {
        EnumUtils.generateBitVector(Traffic.class, (Iterable)null);
    }

    @Test(expected=NullPointerException.class)
    public void test_generateBitVectors_nullIterable() {
        EnumUtils.generateBitVectors(null, (Iterable)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_generateBitVector_nullElement() {
        EnumUtils.generateBitVector(Traffic.class, Arrays.asList(Traffic.RED, null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_generateBitVectors_nullElement() {
        EnumUtils.generateBitVectors(Traffic.class, Arrays.asList(Traffic.RED, null));
    }

    @Test(expected=NullPointerException.class)
    public void test_generateBitVector_nullClassWithArray() {
        EnumUtils.generateBitVector(null, (Enum[])new Traffic[]{Traffic.RED});
    }

    @Test(expected=NullPointerException.class)
    public void test_generateBitVectors_nullClassWithArray() {
        EnumUtils.generateBitVectors(null, (Enum[])new Traffic[]{Traffic.RED});
    }

    @Test(expected=NullPointerException.class)
    public void test_generateBitVector_nullArray() {
        EnumUtils.generateBitVector(Traffic.class, (Enum[])null);
    }

    @Test(expected=NullPointerException.class)
    public void test_generateBitVectors_nullArray() {
        EnumUtils.generateBitVectors(Traffic.class, (Enum[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_generateBitVector_nullArrayElement() {
        EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, null});
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_generateBitVectors_nullArrayElement() {
        EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, null});
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_generateBitVector_longClass() {
        EnumUtils.generateBitVector(TooMany.class, EnumSet.of(TooMany.A1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_generateBitVector_longClassWithArray() {
        EnumUtils.generateBitVector(TooMany.class, (Enum[])new TooMany[]{TooMany.A1});
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_generateBitVector_nonEnumClass() {
        Class<Object> rawType = Object.class;
        ArrayList rawList = new ArrayList();
        EnumUtils.generateBitVector(rawType, rawList);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_generateBitVectors_nonEnumClass() {
        Class<Object> rawType = Object.class;
        ArrayList rawList = new ArrayList();
        EnumUtils.generateBitVectors(rawType, rawList);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_generateBitVector_nonEnumClassWithArray() {
        Class<Object> rawType = Object.class;
        EnumUtils.generateBitVector(rawType, (Enum[])new Enum[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_generateBitVectors_nonEnumClassWithArray() {
        Class<Object> rawType = Object.class;
        EnumUtils.generateBitVectors(rawType, (Enum[])new Enum[0]);
    }

    @Test
    public void test_generateBitVector() {
        Assert.assertEquals((long)0L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.noneOf(Traffic.class)));
        Assert.assertEquals((long)1L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.RED)));
        Assert.assertEquals((long)2L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.AMBER)));
        Assert.assertEquals((long)4L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.GREEN)));
        Assert.assertEquals((long)3L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.RED, Traffic.AMBER)));
        Assert.assertEquals((long)5L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.RED, Traffic.GREEN)));
        Assert.assertEquals((long)6L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.AMBER, Traffic.GREEN)));
        Assert.assertEquals((long)7L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.RED, Traffic.AMBER, Traffic.GREEN)));
        Assert.assertEquals((long)0x80000000L, (long)EnumUtils.generateBitVector(Enum64.class, EnumSet.of(Enum64.A31)));
        Assert.assertEquals((long)0x100000000L, (long)EnumUtils.generateBitVector(Enum64.class, EnumSet.of(Enum64.A32)));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)EnumUtils.generateBitVector(Enum64.class, EnumSet.of(Enum64.A63)));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)EnumUtils.generateBitVector(Enum64.class, EnumSet.of(Enum64.A63)));
    }

    @Test
    public void test_generateBitVectors() {
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, EnumSet.noneOf(Traffic.class)), 0L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, EnumSet.of(Traffic.RED)), 1L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, EnumSet.of(Traffic.AMBER)), 2L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, EnumSet.of(Traffic.GREEN)), 4L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, EnumSet.of(Traffic.RED, Traffic.AMBER)), 3L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, EnumSet.of(Traffic.RED, Traffic.GREEN)), 5L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, EnumSet.of(Traffic.AMBER, Traffic.GREEN)), 6L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, EnumSet.of(Traffic.RED, Traffic.AMBER, Traffic.GREEN)), 7L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Enum64.class, EnumSet.of(Enum64.A31)), 0x80000000L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Enum64.class, EnumSet.of(Enum64.A32)), 0x100000000L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Enum64.class, EnumSet.of(Enum64.A63)), Long.MIN_VALUE);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Enum64.class, EnumSet.of(Enum64.A63)), Long.MIN_VALUE);
        this.assertArrayEquals(EnumUtils.generateBitVectors(TooMany.class, EnumSet.of(TooMany.M2)), 1L, 0L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(TooMany.class, EnumSet.of(TooMany.L2, TooMany.M2)), 1L, Long.MIN_VALUE);
    }

    @Test
    public void test_generateBitVectorFromArray() {
        Assert.assertEquals((long)0L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[0]));
        Assert.assertEquals((long)1L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.RED}));
        Assert.assertEquals((long)2L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.AMBER}));
        Assert.assertEquals((long)4L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.GREEN}));
        Assert.assertEquals((long)3L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.AMBER}));
        Assert.assertEquals((long)5L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.GREEN}));
        Assert.assertEquals((long)6L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.AMBER, Traffic.GREEN}));
        Assert.assertEquals((long)7L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.AMBER, Traffic.GREEN}));
        Assert.assertEquals((long)7L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.AMBER, Traffic.GREEN, Traffic.GREEN}));
        Assert.assertEquals((long)0x80000000L, (long)EnumUtils.generateBitVector(Enum64.class, (Enum[])new Enum64[]{Enum64.A31}));
        Assert.assertEquals((long)0x100000000L, (long)EnumUtils.generateBitVector(Enum64.class, (Enum[])new Enum64[]{Enum64.A32}));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)EnumUtils.generateBitVector(Enum64.class, (Enum[])new Enum64[]{Enum64.A63}));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)EnumUtils.generateBitVector(Enum64.class, (Enum[])new Enum64[]{Enum64.A63}));
    }

    @Test
    public void test_generateBitVectorsFromArray() {
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[0]), 0L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.RED}), 1L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.AMBER}), 2L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.GREEN}), 4L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.AMBER}), 3L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.GREEN}), 5L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.AMBER, Traffic.GREEN}), 6L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.AMBER, Traffic.GREEN}), 7L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.AMBER, Traffic.GREEN, Traffic.GREEN}), 7L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Enum64.class, (Enum[])new Enum64[]{Enum64.A31}), 0x80000000L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Enum64.class, (Enum[])new Enum64[]{Enum64.A32}), 0x100000000L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Enum64.class, (Enum[])new Enum64[]{Enum64.A63}), Long.MIN_VALUE);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Enum64.class, (Enum[])new Enum64[]{Enum64.A63}), Long.MIN_VALUE);
        this.assertArrayEquals(EnumUtils.generateBitVectors(TooMany.class, (Enum[])new TooMany[]{TooMany.M2}), 1L, 0L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(TooMany.class, (Enum[])new TooMany[]{TooMany.L2, TooMany.M2}), 1L, Long.MIN_VALUE);
    }

    private void assertArrayEquals(long[] actual, long ... expected) {
        Assert.assertArrayEquals((long[])expected, (long[])actual);
    }

    @Test(expected=NullPointerException.class)
    public void test_processBitVector_nullClass() {
        Class empty = null;
        EnumUtils.processBitVector(empty, (long)0L);
    }

    @Test(expected=NullPointerException.class)
    public void test_processBitVectors_nullClass() {
        Class empty = null;
        EnumUtils.processBitVectors(empty, (long[])new long[]{0L});
    }

    @Test
    public void test_processBitVector() {
        Assert.assertEquals(EnumSet.noneOf(Traffic.class), (Object)EnumUtils.processBitVector(Traffic.class, (long)0L));
        Assert.assertEquals(EnumSet.of(Traffic.RED), (Object)EnumUtils.processBitVector(Traffic.class, (long)1L));
        Assert.assertEquals(EnumSet.of(Traffic.AMBER), (Object)EnumUtils.processBitVector(Traffic.class, (long)2L));
        Assert.assertEquals(EnumSet.of(Traffic.RED, Traffic.AMBER), (Object)EnumUtils.processBitVector(Traffic.class, (long)3L));
        Assert.assertEquals(EnumSet.of(Traffic.GREEN), (Object)EnumUtils.processBitVector(Traffic.class, (long)4L));
        Assert.assertEquals(EnumSet.of(Traffic.RED, Traffic.GREEN), (Object)EnumUtils.processBitVector(Traffic.class, (long)5L));
        Assert.assertEquals(EnumSet.of(Traffic.AMBER, Traffic.GREEN), (Object)EnumUtils.processBitVector(Traffic.class, (long)6L));
        Assert.assertEquals(EnumSet.of(Traffic.RED, Traffic.AMBER, Traffic.GREEN), (Object)EnumUtils.processBitVector(Traffic.class, (long)7L));
        Assert.assertEquals(EnumSet.of(Enum64.A31), (Object)EnumUtils.processBitVector(Enum64.class, (long)0x80000000L));
        Assert.assertEquals(EnumSet.of(Enum64.A32), (Object)EnumUtils.processBitVector(Enum64.class, (long)0x100000000L));
        Assert.assertEquals(EnumSet.of(Enum64.A63), (Object)EnumUtils.processBitVector(Enum64.class, (long)Long.MIN_VALUE));
        Assert.assertEquals(EnumSet.of(Enum64.A63), (Object)EnumUtils.processBitVector(Enum64.class, (long)Long.MIN_VALUE));
    }

    @Test
    public void test_processBitVectors() {
        Assert.assertEquals(EnumSet.noneOf(Traffic.class), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L}));
        Assert.assertEquals(EnumSet.of(Traffic.RED), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{1L}));
        Assert.assertEquals(EnumSet.of(Traffic.AMBER), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{2L}));
        Assert.assertEquals(EnumSet.of(Traffic.RED, Traffic.AMBER), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{3L}));
        Assert.assertEquals(EnumSet.of(Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{4L}));
        Assert.assertEquals(EnumSet.of(Traffic.RED, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{5L}));
        Assert.assertEquals(EnumSet.of(Traffic.AMBER, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{6L}));
        Assert.assertEquals(EnumSet.of(Traffic.RED, Traffic.AMBER, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{7L}));
        Assert.assertEquals(EnumSet.noneOf(Traffic.class), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L, 0L}));
        Assert.assertEquals(EnumSet.of(Traffic.RED), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L, 1L}));
        Assert.assertEquals(EnumSet.of(Traffic.AMBER), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L, 2L}));
        Assert.assertEquals(EnumSet.of(Traffic.RED, Traffic.AMBER), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L, 3L}));
        Assert.assertEquals(EnumSet.of(Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L, 4L}));
        Assert.assertEquals(EnumSet.of(Traffic.RED, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L, 5L}));
        Assert.assertEquals(EnumSet.of(Traffic.AMBER, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L, 6L}));
        Assert.assertEquals(EnumSet.of(Traffic.RED, Traffic.AMBER, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L, 7L}));
        Assert.assertEquals(EnumSet.noneOf(Traffic.class), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{666L, 0L}));
        Assert.assertEquals(EnumSet.of(Traffic.RED), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{666L, 1L}));
        Assert.assertEquals(EnumSet.of(Traffic.AMBER), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{666L, 2L}));
        Assert.assertEquals(EnumSet.of(Traffic.RED, Traffic.AMBER), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{666L, 3L}));
        Assert.assertEquals(EnumSet.of(Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{666L, 4L}));
        Assert.assertEquals(EnumSet.of(Traffic.RED, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{666L, 5L}));
        Assert.assertEquals(EnumSet.of(Traffic.AMBER, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{666L, 6L}));
        Assert.assertEquals(EnumSet.of(Traffic.RED, Traffic.AMBER, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{666L, 7L}));
        Assert.assertEquals(EnumSet.of(Enum64.A31), (Object)EnumUtils.processBitVectors(Enum64.class, (long[])new long[]{0x80000000L}));
        Assert.assertEquals(EnumSet.of(Enum64.A32), (Object)EnumUtils.processBitVectors(Enum64.class, (long[])new long[]{0x100000000L}));
        Assert.assertEquals(EnumSet.of(Enum64.A63), (Object)EnumUtils.processBitVectors(Enum64.class, (long[])new long[]{Long.MIN_VALUE}));
        Assert.assertEquals(EnumSet.of(Enum64.A63), (Object)EnumUtils.processBitVectors(Enum64.class, (long[])new long[]{Long.MIN_VALUE}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_processBitVector_longClass() {
        EnumUtils.processBitVector(TooMany.class, (long)0L);
    }

    public void test_processBitVectors_longClass() {
        Assert.assertEquals(EnumSet.noneOf(TooMany.class), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L}));
        Assert.assertEquals(EnumSet.of(TooMany.A), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L}));
        Assert.assertEquals(EnumSet.of(TooMany.B), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{2L}));
        Assert.assertEquals(EnumSet.of(TooMany.A, TooMany.B), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{3L}));
        Assert.assertEquals(EnumSet.of(TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{4L}));
        Assert.assertEquals(EnumSet.of(TooMany.A, TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{5L}));
        Assert.assertEquals(EnumSet.of(TooMany.B, TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{6L}));
        Assert.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{7L}));
        Assert.assertEquals(EnumSet.noneOf(TooMany.class), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 0L}));
        Assert.assertEquals(EnumSet.of(TooMany.A), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 1L}));
        Assert.assertEquals(EnumSet.of(TooMany.B), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 2L}));
        Assert.assertEquals(EnumSet.of(TooMany.A, TooMany.B), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 3L}));
        Assert.assertEquals(EnumSet.of(TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 4L}));
        Assert.assertEquals(EnumSet.of(TooMany.A, TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 5L}));
        Assert.assertEquals(EnumSet.of(TooMany.B, TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 6L}));
        Assert.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 7L}));
        Assert.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 7L}));
        Assert.assertEquals(EnumSet.of(TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 0L}));
        Assert.assertEquals(EnumSet.of(TooMany.A, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 1L}));
        Assert.assertEquals(EnumSet.of(TooMany.B, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 2L}));
        Assert.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 3L}));
        Assert.assertEquals(EnumSet.of(TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 4L}));
        Assert.assertEquals(EnumSet.of(TooMany.A, TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 5L}));
        Assert.assertEquals(EnumSet.of(TooMany.B, TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 6L}));
        Assert.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 7L}));
        Assert.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 7L}));
        Assert.assertEquals(EnumSet.of(TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 0L}));
        Assert.assertEquals(EnumSet.of(TooMany.A, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 1L}));
        Assert.assertEquals(EnumSet.of(TooMany.B, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 2L}));
        Assert.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 3L}));
        Assert.assertEquals(EnumSet.of(TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 4L}));
        Assert.assertEquals(EnumSet.of(TooMany.A, TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 5L}));
        Assert.assertEquals(EnumSet.of(TooMany.B, TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 6L}));
        Assert.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 7L}));
        Assert.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 7L}));
    }
}

