/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.regex.Pattern;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConstantInitializer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConstantInitializerTest {
    private static final Integer VALUE = 42;
    private ConstantInitializer<Integer> init;

    @Before
    public void setUp() throws Exception {
        this.init = new ConstantInitializer((Object)VALUE);
    }

    private void checkEquals(Object obj, boolean expected) {
        Assert.assertTrue((String)"Wrong result of equals", (expected == this.init.equals(obj) ? 1 : 0) != 0);
        if (obj != null) {
            Assert.assertTrue((String)"Not symmetric", (expected == obj.equals(this.init) ? 1 : 0) != 0);
            if (expected) {
                Assert.assertEquals((String)"Different hash codes", (long)this.init.hashCode(), (long)obj.hashCode());
            }
        }
    }

    @Test
    public void testGetObject() {
        Assert.assertEquals((String)"Wrong object", (Object)VALUE, (Object)this.init.getObject());
    }

    @Test
    public void testGet() throws ConcurrentException {
        Assert.assertEquals((String)"Wrong object", (Object)VALUE, (Object)this.init.get());
    }

    @Test
    public void testEqualsTrue() {
        this.checkEquals(this.init, true);
        ConstantInitializer init2 = new ConstantInitializer((Object)VALUE);
        this.checkEquals(init2, true);
        this.init = new ConstantInitializer(null);
        init2 = new ConstantInitializer(null);
        this.checkEquals(init2, true);
    }

    @Test
    public void testEqualsFalse() {
        ConstantInitializer init2 = new ConstantInitializer(null);
        this.checkEquals(init2, false);
        init2 = new ConstantInitializer((Object)(VALUE + 1));
        this.checkEquals(init2, false);
    }

    @Test
    public void testEqualsWithOtherObjects() {
        this.checkEquals(null, false);
        this.checkEquals(this, false);
        this.checkEquals(new ConstantInitializer((Object)"Test"), false);
    }

    @Test
    public void testToString() {
        String s = this.init.toString();
        Pattern pattern = Pattern.compile("ConstantInitializer@-?\\d+ \\[ object = " + VALUE + " \\]");
        Assert.assertTrue((String)("Wrong string: " + s), (boolean)pattern.matcher(s).matches());
    }

    @Test
    public void testToStringNull() {
        String s = new ConstantInitializer(null).toString();
        Assert.assertTrue((String)("Object not found: " + s), (s.indexOf("object = null") > 0 ? 1 : 0) != 0);
    }
}

