/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import org.apache.commons.lang3.exception.AbstractExceptionTest;
import org.apache.commons.lang3.exception.CloneFailedException;
import org.junit.Assert;
import org.junit.Test;

public class CloneFailedExceptionTest
extends AbstractExceptionTest {
    @Test(expected=CloneFailedException.class)
    public void testThrowingInformativeException() throws Exception {
        throw new CloneFailedException("Exception message", (Throwable)this.generateCause());
    }

    @Test(expected=CloneFailedException.class)
    public void testThrowingExceptionWithMessage() throws Exception {
        throw new CloneFailedException("Exception message");
    }

    @Test(expected=CloneFailedException.class)
    public void testThrowingExceptionWithCause() throws Exception {
        throw new CloneFailedException((Throwable)this.generateCause());
    }

    @Test
    public void testWithCauseAndMessage() throws Exception {
        CloneFailedException exception = new CloneFailedException("Exception message", (Throwable)this.generateCause());
        Assert.assertNotNull((Object)((Object)exception));
        Assert.assertEquals((String)"Wrong exception message", (Object)"Exception message", (Object)exception.getMessage());
        Throwable cause = exception.getCause();
        Assert.assertNotNull((Object)cause);
        Assert.assertEquals((String)"Wrong cause message", (Object)"Cause message", (Object)cause.getMessage());
    }

    @Test
    public void testWithoutCause() throws Exception {
        CloneFailedException exception = new CloneFailedException("Exception message");
        Assert.assertNotNull((Object)((Object)exception));
        Assert.assertEquals((String)"Wrong exception message", (Object)"Exception message", (Object)exception.getMessage());
        Throwable cause = exception.getCause();
        Assert.assertNull((Object)cause);
    }

    @Test
    public void testWithoutMessage() throws Exception {
        CloneFailedException exception = new CloneFailedException((Throwable)this.generateCause());
        Assert.assertNotNull((Object)((Object)exception));
        Assert.assertNotNull((Object)exception.getMessage());
        Throwable cause = exception.getCause();
        Assert.assertNotNull((Object)cause);
        Assert.assertEquals((String)"Wrong cause message", (Object)"Cause message", (Object)cause.getMessage());
    }
}

