/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.tuple;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.junit.Assert;
import org.junit.Test;

public class ImmutablePairTest {
    @Test
    public void testBasic() throws Exception {
        ImmutablePair pair = new ImmutablePair((Object)0, (Object)"foo");
        Assert.assertEquals((long)0L, (long)((Integer)pair.left).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)pair.getLeft()).intValue());
        Assert.assertEquals((Object)"foo", (Object)pair.right);
        Assert.assertEquals((Object)"foo", (Object)pair.getRight());
        ImmutablePair pair2 = new ImmutablePair(null, (Object)"bar");
        Assert.assertNull((Object)pair2.left);
        Assert.assertNull((Object)pair2.getLeft());
        Assert.assertEquals((Object)"bar", (Object)pair2.right);
        Assert.assertEquals((Object)"bar", (Object)pair2.getRight());
    }

    @Test
    public void testPairOf() throws Exception {
        ImmutablePair pair = ImmutablePair.of((Object)0, (Object)"foo");
        Assert.assertEquals((long)0L, (long)((Integer)pair.left).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)pair.getLeft()).intValue());
        Assert.assertEquals((Object)"foo", (Object)pair.right);
        Assert.assertEquals((Object)"foo", (Object)pair.getRight());
        ImmutablePair pair2 = ImmutablePair.of(null, (Object)"bar");
        Assert.assertNull((Object)pair2.left);
        Assert.assertNull((Object)pair2.getLeft());
        Assert.assertEquals((Object)"bar", (Object)pair2.right);
        Assert.assertEquals((Object)"bar", (Object)pair2.getRight());
    }

    @Test
    public void testEquals() throws Exception {
        Assert.assertEquals((Object)ImmutablePair.of(null, (Object)"foo"), (Object)ImmutablePair.of(null, (Object)"foo"));
        Assert.assertFalse((boolean)ImmutablePair.of((Object)"foo", (Object)0).equals((Object)ImmutablePair.of((Object)"foo", null)));
        Assert.assertFalse((boolean)ImmutablePair.of((Object)"foo", (Object)"bar").equals((Object)ImmutablePair.of((Object)"xyz", (Object)"bar")));
        ImmutablePair p = ImmutablePair.of((Object)"foo", (Object)"bar");
        Assert.assertTrue((boolean)p.equals((Object)p));
        Assert.assertFalse((boolean)p.equals(new Object()));
    }

    @Test
    public void testHashCode() throws Exception {
        Assert.assertEquals((long)ImmutablePair.of(null, (Object)"foo").hashCode(), (long)ImmutablePair.of(null, (Object)"foo").hashCode());
    }

    @Test
    public void testNullPairEquals() {
        Assert.assertEquals((Object)ImmutablePair.nullPair(), (Object)ImmutablePair.nullPair());
    }

    @Test
    public void testNullPairSame() {
        Assert.assertSame((Object)ImmutablePair.nullPair(), (Object)ImmutablePair.nullPair());
    }

    @Test
    public void testNullPairLeft() {
        Assert.assertNull((Object)ImmutablePair.nullPair().getLeft());
    }

    @Test
    public void testNullPairKey() {
        Assert.assertNull((Object)ImmutablePair.nullPair().getKey());
    }

    @Test
    public void testNullPairRight() {
        Assert.assertNull((Object)ImmutablePair.nullPair().getRight());
    }

    @Test
    public void testNullPairValue() {
        Assert.assertNull((Object)ImmutablePair.nullPair().getValue());
    }

    @Test
    public void testNullPairTyped() {
        ImmutablePair pair = ImmutablePair.nullPair();
        Assert.assertNotNull((Object)pair);
    }

    @Test
    public void testToString() throws Exception {
        Assert.assertEquals((Object)"(null,null)", (Object)ImmutablePair.of(null, null).toString());
        Assert.assertEquals((Object)"(null,two)", (Object)ImmutablePair.of(null, (Object)"two").toString());
        Assert.assertEquals((Object)"(one,null)", (Object)ImmutablePair.of((Object)"one", null).toString());
        Assert.assertEquals((Object)"(one,two)", (Object)ImmutablePair.of((Object)"one", (Object)"two").toString());
    }

    @Test
    public void testSerialization() throws Exception {
        ImmutablePair origPair = ImmutablePair.of((Object)0, (Object)"foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(origPair);
        ImmutablePair deserializedPair = (ImmutablePair)new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
        Assert.assertEquals((Object)origPair, (Object)deserializedPair);
        Assert.assertEquals((long)origPair.hashCode(), (long)deserializedPair.hashCode());
    }
}

