/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.CharSetUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CharSetUtilsTest {
    @Test
    public void testConstructor() {
        Assertions.assertNotNull((Object)new CharSetUtils());
        Constructor<?>[] cons = CharSetUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(CharSetUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(CharSetUtils.class.getModifiers()));
    }

    @Test
    public void testSqueeze_StringString() {
        Assertions.assertNull((Object)CharSetUtils.squeeze(null, (String[])new String[]{null}));
        Assertions.assertNull((Object)CharSetUtils.squeeze(null, (String[])new String[]{""}));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.squeeze((String)"", (String[])new String[]{null}));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.squeeze((String)"", (String[])new String[]{""}));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.squeeze((String)"", (String[])new String[]{"a-e"}));
        Assertions.assertEquals((Object)"hello", (Object)CharSetUtils.squeeze((String)"hello", (String[])new String[]{null}));
        Assertions.assertEquals((Object)"hello", (Object)CharSetUtils.squeeze((String)"hello", (String[])new String[]{""}));
        Assertions.assertEquals((Object)"hello", (Object)CharSetUtils.squeeze((String)"hello", (String[])new String[]{"a-e"}));
        Assertions.assertEquals((Object)"helo", (Object)CharSetUtils.squeeze((String)"hello", (String[])new String[]{"l-p"}));
        Assertions.assertEquals((Object)"heloo", (Object)CharSetUtils.squeeze((String)"helloo", (String[])new String[]{"l"}));
        Assertions.assertEquals((Object)"hello", (Object)CharSetUtils.squeeze((String)"helloo", (String[])new String[]{"^l"}));
    }

    @Test
    public void testSqueeze_StringStringarray() {
        Assertions.assertNull((Object)CharSetUtils.squeeze(null, (String[])null));
        Assertions.assertNull((Object)CharSetUtils.squeeze(null, (String[])new String[0]));
        Assertions.assertNull((Object)CharSetUtils.squeeze(null, (String[])new String[]{null}));
        Assertions.assertNull((Object)CharSetUtils.squeeze(null, (String[])new String[]{"el"}));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.squeeze((String)"", (String[])null));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.squeeze((String)"", (String[])new String[0]));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.squeeze((String)"", (String[])new String[]{null}));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.squeeze((String)"", (String[])new String[]{"a-e"}));
        Assertions.assertEquals((Object)"hello", (Object)CharSetUtils.squeeze((String)"hello", (String[])null));
        Assertions.assertEquals((Object)"hello", (Object)CharSetUtils.squeeze((String)"hello", (String[])new String[0]));
        Assertions.assertEquals((Object)"hello", (Object)CharSetUtils.squeeze((String)"hello", (String[])new String[]{null}));
        Assertions.assertEquals((Object)"hello", (Object)CharSetUtils.squeeze((String)"hello", (String[])new String[]{"a-e"}));
        Assertions.assertEquals((Object)"helo", (Object)CharSetUtils.squeeze((String)"hello", (String[])new String[]{"el"}));
        Assertions.assertEquals((Object)"hello", (Object)CharSetUtils.squeeze((String)"hello", (String[])new String[]{"e"}));
        Assertions.assertEquals((Object)"fofof", (Object)CharSetUtils.squeeze((String)"fooffooff", (String[])new String[]{"of"}));
        Assertions.assertEquals((Object)"fof", (Object)CharSetUtils.squeeze((String)"fooooff", (String[])new String[]{"fo"}));
    }

    @Test
    public void testContainsAny_StringString() {
        Assertions.assertFalse((boolean)CharSetUtils.containsAny(null, (String[])new String[]{null}));
        Assertions.assertFalse((boolean)CharSetUtils.containsAny(null, (String[])new String[]{""}));
        Assertions.assertFalse((boolean)CharSetUtils.containsAny((String)"", (String[])new String[]{null}));
        Assertions.assertFalse((boolean)CharSetUtils.containsAny((String)"", (String[])new String[]{""}));
        Assertions.assertFalse((boolean)CharSetUtils.containsAny((String)"", (String[])new String[]{"a-e"}));
        Assertions.assertFalse((boolean)CharSetUtils.containsAny((String)"hello", (String[])new String[]{null}));
        Assertions.assertFalse((boolean)CharSetUtils.containsAny((String)"hello", (String[])new String[]{""}));
        Assertions.assertTrue((boolean)CharSetUtils.containsAny((String)"hello", (String[])new String[]{"a-e"}));
        Assertions.assertTrue((boolean)CharSetUtils.containsAny((String)"hello", (String[])new String[]{"l-p"}));
    }

    @Test
    public void testContainsAny_StringStringarray() {
        Assertions.assertFalse((boolean)CharSetUtils.containsAny(null, (String[])null));
        Assertions.assertFalse((boolean)CharSetUtils.containsAny(null, (String[])new String[0]));
        Assertions.assertFalse((boolean)CharSetUtils.containsAny(null, (String[])new String[]{null}));
        Assertions.assertFalse((boolean)CharSetUtils.containsAny(null, (String[])new String[]{"a-e"}));
        Assertions.assertFalse((boolean)CharSetUtils.containsAny((String)"", (String[])null));
        Assertions.assertFalse((boolean)CharSetUtils.containsAny((String)"", (String[])new String[0]));
        Assertions.assertFalse((boolean)CharSetUtils.containsAny((String)"", (String[])new String[]{null}));
        Assertions.assertFalse((boolean)CharSetUtils.containsAny((String)"", (String[])new String[]{"a-e"}));
        Assertions.assertFalse((boolean)CharSetUtils.containsAny((String)"hello", (String[])null));
        Assertions.assertFalse((boolean)CharSetUtils.containsAny((String)"hello", (String[])new String[0]));
        Assertions.assertFalse((boolean)CharSetUtils.containsAny((String)"hello", (String[])new String[]{null}));
        Assertions.assertTrue((boolean)CharSetUtils.containsAny((String)"hello", (String[])new String[]{"a-e"}));
        Assertions.assertTrue((boolean)CharSetUtils.containsAny((String)"hello", (String[])new String[]{"el"}));
        Assertions.assertFalse((boolean)CharSetUtils.containsAny((String)"hello", (String[])new String[]{"x"}));
        Assertions.assertTrue((boolean)CharSetUtils.containsAny((String)"hello", (String[])new String[]{"e-i"}));
        Assertions.assertTrue((boolean)CharSetUtils.containsAny((String)"hello", (String[])new String[]{"a-z"}));
        Assertions.assertFalse((boolean)CharSetUtils.containsAny((String)"hello", (String[])new String[]{""}));
    }

    @Test
    public void testCount_StringString() {
        Assertions.assertEquals((int)0, (int)CharSetUtils.count(null, (String[])new String[]{null}));
        Assertions.assertEquals((int)0, (int)CharSetUtils.count(null, (String[])new String[]{""}));
        Assertions.assertEquals((int)0, (int)CharSetUtils.count((String)"", (String[])new String[]{null}));
        Assertions.assertEquals((int)0, (int)CharSetUtils.count((String)"", (String[])new String[]{""}));
        Assertions.assertEquals((int)0, (int)CharSetUtils.count((String)"", (String[])new String[]{"a-e"}));
        Assertions.assertEquals((int)0, (int)CharSetUtils.count((String)"hello", (String[])new String[]{null}));
        Assertions.assertEquals((int)0, (int)CharSetUtils.count((String)"hello", (String[])new String[]{""}));
        Assertions.assertEquals((int)1, (int)CharSetUtils.count((String)"hello", (String[])new String[]{"a-e"}));
        Assertions.assertEquals((int)3, (int)CharSetUtils.count((String)"hello", (String[])new String[]{"l-p"}));
    }

    @Test
    public void testCount_StringStringarray() {
        Assertions.assertEquals((int)0, (int)CharSetUtils.count(null, (String[])null));
        Assertions.assertEquals((int)0, (int)CharSetUtils.count(null, (String[])new String[0]));
        Assertions.assertEquals((int)0, (int)CharSetUtils.count(null, (String[])new String[]{null}));
        Assertions.assertEquals((int)0, (int)CharSetUtils.count(null, (String[])new String[]{"a-e"}));
        Assertions.assertEquals((int)0, (int)CharSetUtils.count((String)"", (String[])null));
        Assertions.assertEquals((int)0, (int)CharSetUtils.count((String)"", (String[])new String[0]));
        Assertions.assertEquals((int)0, (int)CharSetUtils.count((String)"", (String[])new String[]{null}));
        Assertions.assertEquals((int)0, (int)CharSetUtils.count((String)"", (String[])new String[]{"a-e"}));
        Assertions.assertEquals((int)0, (int)CharSetUtils.count((String)"hello", (String[])null));
        Assertions.assertEquals((int)0, (int)CharSetUtils.count((String)"hello", (String[])new String[0]));
        Assertions.assertEquals((int)0, (int)CharSetUtils.count((String)"hello", (String[])new String[]{null}));
        Assertions.assertEquals((int)1, (int)CharSetUtils.count((String)"hello", (String[])new String[]{"a-e"}));
        Assertions.assertEquals((int)3, (int)CharSetUtils.count((String)"hello", (String[])new String[]{"el"}));
        Assertions.assertEquals((int)0, (int)CharSetUtils.count((String)"hello", (String[])new String[]{"x"}));
        Assertions.assertEquals((int)2, (int)CharSetUtils.count((String)"hello", (String[])new String[]{"e-i"}));
        Assertions.assertEquals((int)5, (int)CharSetUtils.count((String)"hello", (String[])new String[]{"a-z"}));
        Assertions.assertEquals((int)0, (int)CharSetUtils.count((String)"hello", (String[])new String[]{""}));
    }

    @Test
    public void testKeep_StringString() {
        Assertions.assertNull((Object)CharSetUtils.keep(null, (String[])new String[]{null}));
        Assertions.assertNull((Object)CharSetUtils.keep(null, (String[])new String[]{""}));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.keep((String)"", (String[])new String[]{null}));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.keep((String)"", (String[])new String[]{""}));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.keep((String)"", (String[])new String[]{"a-e"}));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.keep((String)"hello", (String[])new String[]{null}));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.keep((String)"hello", (String[])new String[]{""}));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.keep((String)"hello", (String[])new String[]{"xyz"}));
        Assertions.assertEquals((Object)"hello", (Object)CharSetUtils.keep((String)"hello", (String[])new String[]{"a-z"}));
        Assertions.assertEquals((Object)"hello", (Object)CharSetUtils.keep((String)"hello", (String[])new String[]{"oleh"}));
        Assertions.assertEquals((Object)"ell", (Object)CharSetUtils.keep((String)"hello", (String[])new String[]{"el"}));
    }

    @Test
    public void testKeep_StringStringarray() {
        Assertions.assertNull((Object)CharSetUtils.keep(null, (String[])null));
        Assertions.assertNull((Object)CharSetUtils.keep(null, (String[])new String[0]));
        Assertions.assertNull((Object)CharSetUtils.keep(null, (String[])new String[]{null}));
        Assertions.assertNull((Object)CharSetUtils.keep(null, (String[])new String[]{"a-e"}));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.keep((String)"", (String[])null));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.keep((String)"", (String[])new String[0]));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.keep((String)"", (String[])new String[]{null}));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.keep((String)"", (String[])new String[]{"a-e"}));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.keep((String)"hello", (String[])null));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.keep((String)"hello", (String[])new String[0]));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.keep((String)"hello", (String[])new String[]{null}));
        Assertions.assertEquals((Object)"e", (Object)CharSetUtils.keep((String)"hello", (String[])new String[]{"a-e"}));
        Assertions.assertEquals((Object)"e", (Object)CharSetUtils.keep((String)"hello", (String[])new String[]{"a-e"}));
        Assertions.assertEquals((Object)"ell", (Object)CharSetUtils.keep((String)"hello", (String[])new String[]{"el"}));
        Assertions.assertEquals((Object)"hello", (Object)CharSetUtils.keep((String)"hello", (String[])new String[]{"elho"}));
        Assertions.assertEquals((Object)"hello", (Object)CharSetUtils.keep((String)"hello", (String[])new String[]{"a-z"}));
        Assertions.assertEquals((Object)"----", (Object)CharSetUtils.keep((String)"----", (String[])new String[]{"-"}));
        Assertions.assertEquals((Object)"ll", (Object)CharSetUtils.keep((String)"hello", (String[])new String[]{"l"}));
    }

    @Test
    public void testDelete_StringString() {
        Assertions.assertNull((Object)CharSetUtils.delete(null, (String[])new String[]{null}));
        Assertions.assertNull((Object)CharSetUtils.delete(null, (String[])new String[]{""}));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.delete((String)"", (String[])new String[]{null}));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.delete((String)"", (String[])new String[]{""}));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.delete((String)"", (String[])new String[]{"a-e"}));
        Assertions.assertEquals((Object)"hello", (Object)CharSetUtils.delete((String)"hello", (String[])new String[]{null}));
        Assertions.assertEquals((Object)"hello", (Object)CharSetUtils.delete((String)"hello", (String[])new String[]{""}));
        Assertions.assertEquals((Object)"hllo", (Object)CharSetUtils.delete((String)"hello", (String[])new String[]{"a-e"}));
        Assertions.assertEquals((Object)"he", (Object)CharSetUtils.delete((String)"hello", (String[])new String[]{"l-p"}));
        Assertions.assertEquals((Object)"hello", (Object)CharSetUtils.delete((String)"hello", (String[])new String[]{"z"}));
    }

    @Test
    public void testDelete_StringStringarray() {
        Assertions.assertNull((Object)CharSetUtils.delete(null, (String[])null));
        Assertions.assertNull((Object)CharSetUtils.delete(null, (String[])new String[0]));
        Assertions.assertNull((Object)CharSetUtils.delete(null, (String[])new String[]{null}));
        Assertions.assertNull((Object)CharSetUtils.delete(null, (String[])new String[]{"el"}));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.delete((String)"", (String[])null));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.delete((String)"", (String[])new String[0]));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.delete((String)"", (String[])new String[]{null}));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.delete((String)"", (String[])new String[]{"a-e"}));
        Assertions.assertEquals((Object)"hello", (Object)CharSetUtils.delete((String)"hello", (String[])null));
        Assertions.assertEquals((Object)"hello", (Object)CharSetUtils.delete((String)"hello", (String[])new String[0]));
        Assertions.assertEquals((Object)"hello", (Object)CharSetUtils.delete((String)"hello", (String[])new String[]{null}));
        Assertions.assertEquals((Object)"hello", (Object)CharSetUtils.delete((String)"hello", (String[])new String[]{"xyz"}));
        Assertions.assertEquals((Object)"ho", (Object)CharSetUtils.delete((String)"hello", (String[])new String[]{"el"}));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.delete((String)"hello", (String[])new String[]{"elho"}));
        Assertions.assertEquals((Object)"hello", (Object)CharSetUtils.delete((String)"hello", (String[])new String[]{""}));
        Assertions.assertEquals((Object)"hello", (Object)CharSetUtils.delete((String)"hello", (String[])new String[]{""}));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.delete((String)"hello", (String[])new String[]{"a-z"}));
        Assertions.assertEquals((Object)"", (Object)CharSetUtils.delete((String)"----", (String[])new String[]{"-"}));
        Assertions.assertEquals((Object)"heo", (Object)CharSetUtils.delete((String)"hello", (String[])new String[]{"l"}));
    }
}

