/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.UUID;
import org.apache.commons.lang3.Conversion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConversionTest {
    @Test
    public void testHexDigitToInt() {
        Assertions.assertEquals((int)0, (int)Conversion.hexDigitToInt((char)'0'));
        Assertions.assertEquals((int)1, (int)Conversion.hexDigitToInt((char)'1'));
        Assertions.assertEquals((int)2, (int)Conversion.hexDigitToInt((char)'2'));
        Assertions.assertEquals((int)3, (int)Conversion.hexDigitToInt((char)'3'));
        Assertions.assertEquals((int)4, (int)Conversion.hexDigitToInt((char)'4'));
        Assertions.assertEquals((int)5, (int)Conversion.hexDigitToInt((char)'5'));
        Assertions.assertEquals((int)6, (int)Conversion.hexDigitToInt((char)'6'));
        Assertions.assertEquals((int)7, (int)Conversion.hexDigitToInt((char)'7'));
        Assertions.assertEquals((int)8, (int)Conversion.hexDigitToInt((char)'8'));
        Assertions.assertEquals((int)9, (int)Conversion.hexDigitToInt((char)'9'));
        Assertions.assertEquals((int)10, (int)Conversion.hexDigitToInt((char)'A'));
        Assertions.assertEquals((int)10, (int)Conversion.hexDigitToInt((char)'a'));
        Assertions.assertEquals((int)11, (int)Conversion.hexDigitToInt((char)'B'));
        Assertions.assertEquals((int)11, (int)Conversion.hexDigitToInt((char)'b'));
        Assertions.assertEquals((int)12, (int)Conversion.hexDigitToInt((char)'C'));
        Assertions.assertEquals((int)12, (int)Conversion.hexDigitToInt((char)'c'));
        Assertions.assertEquals((int)13, (int)Conversion.hexDigitToInt((char)'D'));
        Assertions.assertEquals((int)13, (int)Conversion.hexDigitToInt((char)'d'));
        Assertions.assertEquals((int)14, (int)Conversion.hexDigitToInt((char)'E'));
        Assertions.assertEquals((int)14, (int)Conversion.hexDigitToInt((char)'e'));
        Assertions.assertEquals((int)15, (int)Conversion.hexDigitToInt((char)'F'));
        Assertions.assertEquals((int)15, (int)Conversion.hexDigitToInt((char)'f'));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Conversion.hexDigitToInt((char)'G'));
    }

    @Test
    public void testHexDigitMsb0ToInt() {
        Assertions.assertEquals((int)0, (int)Conversion.hexDigitMsb0ToInt((char)'0'));
        Assertions.assertEquals((int)8, (int)Conversion.hexDigitMsb0ToInt((char)'1'));
        Assertions.assertEquals((int)4, (int)Conversion.hexDigitMsb0ToInt((char)'2'));
        Assertions.assertEquals((int)12, (int)Conversion.hexDigitMsb0ToInt((char)'3'));
        Assertions.assertEquals((int)2, (int)Conversion.hexDigitMsb0ToInt((char)'4'));
        Assertions.assertEquals((int)10, (int)Conversion.hexDigitMsb0ToInt((char)'5'));
        Assertions.assertEquals((int)6, (int)Conversion.hexDigitMsb0ToInt((char)'6'));
        Assertions.assertEquals((int)14, (int)Conversion.hexDigitMsb0ToInt((char)'7'));
        Assertions.assertEquals((int)1, (int)Conversion.hexDigitMsb0ToInt((char)'8'));
        Assertions.assertEquals((int)9, (int)Conversion.hexDigitMsb0ToInt((char)'9'));
        Assertions.assertEquals((int)5, (int)Conversion.hexDigitMsb0ToInt((char)'A'));
        Assertions.assertEquals((int)5, (int)Conversion.hexDigitMsb0ToInt((char)'a'));
        Assertions.assertEquals((int)13, (int)Conversion.hexDigitMsb0ToInt((char)'B'));
        Assertions.assertEquals((int)13, (int)Conversion.hexDigitMsb0ToInt((char)'b'));
        Assertions.assertEquals((int)3, (int)Conversion.hexDigitMsb0ToInt((char)'C'));
        Assertions.assertEquals((int)3, (int)Conversion.hexDigitMsb0ToInt((char)'c'));
        Assertions.assertEquals((int)11, (int)Conversion.hexDigitMsb0ToInt((char)'D'));
        Assertions.assertEquals((int)11, (int)Conversion.hexDigitMsb0ToInt((char)'d'));
        Assertions.assertEquals((int)7, (int)Conversion.hexDigitMsb0ToInt((char)'E'));
        Assertions.assertEquals((int)7, (int)Conversion.hexDigitMsb0ToInt((char)'e'));
        Assertions.assertEquals((int)15, (int)Conversion.hexDigitMsb0ToInt((char)'F'));
        Assertions.assertEquals((int)15, (int)Conversion.hexDigitMsb0ToInt((char)'f'));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Conversion.hexDigitMsb0ToInt((char)'G'));
    }

    @Test
    public void testHexDigitToBinary() {
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, false, false}, (boolean[])Conversion.hexDigitToBinary((char)'0'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, false, false}, (boolean[])Conversion.hexDigitToBinary((char)'1'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, true, false, false}, (boolean[])Conversion.hexDigitToBinary((char)'2'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, false, false}, (boolean[])Conversion.hexDigitToBinary((char)'3'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, true, false}, (boolean[])Conversion.hexDigitToBinary((char)'4'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, true, false}, (boolean[])Conversion.hexDigitToBinary((char)'5'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, true, true, false}, (boolean[])Conversion.hexDigitToBinary((char)'6'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, true, false}, (boolean[])Conversion.hexDigitToBinary((char)'7'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, false, true}, (boolean[])Conversion.hexDigitToBinary((char)'8'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, false, true}, (boolean[])Conversion.hexDigitToBinary((char)'9'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, true, false, true}, (boolean[])Conversion.hexDigitToBinary((char)'A'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, true, false, true}, (boolean[])Conversion.hexDigitToBinary((char)'a'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, false, true}, (boolean[])Conversion.hexDigitToBinary((char)'B'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, false, true}, (boolean[])Conversion.hexDigitToBinary((char)'b'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, true, true}, (boolean[])Conversion.hexDigitToBinary((char)'C'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, true, true}, (boolean[])Conversion.hexDigitToBinary((char)'c'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, true, true}, (boolean[])Conversion.hexDigitToBinary((char)'D'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, true, true}, (boolean[])Conversion.hexDigitToBinary((char)'d'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, true, true, true}, (boolean[])Conversion.hexDigitToBinary((char)'E'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, true, true, true}, (boolean[])Conversion.hexDigitToBinary((char)'e'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, true, true}, (boolean[])Conversion.hexDigitToBinary((char)'F'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, true, true}, (boolean[])Conversion.hexDigitToBinary((char)'f'));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Conversion.hexDigitToBinary((char)'G'));
    }

    @Test
    public void testHexDigitMsb0ToBinary() {
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, false, false}, (boolean[])Conversion.hexDigitMsb0ToBinary((char)'0'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, false, true}, (boolean[])Conversion.hexDigitMsb0ToBinary((char)'1'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, true, false}, (boolean[])Conversion.hexDigitMsb0ToBinary((char)'2'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, true, true}, (boolean[])Conversion.hexDigitMsb0ToBinary((char)'3'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, true, false, false}, (boolean[])Conversion.hexDigitMsb0ToBinary((char)'4'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, true, false, true}, (boolean[])Conversion.hexDigitMsb0ToBinary((char)'5'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, true, true, false}, (boolean[])Conversion.hexDigitMsb0ToBinary((char)'6'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, true, true, true}, (boolean[])Conversion.hexDigitMsb0ToBinary((char)'7'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, false, false}, (boolean[])Conversion.hexDigitMsb0ToBinary((char)'8'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, false, true}, (boolean[])Conversion.hexDigitMsb0ToBinary((char)'9'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, true, false}, (boolean[])Conversion.hexDigitMsb0ToBinary((char)'A'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, true, false}, (boolean[])Conversion.hexDigitMsb0ToBinary((char)'a'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, true, true}, (boolean[])Conversion.hexDigitMsb0ToBinary((char)'B'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, true, true}, (boolean[])Conversion.hexDigitMsb0ToBinary((char)'b'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, false, false}, (boolean[])Conversion.hexDigitMsb0ToBinary((char)'C'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, false, false}, (boolean[])Conversion.hexDigitMsb0ToBinary((char)'c'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, false, true}, (boolean[])Conversion.hexDigitMsb0ToBinary((char)'D'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, false, true}, (boolean[])Conversion.hexDigitMsb0ToBinary((char)'d'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, true, false}, (boolean[])Conversion.hexDigitMsb0ToBinary((char)'E'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, true, false}, (boolean[])Conversion.hexDigitMsb0ToBinary((char)'e'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, true, true}, (boolean[])Conversion.hexDigitMsb0ToBinary((char)'F'));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, true, true}, (boolean[])Conversion.hexDigitMsb0ToBinary((char)'f'));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Conversion.hexDigitMsb0ToBinary((char)'G'));
    }

    @Test
    public void testBinaryToHexDigit() {
        Assertions.assertEquals((char)'0', (char)Conversion.binaryToHexDigit((boolean[])new boolean[]{false, false, false, false}));
        Assertions.assertEquals((char)'1', (char)Conversion.binaryToHexDigit((boolean[])new boolean[]{true, false, false, false}));
        Assertions.assertEquals((char)'2', (char)Conversion.binaryToHexDigit((boolean[])new boolean[]{false, true, false, false}));
        Assertions.assertEquals((char)'3', (char)Conversion.binaryToHexDigit((boolean[])new boolean[]{true, true, false, false}));
        Assertions.assertEquals((char)'4', (char)Conversion.binaryToHexDigit((boolean[])new boolean[]{false, false, true, false}));
        Assertions.assertEquals((char)'5', (char)Conversion.binaryToHexDigit((boolean[])new boolean[]{true, false, true, false}));
        Assertions.assertEquals((char)'6', (char)Conversion.binaryToHexDigit((boolean[])new boolean[]{false, true, true, false}));
        Assertions.assertEquals((char)'7', (char)Conversion.binaryToHexDigit((boolean[])new boolean[]{true, true, true, false}));
        Assertions.assertEquals((char)'8', (char)Conversion.binaryToHexDigit((boolean[])new boolean[]{false, false, false, true}));
        Assertions.assertEquals((char)'9', (char)Conversion.binaryToHexDigit((boolean[])new boolean[]{true, false, false, true}));
        Assertions.assertEquals((char)'a', (char)Conversion.binaryToHexDigit((boolean[])new boolean[]{false, true, false, true}));
        Assertions.assertEquals((char)'b', (char)Conversion.binaryToHexDigit((boolean[])new boolean[]{true, true, false, true}));
        Assertions.assertEquals((char)'c', (char)Conversion.binaryToHexDigit((boolean[])new boolean[]{false, false, true, true}));
        Assertions.assertEquals((char)'d', (char)Conversion.binaryToHexDigit((boolean[])new boolean[]{true, false, true, true}));
        Assertions.assertEquals((char)'e', (char)Conversion.binaryToHexDigit((boolean[])new boolean[]{false, true, true, true}));
        Assertions.assertEquals((char)'f', (char)Conversion.binaryToHexDigit((boolean[])new boolean[]{true, true, true, true}));
        Assertions.assertEquals((char)'1', (char)Conversion.binaryToHexDigit((boolean[])new boolean[]{true}));
        Assertions.assertEquals((char)'f', (char)Conversion.binaryToHexDigit((boolean[])new boolean[]{true, true, true, true, true}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Conversion.binaryToHexDigit((boolean[])new boolean[0]));
    }

    @Test
    public void testBinaryToHexDigit_2args() {
        boolean[] shortArray = new boolean[]{false, true, true};
        Assertions.assertEquals((char)'6', (char)Conversion.binaryToHexDigit((boolean[])shortArray, (int)0));
        Assertions.assertEquals((char)'3', (char)Conversion.binaryToHexDigit((boolean[])shortArray, (int)1));
        Assertions.assertEquals((char)'1', (char)Conversion.binaryToHexDigit((boolean[])shortArray, (int)2));
        boolean[] longArray = new boolean[]{true, false, true, false, false, true, true};
        Assertions.assertEquals((char)'5', (char)Conversion.binaryToHexDigit((boolean[])longArray, (int)0));
        Assertions.assertEquals((char)'2', (char)Conversion.binaryToHexDigit((boolean[])longArray, (int)1));
        Assertions.assertEquals((char)'9', (char)Conversion.binaryToHexDigit((boolean[])longArray, (int)2));
        Assertions.assertEquals((char)'c', (char)Conversion.binaryToHexDigit((boolean[])longArray, (int)3));
        Assertions.assertEquals((char)'6', (char)Conversion.binaryToHexDigit((boolean[])longArray, (int)4));
        Assertions.assertEquals((char)'3', (char)Conversion.binaryToHexDigit((boolean[])longArray, (int)5));
        Assertions.assertEquals((char)'1', (char)Conversion.binaryToHexDigit((boolean[])longArray, (int)6));
    }

    @Test
    public void testBinaryToHexDigitMsb0_bits() {
        Assertions.assertEquals((char)'0', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{false, false, false, false}));
        Assertions.assertEquals((char)'1', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{false, false, false, true}));
        Assertions.assertEquals((char)'2', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{false, false, true, false}));
        Assertions.assertEquals((char)'3', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{false, false, true, true}));
        Assertions.assertEquals((char)'4', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{false, true, false, false}));
        Assertions.assertEquals((char)'5', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{false, true, false, true}));
        Assertions.assertEquals((char)'6', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{false, true, true, false}));
        Assertions.assertEquals((char)'7', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{false, true, true, true}));
        Assertions.assertEquals((char)'8', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{true, false, false, false}));
        Assertions.assertEquals((char)'9', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{true, false, false, true}));
        Assertions.assertEquals((char)'a', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{true, false, true, false}));
        Assertions.assertEquals((char)'b', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{true, false, true, true}));
        Assertions.assertEquals((char)'c', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{true, true, false, false}));
        Assertions.assertEquals((char)'d', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{true, true, false, true}));
        Assertions.assertEquals((char)'e', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{true, true, true, false}));
        Assertions.assertEquals((char)'f', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{true, true, true, true}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[0]));
    }

    @Test
    public void testBinaryToHexDigitMsb0_4bits_2args() {
        boolean[] shortArray = new boolean[]{true, true, false, true};
        Assertions.assertEquals((char)'d', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])shortArray, (int)0));
        boolean[] longArray = new boolean[]{true, false, true, false, false, true, true};
        Assertions.assertEquals((char)'a', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])longArray, (int)0));
        Assertions.assertEquals((char)'4', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])longArray, (int)1));
        Assertions.assertEquals((char)'9', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])longArray, (int)2));
        Assertions.assertEquals((char)'3', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])longArray, (int)3));
        boolean[] maxLengthArray = new boolean[]{true, false, true, false, false, true, true, true};
        Assertions.assertEquals((char)'a', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])maxLengthArray, (int)0));
        Assertions.assertEquals((char)'4', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])maxLengthArray, (int)1));
        Assertions.assertEquals((char)'9', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])maxLengthArray, (int)2));
        Assertions.assertEquals((char)'3', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])maxLengthArray, (int)3));
        Assertions.assertEquals((char)'7', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])maxLengthArray, (int)4));
        boolean[] javaDocCheck = new boolean[]{true, false, false, true, true, false, true, false};
        Assertions.assertEquals((char)'d', (char)Conversion.binaryToHexDigitMsb0_4bits((boolean[])javaDocCheck, (int)3));
    }

    @Test
    public void testBinaryBeMsb0ToHexDigit() {
        Assertions.assertEquals((char)'0', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{false, false, false, false}));
        Assertions.assertEquals((char)'1', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{false, false, false, true}));
        Assertions.assertEquals((char)'2', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{false, false, true, false}));
        Assertions.assertEquals((char)'3', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{false, false, true, true}));
        Assertions.assertEquals((char)'4', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{false, true, false, false}));
        Assertions.assertEquals((char)'5', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{false, true, false, true}));
        Assertions.assertEquals((char)'6', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{false, true, true, false}));
        Assertions.assertEquals((char)'7', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{false, true, true, true}));
        Assertions.assertEquals((char)'8', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{true, false, false, false}));
        Assertions.assertEquals((char)'9', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{true, false, false, true}));
        Assertions.assertEquals((char)'a', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{true, false, true, false}));
        Assertions.assertEquals((char)'b', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{true, false, true, true}));
        Assertions.assertEquals((char)'c', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{true, true, false, false}));
        Assertions.assertEquals((char)'d', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{true, true, false, true}));
        Assertions.assertEquals((char)'e', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{true, true, true, false}));
        Assertions.assertEquals((char)'f', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{true, true, true, true}));
        Assertions.assertEquals((char)'4', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{true, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[0]));
    }

    @Test
    public void testBinaryBeMsb0ToHexDigit_2args() {
        Assertions.assertEquals((char)'5', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{true, false, false, false, false, false, false, false, false, false, false, true, false, true, false, false}, (int)2));
        boolean[] shortArray = new boolean[]{true, true, false};
        Assertions.assertEquals((char)'6', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])shortArray, (int)0));
        Assertions.assertEquals((char)'3', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])shortArray, (int)1));
        Assertions.assertEquals((char)'1', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])shortArray, (int)2));
        boolean[] shortArray2 = new boolean[]{true, true, true, false, false, true, false, true};
        Assertions.assertEquals((char)'5', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])shortArray2, (int)0));
        Assertions.assertEquals((char)'2', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])shortArray2, (int)1));
        Assertions.assertEquals((char)'9', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])shortArray2, (int)2));
        Assertions.assertEquals((char)'c', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])shortArray2, (int)3));
        Assertions.assertEquals((char)'e', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])shortArray2, (int)4));
        Assertions.assertEquals((char)'7', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])shortArray2, (int)5));
        Assertions.assertEquals((char)'3', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])shortArray2, (int)6));
        Assertions.assertEquals((char)'1', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])shortArray2, (int)7));
        boolean[] multiBytesArray = new boolean[]{true, true, false, false, true, false, true, false, true, true, true, false, false, true, false, true};
        Assertions.assertEquals((char)'5', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)0));
        Assertions.assertEquals((char)'2', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)1));
        Assertions.assertEquals((char)'9', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)2));
        Assertions.assertEquals((char)'c', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)3));
        Assertions.assertEquals((char)'e', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)4));
        Assertions.assertEquals((char)'7', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)5));
        Assertions.assertEquals((char)'b', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)6));
        Assertions.assertEquals((char)'5', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)7));
        Assertions.assertEquals((char)'a', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)8));
        Assertions.assertEquals((char)'5', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)9));
        Assertions.assertEquals((char)'2', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)10));
        Assertions.assertEquals((char)'9', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)11));
        Assertions.assertEquals((char)'c', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)12));
        Assertions.assertEquals((char)'6', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)13));
        Assertions.assertEquals((char)'3', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)14));
        Assertions.assertEquals((char)'1', (char)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)15));
    }

    @Test
    public void testIntToHexDigit() {
        Assertions.assertEquals((char)'0', (char)Conversion.intToHexDigit((int)0));
        Assertions.assertEquals((char)'1', (char)Conversion.intToHexDigit((int)1));
        Assertions.assertEquals((char)'2', (char)Conversion.intToHexDigit((int)2));
        Assertions.assertEquals((char)'3', (char)Conversion.intToHexDigit((int)3));
        Assertions.assertEquals((char)'4', (char)Conversion.intToHexDigit((int)4));
        Assertions.assertEquals((char)'5', (char)Conversion.intToHexDigit((int)5));
        Assertions.assertEquals((char)'6', (char)Conversion.intToHexDigit((int)6));
        Assertions.assertEquals((char)'7', (char)Conversion.intToHexDigit((int)7));
        Assertions.assertEquals((char)'8', (char)Conversion.intToHexDigit((int)8));
        Assertions.assertEquals((char)'9', (char)Conversion.intToHexDigit((int)9));
        Assertions.assertEquals((char)'a', (char)Conversion.intToHexDigit((int)10));
        Assertions.assertEquals((char)'b', (char)Conversion.intToHexDigit((int)11));
        Assertions.assertEquals((char)'c', (char)Conversion.intToHexDigit((int)12));
        Assertions.assertEquals((char)'d', (char)Conversion.intToHexDigit((int)13));
        Assertions.assertEquals((char)'e', (char)Conversion.intToHexDigit((int)14));
        Assertions.assertEquals((char)'f', (char)Conversion.intToHexDigit((int)15));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Conversion.intToHexDigit((int)16));
    }

    @Test
    public void testIntToHexDigitMsb0() {
        Assertions.assertEquals((char)'0', (char)Conversion.intToHexDigitMsb0((int)0));
        Assertions.assertEquals((char)'8', (char)Conversion.intToHexDigitMsb0((int)1));
        Assertions.assertEquals((char)'4', (char)Conversion.intToHexDigitMsb0((int)2));
        Assertions.assertEquals((char)'c', (char)Conversion.intToHexDigitMsb0((int)3));
        Assertions.assertEquals((char)'2', (char)Conversion.intToHexDigitMsb0((int)4));
        Assertions.assertEquals((char)'a', (char)Conversion.intToHexDigitMsb0((int)5));
        Assertions.assertEquals((char)'6', (char)Conversion.intToHexDigitMsb0((int)6));
        Assertions.assertEquals((char)'e', (char)Conversion.intToHexDigitMsb0((int)7));
        Assertions.assertEquals((char)'1', (char)Conversion.intToHexDigitMsb0((int)8));
        Assertions.assertEquals((char)'9', (char)Conversion.intToHexDigitMsb0((int)9));
        Assertions.assertEquals((char)'5', (char)Conversion.intToHexDigitMsb0((int)10));
        Assertions.assertEquals((char)'d', (char)Conversion.intToHexDigitMsb0((int)11));
        Assertions.assertEquals((char)'3', (char)Conversion.intToHexDigitMsb0((int)12));
        Assertions.assertEquals((char)'b', (char)Conversion.intToHexDigitMsb0((int)13));
        Assertions.assertEquals((char)'7', (char)Conversion.intToHexDigitMsb0((int)14));
        Assertions.assertEquals((char)'f', (char)Conversion.intToHexDigitMsb0((int)15));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Conversion.intToHexDigitMsb0((int)16));
    }

    static String dbgPrint(boolean[] src) {
        StringBuilder sb = new StringBuilder();
        for (boolean e : src) {
            if (e) {
                sb.append("1, ");
                continue;
            }
            sb.append("0, ");
        }
        String out = sb.toString();
        return out.substring(0, out.length() - 1);
    }

    @Test
    public void testIntArrayToLong() {
        int[] src = new int[]{-839782207, 252851286, 0x78000000};
        Assertions.assertEquals((long)0L, (long)Conversion.intArrayToLong((int[])src, (int)0, (long)0L, (int)0, (int)0));
        Assertions.assertEquals((long)0L, (long)Conversion.intArrayToLong((int[])src, (int)1, (long)0L, (int)0, (int)0));
        Assertions.assertEquals((long)3455185089L, (long)Conversion.intArrayToLong((int[])src, (int)0, (long)0L, (int)0, (int)1));
        Assertions.assertEquals((long)1085988007576727745L, (long)Conversion.intArrayToLong((int[])src, (int)0, (long)0L, (int)0, (int)2));
        Assertions.assertEquals((long)252851286L, (long)Conversion.intArrayToLong((int[])src, (int)1, (long)0L, (int)0, (int)1));
        Assertions.assertEquals((long)1311768467463790320L, (long)Conversion.intArrayToLong((int[])src, (int)0, (long)1311768467463790320L, (int)0, (int)0));
        Assertions.assertEquals((long)1311768466880987136L, (long)Conversion.intArrayToLong((int[])src, (int)2, (long)1311768467463790320L, (int)0, (int)1));
    }

    @Test
    public void testShortArrayToLong() {
        short[] src = new short[]{-12815, -3903, 3858, 13398, 30720};
        Assertions.assertEquals((long)0L, (long)Conversion.shortArrayToLong((short[])src, (int)0, (long)0L, (int)0, (int)0));
        Assertions.assertEquals((long)52721L, (long)Conversion.shortArrayToLong((short[])src, (int)0, (long)0L, (int)0, (int)1));
        Assertions.assertEquals((long)4039233009L, (long)Conversion.shortArrayToLong((short[])src, (int)0, (long)0L, (int)0, (int)2));
        Assertions.assertEquals((long)8646968828776083649L, (long)Conversion.shortArrayToLong((short[])src, (int)1, (long)0L, (int)0, (int)4));
        Assertions.assertEquals((long)1311768467463790320L, (long)Conversion.shortArrayToLong((short[])src, (int)0, (long)1311768467463790320L, (int)0, (int)0));
        Assertions.assertEquals((long)1311768833995628272L, (long)Conversion.shortArrayToLong((short[])src, (int)0, (long)1311768467463790320L, (int)24, (int)1));
        Assertions.assertEquals((long)1311805333745098480L, (long)Conversion.shortArrayToLong((short[])src, (int)3, (long)1311768467463790320L, (int)16, (int)2));
    }

    @Test
    public void testByteArrayToLong() {
        byte[] src = new byte[]{-51, -15, -16, -63, 15, 18, 52, 86, 120};
        Assertions.assertEquals((long)0L, (long)Conversion.byteArrayToLong((byte[])src, (int)0, (long)0L, (int)0, (int)0));
        Assertions.assertEquals((long)205L, (long)Conversion.byteArrayToLong((byte[])src, (int)0, (long)0L, (int)0, (int)1));
        Assertions.assertEquals((long)3253793229L, (long)Conversion.byteArrayToLong((byte[])src, (int)0, (long)0L, (int)0, (int)4));
        Assertions.assertEquals((long)264368369L, (long)Conversion.byteArrayToLong((byte[])src, (int)1, (long)0L, (int)0, (int)4));
        Assertions.assertEquals((long)1311768467463790320L, (long)Conversion.byteArrayToLong((byte[])src, (int)0, (long)1311768467463790320L, (int)0, (int)0));
        Assertions.assertEquals((long)1311768468319428336L, (long)Conversion.byteArrayToLong((byte[])src, (int)0, (long)1311768467463790320L, (int)24, (int)1));
        Assertions.assertEquals((long)1311768467459299056L, (long)Conversion.byteArrayToLong((byte[])src, (int)7, (long)1311768467463790320L, (int)8, (int)2));
    }

    @Test
    public void testShortArrayToInt() {
        short[] src = new short[]{-12815, -3903, 3858, 13398, 30720};
        Assertions.assertEquals((int)0, (int)Conversion.shortArrayToInt((short[])src, (int)0, (int)0, (int)0, (int)0));
        Assertions.assertEquals((int)52721, (int)Conversion.shortArrayToInt((short[])src, (int)0, (int)0, (int)0, (int)1));
        Assertions.assertEquals((int)-255734287, (int)Conversion.shortArrayToInt((short[])src, (int)0, (int)0, (int)0, (int)2));
        Assertions.assertEquals((int)252899521, (int)Conversion.shortArrayToInt((short[])src, (int)1, (int)0, (int)0, (int)2));
        Assertions.assertEquals((int)305419896, (int)Conversion.shortArrayToInt((short[])src, (int)0, (int)305419896, (int)0, (int)0));
        Assertions.assertEquals((int)-839821704, (int)Conversion.shortArrayToInt((short[])src, (int)0, (int)305419896, (int)16, (int)1));
    }

    @Test
    public void testByteArrayToInt() {
        byte[] src = new byte[]{-51, -15, -16, -63, 15, 18, 52, 86, 120};
        Assertions.assertEquals((int)0, (int)Conversion.byteArrayToInt((byte[])src, (int)0, (int)0, (int)0, (int)0));
        Assertions.assertEquals((int)205, (int)Conversion.byteArrayToInt((byte[])src, (int)0, (int)0, (int)0, (int)1));
        Assertions.assertEquals((int)-1041174067, (int)Conversion.byteArrayToInt((byte[])src, (int)0, (int)0, (int)0, (int)4));
        Assertions.assertEquals((int)264368369, (int)Conversion.byteArrayToInt((byte[])src, (int)1, (int)0, (int)0, (int)4));
        Assertions.assertEquals((int)305419896, (int)Conversion.byteArrayToInt((byte[])src, (int)0, (int)305419896, (int)0, (int)0));
        Assertions.assertEquals((int)-852208008, (int)Conversion.byteArrayToInt((byte[])src, (int)0, (int)305419896, (int)24, (int)1));
    }

    @Test
    public void testByteArrayToShort() {
        byte[] src = new byte[]{-51, -15, -16, -63, 15, 18, 52, 86, 120};
        Assertions.assertEquals((short)0, (short)Conversion.byteArrayToShort((byte[])src, (int)0, (short)0, (int)0, (int)0));
        Assertions.assertEquals((short)205, (short)Conversion.byteArrayToShort((byte[])src, (int)0, (short)0, (int)0, (int)1));
        Assertions.assertEquals((short)-3635, (short)Conversion.byteArrayToShort((byte[])src, (int)0, (short)0, (int)0, (int)2));
        Assertions.assertEquals((short)-3855, (short)Conversion.byteArrayToShort((byte[])src, (int)1, (short)0, (int)0, (int)2));
        Assertions.assertEquals((short)4660, (short)Conversion.byteArrayToShort((byte[])src, (int)0, (short)4660, (int)0, (int)0));
        Assertions.assertEquals((short)-13004, (short)Conversion.byteArrayToShort((byte[])src, (int)0, (short)4660, (int)8, (int)1));
    }

    @Test
    public void testHexToLong() {
        String src = "CDF1F0C10F12345678";
        Assertions.assertEquals((long)0L, (long)Conversion.hexToLong((String)"CDF1F0C10F12345678", (int)0, (long)0L, (int)0, (int)0));
        Assertions.assertEquals((long)12L, (long)Conversion.hexToLong((String)"CDF1F0C10F12345678", (int)0, (long)0L, (int)0, (int)1));
        Assertions.assertEquals((long)470753244L, (long)Conversion.hexToLong((String)"CDF1F0C10F12345678", (int)0, (long)0L, (int)0, (int)8));
        Assertions.assertEquals((long)29422077L, (long)Conversion.hexToLong((String)"CDF1F0C10F12345678", (int)1, (long)0L, (int)0, (int)8));
        Assertions.assertEquals((long)1311768471490322160L, (long)Conversion.hexToLong((String)"CDF1F0C10F12345678", (int)0, (long)1311768471490322160L, (int)0, (int)0));
        Assertions.assertEquals((long)1311768466859810544L, (long)Conversion.hexToLong((String)"CDF1F0C10F12345678", (int)15, (long)1311768471490322160L, (int)24, (int)3));
    }

    @Test
    public void testHexToInt() {
        String src = "CDF1F0C10F12345678";
        Assertions.assertEquals((int)0, (int)Conversion.hexToInt((String)"CDF1F0C10F12345678", (int)0, (int)0, (int)0, (int)0));
        Assertions.assertEquals((int)12, (int)Conversion.hexToInt((String)"CDF1F0C10F12345678", (int)0, (int)0, (int)0, (int)1));
        Assertions.assertEquals((int)470753244, (int)Conversion.hexToInt((String)"CDF1F0C10F12345678", (int)0, (int)0, (int)0, (int)8));
        Assertions.assertEquals((int)29422077, (int)Conversion.hexToInt((String)"CDF1F0C10F12345678", (int)1, (int)0, (int)0, (int)8));
        Assertions.assertEquals((int)305419897, (int)Conversion.hexToInt((String)"CDF1F0C10F12345678", (int)0, (int)305419897, (int)0, (int)0));
        Assertions.assertEquals((int)-2023467399, (int)Conversion.hexToInt((String)"CDF1F0C10F12345678", (int)15, (int)305419897, (int)20, (int)3));
    }

    @Test
    public void testHexToShort() {
        String src = "CDF1F0C10F12345678";
        Assertions.assertEquals((short)0, (short)Conversion.hexToShort((String)"CDF1F0C10F12345678", (int)0, (short)0, (int)0, (int)0));
        Assertions.assertEquals((short)12, (short)Conversion.hexToShort((String)"CDF1F0C10F12345678", (int)0, (short)0, (int)0, (int)1));
        Assertions.assertEquals((short)8156, (short)Conversion.hexToShort((String)"CDF1F0C10F12345678", (int)0, (short)0, (int)0, (int)4));
        Assertions.assertEquals((short)-3587, (short)Conversion.hexToShort((String)"CDF1F0C10F12345678", (int)1, (short)0, (int)0, (int)4));
        Assertions.assertEquals((short)4660, (short)Conversion.hexToShort((String)"CDF1F0C10F12345678", (int)0, (short)4660, (int)0, (int)0));
        Assertions.assertEquals((short)-30876, (short)Conversion.hexToShort((String)"CDF1F0C10F12345678", (int)15, (short)4660, (int)4, (int)3));
    }

    @Test
    public void testHexToByte() {
        String src = "CDF1F0C10F12345678";
        Assertions.assertEquals((byte)0, (byte)Conversion.hexToByte((String)"CDF1F0C10F12345678", (int)0, (byte)0, (int)0, (int)0));
        Assertions.assertEquals((byte)12, (byte)Conversion.hexToByte((String)"CDF1F0C10F12345678", (int)0, (byte)0, (int)0, (int)1));
        Assertions.assertEquals((byte)-36, (byte)Conversion.hexToByte((String)"CDF1F0C10F12345678", (int)0, (byte)0, (int)0, (int)2));
        Assertions.assertEquals((byte)-3, (byte)Conversion.hexToByte((String)"CDF1F0C10F12345678", (int)1, (byte)0, (int)0, (int)2));
        Assertions.assertEquals((byte)52, (byte)Conversion.hexToByte((String)"CDF1F0C10F12345678", (int)0, (byte)52, (int)0, (int)0));
        Assertions.assertEquals((byte)-124, (byte)Conversion.hexToByte((String)"CDF1F0C10F12345678", (int)17, (byte)52, (int)4, (int)1));
    }

    @Test
    public void testBinaryToLong() {
        boolean[] src = new boolean[]{false, false, true, true, true, false, true, true, true, true, true, true, true, false, false, false, true, true, true, true, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, false, false, false, false, true, false, false, true, true, false, false, false, false, true, false, true, false, true, false, false, true, true, false, true, true, true, false, false, false, false, true};
        Assertions.assertEquals((long)0L, (long)Conversion.binaryToLong((boolean[])src, (int)0, (long)0L, (int)0, (int)0));
        Assertions.assertEquals((long)12L, (long)Conversion.binaryToLong((boolean[])src, (int)0, (long)0L, (int)0, (int)4));
        Assertions.assertEquals((long)470753244L, (long)Conversion.binaryToLong((boolean[])src, (int)0, (long)0L, (int)0, (int)32));
        Assertions.assertEquals((long)29422077L, (long)Conversion.binaryToLong((boolean[])src, (int)4, (long)0L, (int)0, (int)32));
        Assertions.assertEquals((long)1311768471490322160L, (long)Conversion.binaryToLong((boolean[])src, (int)0, (long)1311768471490322160L, (int)0, (int)0));
        Assertions.assertEquals((long)1311768466859810544L, (long)Conversion.binaryToLong((boolean[])src, (int)60, (long)1311768471490322160L, (int)24, (int)12));
    }

    @Test
    public void testBinaryToInt() {
        boolean[] src = new boolean[]{false, false, true, true, true, false, true, true, true, true, true, true, true, false, false, false, true, true, true, true, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, false, false, false, false, true, false, false, true, true, false, false, false, false, true, false, true, false, true, false, false, true, true, false, true, true, true, false, false, false, false, true};
        Assertions.assertEquals((int)0, (int)Conversion.binaryToInt((boolean[])src, (int)0, (int)0, (int)0, (int)0));
        Assertions.assertEquals((int)12, (int)Conversion.binaryToInt((boolean[])src, (int)0, (int)0, (int)0, (int)4));
        Assertions.assertEquals((int)470753244, (int)Conversion.binaryToInt((boolean[])src, (int)0, (int)0, (int)0, (int)32));
        Assertions.assertEquals((int)29422077, (int)Conversion.binaryToInt((boolean[])src, (int)4, (int)0, (int)0, (int)32));
        Assertions.assertEquals((int)305419897, (int)Conversion.binaryToInt((boolean[])src, (int)0, (int)305419897, (int)0, (int)0));
        Assertions.assertEquals((int)-2023467399, (int)Conversion.binaryToInt((boolean[])src, (int)60, (int)305419897, (int)20, (int)12));
    }

    @Test
    public void testBinaryToShort() {
        boolean[] src = new boolean[]{false, false, true, true, true, false, true, true, true, true, true, true, true, false, false, false, true, true, true, true, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, false, false, false, false, true, false, false, true, true, false, false, false, false, true, false, true, false, true, false, false, true, true, false, true, true, true, false, false, false, false, true};
        Assertions.assertEquals((short)0, (short)Conversion.binaryToShort((boolean[])src, (int)0, (short)0, (int)0, (int)0));
        Assertions.assertEquals((short)12, (short)Conversion.binaryToShort((boolean[])src, (int)0, (short)0, (int)0, (int)4));
        Assertions.assertEquals((short)8156, (short)Conversion.binaryToShort((boolean[])src, (int)0, (short)0, (int)0, (int)16));
        Assertions.assertEquals((short)-3587, (short)Conversion.binaryToShort((boolean[])src, (int)4, (short)0, (int)0, (int)16));
        Assertions.assertEquals((short)4660, (short)Conversion.binaryToShort((boolean[])src, (int)0, (short)4660, (int)0, (int)0));
        Assertions.assertEquals((short)-30876, (short)Conversion.binaryToShort((boolean[])src, (int)60, (short)4660, (int)4, (int)12));
    }

    @Test
    public void testBinaryToByte() {
        boolean[] src = new boolean[]{false, false, true, true, true, false, true, true, true, true, true, true, true, false, false, false, true, true, true, true, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, false, false, false, false, true, false, false, true, true, false, false, false, false, true, false, true, false, true, false, false, true, true, false, true, true, true, false, false, false, false, true};
        Assertions.assertEquals((byte)0, (byte)Conversion.binaryToByte((boolean[])src, (int)0, (byte)0, (int)0, (int)0));
        Assertions.assertEquals((byte)12, (byte)Conversion.binaryToByte((boolean[])src, (int)0, (byte)0, (int)0, (int)4));
        Assertions.assertEquals((byte)-36, (byte)Conversion.binaryToByte((boolean[])src, (int)0, (byte)0, (int)0, (int)8));
        Assertions.assertEquals((byte)-3, (byte)Conversion.binaryToByte((boolean[])src, (int)4, (byte)0, (int)0, (int)8));
        Assertions.assertEquals((byte)52, (byte)Conversion.binaryToByte((boolean[])src, (int)0, (byte)52, (int)0, (int)0));
        Assertions.assertEquals((byte)-124, (byte)Conversion.binaryToByte((boolean[])src, (int)68, (byte)52, (int)4, (int)4));
    }

    @Test
    public void testLongToIntArray() {
        Assertions.assertArrayEquals((int[])new int[0], (int[])Conversion.longToIntArray((long)0L, (int)0, (int[])new int[0], (int)0, (int)0));
        Assertions.assertArrayEquals((int[])new int[0], (int[])Conversion.longToIntArray((long)0L, (int)100, (int[])new int[0], (int)0, (int)0));
        Assertions.assertArrayEquals((int[])new int[0], (int[])Conversion.longToIntArray((long)0L, (int)0, (int[])new int[0], (int)100, (int)0));
        Assertions.assertArrayEquals((int[])new int[]{-1, -1, -1, -1}, (int[])Conversion.longToIntArray((long)1311768467294899695L, (int)0, (int[])new int[]{-1, -1, -1, -1}, (int)0, (int)0));
        Assertions.assertArrayEquals((int[])new int[]{-1867788817, -1, -1, -1}, (int[])Conversion.longToIntArray((long)1311768467294899695L, (int)0, (int[])new int[]{-1, -1, -1, -1}, (int)0, (int)1));
        Assertions.assertArrayEquals((int[])new int[]{-1867788817, 305419896, -1, -1}, (int[])Conversion.longToIntArray((long)1311768467294899695L, (int)0, (int[])new int[]{-1, -1, -1, -1}, (int)0, (int)2));
        Assertions.assertArrayEquals((int[])new int[]{-1, -1, -1867788817, 305419896}, (int[])Conversion.longToIntArray((long)1311768467294899695L, (int)0, (int[])new int[]{-1, -1, -1, -1}, (int)2, (int)2));
        Assertions.assertArrayEquals((int[])new int[]{-1, -1, -1867788817, -1}, (int[])Conversion.longToIntArray((long)1311768467294899695L, (int)0, (int[])new int[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assertions.assertArrayEquals((int[])new int[]{-1, -1, -1, -1867788817}, (int[])Conversion.longToIntArray((long)1311768467294899695L, (int)0, (int[])new int[]{-1, -1, -1, -1}, (int)3, (int)1));
        Assertions.assertArrayEquals((int[])new int[]{-1, -1, 1213589239, -1}, (int[])Conversion.longToIntArray((long)1311768467294899695L, (int)1, (int[])new int[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assertions.assertArrayEquals((int[])new int[]{-1, -1, 606794619, -1}, (int[])Conversion.longToIntArray((long)1311768467294899695L, (int)2, (int[])new int[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assertions.assertArrayEquals((int[])new int[]{-1, -1, 303397309, -1}, (int[])Conversion.longToIntArray((long)1311768467294899695L, (int)3, (int[])new int[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assertions.assertArrayEquals((int[])new int[]{-1, -1, -1995784994, -1}, (int[])Conversion.longToIntArray((long)1311768467294899695L, (int)4, (int[])new int[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assertions.assertArrayEquals((int[])new int[]{152709948}, (int[])Conversion.longToIntArray((long)1311768467294899695L, (int)33, (int[])new int[]{0}, (int)0, (int)1));
    }

    @Test
    public void testLongToShortArray() {
        Assertions.assertArrayEquals((short[])new short[0], (short[])Conversion.longToShortArray((long)0L, (int)0, (short[])new short[0], (int)0, (int)0));
        Assertions.assertArrayEquals((short[])new short[0], (short[])Conversion.longToShortArray((long)0L, (int)100, (short[])new short[0], (int)0, (int)0));
        Assertions.assertArrayEquals((short[])new short[0], (short[])Conversion.longToShortArray((long)0L, (int)0, (short[])new short[0], (int)100, (int)0));
        Assertions.assertArrayEquals((short[])new short[]{-1, -1, -1, -1}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)0, (int)0));
        Assertions.assertArrayEquals((short[])new short[]{-12817, -1, -1, -1}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)0, (int)1));
        Assertions.assertArrayEquals((short[])new short[]{-12817, -28501, -1, -1}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)0, (int)2));
        Assertions.assertArrayEquals((short[])new short[]{-12817, -28501, 22136, -1}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)0, (int)3));
        Assertions.assertArrayEquals((short[])new short[]{-12817, -28501, 22136, 4660}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)0, (int)4));
        Assertions.assertArrayEquals((short[])new short[]{-1, -12817, -28501, 22136}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)1, (int)3));
        Assertions.assertArrayEquals((short[])new short[]{-1, -1, -12817, -28501}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)2, (int)2));
        Assertions.assertArrayEquals((short[])new short[]{-1, -1, -12817, -1}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assertions.assertArrayEquals((short[])new short[]{-1, -1, -1, -12817}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)3, (int)1));
        Assertions.assertArrayEquals((short[])new short[]{-1, -1, -6409, -1}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)1, (short[])new short[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assertions.assertArrayEquals((short[])new short[]{-1, -1, -3205, -1}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)2, (short[])new short[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assertions.assertArrayEquals((short[])new short[]{-1, -1, 31165, -1}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)3, (short[])new short[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assertions.assertArrayEquals((short[])new short[]{-1, -1, -17186, -1}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)4, (short[])new short[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assertions.assertArrayEquals((short[])new short[]{-6409, 18517, 11068, 2330}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)1, (short[])new short[]{-1, -1, -1, -1}, (int)0, (int)4));
        Assertions.assertArrayEquals((short[])new short[]{11068}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)33, (short[])new short[]{0}, (int)0, (int)1));
    }

    @Test
    public void testIntToShortArray() {
        Assertions.assertArrayEquals((short[])new short[0], (short[])Conversion.intToShortArray((int)0, (int)0, (short[])new short[0], (int)0, (int)0));
        Assertions.assertArrayEquals((short[])new short[0], (short[])Conversion.intToShortArray((int)0, (int)100, (short[])new short[0], (int)0, (int)0));
        Assertions.assertArrayEquals((short[])new short[0], (short[])Conversion.intToShortArray((int)0, (int)0, (short[])new short[0], (int)100, (int)0));
        Assertions.assertArrayEquals((short[])new short[]{-1, -1, -1, -1}, (short[])Conversion.intToShortArray((int)305419896, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)0, (int)0));
        Assertions.assertArrayEquals((short[])new short[]{22136, -1, -1, -1}, (short[])Conversion.intToShortArray((int)305419896, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)0, (int)1));
        Assertions.assertArrayEquals((short[])new short[]{22136, 4660, -1, -1}, (short[])Conversion.intToShortArray((int)305419896, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)0, (int)2));
        Assertions.assertArrayEquals((short[])new short[]{-1, -1, 22136, 4660}, (short[])Conversion.intToShortArray((int)305419896, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)2, (int)2));
        Assertions.assertArrayEquals((short[])new short[]{-1, -1, 22136, -1}, (short[])Conversion.intToShortArray((int)305419896, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assertions.assertArrayEquals((short[])new short[]{-1, -1, -1, 22136}, (short[])Conversion.intToShortArray((int)305419896, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)3, (int)1));
        Assertions.assertArrayEquals((short[])new short[]{-1, -1, 11068, -1}, (short[])Conversion.intToShortArray((int)305419896, (int)1, (short[])new short[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assertions.assertArrayEquals((short[])new short[]{-1, -1, 5534, -1}, (short[])Conversion.intToShortArray((int)305419896, (int)2, (short[])new short[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assertions.assertArrayEquals((short[])new short[]{-1, -1, -30001, -1}, (short[])Conversion.intToShortArray((int)305419896, (int)3, (short[])new short[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assertions.assertArrayEquals((short[])new short[]{-1, -1, 17767, -1}, (short[])Conversion.intToShortArray((int)305419896, (int)4, (short[])new short[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assertions.assertArrayEquals((short[])new short[]{2330}, (short[])Conversion.intToShortArray((int)305419896, (int)17, (short[])new short[]{0}, (int)0, (int)1));
    }

    @Test
    public void testLongToByteArray() {
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])Conversion.longToByteArray((long)0L, (int)0, (byte[])new byte[0], (int)0, (int)0));
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])Conversion.longToByteArray((long)0L, (int)100, (byte[])new byte[0], (int)0, (int)0));
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])Conversion.longToByteArray((long)0L, (int)0, (byte[])new byte[0], (int)100, (int)0));
        Assertions.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)0));
        Assertions.assertArrayEquals((byte[])new byte[]{-17, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)1));
        Assertions.assertArrayEquals((byte[])new byte[]{-17, -51, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)2));
        Assertions.assertArrayEquals((byte[])new byte[]{-17, -51, -85, -112, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)4));
        Assertions.assertArrayEquals((byte[])new byte[]{-17, -51, -85, -112, 120, 86, 52, -1, -1, -1, -1}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)7));
        Assertions.assertArrayEquals((byte[])new byte[]{-17, -51, -85, -112, 120, 86, 52, 18, -1, -1, -1}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)8));
        Assertions.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -17, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)3, (int)1));
        Assertions.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -17, -51, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)3, (int)2));
        Assertions.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -17, -51, -85, -112, -1, -1, -1, -1}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)3, (int)4));
        Assertions.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -17, -51, -85, -112, 120, 86, 52, -1}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)3, (int)7));
        Assertions.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -17, -51, -85, -112, 120, 86, 52, 18}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)3, (int)8));
        Assertions.assertArrayEquals((byte[])new byte[]{-9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)1, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)1));
        Assertions.assertArrayEquals((byte[])new byte[]{123, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)2, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)1));
        Assertions.assertArrayEquals((byte[])new byte[]{-1, 0, -1, 111, 94, -123, -60, -77, -94, -111, 0}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)5, (byte[])new byte[]{-1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)3, (int)8));
        Assertions.assertArrayEquals((byte[])new byte[]{-1, 0, -1, 94, -123, -60, -77, -94, -111, 0, -1}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)13, (byte[])new byte[]{-1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)3, (int)7));
    }

    @Test
    public void testIntToByteArray() {
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])Conversion.intToByteArray((int)0, (int)0, (byte[])new byte[0], (int)0, (int)0));
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])Conversion.intToByteArray((int)0, (int)100, (byte[])new byte[0], (int)0, (int)0));
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])Conversion.intToByteArray((int)0, (int)0, (byte[])new byte[0], (int)100, (int)0));
        Assertions.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.intToByteArray((int)-1867788817, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)0));
        Assertions.assertArrayEquals((byte[])new byte[]{-17, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.intToByteArray((int)-1867788817, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)1));
        Assertions.assertArrayEquals((byte[])new byte[]{-17, -51, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.intToByteArray((int)-1867788817, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)2));
        Assertions.assertArrayEquals((byte[])new byte[]{-17, -51, -85, -112, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.intToByteArray((int)-1867788817, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)4));
        Assertions.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -17, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.intToByteArray((int)-1867788817, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)3, (int)1));
        Assertions.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -17, -51, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.intToByteArray((int)-1867788817, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)3, (int)2));
        Assertions.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -17, -51, -85, -112, -1, -1, -1, -1}, (byte[])Conversion.intToByteArray((int)-1867788817, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)3, (int)4));
        Assertions.assertArrayEquals((byte[])new byte[]{-9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.intToByteArray((int)-1867788817, (int)1, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)1));
        Assertions.assertArrayEquals((byte[])new byte[]{123, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.intToByteArray((int)-1867788817, (int)2, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)1));
        Assertions.assertArrayEquals((byte[])new byte[]{-1, 0, -1, 111, 94, -123, -4, -1, -1, -1, -1}, (byte[])Conversion.intToByteArray((int)-1867788817, (int)5, (byte[])new byte[]{-1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)3, (int)4));
        Assertions.assertArrayEquals((byte[])new byte[]{-1, 0, -1, 94, -123, -4, -1, -1, -1, -1, -1}, (byte[])Conversion.intToByteArray((int)-1867788817, (int)13, (byte[])new byte[]{-1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)3, (int)3));
    }

    @Test
    public void testShortToByteArray() {
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])Conversion.shortToByteArray((short)0, (int)0, (byte[])new byte[0], (int)0, (int)0));
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])Conversion.shortToByteArray((short)0, (int)100, (byte[])new byte[0], (int)0, (int)0));
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])Conversion.shortToByteArray((short)0, (int)0, (byte[])new byte[0], (int)100, (int)0));
        Assertions.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.shortToByteArray((short)-12817, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1}, (int)0, (int)0));
        Assertions.assertArrayEquals((byte[])new byte[]{-17, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.shortToByteArray((short)-12817, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1}, (int)0, (int)1));
        Assertions.assertArrayEquals((byte[])new byte[]{-17, -51, -1, -1, -1, -1, -1}, (byte[])Conversion.shortToByteArray((short)-12817, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1}, (int)0, (int)2));
        Assertions.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -17, -1, -1, -1}, (byte[])Conversion.shortToByteArray((short)-12817, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1}, (int)3, (int)1));
        Assertions.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -17, -51, -1, -1}, (byte[])Conversion.shortToByteArray((short)-12817, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1}, (int)3, (int)2));
        Assertions.assertArrayEquals((byte[])new byte[]{-9, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.shortToByteArray((short)-12817, (int)1, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1}, (int)0, (int)1));
        Assertions.assertArrayEquals((byte[])new byte[]{123, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.shortToByteArray((short)-12817, (int)2, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1}, (int)0, (int)1));
        Assertions.assertArrayEquals((byte[])new byte[]{-1, 0, -1, 111, -2, -1, -1}, (byte[])Conversion.shortToByteArray((short)-12817, (int)5, (byte[])new byte[]{-1, 0, -1, -1, -1, -1, -1}, (int)3, (int)2));
        Assertions.assertArrayEquals((byte[])new byte[]{-1, 0, -1, -2, -1, -1, -1}, (byte[])Conversion.shortToByteArray((short)-12817, (int)13, (byte[])new byte[]{-1, 0, -1, -1, -1, -1, -1}, (int)3, (int)1));
    }

    @Test
    public void testLongToHex() {
        Assertions.assertEquals((Object)"", (Object)Conversion.longToHex((long)0L, (int)0, (String)"", (int)0, (int)0));
        Assertions.assertEquals((Object)"", (Object)Conversion.longToHex((long)0L, (int)100, (String)"", (int)0, (int)0));
        Assertions.assertEquals((Object)"", (Object)Conversion.longToHex((long)0L, (int)0, (String)"", (int)100, (int)0));
        Assertions.assertEquals((Object)"ffffffffffffffffffffffff", (Object)Conversion.longToHex((long)1311768467294899695L, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)0));
        Assertions.assertEquals((Object)"3fffffffffffffffffffffff", (Object)Conversion.longToHex((long)1311768467294899683L, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)1));
        Assertions.assertEquals((Object)"feffffffffffffffffffffff", (Object)Conversion.longToHex((long)1311768467294899695L, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)2));
        Assertions.assertEquals((Object)"fedcffffffffffffffffffff", (Object)Conversion.longToHex((long)1311768467294899695L, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)4));
        Assertions.assertEquals((Object)"fedcba098765432fffffffff", (Object)Conversion.longToHex((long)1311768467294899695L, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)15));
        Assertions.assertEquals((Object)"fedcba0987654321ffffffff", (Object)Conversion.longToHex((long)1311768467294899695L, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)16));
        Assertions.assertEquals((Object)"fff3ffffffffffffffffffff", (Object)Conversion.longToHex((long)1311768467294899683L, (int)0, (String)"ffffffffffffffffffffffff", (int)3, (int)1));
        Assertions.assertEquals((Object)"ffffefffffffffffffffffff", (Object)Conversion.longToHex((long)1311768467294899695L, (int)0, (String)"ffffffffffffffffffffffff", (int)3, (int)2));
        Assertions.assertEquals((Object)"ffffedcfffffffffffffffff", (Object)Conversion.longToHex((long)1311768467294899695L, (int)0, (String)"ffffffffffffffffffffffff", (int)3, (int)4));
        Assertions.assertEquals((Object)"ffffedcba098765432ffffff", (Object)Conversion.longToHex((long)1311768467294899695L, (int)0, (String)"ffffffffffffffffffffffff", (int)3, (int)15));
        Assertions.assertEquals((Object)"ffffedcba0987654321fffff", (Object)Conversion.longToHex((long)1311768467294899695L, (int)0, (String)"ffffffffffffffffffffffff", (int)3, (int)16));
        Assertions.assertEquals((Object)"7fffffffffffffffffffffff", (Object)Conversion.longToHex((long)1311768467294899695L, (int)1, (String)"ffffffffffffffffffffffff", (int)0, (int)1));
        Assertions.assertEquals((Object)"bfffffffffffffffffffffff", (Object)Conversion.longToHex((long)1311768467294899695L, (int)2, (String)"ffffffffffffffffffffffff", (int)0, (int)1));
        Assertions.assertEquals((Object)"fffdb975121fca86420fffff", (Object)Conversion.longToHex((long)1311768467294899695L, (int)3, (String)"ffffffffffffffffffffffff", (int)3, (int)16));
        Assertions.assertEquals((Object)"fffedcba0987654321ffffff", (Object)Conversion.longToHex((long)1311768467294899695L, (int)4, (String)"ffffffffffffffffffffffff", (int)3, (int)15));
        Assertions.assertEquals((Object)"fedcba0987654321", (Object)Conversion.longToHex((long)1311768467294899695L, (int)0, (String)"", (int)0, (int)16));
        Assertions.assertThrows(StringIndexOutOfBoundsException.class, () -> Conversion.longToHex((long)1311768467294899695L, (int)0, (String)"", (int)1, (int)8));
    }

    @Test
    public void testIntToHex() {
        Assertions.assertEquals((Object)"", (Object)Conversion.intToHex((int)0, (int)0, (String)"", (int)0, (int)0));
        Assertions.assertEquals((Object)"", (Object)Conversion.intToHex((int)0, (int)100, (String)"", (int)0, (int)0));
        Assertions.assertEquals((Object)"", (Object)Conversion.intToHex((int)0, (int)0, (String)"", (int)100, (int)0));
        Assertions.assertEquals((Object)"ffffffffffffffffffffffff", (Object)Conversion.intToHex((int)-1867788817, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)0));
        Assertions.assertEquals((Object)"3fffffffffffffffffffffff", (Object)Conversion.intToHex((int)-1867788829, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)1));
        Assertions.assertEquals((Object)"feffffffffffffffffffffff", (Object)Conversion.intToHex((int)-1867788817, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)2));
        Assertions.assertEquals((Object)"fedcffffffffffffffffffff", (Object)Conversion.intToHex((int)-1867788817, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)4));
        Assertions.assertEquals((Object)"fedcba0fffffffffffffffff", (Object)Conversion.intToHex((int)-1867788817, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)7));
        Assertions.assertEquals((Object)"fedcba09ffffffffffffffff", (Object)Conversion.intToHex((int)-1867788817, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)8));
        Assertions.assertEquals((Object)"fff3ffffffffffffffffffff", (Object)Conversion.intToHex((int)-1867788829, (int)0, (String)"ffffffffffffffffffffffff", (int)3, (int)1));
        Assertions.assertEquals((Object)"ffffefffffffffffffffffff", (Object)Conversion.intToHex((int)-1867788817, (int)0, (String)"ffffffffffffffffffffffff", (int)3, (int)2));
        Assertions.assertEquals((Object)"ffffedcfffffffffffffffff", (Object)Conversion.intToHex((int)-1867788817, (int)0, (String)"ffffffffffffffffffffffff", (int)3, (int)4));
        Assertions.assertEquals((Object)"ffffedcba0ffffffffffffff", (Object)Conversion.intToHex((int)-1867788817, (int)0, (String)"ffffffffffffffffffffffff", (int)3, (int)7));
        Assertions.assertEquals((Object)"ffffedcba09fffffffffffff", (Object)Conversion.intToHex((int)-1867788817, (int)0, (String)"ffffffffffffffffffffffff", (int)3, (int)8));
        Assertions.assertEquals((Object)"7fffffffffffffffffffffff", (Object)Conversion.intToHex((int)-1867788817, (int)1, (String)"ffffffffffffffffffffffff", (int)0, (int)1));
        Assertions.assertEquals((Object)"bfffffffffffffffffffffff", (Object)Conversion.intToHex((int)-1867788817, (int)2, (String)"ffffffffffffffffffffffff", (int)0, (int)1));
        Assertions.assertEquals((Object)"fffdb97512ffffffffffffff", (Object)Conversion.intToHex((int)-1867788817, (int)3, (String)"ffffffffffffffffffffffff", (int)3, (int)8));
        Assertions.assertEquals((Object)"fffedcba09ffffffffffffff", (Object)Conversion.intToHex((int)-1867788817, (int)4, (String)"ffffffffffffffffffffffff", (int)3, (int)7));
        Assertions.assertEquals((Object)"fedcba09", (Object)Conversion.intToHex((int)-1867788817, (int)0, (String)"", (int)0, (int)8));
        Assertions.assertThrows(StringIndexOutOfBoundsException.class, () -> Conversion.intToHex((int)-1867788817, (int)0, (String)"", (int)1, (int)8));
    }

    @Test
    public void testShortToHex() {
        Assertions.assertEquals((Object)"", (Object)Conversion.shortToHex((short)0, (int)0, (String)"", (int)0, (int)0));
        Assertions.assertEquals((Object)"", (Object)Conversion.shortToHex((short)0, (int)100, (String)"", (int)0, (int)0));
        Assertions.assertEquals((Object)"", (Object)Conversion.shortToHex((short)0, (int)0, (String)"", (int)100, (int)0));
        Assertions.assertEquals((Object)"ffffffffffffffffffffffff", (Object)Conversion.shortToHex((short)-12817, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)0));
        Assertions.assertEquals((Object)"3fffffffffffffffffffffff", (Object)Conversion.shortToHex((short)-12829, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)1));
        Assertions.assertEquals((Object)"feffffffffffffffffffffff", (Object)Conversion.shortToHex((short)-12817, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)2));
        Assertions.assertEquals((Object)"fedfffffffffffffffffffff", (Object)Conversion.shortToHex((short)-12817, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)3));
        Assertions.assertEquals((Object)"fedcffffffffffffffffffff", (Object)Conversion.shortToHex((short)-12817, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)4));
        Assertions.assertEquals((Object)"fff3ffffffffffffffffffff", (Object)Conversion.shortToHex((short)-12829, (int)0, (String)"ffffffffffffffffffffffff", (int)3, (int)1));
        Assertions.assertEquals((Object)"ffffefffffffffffffffffff", (Object)Conversion.shortToHex((short)-12817, (int)0, (String)"ffffffffffffffffffffffff", (int)3, (int)2));
        Assertions.assertEquals((Object)"7fffffffffffffffffffffff", (Object)Conversion.shortToHex((short)-12817, (int)1, (String)"ffffffffffffffffffffffff", (int)0, (int)1));
        Assertions.assertEquals((Object)"bfffffffffffffffffffffff", (Object)Conversion.shortToHex((short)-12817, (int)2, (String)"ffffffffffffffffffffffff", (int)0, (int)1));
        Assertions.assertEquals((Object)"fffdb9ffffffffffffffffff", (Object)Conversion.shortToHex((short)-12817, (int)3, (String)"ffffffffffffffffffffffff", (int)3, (int)4));
        Assertions.assertEquals((Object)"fffedcffffffffffffffffff", (Object)Conversion.shortToHex((short)-12817, (int)4, (String)"ffffffffffffffffffffffff", (int)3, (int)3));
        Assertions.assertEquals((Object)"fedc", (Object)Conversion.shortToHex((short)-12817, (int)0, (String)"", (int)0, (int)4));
        Assertions.assertThrows(StringIndexOutOfBoundsException.class, () -> Conversion.shortToHex((short)-12817, (int)0, (String)"", (int)1, (int)4));
    }

    @Test
    public void testByteToHex() {
        Assertions.assertEquals((Object)"", (Object)Conversion.byteToHex((byte)0, (int)0, (String)"", (int)0, (int)0));
        Assertions.assertEquals((Object)"", (Object)Conversion.byteToHex((byte)0, (int)100, (String)"", (int)0, (int)0));
        Assertions.assertEquals((Object)"", (Object)Conversion.byteToHex((byte)0, (int)0, (String)"", (int)100, (int)0));
        Assertions.assertEquals((Object)"00000", (Object)Conversion.byteToHex((byte)-17, (int)0, (String)"00000", (int)0, (int)0));
        Assertions.assertEquals((Object)"f0000", (Object)Conversion.byteToHex((byte)-17, (int)0, (String)"00000", (int)0, (int)1));
        Assertions.assertEquals((Object)"fe000", (Object)Conversion.byteToHex((byte)-17, (int)0, (String)"00000", (int)0, (int)2));
        Assertions.assertEquals((Object)"000f0", (Object)Conversion.byteToHex((byte)-17, (int)0, (String)"00000", (int)3, (int)1));
        Assertions.assertEquals((Object)"000fe", (Object)Conversion.byteToHex((byte)-17, (int)0, (String)"00000", (int)3, (int)2));
        Assertions.assertEquals((Object)"70000", (Object)Conversion.byteToHex((byte)-17, (int)1, (String)"00000", (int)0, (int)1));
        Assertions.assertEquals((Object)"b0000", (Object)Conversion.byteToHex((byte)-17, (int)2, (String)"00000", (int)0, (int)1));
        Assertions.assertEquals((Object)"000df", (Object)Conversion.byteToHex((byte)-17, (int)3, (String)"00000", (int)3, (int)2));
        Assertions.assertEquals((Object)"000e0", (Object)Conversion.byteToHex((byte)-17, (int)4, (String)"00000", (int)3, (int)1));
        Assertions.assertEquals((Object)"fe", (Object)Conversion.byteToHex((byte)-17, (int)0, (String)"", (int)0, (int)2));
        Assertions.assertThrows(StringIndexOutOfBoundsException.class, () -> Conversion.byteToHex((byte)-17, (int)0, (String)"", (int)1, (int)2));
    }

    @Test
    public void testLongToBinary() {
        Assertions.assertArrayEquals((boolean[])new boolean[0], (boolean[])Conversion.longToBinary((long)0L, (int)0, (boolean[])new boolean[0], (int)0, (int)0));
        Assertions.assertArrayEquals((boolean[])new boolean[0], (boolean[])Conversion.longToBinary((long)0L, (int)100, (boolean[])new boolean[0], (int)0, (int)0));
        Assertions.assertArrayEquals((boolean[])new boolean[0], (boolean[])Conversion.longToBinary((long)0L, (int)0, (boolean[])new boolean[0], (int)100, (int)0));
        Assertions.assertArrayEquals((boolean[])new boolean[69], (boolean[])Conversion.longToBinary((long)1311768467294899695L, (int)0, (boolean[])new boolean[69], (int)0, (int)0));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, (boolean[])Conversion.longToBinary((long)1311768467294899695L, (int)0, (boolean[])new boolean[69], (int)0, (int)1));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, (boolean[])Conversion.longToBinary((long)1311768467294899695L, (int)0, (boolean[])new boolean[69], (int)0, (int)2));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, (boolean[])Conversion.longToBinary((long)1311768467294899695L, (int)0, (boolean[])new boolean[69], (int)0, (int)3));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, true, true, false, true, true, true, true, false, true, true, false, false, true, true, true, true, false, true, false, true, false, true, false, false, false, false, true, false, false, true, false, false, false, true, true, true, true, false, false, true, true, false, true, false, true, false, false, false, true, false, true, true, false, false, false, true, false, false, true, false, false, false, false, false, false, false, false}, (boolean[])Conversion.longToBinary((long)1311768467294899695L, (int)0, (boolean[])new boolean[69], (int)0, (int)63));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, true, true, false, true, true, true, true, false, true, true, false, false, true, true, true, true, false, true, false, true, false, true, false, false, false, false, true, false, false, true, false, false, false, true, true, true, true, false, false, true, true, false, true, false, true, false, false, false, true, false, true, true, false, false, false, true, false, false, true, false, false, false, false, false, false, false, false}, (boolean[])Conversion.longToBinary((long)1311768467294899695L, (int)0, (boolean[])new boolean[69], (int)0, (int)64));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, (boolean[])Conversion.longToBinary((long)1311768467294899695L, (int)0, (boolean[])new boolean[69], (int)2, (int)1));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, true, true, true, true, false, true, true, true, true, false, true, true, false, false, true, true, true, true, false, true, false, true, false, true, false, false, false, false, true, false, false, true, false, false, false, true, true, true, true, false, false, true, true, false, true, false, true, false, false, false, true, false, true, true, false, false, false, true, false, false, true, false, false, false, false, false, false}, (boolean[])Conversion.longToBinary((long)1311768467294899695L, (int)0, (boolean[])new boolean[69], (int)2, (int)64));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, true, false, true, true, true, true, false, true, true, false, false, true, true, true, true, false, true, false, true, false, true, false, false, false, false, true, false, false, true, false, false, false, true, true, true, true, false, false, true, true, false, true, false, true, false, false, false, true, false, true, true, false, false, false, true, false, false, true, false, false, false, false, false, false, false, false, false}, (boolean[])Conversion.longToBinary((long)1311768467294899695L, (int)1, (boolean[])new boolean[69], (int)0, (int)63));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, false, true, true, true, true, false, true, true, false, false, true, true, true, true, false, true, false, true, false, true, false, false, false, false, true, false, false, true, false, false, false, true, true, true, true, false, false, true, true, false, true, false, true, false, false, false, true, false, true, true, false, false, false, true, false, false, true, false, false, false, false, false, false, false, false, false, false}, (boolean[])Conversion.longToBinary((long)1311768467294899695L, (int)2, (boolean[])new boolean[69], (int)0, (int)62));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, false, true, true, false, true, true, true, true, false, true, true, false, false, true, true, true, true, false, true, false, true, false, true, false, false, false, false, true, false, false, true, false, false, false, true, true, true, true, false, false, true, true, false, true, false, true, false, false, false, true, false, true, true, false, false, false, true, false, false, true, false, false, false, false, false, false, false}, (boolean[])Conversion.longToBinary((long)1311768467294899695L, (int)2, (boolean[])new boolean[69], (int)3, (int)62));
    }

    @Test
    public void testIntToBinary() {
        Assertions.assertArrayEquals((boolean[])new boolean[0], (boolean[])Conversion.intToBinary((int)0, (int)0, (boolean[])new boolean[0], (int)0, (int)0));
        Assertions.assertArrayEquals((boolean[])new boolean[0], (boolean[])Conversion.intToBinary((int)0, (int)100, (boolean[])new boolean[0], (int)0, (int)0));
        Assertions.assertArrayEquals((boolean[])new boolean[0], (boolean[])Conversion.intToBinary((int)0, (int)0, (boolean[])new boolean[0], (int)100, (int)0));
        Assertions.assertArrayEquals((boolean[])new boolean[69], (boolean[])Conversion.intToBinary((int)-1867788817, (int)0, (boolean[])new boolean[69], (int)0, (int)0));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, (boolean[])Conversion.intToBinary((int)-1867788817, (int)0, (boolean[])new boolean[37], (int)0, (int)1));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, (boolean[])Conversion.intToBinary((int)-1867788817, (int)0, (boolean[])new boolean[37], (int)0, (int)2));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, (boolean[])Conversion.intToBinary((int)-1867788817, (int)0, (boolean[])new boolean[37], (int)0, (int)3));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, true, true, false, true, true, true, true, false, true, true, false, false, true, true, true, true, false, true, false, true, false, true, false, false, false, false, true, false, false, false, false, false, false, false, false}, (boolean[])Conversion.intToBinary((int)-1867788817, (int)0, (boolean[])new boolean[37], (int)0, (int)31));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, true, true, false, true, true, true, true, false, true, true, false, false, true, true, true, true, false, true, false, true, false, true, false, false, false, false, true, false, false, true, false, false, false, false, false}, (boolean[])Conversion.intToBinary((int)-1867788817, (int)0, (boolean[])new boolean[37], (int)0, (int)32));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, (boolean[])Conversion.intToBinary((int)-1867788817, (int)0, (boolean[])new boolean[37], (int)2, (int)1));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, true, true, true, true, false, true, true, true, true, false, true, true, false, false, true, true, true, true, false, true, false, true, false, true, false, false, false, false, true, false, false, true, false, false, false}, (boolean[])Conversion.intToBinary((int)-1867788817, (int)0, (boolean[])new boolean[37], (int)2, (int)32));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, true, false, true, true, true, true, false, true, true, false, false, true, true, true, true, false, true, false, true, false, true, false, false, false, false, true, false, false, true, false, false, false, false, false, false}, (boolean[])Conversion.intToBinary((int)-1867788817, (int)1, (boolean[])new boolean[37], (int)0, (int)31));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, false, true, true, true, true, false, true, true, false, false, true, true, true, true, false, true, false, true, false, true, false, false, false, false, true, false, false, true, false, false, false, false, false, false, false}, (boolean[])Conversion.intToBinary((int)-1867788817, (int)2, (boolean[])new boolean[37], (int)0, (int)30));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, false, true, true, false, true, true, true, true, false, true, true, false, false, true, true, true, true, false, true, false, true, false, true, false, false, false, false, true, false, false, true, false, false, false, false}, (boolean[])Conversion.intToBinary((int)-1867788817, (int)2, (boolean[])new boolean[37], (int)3, (int)30));
    }

    @Test
    public void testShortToBinary() {
        Assertions.assertArrayEquals((boolean[])new boolean[0], (boolean[])Conversion.shortToBinary((short)0, (int)0, (boolean[])new boolean[0], (int)0, (int)0));
        Assertions.assertArrayEquals((boolean[])new boolean[0], (boolean[])Conversion.shortToBinary((short)0, (int)100, (boolean[])new boolean[0], (int)0, (int)0));
        Assertions.assertArrayEquals((boolean[])new boolean[0], (boolean[])Conversion.shortToBinary((short)0, (int)0, (boolean[])new boolean[0], (int)100, (int)0));
        Assertions.assertArrayEquals((boolean[])new boolean[69], (boolean[])Conversion.shortToBinary((short)-12817, (int)0, (boolean[])new boolean[69], (int)0, (int)0));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, (boolean[])Conversion.shortToBinary((short)-12817, (int)0, (boolean[])new boolean[21], (int)0, (int)1));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, (boolean[])Conversion.shortToBinary((short)-12817, (int)0, (boolean[])new boolean[21], (int)0, (int)2));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, (boolean[])Conversion.shortToBinary((short)-12817, (int)0, (boolean[])new boolean[21], (int)0, (int)3));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, true, true, false, true, true, true, true, false, true, true, false, false, true, false, false, false, false, false, false}, (boolean[])Conversion.shortToBinary((short)-12817, (int)0, (boolean[])new boolean[21], (int)0, (int)15));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, true, true, false, true, true, true, true, false, true, true, false, false, true, true, false, false, false, false, false}, (boolean[])Conversion.shortToBinary((short)-12817, (int)0, (boolean[])new boolean[21], (int)0, (int)16));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, (boolean[])Conversion.shortToBinary((short)-12817, (int)0, (boolean[])new boolean[21], (int)2, (int)1));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, true, true, true, true, false, true, true, true, true, false, true, true, false, false, true, true, false, false, false}, (boolean[])Conversion.shortToBinary((short)-12817, (int)0, (boolean[])new boolean[21], (int)2, (int)16));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, true, false, true, true, true, true, false, true, true, false, false, true, true, false, false, false, false, false, false}, (boolean[])Conversion.shortToBinary((short)-12817, (int)1, (boolean[])new boolean[21], (int)0, (int)15));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, false, true, true, true, true, false, true, true, false, false, true, true, false, false, false, false, false, false, false}, (boolean[])Conversion.shortToBinary((short)-12817, (int)2, (boolean[])new boolean[21], (int)0, (int)14));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, false, true, true, false, true, true, true, true, false, true, true, false, false, true, true, false, false, false, false}, (boolean[])Conversion.shortToBinary((short)-12817, (int)2, (boolean[])new boolean[21], (int)3, (int)14));
    }

    @Test
    public void testByteToBinary() {
        Assertions.assertArrayEquals((boolean[])new boolean[0], (boolean[])Conversion.byteToBinary((byte)0, (int)0, (boolean[])new boolean[0], (int)0, (int)0));
        Assertions.assertArrayEquals((boolean[])new boolean[0], (boolean[])Conversion.byteToBinary((byte)0, (int)100, (boolean[])new boolean[0], (int)0, (int)0));
        Assertions.assertArrayEquals((boolean[])new boolean[0], (boolean[])Conversion.byteToBinary((byte)0, (int)0, (boolean[])new boolean[0], (int)100, (int)0));
        Assertions.assertArrayEquals((boolean[])new boolean[69], (boolean[])Conversion.byteToBinary((byte)-17, (int)0, (boolean[])new boolean[69], (int)0, (int)0));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, false, false, false, false, false, false, false, false, false, false, false}, (boolean[])Conversion.byteToBinary((byte)-107, (int)0, (boolean[])new boolean[13], (int)0, (int)1));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, false, false, false, false, false, false, false, false, false, false, false}, (boolean[])Conversion.byteToBinary((byte)-107, (int)0, (boolean[])new boolean[13], (int)0, (int)2));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, true, false, false, false, false, false, false, false, false, false, false}, (boolean[])Conversion.byteToBinary((byte)-107, (int)0, (boolean[])new boolean[13], (int)0, (int)3));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, true, false, true, false, false, false, false, false, false, false, false}, (boolean[])Conversion.byteToBinary((byte)-107, (int)0, (boolean[])new boolean[13], (int)0, (int)7));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, true, false, true, false, false, true, false, false, false, false, false}, (boolean[])Conversion.byteToBinary((byte)-107, (int)0, (boolean[])new boolean[13], (int)0, (int)8));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, true, false, false, false, false, false, false, false, false, false, false}, (boolean[])Conversion.byteToBinary((byte)-107, (int)0, (boolean[])new boolean[13], (int)2, (int)1));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, true, false, true, false, true, false, false, true, false, false, false}, (boolean[])Conversion.byteToBinary((byte)-107, (int)0, (boolean[])new boolean[13], (int)2, (int)8));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, true, false, true, false, false, true, false, false, false, false, false, false}, (boolean[])Conversion.byteToBinary((byte)-107, (int)1, (boolean[])new boolean[13], (int)0, (int)7));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, true, false, false, true, false, false, false, false, false, false, false}, (boolean[])Conversion.byteToBinary((byte)-107, (int)2, (boolean[])new boolean[13], (int)0, (int)6));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, false, true, false, true, false, false, true, false, false, false, false}, (boolean[])Conversion.byteToBinary((byte)-107, (int)2, (boolean[])new boolean[13], (int)3, (int)6));
    }

    @Test
    public void testUuidToByteArray() {
        Assertions.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.uuidToByteArray((UUID)new UUID(-1L, -1L), (byte[])new byte[16], (int)0, (int)16));
        Assertions.assertArrayEquals((byte[])new byte[]{-120, -103, -86, -69, -52, -35, -18, -1, 0, 17, 34, 51, 68, 85, 102, 119}, (byte[])Conversion.uuidToByteArray((UUID)new UUID(-4822678189205112L, 8603657889541918976L), (byte[])new byte[16], (int)0, (int)16));
        Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, -120, -103, -86, -69, -52, -35, -18, -1, 0, 0, 0, 0}, (byte[])Conversion.uuidToByteArray((UUID)new UUID(-4822678189205112L, 8603657889541918976L), (byte[])new byte[16], (int)4, (int)8));
        Assertions.assertArrayEquals((byte[])new byte[]{0, 0, -120, -103, -86, -69, -52, -35, -18, -1, 0, 17, 34, 51, 0, 0}, (byte[])Conversion.uuidToByteArray((UUID)new UUID(-4822678189205112L, 8603657889541918976L), (byte[])new byte[16], (int)2, (int)12));
    }

    @Test
    public void testByteArrayToUuid() {
        Assertions.assertEquals((Object)new UUID(-1L, -1L), (Object)Conversion.byteArrayToUuid((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0));
        Assertions.assertEquals((Object)new UUID(-4822678189205112L, 8603657889541918976L), (Object)Conversion.byteArrayToUuid((byte[])new byte[]{-120, -103, -86, -69, -52, -35, -18, -1, 0, 17, 34, 51, 68, 85, 102, 119}, (int)0));
        Assertions.assertEquals((Object)new UUID(-4822678189205112L, 8603657889541918976L), (Object)Conversion.byteArrayToUuid((byte[])new byte[]{0, 0, -120, -103, -86, -69, -52, -35, -18, -1, 0, 17, 34, 51, 68, 85, 102, 119}, (int)2));
    }
}

