/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FastDateParser_MoreOrLessTest {
    private static final TimeZone NEW_YORK = TimeZone.getTimeZone("America/New_York");

    @Test
    public void testInputHasPrecedingCharacters() {
        FastDateParser parser = new FastDateParser("MM/dd", TimeZone.getDefault(), Locale.getDefault());
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = parser.parse("A 3/23/61", parsePosition);
        Assertions.assertNull((Object)date);
        Assertions.assertEquals((int)0, (int)parsePosition.getIndex());
        Assertions.assertEquals((int)0, (int)parsePosition.getErrorIndex());
    }

    @Test
    public void testInputHasWhitespace() {
        FastDateParser parser = new FastDateParser("M/d/y", TimeZone.getDefault(), Locale.getDefault());
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = parser.parse(" 3/ 23/ 1961", parsePosition);
        Assertions.assertEquals((int)12, (int)parsePosition.getIndex());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Assertions.assertEquals((int)1961, (int)calendar.get(1));
        Assertions.assertEquals((int)2, (int)calendar.get(2));
        Assertions.assertEquals((int)23, (int)calendar.get(5));
    }

    @Test
    public void testInputHasMoreCharacters() {
        FastDateParser parser = new FastDateParser("MM/dd", TimeZone.getDefault(), Locale.getDefault());
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = parser.parse("3/23/61", parsePosition);
        Assertions.assertEquals((int)4, (int)parsePosition.getIndex());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Assertions.assertEquals((int)2, (int)calendar.get(2));
        Assertions.assertEquals((int)23, (int)calendar.get(5));
    }

    @Test
    public void testInputHasWrongCharacters() {
        FastDateParser parser = new FastDateParser("MM-dd-yyy", TimeZone.getDefault(), Locale.getDefault());
        ParsePosition parsePosition = new ParsePosition(0);
        Assertions.assertNull((Object)parser.parse("03/23/1961", parsePosition));
        Assertions.assertEquals((int)2, (int)parsePosition.getErrorIndex());
    }

    @Test
    public void testInputHasLessCharacters() {
        FastDateParser parser = new FastDateParser("MM/dd/yyy", TimeZone.getDefault(), Locale.getDefault());
        ParsePosition parsePosition = new ParsePosition(0);
        Assertions.assertNull((Object)parser.parse("03/23", parsePosition));
        Assertions.assertEquals((int)5, (int)parsePosition.getErrorIndex());
    }

    @Test
    public void testInputHasWrongTimeZone() {
        FastDateParser parser = new FastDateParser("mm:ss z", NEW_YORK, Locale.US);
        String input = "11:23 Pacific Standard Time";
        ParsePosition parsePosition = new ParsePosition(0);
        Assertions.assertNotNull((Object)parser.parse("11:23 Pacific Standard Time", parsePosition));
        Assertions.assertEquals((int)"11:23 Pacific Standard Time".length(), (int)parsePosition.getIndex());
        parsePosition.setIndex(0);
        Assertions.assertNull((Object)parser.parse("11:23 Pacific Standard ", parsePosition));
        Assertions.assertEquals((int)6, (int)parsePosition.getErrorIndex());
    }

    @Test
    public void testInputHasWrongDay() {
        FastDateParser parser = new FastDateParser("EEEE, MM/dd/yyy", NEW_YORK, Locale.US);
        String input = "Thursday, 03/23/61";
        ParsePosition parsePosition = new ParsePosition(0);
        Assertions.assertNotNull((Object)parser.parse("Thursday, 03/23/61", parsePosition));
        Assertions.assertEquals((int)"Thursday, 03/23/61".length(), (int)parsePosition.getIndex());
        parsePosition.setIndex(0);
        Assertions.assertNull((Object)parser.parse("Thorsday, 03/23/61", parsePosition));
        Assertions.assertEquals((int)0, (int)parsePosition.getErrorIndex());
    }
}

