/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.tuple;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MutableTripleTest {
    @Test
    public void testBasic() {
        MutableTriple triple = new MutableTriple((Object)0, (Object)"foo", (Object)Boolean.FALSE);
        Assertions.assertEquals((int)0, (int)((Integer)triple.getLeft()));
        Assertions.assertEquals((Object)"foo", (Object)triple.getMiddle());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)triple.getRight());
        MutableTriple triple2 = new MutableTriple(null, (Object)"bar", (Object)"hello");
        Assertions.assertNull((Object)triple2.getLeft());
        Assertions.assertEquals((Object)"bar", (Object)triple2.getMiddle());
        Assertions.assertEquals((Object)"hello", (Object)triple2.getRight());
    }

    @Test
    public void testDefault() {
        MutableTriple triple = new MutableTriple();
        Assertions.assertNull((Object)triple.getLeft());
        Assertions.assertNull((Object)triple.getMiddle());
        Assertions.assertNull((Object)triple.getRight());
    }

    @Test
    public void testMutate() {
        MutableTriple triple = new MutableTriple((Object)0, (Object)"foo", (Object)Boolean.TRUE);
        triple.setLeft((Object)42);
        triple.setMiddle((Object)"bar");
        triple.setRight((Object)Boolean.FALSE);
        Assertions.assertEquals((int)42, (int)((Integer)triple.getLeft()));
        Assertions.assertEquals((Object)"bar", (Object)triple.getMiddle());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)triple.getRight());
    }

    @Test
    public void testTripleOf() {
        MutableTriple triple = MutableTriple.of((Object)0, (Object)"foo", (Object)Boolean.TRUE);
        Assertions.assertEquals((int)0, (int)((Integer)triple.getLeft()));
        Assertions.assertEquals((Object)"foo", (Object)triple.getMiddle());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)triple.getRight());
        MutableTriple triple2 = MutableTriple.of(null, (Object)"bar", (Object)"hello");
        Assertions.assertNull((Object)triple2.getLeft());
        Assertions.assertEquals((Object)"bar", (Object)triple2.getMiddle());
        Assertions.assertEquals((Object)"hello", (Object)triple2.getRight());
    }

    @Test
    public void testEquals() {
        Assertions.assertEquals((Object)MutableTriple.of(null, (Object)"foo", (Object)"baz"), (Object)MutableTriple.of(null, (Object)"foo", (Object)"baz"));
        Assertions.assertNotEquals((Object)MutableTriple.of((Object)"foo", (Object)0, (Object)Boolean.TRUE), (Object)MutableTriple.of((Object)"foo", null, (Object)Boolean.TRUE));
        Assertions.assertNotEquals((Object)MutableTriple.of((Object)"foo", (Object)"bar", (Object)"baz"), (Object)MutableTriple.of((Object)"xyz", (Object)"bar", (Object)"baz"));
        Assertions.assertNotEquals((Object)MutableTriple.of((Object)"foo", (Object)"bar", (Object)"baz"), (Object)MutableTriple.of((Object)"foo", (Object)"bar", (Object)"blo"));
        MutableTriple p = MutableTriple.of((Object)"foo", (Object)"bar", (Object)"baz");
        Assertions.assertEquals((Object)p, (Object)p);
        Assertions.assertNotEquals((Object)p, (Object)new Object());
    }

    @Test
    public void testHashCode() {
        Assertions.assertEquals((int)MutableTriple.of(null, (Object)"foo", (Object)"baz").hashCode(), (int)MutableTriple.of(null, (Object)"foo", (Object)"baz").hashCode());
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"(null,null,null)", (Object)MutableTriple.of(null, null, null).toString());
        Assertions.assertEquals((Object)"(null,two,null)", (Object)MutableTriple.of(null, (Object)"two", null).toString());
        Assertions.assertEquals((Object)"(one,null,null)", (Object)MutableTriple.of((Object)"one", null, null).toString());
        Assertions.assertEquals((Object)"(one,two,null)", (Object)MutableTriple.of((Object)"one", (Object)"two", null).toString());
        Assertions.assertEquals((Object)"(null,two,three)", (Object)MutableTriple.of(null, (Object)"two", (Object)"three").toString());
        Assertions.assertEquals((Object)"(one,null,three)", (Object)MutableTriple.of((Object)"one", null, (Object)"three").toString());
        Assertions.assertEquals((Object)"(one,two,three)", (Object)MutableTriple.of((Object)"one", (Object)"two", (Object)"three").toString());
    }

    @Test
    public void testSerialization() throws Exception {
        MutableTriple origTriple = MutableTriple.of((Object)0, (Object)"foo", (Object)Boolean.TRUE);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(origTriple);
        MutableTriple deserializedTriple = (MutableTriple)new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
        Assertions.assertEquals((Object)origTriple, (Object)deserializedTriple);
        Assertions.assertEquals((int)origTriple.hashCode(), (int)deserializedTriple.hashCode());
    }
}

