/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.tuple;

import java.util.Calendar;
import java.util.HashSet;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TripleTest {
    @Test
    public void testTripleOf() {
        Triple triple = Triple.of((Object)0, (Object)"foo", (Object)Boolean.TRUE);
        Assertions.assertTrue((boolean)(triple instanceof ImmutableTriple));
        Assertions.assertEquals((int)0, (int)((Integer)((ImmutableTriple)triple).left));
        Assertions.assertEquals((Object)"foo", (Object)((ImmutableTriple)triple).middle);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)((ImmutableTriple)triple).right);
        Triple triple2 = Triple.of(null, (Object)"bar", (Object)200L);
        Assertions.assertTrue((boolean)(triple2 instanceof ImmutableTriple));
        Assertions.assertNull((Object)((ImmutableTriple)triple2).left);
        Assertions.assertEquals((Object)"bar", (Object)((ImmutableTriple)triple2).middle);
        Assertions.assertEquals((Long)new Long(200L), (Long)((Long)((ImmutableTriple)triple2).right));
    }

    @Test
    public void testCompatibilityBetweenTriples() {
        ImmutableTriple triple = ImmutableTriple.of((Object)0, (Object)"foo", (Object)Boolean.TRUE);
        MutableTriple triple2 = MutableTriple.of((Object)0, (Object)"foo", (Object)Boolean.TRUE);
        Assertions.assertEquals((Object)triple, (Object)triple2);
        Assertions.assertEquals((int)triple.hashCode(), (int)triple2.hashCode());
        HashSet<ImmutableTriple> set = new HashSet<ImmutableTriple>();
        set.add(triple);
        Assertions.assertTrue((boolean)set.contains(triple2));
    }

    @Test
    public void testComparable1() {
        Triple triple1 = Triple.of((Object)"A", (Object)"D", (Object)"A");
        Triple triple2 = Triple.of((Object)"B", (Object)"C", (Object)"A");
        Assertions.assertEquals((int)0, (int)triple1.compareTo(triple1));
        Assertions.assertTrue((triple1.compareTo(triple2) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)triple2.compareTo(triple2));
        Assertions.assertTrue((triple2.compareTo(triple1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testComparable2() {
        Triple triple1 = Triple.of((Object)"A", (Object)"C", (Object)"B");
        Triple triple2 = Triple.of((Object)"A", (Object)"D", (Object)"B");
        Assertions.assertEquals((int)0, (int)triple1.compareTo(triple1));
        Assertions.assertTrue((triple1.compareTo(triple2) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)triple2.compareTo(triple2));
        Assertions.assertTrue((triple2.compareTo(triple1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testComparable3() {
        Triple triple1 = Triple.of((Object)"A", (Object)"A", (Object)"D");
        Triple triple2 = Triple.of((Object)"A", (Object)"B", (Object)"C");
        Assertions.assertEquals((int)0, (int)triple1.compareTo(triple1));
        Assertions.assertTrue((triple1.compareTo(triple2) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)triple2.compareTo(triple2));
        Assertions.assertTrue((triple2.compareTo(triple1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testComparable4() {
        Triple triple1 = Triple.of((Object)"B", (Object)"A", (Object)"C");
        Triple triple2 = Triple.of((Object)"B", (Object)"A", (Object)"D");
        Assertions.assertEquals((int)0, (int)triple1.compareTo(triple1));
        Assertions.assertTrue((triple1.compareTo(triple2) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)triple2.compareTo(triple2));
        Assertions.assertTrue((triple2.compareTo(triple1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        Triple triple = Triple.of((Object)"Key", (Object)"Something", (Object)"Value");
        Assertions.assertEquals((Object)"(Key,Something,Value)", (Object)triple.toString());
    }

    @Test
    public void testToStringCustom() {
        Calendar date = Calendar.getInstance();
        date.set(2011, 3, 25);
        Triple triple = Triple.of((Object)"DOB", (Object)"string", (Object)date);
        Assertions.assertEquals((Object)"Test created on 04-25-2011", (Object)triple.toString("Test created on %3$tm-%3$td-%3$tY"));
    }

    @Test
    public void testFormattable_simple() {
        Triple triple = Triple.of((Object)"Key", (Object)"Something", (Object)"Value");
        Assertions.assertEquals((Object)"(Key,Something,Value)", (Object)String.format("%1$s", triple));
    }

    @Test
    public void testFormattable_padded() {
        Triple triple = Triple.of((Object)"Key", (Object)"Something", (Object)"Value");
        Assertions.assertEquals((Object)"         (Key,Something,Value)", (Object)String.format("%1$30s", triple));
    }
}

