/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

class CharRange {
    private static char UNSET;
    private char start;
    private char close;
    private boolean negated;

    public char getStart() {
        return this.start;
    }

    public char getEnd() {
        return this.close;
    }

    public void setStart(char ch) {
        this.start = ch;
    }

    public void setEnd(char ch) {
        this.close = ch;
    }

    public boolean isRange() {
        return this.close != UNSET;
    }

    public boolean inRange(char ch) {
        if (this.isRange()) {
            return ch >= this.start && ch <= this.close;
        }
        return this.start == ch;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public void setNegated(boolean negated) {
        this.negated = negated;
    }

    public String toString() {
        String str = "";
        if (this.isNegated()) {
            str = str + "^";
        }
        str = str + this.start;
        if (this.isRange()) {
            str = str + "-";
            str = str + this.close;
        }
        return str;
    }

    public CharRange(char start) {
        this.start = start;
    }

    public CharRange(char start, char close) {
        this.start = start;
        this.close = close;
    }

    public CharRange(String start, String close) {
        this.start = start.charAt(0);
        this.close = close.charAt(0);
    }
}

