/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.enum;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.enum.Enum;

public abstract class ValuedEnum
extends Enum {
    private final int iValue;

    protected static Enum getEnum(Class enumClass, int value) {
        if (enumClass == null) {
            throw new IllegalArgumentException("The Enum Class must not be null");
        }
        List list = Enum.getEnumList(enumClass);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            ValuedEnum valuedEnum = (ValuedEnum)it.next();
            if (valuedEnum.getValue() != value) continue;
            return valuedEnum;
        }
        return null;
    }

    public final int getValue() {
        return this.iValue;
    }

    public int compareTo(Object other) {
        return this.iValue - ((ValuedEnum)other).iValue;
    }

    public String toString() {
        String shortName = this.getClass().getName();
        int pos = shortName.lastIndexOf(46);
        if (pos != -1) {
            shortName = shortName.substring(pos + 1);
        }
        return shortName + "[" + this.getName() + "=" + this.getValue() + "]";
    }

    protected ValuedEnum(String name, int value) {
        super(name);
        this.iValue = value;
    }
}

