/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jdom.Verifier;
import org.jdom.output.XMLOutputter;

public class Comment
implements Serializable,
Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: Comment.java,v $ $Revision: 1.17 $ $Date: 2001/05/08 22:23:55 $ $Name: jdom_1_0_b7_rc4 $";
    protected String text;
    protected Element parent;
    protected Document document;

    protected Comment() {
    }

    public Comment(String text) {
        this.setText(text);
    }

    public Object clone() {
        Comment comment = null;
        try {
            comment = (Comment)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        comment.parent = null;
        comment.document = null;
        return comment;
    }

    public Comment detach() {
        Element p = this.getParent();
        if (p != null) {
            p.removeContent(this);
        } else {
            Document d = this.getDocument();
            if (d != null) {
                d.removeContent(this);
            }
        }
        return this;
    }

    public final boolean equals(Object ob) {
        return ob == this;
    }

    public Document getDocument() {
        if (this.document != null) {
            return this.document;
        }
        Element p = this.getParent();
        if (p != null) {
            return p.getDocument();
        }
        return null;
    }

    public Element getParent() {
        return this.parent;
    }

    public final String getSerializedForm() {
        return "<!--" + this.text + "-->";
    }

    public String getText() {
        return this.text;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    protected Comment setDocument(Document document) {
        this.document = document;
        return this;
    }

    protected Comment setParent(Element parent) {
        this.parent = parent;
        return this;
    }

    public Comment setText(String text) {
        String reason = Verifier.checkCommentData(text);
        if (reason != null) {
            throw new IllegalDataException(text, "comment", reason);
        }
        this.text = text;
        return this;
    }

    public String toString() {
        return "[Comment: " + new XMLOutputter().outputString(this) + "]";
    }
}

