/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.latka;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.latka.AbstractReporter;
import org.apache.commons.latka.LatkaException;
import org.apache.commons.latka.LatkaProperties;
import org.apache.commons.latka.Suite;
import org.apache.commons.latka.XMLReporter;
import org.apache.commons.latka.event.LatkaEventInfo;
import org.apache.commons.latka.xml.SuiteHandler;
import org.apache.commons.latka.xml.XMLPreprocessor;
import org.apache.log4j.Category;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Latka {
    protected boolean _isValidating = true;
    protected URL _reportStylesheetUrl = null;
    protected static Category _log = Category.getInstance((String)(class$org$apache$commons$latka$Latka == null ? (class$org$apache$commons$latka$Latka = Latka.class$("org.apache.commons.latka.Latka")) : class$org$apache$commons$latka$Latka).getName());
    protected Properties _props = LatkaProperties.getProperties();
    protected static String LATKA_USAGE = null;
    static /* synthetic */ Class class$org$apache$commons$latka$Latka;

    public void runTests(Suite suite, LatkaEventInfo latkaEventInfo) throws LatkaException {
        InputSource inputSource = null;
        try {
            XMLPreprocessor xMLPreprocessor = new XMLPreprocessor();
            Reader reader = null;
            reader = suite.getReader() != null ? xMLPreprocessor.preprocessXml(suite.getReader()) : xMLPreprocessor.preprocessXml(suite.getURL());
            inputSource = new InputSource(reader);
            if (suite.getURL() != null) {
                inputSource.setSystemId(suite.getURL().toString());
            }
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(this._isValidating);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            SuiteHandler suiteHandler = new SuiteHandler(sAXParser.getXMLReader(), latkaEventInfo);
            sAXParser.parse(inputSource, (DefaultHandler)suiteHandler);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new LatkaException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new LatkaException(sAXException);
        }
        catch (IOException iOException) {
            throw new LatkaException(iOException);
        }
    }

    public void setValidating(boolean bl) {
        this._isValidating = bl;
    }

    public void setReportStylesheet(URL uRL) {
        this._reportStylesheetUrl = uRL;
    }

    protected void _logXML(String string) throws IOException {
        String string2 = this._props.getProperty("latka.writeLog");
        if (string2 != null && string2.equals("false")) {
            return;
        }
        File file = new File("logs");
        file.mkdirs();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd'-'HHmm");
        Date date = new Date();
        String string3 = simpleDateFormat.format(date);
        File file2 = new File(file, string3 + ".xml");
        FileWriter fileWriter = new FileWriter(file2);
        fileWriter.write(string);
        fileWriter.close();
    }

    public String transformXML(String string) throws LatkaException {
        try {
            Object object;
            StringWriter stringWriter = new StringWriter();
            StreamSource streamSource = null;
            if (this._reportStylesheetUrl == null) {
                object = Thread.currentThread().getContextClassLoader();
                streamSource = new StreamSource(((ClassLoader)object).getResourceAsStream("org.apache.commons.latka.report.xsl"));
            } else {
                streamSource = new StreamSource(this._reportStylesheetUrl.toString());
            }
            object = TransformerFactory.newInstance().newTransformer(streamSource);
            StreamSource streamSource2 = new StreamSource(new StringReader(string));
            StreamResult streamResult = new StreamResult(stringWriter);
            ((Transformer)object).transform(streamSource2, streamResult);
            return stringWriter.toString();
        }
        catch (TransformerException transformerException) {
            throw new LatkaException(transformerException);
        }
    }

    protected void runCommandLine(String[] stringArray) throws LatkaException {
        Object object;
        Object object2;
        Object object3;
        if (stringArray.length < 1) {
            System.out.println(LATKA_USAGE);
        }
        String string = stringArray[0];
        if (stringArray.length > 1) {
            int n = 1;
            while (n < stringArray.length) {
                object3 = stringArray[n];
                if (((String)object3).startsWith("prop:")) {
                    object2 = ((String)object3).substring(5, ((String)object3).indexOf("="));
                    object = ((String)object3).substring(((String)object3).indexOf("=") + 1);
                    this._props.setProperty((String)object2, (String)object);
                } else if (((String)object3).startsWith("propfile:")) {
                    try {
                        this._props.load(new FileInputStream(((String)object3).substring(9)));
                    }
                    catch (IOException iOException) {
                        System.out.println("Could not load user prop file, uri=" + ((String)object3).substring(9));
                    }
                } else {
                    throw new IllegalArgumentException(LATKA_USAGE);
                }
                ++n;
            }
        }
        String string2 = null;
        object3 = new XMLReporter();
        try {
            object2 = new URL(string);
            object = new Suite((URL)object2);
            this.runTests((Suite)object, (LatkaEventInfo)object3);
            string2 = ((XMLReporter)object3).getDocumentAsString();
            this._logXML(string2);
        }
        catch (IOException iOException) {
            throw new LatkaException(iOException);
        }
        System.out.println(this.transformXML(string2));
        if (!((AbstractReporter)object3).didSuiteSucceed()) {
            throw new LatkaException("SUITE FAILED");
        }
    }

    public static void main(String[] stringArray) {
        Latka latka = new Latka();
        try {
            latka.runCommandLine(stringArray);
        }
        catch (LatkaException latkaException) {
            latkaException.printStackTrace();
            LatkaException.printWrappedExceptions(latkaException);
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n######################\n");
        stringBuffer.append("Latka usage:\n");
        stringBuffer.append("  java org.apache.commons.latka.Latka \"XML_suite_URL\" ");
        stringBuffer.append("[\"propfile:file_name\"] [\"prop:prop_name=prop_value\"]\n\n");
        stringBuffer.append("The quotes around properties are REQUIRED.\n");
        stringBuffer.append("######################\n");
        LATKA_USAGE = stringBuffer.toString();
    }
}

