/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.latka;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public class LatkaProperties {
    protected static Properties _initProps = LatkaProperties.loadDefaultProps();
    protected static ThreadLocal _propsThreadLocal = new LatkaThreadLocal(_initProps);

    public static Properties getProperties() {
        return (Properties)_propsThreadLocal.get();
    }

    public static void resetProperties() {
        Properties properties = (Properties)_propsThreadLocal.get();
        ((Hashtable)properties).clear();
        ((Hashtable)properties).putAll(_initProps);
    }

    protected static Properties loadDefaultProps() {
        Properties properties = new Properties();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            properties.load(classLoader.getResourceAsStream("latka.properties.internal"));
        }
        catch (IOException iOException) {
            System.out.println("Couldn't find latka.properties.internal file in the classpath");
        }
        return properties;
    }

    private static class LatkaThreadLocal
    extends ThreadLocal {
        protected Properties _initProps = null;

        public LatkaThreadLocal(Properties properties) {
            this._initProps = properties;
        }

        protected Object initialValue() {
            return ((Hashtable)this._initProps).clone();
        }
    }
}

