/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.latka;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.latka.AbstractReporter;
import org.apache.commons.latka.event.RequestErrorEvent;
import org.apache.commons.latka.event.RequestEvent;
import org.apache.commons.latka.event.RequestFailedEvent;
import org.apache.commons.latka.event.SuiteEvent;

public class SimpleReporter
extends AbstractReporter {
    int _pass = 0;
    int _fail = 0;
    int _err = 0;
    int _skip = 0;
    List _failures = new ArrayList();
    List _errors = new ArrayList();

    public void requestSucceeded(RequestEvent requestEvent) {
        System.out.print(".");
        super.requestSucceeded(requestEvent);
        ++this._pass;
    }

    public void requestFailed(RequestEvent requestEvent) {
        System.out.print("F");
        super.requestFailed(requestEvent);
        ++this._fail;
        this._failures.add(requestEvent);
    }

    public void requestSkipped(RequestEvent requestEvent) {
        System.out.print("s");
        super.requestSkipped(requestEvent);
        ++this._skip;
    }

    public void requestError(RequestEvent requestEvent) {
        System.out.print("E");
        super.requestError(requestEvent);
        ++this._err;
        this._errors.add(requestEvent);
    }

    public void suiteCompleted(SuiteEvent suiteEvent) {
        System.out.println();
        if (this.didSuiteSucceed()) {
            System.out.println("SUITE PASSED");
        } else {
            System.out.println("SUITE FAILED");
        }
        this.printStats();
        if (this.didSuiteSucceed()) {
            System.out.println("SUITE PASSED");
        } else {
            this.maybePrintFailures();
            this.maybePrintErrors();
            System.out.println("SUITE FAILED");
        }
    }

    private void printStats() {
        System.out.println(this._pass + this._fail + this._err + this._skip + " requests run.");
        System.out.println(this._pass + " passed.");
        System.out.println(this._fail + " failed.");
        System.out.println(this._err + " errors.");
        System.out.println(this._skip + " skipped.");
    }

    private void maybePrintFailures() {
        if (!this._failures.isEmpty()) {
            System.out.println();
            System.out.println("Failures:");
            Iterator iterator = this._failures.iterator();
            while (iterator.hasNext()) {
                RequestFailedEvent requestFailedEvent = (RequestFailedEvent)iterator.next();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Request ");
                if (null != requestFailedEvent.getRequest()) {
                    if (null != requestFailedEvent.getRequest().getLabel()) {
                        stringBuffer.append("\"").append(requestFailedEvent.getRequest().getLabel()).append("\" ");
                    }
                    if (null != requestFailedEvent.getRequest().getURL()) {
                        stringBuffer.append("<").append(requestFailedEvent.getRequest().getURL()).append("> ");
                    }
                }
                stringBuffer.append(" failed. ");
                stringBuffer.append(requestFailedEvent.getValidationException().getMessage());
                System.out.println(stringBuffer.toString());
            }
        }
    }

    private void maybePrintErrors() {
        if (!this._errors.isEmpty()) {
            System.out.println();
            System.out.println("Failures:");
            Iterator iterator = this._errors.iterator();
            while (iterator.hasNext()) {
                RequestErrorEvent requestErrorEvent = (RequestErrorEvent)iterator.next();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Request ");
                if (null != requestErrorEvent.getRequest()) {
                    if (null != requestErrorEvent.getRequest().getLabel()) {
                        stringBuffer.append("\"").append(requestErrorEvent.getRequest().getLabel()).append("\" ");
                    }
                    if (null != requestErrorEvent.getRequest().getURL()) {
                        stringBuffer.append("<").append(requestErrorEvent.getRequest().getURL()).append("> ");
                    }
                }
                stringBuffer.append(requestErrorEvent.getError().toString());
                System.out.println(stringBuffer.toString());
            }
        }
    }
}

