/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.latka;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.latka.AbstractReporter;
import org.apache.commons.latka.event.RequestErrorEvent;
import org.apache.commons.latka.event.RequestEvent;
import org.apache.commons.latka.event.RequestFailedEvent;
import org.apache.commons.latka.event.SuiteEvent;
import org.apache.commons.latka.http.Request;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class XMLReporter
extends AbstractReporter {
    protected Document _doc = null;
    protected Element _rootElement = null;
    protected PrintWriter _printWriter = new PrintWriter(System.out);

    public XMLReporter() {
        this._rootElement = new Element("report");
        this._doc = new Document(this._rootElement);
        this._rootElement.addAttribute("suiteSuccess", "false");
    }

    public Document getDocument() {
        return this._doc;
    }

    public String getDocumentAsString() throws IOException {
        XMLOutputter xMLOutputter = new XMLOutputter("  ", true);
        StringWriter stringWriter = new StringWriter();
        xMLOutputter.output(this.getDocument(), (Writer)stringWriter);
        String string = stringWriter.toString();
        return string;
    }

    public void requestError(RequestEvent requestEvent) {
        this._printWriter.print("E");
        this._printWriter.flush();
        super.requestError(requestEvent);
        RequestErrorEvent requestErrorEvent = (RequestErrorEvent)requestEvent;
        Request request = requestEvent.getRequest();
        Element element = this.createRequestElement(requestEvent);
        this._rootElement.addContent(element);
        Element element2 = new Element("requestError");
        element.addContent(element2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Request ");
        if (request != null) {
            if (null != request.getLabel()) {
                stringBuffer.append("\"").append(request.getLabel()).append("\" ");
            }
            if (null != request.getURL()) {
                stringBuffer.append("<").append(request.getURL()).append("> ");
            }
        }
        stringBuffer.append(" produced an error. ");
        stringBuffer.append(requestErrorEvent.getError());
        Element element3 = new Element("label");
        element3.addContent(stringBuffer.toString());
        element2.addContent(element3);
    }

    public void requestSucceeded(RequestEvent requestEvent) {
        this._printWriter.print(".");
        this._printWriter.flush();
        super.requestSucceeded(requestEvent);
        Element element = this.createRequestElement(requestEvent);
        this._rootElement.addContent(element);
        Element element2 = new Element("requestSuccess");
        element.addContent(element2);
    }

    public void requestFailed(RequestEvent requestEvent) {
        this._printWriter.print("F");
        this._printWriter.flush();
        super.requestFailed(requestEvent);
        RequestFailedEvent requestFailedEvent = (RequestFailedEvent)requestEvent;
        Request request = requestEvent.getRequest();
        Element element = this.createRequestElement(requestEvent);
        this._rootElement.addContent(element);
        Element element2 = new Element("requestFailure");
        element2.addAttribute("responseId", requestEvent.getResponse().toString());
        element.addContent(element2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Request ");
        if (request != null) {
            if (null != request.getLabel()) {
                stringBuffer.append("\"").append(request.getLabel()).append("\" ");
            }
            if (null != request.getURL()) {
                stringBuffer.append("<").append(request.getURL()).append("> ");
            }
        }
        stringBuffer.append(" Failed. ");
        stringBuffer.append(requestFailedEvent.getValidationException().getMessage());
        Element element3 = new Element("label");
        element3.addContent(stringBuffer.toString());
        element2.addContent(element3);
    }

    public void requestSkipped(RequestEvent requestEvent) {
        this._printWriter.print("S");
        this._printWriter.flush();
        super.requestSkipped(requestEvent);
        Request request = requestEvent.getRequest();
        Element element = this.createRequestElement(requestEvent);
        this._rootElement.addContent(element);
        Element element2 = new Element("requestSkipped");
        element.addContent(element2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Request ");
        if (request != null) {
            if (null != request.getLabel()) {
                stringBuffer.append("\"").append(request.getLabel()).append("\" ");
            }
            if (null != request.getURL()) {
                stringBuffer.append("<").append(requestEvent.getRequest().getURL()).append("> ");
            }
        }
        stringBuffer.append(" Skipped. ");
        Element element3 = new Element("label");
        element3.addContent(stringBuffer.toString());
        element2.addContent(element3);
    }

    public void suiteCompleted(SuiteEvent suiteEvent) {
        this._rootElement.getAttribute("suiteSuccess").setValue(String.valueOf(this.didSuiteSucceed()));
    }

    protected Element createRequestElement(RequestEvent requestEvent) {
        Request request = requestEvent.getRequest();
        Element element = new Element("request");
        element.addAttribute("requestTime", String.valueOf(request.getRequestTiming()));
        String string = request.getLabel();
        if (string != null) {
            element.addAttribute("label", string);
        }
        element.addAttribute("url", request.getURL().toString());
        return element;
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this._printWriter = printWriter;
    }
}

