/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.latka.http;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.latka.http.Request;
import org.apache.commons.latka.http.RequestImpl;
import org.apache.commons.latka.http.Response;

public class ResponseImpl
implements Response {
    protected RequestImpl _request;
    protected HttpMethod _httpMethod;

    ResponseImpl(RequestImpl requestImpl) {
        this._request = requestImpl;
        this._httpMethod = requestImpl.getHttpMethod();
    }

    public Request getRequest() {
        return this._request;
    }

    public int getStatusCode() {
        return this._httpMethod.getStatusCode();
    }

    public String getResource() {
        String string;
        if (this._httpMethod instanceof GetMethod) {
            try {
                string = ((GetMethod)this._httpMethod).getDataAsString();
            }
            catch (IOException iOException) {
                string = null;
            }
        } else if (this._httpMethod instanceof PostMethod) {
            try {
                string = ((PostMethod)this._httpMethod).getDataAsString();
            }
            catch (IOException iOException) {
                string = null;
            }
        } else {
            string = null;
        }
        return string;
    }

    public String getHeader(String string) {
        Header header = this._httpMethod.getHeader(string);
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    public int getByteLength() {
        if (this._httpMethod instanceof GetMethod) {
            try {
                return ((GetMethod)this._httpMethod).getData().available();
            }
            catch (IOException iOException) {
                return -1;
            }
        }
        return -1;
    }

    public InputStream getStream() {
        InputStream inputStream = null;
        if (this._httpMethod instanceof GetMethod) {
            try {
                inputStream = ((GetMethod)this._httpMethod).getData();
            }
            catch (IOException iOException) {
                inputStream = null;
            }
        }
        return inputStream;
    }
}

