/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.latka.validators;

import org.apache.commons.latka.ValidationException;
import org.apache.commons.latka.Validator;
import org.apache.commons.latka.http.Response;
import org.apache.commons.latka.validators.BaseValidator;

public class ResponseHeaderValidator
extends BaseValidator
implements Validator {
    protected String _headerName = null;
    protected String _headerValue = null;
    protected boolean _checkValue = false;
    protected static final String MESSAGE_NONEXISTENT_HEADER = "HEADER NOT IN RESPONSE";
    protected static final String MESSAGE_UNEQUAL_VALUES = "HEADER VALUES UNEQUAL:";

    public ResponseHeaderValidator(String string) {
        this(null, string);
    }

    public ResponseHeaderValidator(String string, String string2) {
        super(string);
        this._headerName = string2;
    }

    public void setHeaderValue(String string) {
        this._checkValue = true;
        if (string == null) {
            string = "null";
        }
        this._headerValue = string;
    }

    public void validate(Response response) throws ValidationException {
        String string = response.getHeader(this._headerName);
        if (string == null) {
            this.fail(MESSAGE_NONEXISTENT_HEADER);
        }
        if (!this._checkValue) {
            return;
        }
        if (!string.equals(this._headerValue)) {
            StringBuffer stringBuffer = new StringBuffer(MESSAGE_UNEQUAL_VALUES);
            stringBuffer.append(" EXPECTED: ");
            stringBuffer.append(this._headerValue);
            stringBuffer.append(" RECEIVED: ");
            stringBuffer.append(string);
            this.fail(stringBuffer.toString());
        }
    }
}

