/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.latka.xml;

import org.apache.commons.latka.ValidationException;
import org.apache.commons.latka.Validator;
import org.apache.commons.latka.event.LatkaEventListener;
import org.apache.commons.latka.event.RequestFailedEvent;
import org.apache.commons.latka.http.Response;
import org.apache.commons.latka.util.xml.BasicDelegateHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public abstract class ValidationHandler
extends BasicDelegateHandler {
    private Response _response = null;
    private LatkaEventListener _listener = null;
    private String _tagName = null;

    void init(XMLReader xMLReader, Response response, LatkaEventListener latkaEventListener, String string) {
        super.init(xMLReader);
        this._response = response;
        this._listener = latkaEventListener;
        this._tagName = string;
    }

    public Response getResponse() {
        return this._response;
    }

    public void validate(Validator validator) {
        BasicDelegateHandler.log.debug((Object)"performing custom validation");
        BasicDelegateHandler.log.debug((Object)("validator = " + validator));
        BasicDelegateHandler.log.debug((Object)("response = " + this._response));
        try {
            validator.validate(this._response);
        }
        catch (ValidationException validationException) {
            this._listener.requestFailed(new RequestFailedEvent(this._response.getRequest(), this._response, validationException));
        }
        BasicDelegateHandler.log.debug((Object)"custom validation complete");
        this.release();
    }

    public String getTagName() {
        return this._tagName;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }
}

