/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.latka.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.latka.LatkaProperties;
import org.apache.commons.latka.xml.FindVariablesHandler;
import org.apache.log4j.Category;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLPreprocessor {
    protected static final String _variableExpr = "\\$\\{(.*?)\\}";
    protected static Category _log = Category.getInstance((Class)(class$org$apache$commons$latka$xml$XMLPreprocessor == null ? (class$org$apache$commons$latka$xml$XMLPreprocessor = XMLPreprocessor.class$("org.apache.commons.latka.xml.XMLPreprocessor")) : class$org$apache$commons$latka$xml$XMLPreprocessor));
    static /* synthetic */ Class class$org$apache$commons$latka$xml$XMLPreprocessor;

    public Reader preprocessXml(Reader reader) throws IOException {
        String string = this.resolveVariables(this.stringFromReader(reader));
        return new StringReader(string);
    }

    public Reader preprocessXml(URL uRL) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(uRL.openConnection().getInputStream());
        return this.preprocessXml(inputStreamReader);
    }

    public Set findVariables(Reader reader) throws IOException {
        String string = this.stringFromReader(reader).trim();
        Set set = this.getLocalVariables(new StringReader(string));
        InputSource inputSource = new InputSource(new StringReader(string));
        set.addAll(this.getVariablesFromEntites(inputSource));
        return set;
    }

    public Set findVariables(URL uRL) throws IOException {
        _log.debug((Object)("Going to read variables from URL: " + uRL));
        InputStreamReader inputStreamReader = new InputStreamReader(uRL.openConnection().getInputStream());
        Set set = this.getLocalVariables(inputStreamReader);
        _log.debug((Object)"variables read");
        InputSource inputSource = new InputSource(uRL.toString());
        set.addAll(this.getVariablesFromEntites(inputSource));
        return set;
    }

    protected Set getVariablesFromEntites(InputSource inputSource) throws IOException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        FindVariablesHandler findVariablesHandler = new FindVariablesHandler();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputSource, (DefaultHandler)findVariablesHandler);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException.toString());
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.toString());
        }
        return findVariablesHandler.getVariables();
    }

    public Set getLocalVariables(Reader reader) throws IOException {
        String string = this.stringFromReader(reader);
        string = this.stripXmlComments(string);
        TreeSet<String> treeSet = new TreeSet<String>();
        try {
            RE rE = new RE(_variableExpr);
            int n = 0;
            while (rE.match(string, n)) {
                treeSet.add(rE.getParen(1));
                n = rE.getParenEnd(0);
            }
        }
        catch (RESyntaxException rESyntaxException) {
            rESyntaxException.printStackTrace();
        }
        return treeSet;
    }

    protected String resolveVariables(String string) throws IOException {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        Properties properties = LatkaProperties.getProperties();
        try {
            string = this.stripXmlComments(string);
            string2 = new RE(_variableExpr);
            int n = 0;
            while (string2.match(string, n)) {
                stringBuffer.append(string.substring(n, string2.getParenStart(0)));
                n = string2.getParenEnd(0);
                String string3 = properties.getProperty(string2.getParen(1));
                if (string3 == null) {
                    throw new IOException("Property " + string2.getParen(1) + " was not defined.");
                }
                stringBuffer.append(string3);
            }
            stringBuffer.append(string.substring(n, string.length()));
        }
        catch (RESyntaxException rESyntaxException) {
            rESyntaxException.printStackTrace();
        }
        string2 = stringBuffer.toString();
        return string2;
    }

    protected String stripXmlComments(String string) {
        try {
            RE rE = new RE("<!--.*?-->", 4);
            string = rE.subst(string, "");
        }
        catch (RESyntaxException rESyntaxException) {
            rESyntaxException.printStackTrace();
        }
        return string;
    }

    protected String stringFromReader(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuffer stringBuffer = new StringBuffer();
        String string = bufferedReader.readLine();
        while (string != null) {
            stringBuffer.append(string);
            stringBuffer.append("\n");
            string = bufferedReader.readLine();
        }
        reader.close();
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

