/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.URLUtil;

public class State {
    protected HashMap credMap = new HashMap();
    protected Credentials defaultCred = null;
    protected String authenticateToken = null;
    protected Vector cookies = new Vector();
    protected boolean encodeURLs = true;
    protected String URLEncodingCharset = "UTF8";
    protected String URLDecodingCharset = "UTF8";

    public void addCookie(Cookie cookie) {
        if (cookie != null) {
            boolean found = false;
            Enumeration e = this.cookies.elements();
            while (!found && e.hasMoreElements()) {
                Cookie tmp = (Cookie)e.nextElement();
                if (!cookie.getDomain().equals(tmp.getDomain()) || !cookie.getName().equals(tmp.getName())) continue;
                found = true;
                this.cookies.removeElement(tmp);
            }
            this.cookies.addElement(cookie);
        }
    }

    public void addCookies(Cookie[] cookies) {
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                this.addCookie(cookies[i]);
                ++i;
            }
        }
    }

    public Vector getCookies() {
        return this.cookies;
    }

    public void setAuthenticateToken(String authenticateToken) {
        this.authenticateToken = authenticateToken;
    }

    public String getAuthenticateToken() {
        return this.authenticateToken;
    }

    public void setEncodeURLs(boolean encodeURLs) {
        this.encodeURLs = encodeURLs;
    }

    public void setURLEncodingCharset(String URLEncodingCharset) {
        this.URLEncodingCharset = URLEncodingCharset;
    }

    public void setURLDecodingCharset(String URLDecodingCharset) {
        this.URLDecodingCharset = URLDecodingCharset;
    }

    public void setCredentials(String realm, Credentials credentials) {
        this.credMap.put(realm, credentials);
    }

    public Credentials getCredentials(String realm) {
        return (Credentials)this.credMap.get(realm);
    }

    public void setDefaultCredentials(Credentials credentials) {
        this.defaultCred = credentials;
    }

    public Credentials getDefaultCredentials() {
        return this.defaultCred;
    }

    public String URLEncode(String url) {
        if (this.encodeURLs) {
            return URLUtil.URLEncode(url, this.URLEncodingCharset);
        }
        return url;
    }

    public String URLDecode(String url) {
        return URLUtil.URLDecode(url, this.URLDecodingCharset);
    }
}

