<?xml version="1.0"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   <xsl:output method="text" indent="no"/>
   <xsl:strip-space elements="*"/>

   <xsl:template match="/">
     <xsl:apply-templates/>
     <xsl:text>&#x0A;</xsl:text>
     Thank you very much.
     <xsl:text>&#x0A;</xsl:text>
   </xsl:template>     

   <xsl:template match="report">
      <xsl:text>&#x0A;</xsl:text>
      <xsl:apply-templates select="//request[not(requestSuccess)]"/>
      <!-- <xsl:apply-templates select="//request"/> -->
      <xsl:call-template name="summary"/>
      <xsl:text>&#x0A;</xsl:text>
   </xsl:template>

   <xsl:template name="summary">
      <xsl:choose>
         <xsl:when test="/report/@suiteSuccess = 'true'">SUITE SUCCEEDED</xsl:when>
         <xsl:otherwise>SUITE FAILED</xsl:otherwise>
      </xsl:choose>
      <xsl:text>&#x0A;</xsl:text>
      <xsl:value-of select="count(//request)"/><xsl:text> requests.</xsl:text>
      <xsl:text>&#x0A;</xsl:text>
      <xsl:value-of select="count(//request/requestSuccess)"/><xsl:text> passed.</xsl:text>
      <xsl:text>&#x0A;</xsl:text>
      <xsl:value-of select="count(//request/requestFailure)"/><xsl:text> failed.</xsl:text>
      <xsl:text>&#x0A;</xsl:text>
      <xsl:value-of select="count(//request/requestSkipped)"/><xsl:text> skipped.</xsl:text>
      <xsl:text>&#x0A;</xsl:text>
      <xsl:value-of select="count(//request/requestError)"/><xsl:text> errors.</xsl:text>
   </xsl:template>

   <xsl:template match="request">
      <xsl:value-of select="@url"/> <xsl:call-template name="label"/>
      <xsl:text>&#x0A;</xsl:text>
      <xsl:apply-templates>
        <xsl:with-param name="timing">
         <xsl:text>(</xsl:text><xsl:value-of select="@requestTime"/><xsl:text> millis)</xsl:text>
        </xsl:with-param>
      </xsl:apply-templates>
      <xsl:text>&#x0A;</xsl:text>
      <xsl:text>&#x0A;</xsl:text>
   </xsl:template>

   <xsl:template match="requestSuccess">
      <xsl:param name="timing"/>
      <xsl:text>  REQUEST SUCCEEDED </xsl:text>
      <xsl:value-of select="$timing"/>
   </xsl:template>

   <xsl:template match="requestFailure">
      <xsl:param name="timing"/>
      <xsl:text>  REQUEST FAILED </xsl:text>
      <xsl:value-of select="$timing"/>
      <xsl:text>&#x0A;    </xsl:text>
      <xsl:apply-templates/>
   </xsl:template>

   <xsl:template match="requestSkipped">
      <xsl:param name="timing"/>
      <xsl:text>  REQUEST SKIPPED </xsl:text>
      <xsl:value-of select="$timing"/>
   </xsl:template>

   <xsl:template match="requestError">
      <xsl:param name="timing"/>
      <xsl:text>  REQUEST ERROR </xsl:text>
      <xsl:value-of select="$timing"/>
      <xsl:text>&#x0A;    </xsl:text>
      <xsl:apply-templates/>
   </xsl:template>

   <xsl:template name="label">
      <xsl:if test="@label">
         <xsl:text> (</xsl:text><xsl:value-of select="@label"/><xsl:text>)</xsl:text>
      </xsl:if>
   </xsl:template>

</xsl:stylesheet>