/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import org.apache.commons.httpclient.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.State;
import org.apache.commons.httpclient.log.Log;
import org.apache.commons.httpclient.log.LogSource;

public class Authenticator {
    private static final Log log = LogSource.getInstance("org.apache.commons.httpclient.Authenticator");
    protected static Base64 base64 = new Base64();

    public static String challengeResponse(State state, Credentials credentials) throws HttpException {
        log.debug("Authenticator.challengeResponse(State,Credentials)");
        if (credentials == null) {
            throw new HttpException(-2);
        }
        String challenge = state.getAuthenticateToken();
        if (challenge == null) {
            return null;
        }
        int space = challenge.indexOf(32);
        if (space < 0) {
            return null;
        }
        String authScheme = challenge.substring(0, space);
        if ("basic".equalsIgnoreCase(authScheme)) {
            return Authenticator.basic(state, credentials);
        }
        if ("digest".equalsIgnoreCase(authScheme)) {
            throw new UnsupportedOperationException("Digest authentication is not supported.");
        }
        throw new UnsupportedOperationException("Authentication type \"" + authScheme + "\" is not recognized.");
    }

    public static String challengeResponse(String challenge, State state) throws HttpException {
        log.debug("Authenticator.challengeResponse(String, State)");
        if (challenge == null) {
            return null;
        }
        int space = challenge.indexOf(32);
        if (space < 0) {
            throw new HttpException("Unable to parse authentication challenge \"" + challenge + "\", expected space");
        }
        String authScheme = challenge.substring(0, space);
        if ("basic".equalsIgnoreCase(authScheme)) {
            if (challenge.length() < space + 1) {
                throw new HttpException("Unable to parse authentication challenge \"" + challenge + "\", expected realm");
            }
            String realmstr = challenge.substring(space + 1, challenge.length());
            realmstr.trim();
            log.debug("Parsing realm from \"" + realmstr + "\".");
            String realm = realmstr.substring("realm=\"".length(), realmstr.length() - 1);
            log.debug("Parsed realm \"" + realm + "\" from challenge \"" + challenge + "\".");
            return Authenticator.basic(realm, state);
        }
        if ("digest".equalsIgnoreCase(authScheme)) {
            throw new UnsupportedOperationException("Digest authentication is not supported.");
        }
        throw new UnsupportedOperationException("Authentication type \"" + authScheme + "\" is not recognized.");
    }

    public static String basic(State state, Credentials credentials) {
        log.debug("Authenticator.basic(State,Credentials)");
        String authString = credentials.getUserName() + ":" + credentials.getPassword();
        return "Basic " + new String(Base64.encode(authString.getBytes()));
    }

    public static String basic(String realm, State state) throws HttpException {
        log.debug("Authenticator.basic(String,State)");
        Credentials cred = state.getCredentials(realm);
        if (null == cred) {
            if (log.isInfoEnabled()) {
                log.info("No credentials found for realm \"" + realm + "\", attempting to use default credentials.");
            }
            if (null == (cred = state.getDefaultCredentials())) {
                throw new HttpException(-2);
            }
        }
        String authString = cred.getUserName() + ":" + cred.getPassword();
        return "Basic " + new String(Base64.encode(authString.getBytes()));
    }
}

