/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.State;

public abstract class HttpMethodBase
implements HttpMethod {
    private boolean used = false;
    protected int statusCode = -1;
    protected String statusText = "Method Not Processed";
    protected String path = "/";
    protected String name;
    protected Hashtable requestHeaders = new Hashtable();
    protected Hashtable responseHeaders = new Hashtable();
    protected Hashtable parameters = new Hashtable();
    protected State state;
    protected String query = null;
    protected String queryString = null;
    protected boolean followRedirects = false;

    public HttpMethodBase() {
    }

    public HttpMethodBase(String path) {
        this.setPath(path);
    }

    public void setDebug(int debug) {
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusText(String statusText) {
        this.statusText = statusText;
    }

    public String getStatusText() {
        this.checkUsed();
        return this.statusText;
    }

    public void setPath(String path) {
        this.checkNotUsed();
        this.path = path == null || path.equals("") ? "/" : path;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public void setHeader(String headerName, String headerValue) {
        this.getHeadersHashtable().put(headerName.toLowerCase(), new Header(headerName, headerValue));
    }

    public Header getHeader(String headerName) {
        return (Header)this.getHeadersHashtable().get(headerName.toLowerCase());
    }

    public void removeHeader(String headerName) {
        this.getHeadersHashtable().remove(headerName.toLowerCase());
    }

    public final boolean hasBeenUsed() {
        return this.used;
    }

    public boolean followRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void setParameter(String parameterName, String parameterValue) {
        this.parameters.put(parameterName, parameterValue);
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setUsed() {
        this.used = true;
    }

    public boolean validate() {
        return true;
    }

    public void recycle() {
        this.path = "/";
        this.statusCode = -1;
        this.statusText = "Method Not Processed";
        this.requestHeaders.clear();
        this.responseHeaders.clear();
        this.parameters.clear();
        this.state = null;
        this.used = false;
        this.query = null;
        this.queryString = null;
        this.followRedirects = false;
    }

    public Enumeration getHeaders() {
        return this.getHeadersHashtable().elements();
    }

    public void generateHeaders(State state) {
        this.generateHeaders("default", state);
    }

    public void generateHeaders(String host, State state) {
        Vector cookies;
        this.responseHeaders.clear();
        if (!this.requestHeaders.containsKey("user-agent")) {
            this.requestHeaders.put("user-agent", HttpClient.USER_AGENT);
        }
        if (!this.requestHeaders.containsKey("host")) {
            this.requestHeaders.put("host", new Header("Host", host));
        }
        if (!this.requestHeaders.containsKey("cookie") && (cookies = state.getCookies()) != null && cookies.size() > 0) {
            this.requestHeaders.put("cookie", Cookie.createCookieHeader(host, this.getPath(), cookies));
        }
    }

    public boolean isStreamedQuery() {
        return false;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String generateQuery() {
        return this.query != null ? this.query : "";
    }

    public void streamQuery(OutputStream out) throws IOException {
    }

    public void processResponseHeaders(Hashtable headers) {
        this.responseHeaders = headers;
    }

    public abstract void parseResponse(InputStream var1) throws IOException, HttpException;

    public final String generateRequestLine() {
        String requestString = this.state.URLEncode(this.path);
        if (this.queryString != null) {
            if (this.queryString.indexOf("?") < 0) {
                requestString = requestString + "?";
            }
            requestString = requestString + this.queryString;
        }
        if (!this.parameters.isEmpty()) {
            if (requestString.indexOf("?") < 0) {
                requestString = requestString + "?";
            } else if (requestString.indexOf("=") >= 0) {
                requestString = requestString + "&";
            }
            StringBuffer parametersString = new StringBuffer();
            Enumeration paramNames = this.parameters.keys();
            while (paramNames.hasMoreElements()) {
                String paramName = (String)paramNames.nextElement();
                String paramValue = (String)this.parameters.get(paramName);
                parametersString.append(this.state.URLEncode(paramName));
                parametersString.append("=");
                parametersString.append(this.state.URLEncode(paramValue));
                if (!paramNames.hasMoreElements()) continue;
                parametersString.append("&");
            }
            requestString = requestString + parametersString.toString();
        }
        return this.getName() + " " + requestString + " " + "HTTP/1.1" + "\r\n";
    }

    public final String generateRequestLine(String phost, int pport) {
        String requestString = this.state.URLEncode(this.path);
        if (this.queryString != null) {
            if (this.queryString.indexOf("?") < 0) {
                requestString = requestString + "?";
            }
            requestString = requestString + this.queryString;
        } else if (!this.parameters.isEmpty()) {
            StringBuffer parametersString = new StringBuffer();
            Enumeration paramNames = this.parameters.keys();
            while (paramNames.hasMoreElements()) {
                String paramName = (String)paramNames.nextElement();
                String paramValue = (String)this.parameters.get(paramName);
                parametersString.append(this.state.URLEncode(paramName));
                parametersString.append("=");
                parametersString.append(this.state.URLEncode(paramValue));
                if (!paramNames.hasMoreElements()) continue;
                parametersString.append("&");
            }
            requestString = requestString + "?" + parametersString.toString();
        }
        return this.getName() + " http://" + phost + ":" + pport + requestString + " " + "HTTP/1.1" + "\r\n";
    }

    public boolean needContentLength() {
        return true;
    }

    public boolean hasResponseBody() {
        return true;
    }

    public boolean needExpectation() {
        return false;
    }

    protected Hashtable getHeadersHashtable() {
        if (this.hasBeenUsed()) {
            return this.responseHeaders;
        }
        return this.requestHeaders;
    }

    protected void checkUsed() {
        if (!this.hasBeenUsed()) {
            throw new IllegalStateException("Method must be executed before this function is called");
        }
    }

    protected void checkNotUsed() {
        if (this.hasBeenUsed()) {
            throw new IllegalStateException("This function must be called before this method is executed");
        }
    }
}

