/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.log.Log;
import org.apache.commons.httpclient.log.LogSource;

public class PutMethod
extends HttpMethodBase {
    private byte[] data = null;
    private File file = null;
    private URL url = null;
    protected static final Log wireLog = LogSource.getInstance("httpclient.wire");

    public PutMethod() {
        this.name = "PUT";
    }

    public PutMethod(String path) {
        super(path);
        this.name = "PUT";
    }

    public void setDebug(int debug) {
    }

    public void sendData(File file) throws IOException {
        this.checkNotUsed();
        this.file = file;
    }

    public void sendData(URL url) throws IOException {
        this.checkNotUsed();
        this.url = url;
    }

    public void sendData(byte[] data) {
        this.checkNotUsed();
        this.data = data;
    }

    public void sendData(String data) {
        this.checkNotUsed();
        this.sendData(data.getBytes());
    }

    public void sendData(InputStream is) throws IOException {
        this.checkNotUsed();
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int nb = 0;
        while ((nb = is.read(buffer)) != -1) {
            os.write(buffer, 0, nb);
        }
        this.data = os.toByteArray();
    }

    public boolean isStreamedQuery() {
        return this.file != null || this.url != null;
    }

    public void recycle() {
        super.recycle();
        this.data = null;
        this.url = null;
        this.file = null;
    }

    public String generateQuery() {
        if (this.query != null) {
            return this.query;
        }
        if (this.data == null) {
            return "";
        }
        return new String(this.data);
    }

    public void streamQuery(OutputStream out) throws IOException {
        InputStream inputStream = null;
        if (this.file != null) {
            inputStream = new FileInputStream(this.file);
        } else if (this.url != null) {
            inputStream = this.url.openConnection().getInputStream();
        }
        byte[] buffer = new byte[4096];
        int nb = 0;
        while ((nb = inputStream.read(buffer)) != -1) {
            if (wireLog.isInfoEnabled()) {
                wireLog.info(">> \"" + new String(buffer) + "\"");
            }
            out.write(buffer, 0, nb);
        }
        inputStream.close();
    }

    public void parseResponse(InputStream is) throws IOException {
    }

    public boolean needExpectation() {
        return true;
    }
}

