/*
 * Decompiled with CFR 0.152.
 */
package com.britannica.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.regexp.CharacterIterator;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import org.apache.regexp.ReaderCharacterIterator;
import org.apache.regexp.StreamCharacterIterator;
import org.apache.regexp.StringCharacterIterator;

public class URLParser {
    public static final int PARSE_ANCHORS = 1;
    public static final int PARSE_FRAMES = 2;
    public static final int PARSE_IMAGES = 4;
    public static final int PARSE_LAYERS = 8;
    public static final int PARSE_LINKS = 16;
    public static final int PARSE_OBJECTS = 32;
    public static final int PARSE_SCRIPTS = 64;
    public static final int PARSE_ALL = Integer.MAX_VALUE;
    public static final String ANCHOR_PATTERN = "<A\\s+[^>]*?HREF\\s*=\\s*([\"']?)([^#'\">\\s]+)[^'\">\\s]*\\1[^>]*>";
    public static final String FRAME_PATTERN = "<FRAME\\s+[^>]*?SRC\\s*=\\s*([\"']?)([^'\">\\s]*)\\1[^>]*>";
    public static final String IMAGE_PATTERN = "<IMG\\s+[^>]*?SRC\\s*=\\s*([\"']?)([^'\">\\s]*)\\1[^>]*>";
    public static final String LAYER_PATTERN = "<LAYER\\s+[^>]*?SRC\\s*=\\s*([\"']?)([^'\">\\s]*)\\1[^>]*>";
    public static final String LINK_PATTERN = "<LINK\\s+[^>]*?HREF\\s*=\\s*([\"']?)([^'\">\\s]*)\\1[^>]*>";
    public static final String OBJECT_PATTERN = "<OBJECT\\s+[^>]*?SRC\\s*=\\s*([\"']?)([^'\">\\s]*)\\1[^>]*>";
    public static final String SCRIPT_PATTERN = "<SCRIPT\\s+[^>]*?SRC\\s*=\\s*([\"']?)([^'\">\\s]*)\\1[^>]*>";
    protected static Map _patterns;
    protected static Map _programs;
    protected static int _numPatterns;
    protected static float _loadFactor;
    protected RECompiler _compiler;
    protected RE _engine;
    protected int _parseFlag;
    protected URL _baseURL;
    protected boolean _includeMalformedURLs;
    protected Collection _malformedURLs;

    public URLParser() {
        this(Integer.MAX_VALUE, null, true);
    }

    public URLParser(int n) {
        this(n, null, false);
    }

    public URLParser(URL uRL, boolean bl) {
        this(Integer.MAX_VALUE, uRL, bl);
    }

    public URLParser(int n, URL uRL, boolean bl) {
        this._parseFlag = n;
        this._baseURL = uRL;
        this._includeMalformedURLs = bl;
        this._engine = new RE();
        this._engine.setMatchFlags(1);
        this._compiler = new RECompiler();
    }

    public void setParseFlag(int n) {
        this._parseFlag = n;
    }

    public int getParseFlag() {
        return this._parseFlag;
    }

    public void addParseFlag(int n) {
        this._parseFlag |= n;
    }

    public void removeParseFlag(int n) {
        this._parseFlag ^= n;
    }

    public void clearParseFlag() {
        this._parseFlag = 0;
    }

    public void setBaseURL(URL uRL) {
        this._baseURL = uRL;
    }

    public URL getBaseURL() {
        return this._baseURL;
    }

    public void setIncludeMalformedURLs(boolean bl) {
        this._includeMalformedURLs = bl;
    }

    public boolean includeMalformedURLs() {
        return this._includeMalformedURLs;
    }

    public Collection getMalformedURLs() {
        return this._malformedURLs;
    }

    public Collection parse(InputStream inputStream) {
        return this.parse((CharacterIterator)new StreamCharacterIterator(inputStream));
    }

    public Collection parse(String string) {
        return this.parse((CharacterIterator)new StringCharacterIterator(string));
    }

    public Collection parse(Reader reader) {
        return this.parse((CharacterIterator)new ReaderCharacterIterator(reader));
    }

    public Collection parse(CharacterIterator characterIterator) {
        Vector vector = new Vector();
        this._malformedURLs = new Vector();
        int n = 1 << _numPatterns;
        while (n != 0) {
            String string;
            int n2 = this._parseFlag & n;
            if (n2 != 0 && (string = (String)_patterns.get(new Integer(n2))) != null) {
                vector.addAll(this.parse(characterIterator, string));
            }
            n >>>= 1;
        }
        return vector;
    }

    protected Collection parse(CharacterIterator characterIterator, String string) {
        Vector<String> vector = new Vector<String>();
        REProgram rEProgram = this.getProgram(string);
        this._engine.setProgram(rEProgram);
        int n = 0;
        while (this._engine.match(characterIterator, n)) {
            n = this._engine.getParenEnd(0);
            String string2 = this._engine.getParen(2);
            try {
                string2 = this.resolveURL(string2);
                vector.add(string2);
            }
            catch (MalformedURLException malformedURLException) {
                if (this._includeMalformedURLs) {
                    vector.add(string2);
                }
                this._malformedURLs.add(string2);
            }
        }
        return vector;
    }

    protected String resolveURL(String string) throws MalformedURLException {
        String string2 = this._baseURL != null ? new URL(this._baseURL, string).toExternalForm() : string;
        return string2;
    }

    protected REProgram getProgram(String string) {
        REProgram rEProgram = (REProgram)_programs.get(string);
        if (rEProgram == null) {
            try {
                rEProgram = this._compiler.compile(string);
                _programs.put(string, rEProgram);
            }
            catch (RESyntaxException rESyntaxException) {
                throw new RuntimeException("The Regular Expression Compiler could not compile the following regular expression: " + string);
            }
        }
        return rEProgram;
    }

    public static void main(String[] stringArray) {
        try {
            URLParser uRLParser = stringArray.length > 1 ? new URLParser(new URL(stringArray[1]), false) : new URLParser();
            Collection collection = uRLParser.parse(new FileInputStream(stringArray[0]));
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                System.out.println((String)iterator.next());
            }
            if (stringArray.length > 1) {
                collection = uRLParser.getMalformedURLs();
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    System.err.println((String)iterator.next());
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("Usage: java com.britannica.util.URLParser <filename> [<base URL>]");
            System.exit(1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File not found: " + stringArray[0]);
            System.exit(2);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Malformed Base URL: " + stringArray[1]);
            System.exit(3);
        }
        System.exit(0);
    }

    static {
        _numPatterns = 7;
        _loadFactor = 0.75f;
        _patterns = new Hashtable((int)((float)_numPatterns / _loadFactor) + 1, _loadFactor);
        _programs = new Hashtable((int)((float)_numPatterns / _loadFactor) + 1, _loadFactor);
        _patterns.put(new Integer(1), ANCHOR_PATTERN);
        _patterns.put(new Integer(2), FRAME_PATTERN);
        _patterns.put(new Integer(4), IMAGE_PATTERN);
        _patterns.put(new Integer(8), LAYER_PATTERN);
        _patterns.put(new Integer(16), LINK_PATTERN);
        _patterns.put(new Integer(32), OBJECT_PATTERN);
        _patterns.put(new Integer(64), SCRIPT_PATTERN);
    }
}

