/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.latka;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.latka.event.LatkaEventInfo;
import org.apache.commons.latka.event.RequestEvent;
import org.apache.commons.latka.event.SuiteEvent;
import org.apache.commons.latka.http.Request;
import org.apache.commons.latka.http.Session;
import org.apache.log4j.Category;

public abstract class AbstractReporter
implements LatkaEventInfo {
    protected Map _requestSucceeded = new HashMap();
    protected Map _sessionSucceeded = new HashMap();
    protected boolean _suiteSucceeded = true;
    protected List _failedResponses = new LinkedList();
    protected static final Category _log = Category.getInstance((Class)(class$org$apache$commons$latka$AbstractReporter == null ? (class$org$apache$commons$latka$AbstractReporter = AbstractReporter.class$("org.apache.commons.latka.AbstractReporter")) : class$org$apache$commons$latka$AbstractReporter));
    static /* synthetic */ Class class$org$apache$commons$latka$AbstractReporter;

    public void requestSucceeded(RequestEvent requestEvent) {
        this.recordSuccess(requestEvent, true);
    }

    public void requestFailed(RequestEvent requestEvent) {
        this.recordSuccess(requestEvent, false);
        this._failedResponses.add(requestEvent.getResponse());
    }

    public void requestSkipped(RequestEvent requestEvent) {
        this.recordSuccess(requestEvent, false);
    }

    public void requestError(RequestEvent requestEvent) {
        this.recordSuccess(requestEvent, false);
    }

    protected void recordSuccess(RequestEvent requestEvent, boolean bl) {
        if (!bl) {
            this._suiteSucceeded = false;
            this._requestSucceeded.put(requestEvent.getRequest(), new Boolean(bl));
            this._sessionSucceeded.put(requestEvent.getSession(), new Boolean(bl));
            _log.info((Object)"request failed");
        }
    }

    public boolean didRequestSucceed(Request request) {
        Boolean bl = (Boolean)this._requestSucceeded.get(request);
        return bl == null || bl == true;
    }

    public boolean didSessionSucceed(Session session) {
        Boolean bl = (Boolean)this._sessionSucceeded.get(session);
        return bl == null || bl == true;
    }

    public boolean didSuiteSucceed() {
        return this._suiteSucceeded;
    }

    public List getFailedResponses() {
        return this._failedResponses;
    }

    public abstract void suiteCompleted(SuiteEvent var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

