/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.latka.http;

import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.State;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.latka.http.Request;
import org.apache.commons.latka.http.Response;
import org.apache.commons.latka.http.ResponseImpl;
import org.apache.commons.latka.http.Session;
import org.apache.commons.latka.http.SessionImpl;
import org.apache.log4j.Category;

public class RequestImpl
implements Request {
    public static final int HTTP_PORT = 80;
    public static final int HTTPS_PORT = 443;
    protected String _host = null;
    protected int _port = -1;
    protected SessionImpl _session = null;
    protected HttpMethod _httpMethod = null;
    protected URL _targetURL = null;
    protected long _requestTiming = -1L;
    protected String _label = null;
    protected HttpClient _httpClient = new HttpClient();
    protected static final Category _log = Category.getInstance((Class)(class$org$apache$commons$latka$http$RequestImpl == null ? (class$org$apache$commons$latka$http$RequestImpl = RequestImpl.class$("org.apache.commons.latka.http.RequestImpl")) : class$org$apache$commons$latka$http$RequestImpl));
    static /* synthetic */ Class class$org$apache$commons$latka$http$RequestImpl;

    protected RequestImpl(URL uRL, int n, State state, SessionImpl sessionImpl) {
        this(null, uRL, n, state, sessionImpl, true);
    }

    protected RequestImpl(String string, URL uRL, int n, State state, SessionImpl sessionImpl, boolean bl) {
        this._httpClient.setState(state);
        this._label = string;
        String string2 = uRL.getQuery();
        this._session = sessionImpl;
        this._targetURL = uRL;
        switch (n) {
            case 0: {
                this._httpMethod = new GetMethod(uRL.getPath());
                ((GetMethod)this._httpMethod).setUseDisk(false);
                break;
            }
            case 1: {
                this._httpMethod = new PostMethod(uRL.getPath());
                ((PostMethod)this._httpMethod).setUseDisk(false);
                break;
            }
            case 2: {
                this._httpMethod = new HeadMethod(uRL.getPath());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported HTTP Method");
            }
        }
        if (string2 != null) {
            this._httpMethod.setQueryString(string2);
        }
        this._httpMethod.setFollowRedirects(bl);
    }

    protected HttpMethod getHttpMethod() {
        return this._httpMethod;
    }

    public void setCredentials(String string, String string2) {
        this._session._state.setDefaultCredentials(new Credentials(string, string2));
    }

    /*
     * Loose catch block
     */
    public Response execute() throws IOException {
        ResponseImpl responseImpl;
        Date date;
        block9: {
            date = new Date();
            responseImpl = null;
            this.openConnection();
            _log.debug((Object)"executing request");
            this._httpClient.executeMethod(this._httpMethod);
            _log.debug((Object)"request executed");
            responseImpl = new ResponseImpl(this);
            Object var6_3 = null;
            try {
                this.closeConnection();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block9;
            {
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (HttpException httpException) {
                    throw new IOException(httpException.toString());
                }
            }
            catch (Throwable throwable) {
                Object var6_4 = null;
                try {
                    this.closeConnection();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
        this._requestTiming = new Date().getTime() - date.getTime();
        if (_log.isInfoEnabled()) {
            _log.info((Object)"response obtained (response logging disabled because some responses are binary)");
        }
        return responseImpl;
    }

    public URL getURL() {
        return this._targetURL;
    }

    public String getLabel() {
        return this._label;
    }

    public void setParameter(String string, String string2) {
        _log.info((Object)"adding parameter, name:");
        _log.info((Object)string);
        _log.info((Object)"value:");
        _log.info((Object)string2);
        try {
            if (this._httpMethod instanceof PostMethod) {
                ((PostMethod)this._httpMethod).addParameter(string, string2);
            } else {
                this._httpMethod.setParameter(string, string2);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException(nullPointerException.toString());
        }
    }

    public void setParameters(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                String string = (String)iterator.next();
                String string2 = (String)map.get(string);
                if (this._httpMethod instanceof PostMethod) {
                    ((PostMethod)this._httpMethod).addParameter(string, string2);
                    continue;
                }
                this._httpMethod.setParameter(string, string2);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException(classCastException.toString());
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException(nullPointerException.toString());
            }
        }
    }

    public void setHeader(String string, String string2) {
        this._httpMethod.setHeader(string, string2);
    }

    public Session getSession() {
        return this._session;
    }

    public int getRequestTiming() {
        return (int)this._requestTiming;
    }

    protected void openConnection() throws IOException {
        _log.debug((Object)"Opening connection");
        URL uRL = this.getURL();
        String string = uRL.getProtocol();
        String string2 = uRL.getHost();
        int n = uRL.getPort();
        if (n == -1) {
            if (string.equals("http")) {
                n = 80;
            } else if (string.equals("https")) {
                n = 443;
            } else {
                throw new IllegalArgumentException("Unsupported Protocol");
            }
        }
        this._host = string2;
        this._port = n;
        this._httpClient.startSession(uRL);
        _log.debug((Object)"connection open");
    }

    protected void closeConnection() throws IOException {
        _log.debug((Object)"closing connection");
        this._httpClient.endSession();
        _log.debug((Object)"connection closed");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

