/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.latka.validators;

import java.text.MessageFormat;
import org.apache.commons.latka.ValidationException;
import org.apache.commons.latka.Validator;
import org.apache.commons.latka.http.Response;
import org.apache.commons.latka.validators.BaseValidator;

public class ByteLengthValidator
extends BaseValidator
implements Validator {
    protected int _minLength = 0;
    protected int _maxLength = -1;
    protected static final MessageFormat MAX_MESSAGE = new MessageFormat("Expected at most {0,number,integer} bytes. Found {1,number,integer}.");
    protected static final MessageFormat MIN_MESSAGE = new MessageFormat("Expected at least {0,number,integer} bytes. Found {1,number,integer}.");

    public ByteLengthValidator() {
        this(null, 0, -1);
    }

    public ByteLengthValidator(String string) {
        this(string, 0, -1);
    }

    public ByteLengthValidator(int n, int n2) {
        this(null, n, n2);
    }

    public ByteLengthValidator(String string, int n, int n2) {
        super(string);
        this._minLength = n;
        this._maxLength = n2;
    }

    public void setMinLength(int n) {
        this._minLength = n;
    }

    public void setMaxLength(int n) {
        this._maxLength = n;
    }

    public void validate(Response response) throws ValidationException {
        int n = response.getByteLength();
        if (this._maxLength > -1 && n > this._maxLength) {
            this.fail(MAX_MESSAGE.format(new Object[]{new Integer(this._maxLength), new Integer(n)}).toString());
        }
        if (n < this._minLength) {
            this.fail(MIN_MESSAGE.format(new Object[]{new Integer(this._minLength), new Integer(n)}).toString());
        }
    }
}

