/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.latka.validators;

import org.apache.commons.latka.ValidationException;
import org.apache.commons.latka.Validator;
import org.apache.commons.latka.http.Response;
import org.apache.commons.latka.http.Session;
import org.apache.commons.latka.validators.BaseValidator;

public class CookieValidator
extends BaseValidator
implements Validator {
    protected String _cookieValue = null;
    protected String _cookieName = null;
    protected static final String MESSAGE_INVALID_TEST = "INVALID TEST: COOKIE NAME NOT SET";
    protected static final String MESSAGE_NONEXISTENT_COOKIE = "COOKIE NOT IN SESSION";
    protected static final String MESSAGE_UNEQUAL_VALUES = "COOKIE VALUES UNEQUAL:";

    public CookieValidator() {
        this(null, null, null);
    }

    public CookieValidator(String string) {
        this(string, null, null);
    }

    public CookieValidator(String string, String string2) {
        this(null, string, string2);
    }

    public CookieValidator(String string, String string2, String string3) {
        super(string);
        this._cookieName = string2;
        this._cookieValue = string3;
    }

    public void setCookieValue(String string) {
        this._cookieValue = string;
    }

    public void setCookieName(String string) {
        this._cookieName = string;
    }

    public void validate(Response response) throws ValidationException {
        if (this._cookieName != null) {
            Session session = response.getRequest().getSession();
            String string = session.getCookieValue(this._cookieName);
            if (string == null) {
                this.fail(MESSAGE_NONEXISTENT_COOKIE);
            } else if (this._cookieValue != null && !this._cookieValue.equals(string)) {
                StringBuffer stringBuffer = new StringBuffer(MESSAGE_UNEQUAL_VALUES);
                stringBuffer.append(" EXPECTED: ");
                stringBuffer.append(this._cookieValue);
                stringBuffer.append(" RECEIVED: ");
                stringBuffer.append(string);
                this.fail(stringBuffer.toString());
            }
        } else {
            this.fail(MESSAGE_INVALID_TEST);
        }
    }
}

