/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.latka.validators;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.commons.latka.ValidationException;
import org.apache.commons.latka.Validator;
import org.apache.commons.latka.http.Response;
import org.apache.commons.latka.validators.BaseValidator;

public class GoldenFileValidator
extends BaseValidator
implements Validator {
    protected File _goldFile = null;
    protected boolean _ignoreWhitespace = false;
    protected static String TRUE_MESSAGE = "EXPECTED TO MATCH GOLDEN FILE: ";
    protected StringBuffer _matchLog = new StringBuffer();

    public GoldenFileValidator(File file) {
        this(null, file);
    }

    public GoldenFileValidator(String string, File file) {
        super(string);
        this._goldFile = file;
    }

    public void setIgnoreWhitespace(boolean bl) {
        this._ignoreWhitespace = bl;
    }

    public void validate(Response response) throws ValidationException {
        StringBuffer stringBuffer;
        String string = null;
        try {
            int n;
            FileReader fileReader = new FileReader(this._goldFile);
            stringBuffer = new StringBuffer();
            while ((n = fileReader.read()) >= 0) {
                stringBuffer.append((char)n);
            }
            string = stringBuffer.toString();
        }
        catch (IOException iOException) {
            this.fail(iOException.toString());
        }
        boolean bl = true;
        bl = this._ignoreWhitespace ? this.compareWeak(response.getResource(), string) : this.compare(response.getResource(), string);
        if (!bl) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(TRUE_MESSAGE);
            stringBuffer.append(this._goldFile);
            stringBuffer.append("\n");
            stringBuffer.append((Object)this._matchLog);
            this.fail(stringBuffer.toString());
        }
    }

    protected boolean compare(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (string.length() != string2.length()) {
            this.log("Wrong size " + string.length() + " " + string2.length());
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) != string2.charAt(n)) {
                this.log("Error at " + n + " " + string.charAt(1) + string2.charAt(n));
                return false;
            }
            ++n;
        }
        return true;
    }

    protected boolean compareWeak(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens()) {
            String string3;
            String string4 = stringTokenizer.nextToken();
            if (string4.equals(string3 = stringTokenizer2.nextToken())) continue;
            this.log("\tFAIL*** : Live token = " + string4 + ", did not match golden file token = " + string3);
            return false;
        }
        return !stringTokenizer.hasMoreTokens() && !stringTokenizer2.hasMoreTokens();
    }

    protected void log(String string) {
        this._matchLog.append(string);
    }
}

