/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.latka.validators;

import java.text.MessageFormat;
import org.apache.commons.latka.ValidationException;
import org.apache.commons.latka.Validator;
import org.apache.commons.latka.http.Request;
import org.apache.commons.latka.http.Response;
import org.apache.commons.latka.validators.BaseValidator;

public class MaxRequestTimeValidator
extends BaseValidator
implements Validator {
    protected int _millis = 30000;
    protected static final MessageFormat MESSAGE = new MessageFormat("Expected maximum response time of  \"{0,number,integer}\" millis, but took at least \"{1,number,integer}\" millis.");

    public MaxRequestTimeValidator() {
        this(null, 30000);
    }

    public MaxRequestTimeValidator(String string) {
        this(string, 30000);
    }

    public MaxRequestTimeValidator(String string, int n) {
        super(string);
        this._millis = n;
    }

    public void setMaxMillis(int n) {
        this._millis = n;
    }

    public void validate(Response response) throws ValidationException {
        Request request = response.getRequest();
        if (request.getRequestTiming() > this._millis) {
            this.fail(MESSAGE.format(new Object[]{new Integer(this._millis), new Integer(request.getRequestTiming())}).toString());
        }
    }
}

