/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.latka.validators;

import org.apache.commons.latka.ValidationException;
import org.apache.commons.latka.Validator;
import org.apache.commons.latka.http.Response;
import org.apache.commons.latka.validators.BaseValidator;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class RegexpValidator
extends BaseValidator
implements Validator {
    protected String _pattern = null;
    protected boolean _cond = true;
    protected boolean _ignoreCase = false;
    protected static final String TRUE_MESSAGE = "EXPECTED TO MATCH PATTERN: ";
    protected static final String FALSE_MESSAGE = "DID NOT EXPECT TO MATCH PATTERN: ";

    public RegexpValidator() {
        this(null, null, true, false);
    }

    public RegexpValidator(String string) {
        this(string, null, true, false);
    }

    public RegexpValidator(String string, String string2, boolean bl, boolean bl2) {
        super(string);
        this._pattern = string2;
        this._cond = bl;
        this._ignoreCase = bl2;
    }

    public void setPattern(String string) {
        this._pattern = string;
    }

    public void setCondition(boolean bl) {
        this._cond = bl;
    }

    public void setIgnoreCase(boolean bl) {
        this._ignoreCase = bl;
    }

    public void validate(Response response) throws ValidationException {
        boolean bl;
        RE rE = null;
        try {
            rE = new RE(this._pattern);
        }
        catch (RESyntaxException rESyntaxException) {
            this.fail(rESyntaxException.toString());
        }
        if (this._ignoreCase) {
            rE.setMatchFlags(1);
        }
        if ((bl = rE.match(response.getResource())) != this._cond) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._cond) {
                stringBuffer.append(TRUE_MESSAGE);
            } else {
                stringBuffer.append(FALSE_MESSAGE);
            }
            stringBuffer.append(this._pattern);
            this.fail(stringBuffer.toString());
        }
    }
}

