/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.latka.validators;

import java.text.MessageFormat;
import org.apache.commons.latka.ValidationException;
import org.apache.commons.latka.Validator;
import org.apache.commons.latka.http.Response;
import org.apache.commons.latka.validators.BaseValidator;

public class StatusCodeValidator
extends BaseValidator
implements Validator {
    protected static final MessageFormat MESSAGE = new MessageFormat("Expected status code \"{0,number,000}\". Found \"{1,number,000}\".");
    protected int _statusCode = 200;

    public StatusCodeValidator() {
        this(null, 200);
    }

    public StatusCodeValidator(int n) {
        this(null, n);
    }

    public StatusCodeValidator(String string) {
        this(string, 200);
    }

    public StatusCodeValidator(String string, int n) {
        super(string);
        this._statusCode = n;
    }

    public void setStatusCode(int n) {
        this._statusCode = n;
    }

    public void validate(Response response) throws ValidationException {
        int n = response.getStatusCode();
        if (this._statusCode != n) {
            this.fail(MESSAGE.format(new Object[]{new Integer(this._statusCode), new Integer(n)}).toString());
        }
    }
}

